/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterDelegate;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;
import org.apache.flink.streaming.runtime.tasks.StreamOperatorWrapper;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.WatermarkGaugeExposingOutput;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RegularOperatorChain<OUT, OP extends StreamOperator<OUT>>
extends OperatorChain<OUT, OP> {
    private static final Logger LOG = LoggerFactory.getLogger(RegularOperatorChain.class);

    public RegularOperatorChain(StreamTask<OUT, OP> containingTask, RecordWriterDelegate<SerializationDelegate<StreamRecord<OUT>>> recordWriterDelegate) {
        super(containingTask, recordWriterDelegate);
    }

    @VisibleForTesting
    RegularOperatorChain(List<StreamOperatorWrapper<?, ?>> allOperatorWrappers, RecordWriterOutput<?>[] streamOutputs, WatermarkGaugeExposingOutput<StreamRecord<OUT>> mainOperatorOutput, StreamOperatorWrapper<OUT, OP> mainOperatorWrapper) {
        super(allOperatorWrappers, streamOutputs, mainOperatorOutput, mainOperatorWrapper);
    }

    @Override
    public boolean isTaskDeployedAsFinished() {
        return false;
    }

    @Override
    public void dispatchOperatorEvent(OperatorID operator, SerializedValue<OperatorEvent> event) throws FlinkException {
        this.operatorEventDispatcher.dispatchEventToHandlers(operator, event);
    }

    @Override
    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators()) {
            if (operatorWrapper.isClosed()) continue;
            operatorWrapper.getStreamOperator().prepareSnapshotPreBarrier(checkpointId);
        }
    }

    @Override
    public void endInput(int inputId) throws Exception {
        if (this.mainOperatorWrapper != null) {
            this.mainOperatorWrapper.endOperatorInput(inputId);
        }
    }

    @Override
    public void initializeStateAndOpenOperators(StreamTaskStateInitializer streamTaskStateInitializer) throws Exception {
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators(true)) {
            Object operator = operatorWrapper.getStreamOperator();
            operator.initializeState(streamTaskStateInitializer);
            operator.open();
        }
    }

    @Override
    public void finishOperators(StreamTaskActionExecutor actionExecutor) throws Exception {
        if (this.firstOperatorWrapper != null) {
            this.firstOperatorWrapper.finish(actionExecutor);
        }
    }

    @Override
    public void closeAllOperators() throws Exception {
        super.closeAllOperators();
        Exception closingException = null;
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators(true)) {
            try {
                operatorWrapper.close();
            }
            catch (Exception e) {
                closingException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, closingException);
            }
        }
        if (closingException != null) {
            throw closingException;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Nullable
    StreamOperator<?> getTailOperator() {
        return this.tailOperatorWrapper == null ? null : (StreamOperator<?>)this.tailOperatorWrapper.getStreamOperator();
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        Exception previousException = null;
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators(true)) {
            try {
                operatorWrapper.notifyCheckpointComplete(checkpointId);
            }
            catch (Exception e) {
                previousException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, previousException);
            }
        }
        ExceptionUtils.tryRethrowException(previousException);
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        Exception previousException = null;
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators(true)) {
            try {
                operatorWrapper.getStreamOperator().notifyCheckpointAborted(checkpointId);
            }
            catch (Exception e) {
                previousException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, previousException);
            }
        }
        ExceptionUtils.tryRethrowException(previousException);
    }

    @Override
    public void snapshotState(Map<OperatorID, OperatorSnapshotFutures> operatorSnapshotsInProgress, CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, Supplier<Boolean> isRunning, ChannelStateWriter.ChannelStateWriteResult channelStateWriteResult, CheckpointStreamFactory storage) throws Exception {
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators(true)) {
            if (operatorWrapper.isClosed()) continue;
            operatorSnapshotsInProgress.put(operatorWrapper.getStreamOperator().getOperatorID(), this.buildOperatorSnapshotFutures(checkpointMetaData, checkpointOptions, (StreamOperator<?>)operatorWrapper.getStreamOperator(), isRunning, channelStateWriteResult, storage));
        }
    }

    private OperatorSnapshotFutures buildOperatorSnapshotFutures(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, StreamOperator<?> op, Supplier<Boolean> isRunning, ChannelStateWriter.ChannelStateWriteResult channelStateWriteResult, CheckpointStreamFactory storage) throws Exception {
        OperatorSnapshotFutures snapshotInProgress = RegularOperatorChain.checkpointStreamOperator(op, checkpointMetaData, checkpointOptions, storage, isRunning);
        if (op == this.getMainOperator()) {
            snapshotInProgress.setInputChannelStateFuture((Future<SnapshotResult<StateObjectCollection<InputChannelStateHandle>>>)((Object)((CompletableFuture)channelStateWriteResult.getInputChannelStateHandles().thenApply(StateObjectCollection::new)).thenApply(SnapshotResult::of)));
        }
        if (op == this.getTailOperator()) {
            snapshotInProgress.setResultSubpartitionStateFuture((Future<SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>>>)((Object)((CompletableFuture)channelStateWriteResult.getResultSubpartitionStateHandles().thenApply(StateObjectCollection::new)).thenApply(SnapshotResult::of)));
        }
        return snapshotInProgress;
    }

    private static OperatorSnapshotFutures checkpointStreamOperator(StreamOperator<?> op, CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation, Supplier<Boolean> isRunning) throws Exception {
        try {
            return op.snapshotState(checkpointMetaData.getCheckpointId(), checkpointMetaData.getTimestamp(), checkpointOptions, storageLocation);
        }
        catch (Exception ex) {
            if (isRunning.get().booleanValue()) {
                LOG.info(ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }
}

