/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels.store.op;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsRequestPBImpl;

public class AddClusterLabelOp
extends FSNodeStoreLogOp<CommonNodeLabelsManager> {
    private List<NodeLabel> labels;
    public static final int OPCODE = 0;

    @Override
    public void write(OutputStream os, CommonNodeLabelsManager mgr) throws IOException {
        ((AddToClusterNodeLabelsRequestPBImpl)AddToClusterNodeLabelsRequest.newInstance(this.labels)).getProto().writeDelimitedTo(os);
    }

    @Override
    public void recover(InputStream is, CommonNodeLabelsManager mgr) throws IOException {
        this.labels = new AddToClusterNodeLabelsRequestPBImpl(YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.parseDelimitedFrom(is)).getNodeLabels();
        mgr.addToCluserNodeLabels(this.labels);
    }

    public AddClusterLabelOp setLabels(List<NodeLabel> nodeLabels) {
        this.labels = nodeLabels;
        return this;
    }

    public List<NodeLabel> getLabels() {
        return this.labels;
    }

    @Override
    public int getOpCode() {
        return 0;
    }
}

