/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.enums;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public enum StorageType implements Serializable
{
    HDFS("hdfs"),
    LFS("lfs");

    private final String identifier;

    private StorageType(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static StorageType of(String identifier) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return LFS;
        }
        for (StorageType type : StorageType.values()) {
            if (!type.identifier.equals(identifier)) continue;
            return type;
        }
        return LFS;
    }
}

