/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog.inmemory;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.state.changelog.StateChange;

@Internal
public class InMemoryChangelogStateHandle
implements ChangelogStateHandle {
    private static final long serialVersionUID = 1L;
    private final List<StateChange> changes;
    private final SequenceNumber from;
    private final SequenceNumber to;
    private final KeyGroupRange keyGroupRange;

    public InMemoryChangelogStateHandle(List<StateChange> changes, long from, long to, KeyGroupRange keyGroupRange) {
        this(changes, SequenceNumber.of(from), SequenceNumber.of(to), keyGroupRange);
    }

    public InMemoryChangelogStateHandle(List<StateChange> changes, SequenceNumber from, SequenceNumber to, KeyGroupRange keyGroupRange) {
        this.changes = changes;
        this.from = from;
        this.to = to;
        this.keyGroupRange = keyGroupRange;
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return this.changes.stream().mapToLong(change -> change.getChange().length).sum();
    }

    public List<StateChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    @Nullable
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        return this.changes.stream().mapToInt(StateChange::getKeyGroup).anyMatch(keyGroupRange::contains) ? this : null;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
    }

    public String toString() {
        return String.format("from %s to %s: %s", this.from, this.to, this.changes);
    }

    public long getFrom() {
        return ((SequenceNumber.GenericSequenceNumber)this.from).number;
    }

    public long getTo() {
        return ((SequenceNumber.GenericSequenceNumber)this.to).number;
    }
}

