/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.IdeaProxyLambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.ReflectLambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import com.baomidou.mybatisplus.core.toolkit.support.ShadowLambdaMeta;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<String, Map<String, ColumnCache>> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, Map<String, ColumnCache>>();

    public static <T> LambdaMeta extract(SFunction<T, ?> func) {
        if (func instanceof Proxy) {
            return new IdeaProxyLambdaMeta((Proxy)((Object)func));
        }
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            return new ReflectLambdaMeta((java.lang.invoke.SerializedLambda)ReflectionKit.setAccessible(method).invoke(func, new Object[0]));
        }
        catch (Throwable e) {
            return new ShadowLambdaMeta(SerializedLambda.extract(func));
        }
    }

    public static String formatKey(String key) {
        return key.toUpperCase(Locale.ENGLISH);
    }

    public static void installCache(TableInfo tableInfo) {
        COLUMN_CACHE_MAP.put(tableInfo.getEntityType().getName(), LambdaUtils.createColumnCacheMap(tableInfo));
    }

    private static Map<String, ColumnCache> createColumnCacheMap(TableInfo info) {
        HashMap<String, ColumnCache> map;
        if (info.havePK()) {
            map = CollectionUtils.newHashMapWithExpectedSize(info.getFieldList().size() + 1);
            map.put(LambdaUtils.formatKey(info.getKeyProperty()), new ColumnCache(info.getKeyColumn(), info.getKeySqlSelect()));
        } else {
            map = CollectionUtils.newHashMapWithExpectedSize(info.getFieldList().size());
        }
        info.getFieldList().forEach(i -> map.put(LambdaUtils.formatKey(i.getProperty()), new ColumnCache(i.getColumn(), i.getSqlSelect(), i.getMapping())));
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(Class<?> clazz) {
        return CollectionUtils.computeIfAbsent(COLUMN_CACHE_MAP, clazz.getName(), key -> {
            TableInfo info = TableInfoHelper.getTableInfo(clazz);
            return info == null ? null : LambdaUtils.createColumnCacheMap(info);
        });
    }
}

