/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.util.MutableObjectIterator;

public class ChannelReaderInputViewIterator<E>
implements MutableObjectIterator<E> {
    private final AbstractChannelReaderInputView inView;
    private final TypeSerializer<E> accessors;
    private final List<MemorySegment> freeMemTarget;

    public ChannelReaderInputViewIterator(IOManager ioAccess, FileIOChannel.ID channel, List<MemorySegment> segments, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors, int numBlocks) throws IOException {
        this(ioAccess, channel, new LinkedBlockingQueue<MemorySegment>(), segments, freeMemTarget, accessors, numBlocks);
    }

    public ChannelReaderInputViewIterator(IOManager ioAccess, FileIOChannel.ID channel, LinkedBlockingQueue<MemorySegment> returnQueue, List<MemorySegment> segments, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors, int numBlocks) throws IOException {
        this(ioAccess.createBlockChannelReader(channel, returnQueue), returnQueue, segments, freeMemTarget, accessors, numBlocks);
    }

    public ChannelReaderInputViewIterator(BlockChannelReader<MemorySegment> reader, LinkedBlockingQueue<MemorySegment> returnQueue, List<MemorySegment> segments, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors, int numBlocks) throws IOException {
        this.accessors = accessors;
        this.freeMemTarget = freeMemTarget;
        this.inView = new ChannelReaderInputView(reader, segments, numBlocks, false);
    }

    public ChannelReaderInputViewIterator(AbstractChannelReaderInputView inView, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors) {
        this.inView = inView;
        this.freeMemTarget = freeMemTarget;
        this.accessors = accessors;
    }

    public E next(E reuse) throws IOException {
        try {
            return (E)this.accessors.deserialize(reuse, (DataInputView)this.inView);
        }
        catch (EOFException eofex) {
            List<MemorySegment> freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }

    public E next() throws IOException {
        try {
            return (E)this.accessors.deserialize((DataInputView)this.inView);
        }
        catch (EOFException eofex) {
            List<MemorySegment> freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }
}

