/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Watcher;
import java.util.Collections;
import java.util.List;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.AbstractKubernetesWatcher;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesPod;
import org.apache.flink.kubernetes.utils.KubernetesUtils;

public class KubernetesPodsWatcher
extends AbstractKubernetesWatcher<Pod, KubernetesPod> {
    public KubernetesPodsWatcher(FlinkKubeClient.WatchCallbackHandler<KubernetesPod> callbackHandler) {
        super(callbackHandler);
    }

    @Override
    public void eventReceived(Watcher.Action action, Pod pod) {
        this.logger.debug("Received {} event for pod {}, details: {}{}", new Object[]{action, pod.getMetadata().getName(), System.lineSeparator(), KubernetesUtils.tryToGetPrettyPrintYaml(pod.getStatus())});
        List<KubernetesPod> pods = Collections.singletonList(new KubernetesPod(pod));
        switch (action) {
            case ADDED: {
                this.callbackHandler.onAdded(pods);
                break;
            }
            case MODIFIED: {
                this.callbackHandler.onModified(pods);
                break;
            }
            case ERROR: {
                this.callbackHandler.onError(pods);
                break;
            }
            case DELETED: {
                this.callbackHandler.onDeleted(pods);
                break;
            }
            default: {
                this.logger.debug("Ignore handling {} event for pod {}", (Object)action, (Object)pod.getMetadata().getName());
            }
        }
    }
}

