/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.DefaultSupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthCheckModuleDescriptorNotFoundException;
import com.atlassian.support.healthcheck.SupportHealthCheckSupplier;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.impl.Pair;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.healthcheck.thread.HealthCheckCallable;
import com.atlassian.support.healthcheck.thread.HealthCheckThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultSupportHealthCheckManager
implements SupportHealthCheckManager,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultSupportHealthCheckManager.class);
    private static final int CHECK_THREAD_COUNT = Integer.getInteger("atlassian.healthcheck.thread-count", 8);
    private final SupportHealthCheckSupplier healthCheckSupplier;
    private ExecutorService executorService;
    private final UserManager userManager;

    public DefaultSupportHealthCheckManager(SupportHealthCheckSupplier healthCheckSupplier, UserManager userManager) {
        this.healthCheckSupplier = healthCheckSupplier;
        this.userManager = userManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.startThreadPool();
    }

    public void destroy() throws Exception {
        this.stopThreadPool();
    }

    void startThreadPool() {
        this.executorService = Executors.newFixedThreadPool(CHECK_THREAD_COUNT, new HealthCheckThreadFactory());
    }

    void stopThreadPool() {
        this.executorService.shutdownNow();
    }

    @Override
    public Collection<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> performAllChecks() {
        return this.runChecks(this.getHealthChecks());
    }

    @Override
    public Collection<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> performChecksWithKeys(Set<String> completeKeys) throws SupportHealthCheckModuleDescriptorNotFoundException {
        return this.runChecks(this.getHealthChecksWithKeys(completeKeys));
    }

    @Override
    public Collection<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> performChecks(Collection<ExtendedSupportHealthCheck> checks) {
        return this.runChecks(checks);
    }

    @Override
    public Collection<ExtendedSupportHealthCheck> getHealthChecks() {
        return this.healthCheckSupplier.getHealthChecks();
    }

    @Override
    public Collection<ExtendedSupportHealthCheck> getHealthChecksWithKeys(Set<String> completeKeys) throws SupportHealthCheckModuleDescriptorNotFoundException {
        return this.healthCheckSupplier.getHealthChecksWithKeys(completeKeys);
    }

    private void checkIfAdmin() {
        String userName = this.userManager.getRemoteUsername();
        if (userName == null || !this.userManager.isAdmin(userName)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private Collection<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> runChecks(Collection<ExtendedSupportHealthCheck> healthChecks) {
        this.checkIfAdmin();
        ArrayList<Pair<Future<SupportHealthStatus>, ExtendedSupportHealthCheck>> futurePairs = new ArrayList<Pair<Future<SupportHealthStatus>, ExtendedSupportHealthCheck>>(healthChecks.size());
        for (ExtendedSupportHealthCheck check : healthChecks) {
            Future<SupportHealthStatus> future = this.executorService.submit(new HealthCheckCallable(check));
            futurePairs.add(new Pair<Future<SupportHealthStatus>, ExtendedSupportHealthCheck>(future, check));
        }
        ArrayList<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>> statuses = new ArrayList<Pair<ExtendedSupportHealthCheck, SupportHealthStatus>>();
        for (Pair pair : futurePairs) {
            ExtendedSupportHealthCheck healthCheck = (ExtendedSupportHealthCheck)pair.getRight();
            Future future = (Future)pair.getLeft();
            try {
                statuses.add(new Pair(healthCheck, future.get(healthCheck.getTimeOut(), TimeUnit.MILLISECONDS)));
            }
            catch (InterruptedException e) {
                statuses.add(new Pair<ExtendedSupportHealthCheck, DefaultSupportHealthStatus>(healthCheck, new DefaultSupportHealthStatus(false, "InterruptedException: " + e.getMessage(), System.currentTimeMillis(), Application.Unknown, SupportHealthStatus.Severity.UNDEFINED, "")));
                log.info(e.getMessage(), (Throwable)e);
            }
            catch (ExecutionException e) {
                statuses.add(new Pair<ExtendedSupportHealthCheck, DefaultSupportHealthStatus>(healthCheck, new DefaultSupportHealthStatus(false, "ExecutionException: " + e.getMessage(), System.currentTimeMillis(), Application.Unknown, SupportHealthStatus.Severity.UNDEFINED, "")));
                log.info(e.getMessage(), (Throwable)e);
            }
            catch (TimeoutException e) {
                statuses.add(new Pair<ExtendedSupportHealthCheck, DefaultSupportHealthStatus>(healthCheck, new DefaultSupportHealthStatus(false, "TimeoutException after " + healthCheck.getTimeOut() + "ms", System.currentTimeMillis(), Application.Unknown, SupportHealthStatus.Severity.UNDEFINED, "")));
                future.cancel(true);
                log.info(e.getMessage(), (Throwable)e);
            }
        }
        return statuses;
    }
}

