/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import io.smallrye.metrics.legacyapi.SnapshotAdapter;
import io.smallrye.metrics.setup.config.DefaultBucketConfiguration;
import io.smallrye.metrics.setup.config.MetricPercentileConfiguration;
import io.smallrye.metrics.setup.config.MetricsConfigurationManager;
import io.smallrye.metrics.setup.config.TimerBucketConfiguration;
import io.smallrye.metrics.setup.config.TimerBucketMaxConfiguration;
import io.smallrye.metrics.setup.config.TimerBucketMinConfiguration;
import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

class TimerAdapter
implements Timer,
MeterHolder {
    private static final String CLASS_NAME = TimerAdapter.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private static final int PRECISION = ConfigProvider.getConfig().getOptionalValue("mp.metrics.smallrye.timer.precision", Integer.class).orElse(3);
    io.micrometer.core.instrument.Timer globalCompositeTimer;
    final MeterRegistry registry;

    TimerAdapter(MeterRegistry registry) {
        this.registry = registry;
    }

    public TimerAdapter register(MpMetadata metadata, MetricDescriptor descriptor, String scope, Tag ... globalTags) {
        if (this.globalCompositeTimer == null || metadata.cleanDirtyMetadata()) {
            MetricPercentileConfiguration percentilesConfig = MetricsConfigurationManager.getInstance().getPercentilesConfiguration(metadata.getName());
            TimerBucketConfiguration bucketsConfig = MetricsConfigurationManager.getInstance().getTimerBucketConfiguration(metadata.getName());
            DefaultBucketConfiguration defaultBucketConfig = MetricsConfigurationManager.getInstance().getDefaultBucketConfiguration(metadata.getName());
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : descriptor.tags()) {
                tagsSet.add(t);
            }
            if (globalTags != null) {
                for (Tag t : globalTags) {
                    tagsSet.add(t);
                }
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            Timer.Builder builder = io.micrometer.core.instrument.Timer.builder((String)descriptor.name()).description(metadata.getDescription()).tags(tagsSet).percentilePrecision(Integer.valueOf(PRECISION));
            if (percentilesConfig != null && percentilesConfig.getValues() != null && ((Double[])percentilesConfig.getValues()).length > 0) {
                double[] vals = Stream.of((Double[])percentilesConfig.getValues()).mapToDouble(Double::doubleValue).toArray();
                builder = builder.publishPercentiles(vals);
            } else if (percentilesConfig == null || percentilesConfig.getValues() != null || !percentilesConfig.isDisabled()) {
                builder = builder.publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999});
            }
            if (bucketsConfig != null && ((Duration[])bucketsConfig.getValues()).length > 0) {
                builder = builder.serviceLevelObjectives((Duration[])bucketsConfig.getValues());
            }
            if (defaultBucketConfig != null && defaultBucketConfig.isEnabled()) {
                TimerBucketMinConfiguration defaultBucketMinConfig;
                builder = builder.publishPercentileHistogram(Boolean.valueOf(defaultBucketConfig.isEnabled()));
                TimerBucketMaxConfiguration defaultBucketMaxConfig = MetricsConfigurationManager.getInstance().getDefaultTimerMaxBucketConfiguration(metadata.getName());
                if (defaultBucketMaxConfig != null && defaultBucketMaxConfig.getValue() != null) {
                    builder = builder.maximumExpectedValue((Duration)defaultBucketMaxConfig.getValue());
                }
                if ((defaultBucketMinConfig = MetricsConfigurationManager.getInstance().getDefaultTimerMinBucketConfiguration(metadata.getName())) != null && defaultBucketMinConfig.getValue() != null) {
                    builder = builder.minimumExpectedValue((Duration)defaultBucketMinConfig.getValue());
                }
            }
            this.globalCompositeTimer = builder.register((MeterRegistry)Metrics.globalRegistry);
        }
        return this;
    }

    public void update(long l, TimeUnit timeUnit) {
        this.globalCompositeTimer.record(l, timeUnit);
    }

    public void update(Duration duration) {
        this.globalCompositeTimer.record(duration);
    }

    public <T> T time(Callable<T> callable) throws Exception {
        return (T)this.globalCompositeTimer.wrap(callable).call();
    }

    public void time(Runnable runnable) {
        this.globalCompositeTimer.wrap(runnable).run();
    }

    public SampleAdapter time() {
        return new SampleAdapter(this.globalCompositeTimer, io.micrometer.core.instrument.Timer.start((MeterRegistry)Metrics.globalRegistry));
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos((long)this.globalCompositeTimer.totalTime(TimeUnit.NANOSECONDS));
    }

    public long getCount() {
        return this.globalCompositeTimer.count();
    }

    public Snapshot getSnapshot() {
        return new SnapshotAdapter(this.globalCompositeTimer.takeSnapshot());
    }

    @Override
    public Meter getMeter() {
        return this.globalCompositeTimer;
    }

    public Timer.Sample start() {
        return io.micrometer.core.instrument.Timer.start((MeterRegistry)this.registry);
    }

    public void stop(Timer.Sample sample) {
        sample.stop(this.globalCompositeTimer);
    }

    static {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, CLASS_NAME, null, "Resolved MicroProfile Config value for mp.metrics.smallrye.timer.precision as \"{0}\"", PRECISION);
        }
    }

    class SampleAdapter
    implements Timer.Context {
        final io.micrometer.core.instrument.Timer timer;
        final Timer.Sample sample;

        SampleAdapter(io.micrometer.core.instrument.Timer timer, Timer.Sample sample) {
            this.sample = sample;
            this.timer = timer;
        }

        public long stop() {
            return this.sample.stop(this.timer);
        }

        public void close() {
            this.sample.stop(this.timer);
        }
    }
}

