/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.AuthorityBinding;
import org.opensaml.saml.saml1.core.SubjectLocality;
import org.opensaml.saml.saml1.core.impl.SubjectStatementUnmarshaller;
import org.w3c.dom.Attr;

public class AuthenticationStatementUnmarshaller
extends SubjectStatementUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)parentObject;
        if (childObject instanceof SubjectLocality) {
            authenticationStatement.setSubjectLocality((SubjectLocality)childObject);
        } else if (childObject instanceof AuthorityBinding) {
            authenticationStatement.getAuthorityBindings().add((AuthorityBinding)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if ("AuthenticationInstant".equals(attribute.getLocalName()) && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                authenticationStatement.setAuthenticationInstant(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
            } else if ("AuthenticationMethod".equals(attribute.getLocalName())) {
                authenticationStatement.setAuthenticationMethod(attribute.getValue());
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

