/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.PropertyName;
import io.smallrye.config.SecretKeys;
import io.smallrye.config._private.ConfigMessages;
import jakarta.annotation.Priority;
import java.util.Set;

@Priority(value=3100)
public class SecretKeysConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 7291982039729980590L;
    private final Set<PropertyName> secrets;

    public SecretKeysConfigSourceInterceptor(Set<PropertyName> secrets) {
        this.secrets = secrets;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (SecretKeys.isLocked() && this.secrets.contains(PropertyName.unprofiled(name))) {
            throw ConfigMessages.msg.notAllowed(name);
        }
        return context.proceed(name);
    }
}

