/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ContentTypes;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpVerb;
import groovyx.net.http.NativeHandlers;
import groovyx.net.http.ToServer;
import groovyx.net.http.Traverser;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ChainedHttpConfig
extends HttpConfig {
    public Map<Map.Entry<String, Object>, Object> getContextMap();

    default public Object actualContext(String contentType, Object id) {
        AbstractMap.SimpleImmutableEntry<String, Object> key = new AbstractMap.SimpleImmutableEntry<String, Object>(contentType, id);
        AbstractMap.SimpleImmutableEntry<String, Object> anyKey = new AbstractMap.SimpleImmutableEntry<String, Object>(ContentTypes.ANY.getAt(0), id);
        Function<ChainedHttpConfig, Object> theValue = config -> {
            Object ctx = config.getContextMap().get(key);
            if (ctx != null) {
                return ctx;
            }
            return config.getContextMap().get(anyKey);
        };
        return Traverser.traverse(this, ChainedHttpConfig::getParent, theValue, Traverser::notNull);
    }

    public ChainedResponse getChainedResponse();

    public ChainedRequest getChainedRequest();

    public ChainedHttpConfig getParent();

    default public BiFunction<ChainedHttpConfig, FromServer, Object> findParser(String contentType) {
        BiFunction<ChainedHttpConfig, FromServer, Object> found = this.getChainedResponse().actualParser(contentType);
        return found == null ? NativeHandlers.Parsers::streamToBytes : found;
    }

    default public BiConsumer<ChainedHttpConfig, ToServer> findEncoder() {
        return this.findEncoder(this.findContentType());
    }

    default public BiConsumer<ChainedHttpConfig, ToServer> findEncoder(String contentType) {
        BiConsumer<ChainedHttpConfig, ToServer> encoder = this.getChainedRequest().actualEncoder(contentType);
        if (encoder == null) {
            throw new IllegalStateException("Could not find encoder for content-type (" + contentType + ")");
        }
        return encoder;
    }

    default public String findContentType() {
        String contentType = this.getChainedRequest().actualContentType();
        if (contentType == null) {
            throw new IllegalStateException("Found request body, but content type is undefined");
        }
        return contentType;
    }

    default public Charset findCharset() {
        return this.getChainedRequest().actualCharset();
    }

    public static interface ChainedResponse
    extends HttpConfig.Response {
        public ChainedResponse getParent();

        public Class<?> getType();

        public Function<Throwable, ?> getException();

        default public BiFunction<FromServer, Object, ?> actualAction(Integer code) {
            return Traverser.traverse(this, ChainedResponse::getParent, cr -> cr.when(code), Traverser::notNull);
        }

        default public Function<Throwable, ?> actualException() {
            return Traverser.traverse(this, ChainedResponse::getParent, ChainedResponse::getException, Traverser::notNull);
        }

        default public BiFunction<ChainedHttpConfig, FromServer, Object> actualParser(String contentType) {
            Function<ChainedResponse, BiFunction> theValue = cr -> {
                BiFunction<ChainedHttpConfig, FromServer, Object> ret = cr.parser(contentType);
                if (ret != null) {
                    return ret;
                }
                return cr.parser(ContentTypes.ANY.getAt(0));
            };
            return Traverser.traverse(this, ChainedResponse::getParent, theValue, Traverser::notNull);
        }
    }

    public static interface ChainedRequest
    extends HttpConfig.Request {
        public ChainedRequest getParent();

        public List<HttpCookie> getCookies();

        public Object getBody();

        public String getContentType();

        public Map<String, BiConsumer<ChainedHttpConfig, ToServer>> getEncoderMap();

        public Charset getCharset();

        default public Charset actualCharset() {
            return Traverser.traverse(this, ChainedRequest::getParent, ChainedRequest::getCharset, Traverser::notNull);
        }

        default public String actualContentType() {
            return Traverser.traverse(this, ChainedRequest::getParent, ChainedRequest::getContentType, Traverser::notNull);
        }

        default public Object actualBody() {
            return Traverser.traverse(this, ChainedRequest::getParent, ChainedRequest::getBody, Traverser::notNull);
        }

        default public Map<String, CharSequence> actualHeaders(Map<String, CharSequence> map) {
            Predicate<Map> addValues = headers -> {
                map.putAll((Map<String, CharSequence>)headers);
                return false;
            };
            Traverser.traverse(this, ChainedRequest::getParent, HttpConfig.Request::getHeaders, addValues);
            return map;
        }

        default public BiConsumer<ChainedHttpConfig, ToServer> actualEncoder(String contentType) {
            Function<ChainedRequest, BiConsumer> theValue = cr -> {
                BiConsumer<ChainedHttpConfig, ToServer> ret = cr.encoder(contentType);
                if (ret != null) {
                    return ret;
                }
                return cr.encoder(ContentTypes.ANY.getAt(0));
            };
            return Traverser.traverse(this, ChainedRequest::getParent, theValue, Traverser::notNull);
        }

        default public HttpConfig.Auth actualAuth() {
            Predicate<HttpConfig.Auth> choose = a -> a != null && a.getAuthType() != null;
            return Traverser.traverse(this, ChainedRequest::getParent, HttpConfig.Request::getAuth, choose);
        }

        default public List<HttpCookie> actualCookies(List<HttpCookie> list) {
            Predicate<List> addAll = cookies -> {
                list.addAll((Collection<HttpCookie>)cookies);
                return false;
            };
            Traverser.traverse(this, ChainedRequest::getParent, ChainedRequest::getCookies, addAll);
            return list;
        }

        public HttpVerb getVerb();

        public void setVerb(HttpVerb var1);
    }
}

