/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.RollbackProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,routing")
@XmlRootElement(name="rollback")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RollbackDefinition
extends NoOutputDefinition<RollbackDefinition> {
    @XmlAttribute
    private Boolean markRollbackOnly;
    @XmlAttribute
    private Boolean markRollbackOnlyLast;
    @XmlAttribute
    private String message;

    public RollbackDefinition() {
    }

    public RollbackDefinition(String message) {
        this.message = message;
    }

    public String toString() {
        if (this.message != null) {
            return "Rollback[" + this.message + "]";
        }
        return "Rollback";
    }

    @Override
    public String getShortName() {
        return "rollback";
    }

    @Override
    public String getLabel() {
        return "rollback";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        boolean isMarkRollbackOnlyLast;
        boolean isMarkRollbackOnly = this.getMarkRollbackOnly() != null && this.getMarkRollbackOnly() != false;
        boolean bl = isMarkRollbackOnlyLast = this.getMarkRollbackOnlyLast() != null && this.getMarkRollbackOnlyLast() != false;
        if (isMarkRollbackOnly && isMarkRollbackOnlyLast) {
            throw new IllegalArgumentException("Only either one of markRollbackOnly and markRollbackOnlyLast is possible to select as true");
        }
        RollbackProcessor answer = new RollbackProcessor(this.message);
        answer.setMarkRollbackOnly(isMarkRollbackOnly);
        answer.setMarkRollbackOnlyLast(isMarkRollbackOnlyLast);
        return answer;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Boolean getMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(Boolean markRollbackOnly) {
        this.markRollbackOnly = markRollbackOnly;
    }

    public Boolean getMarkRollbackOnlyLast() {
        return this.markRollbackOnlyLast;
    }

    public void setMarkRollbackOnlyLast(Boolean markRollbackOnlyLast) {
        this.markRollbackOnlyLast = markRollbackOnlyLast;
    }
}

