/* glibc bindings for target ABI version glibc 2.11 */
#if defined(__linux__) && !defined (__LIBC_CUSTOM_BINDINGS_H__) && !defined(__ANDROID__)

#if defined (__cplusplus)
extern "C" {
#endif

#undef SYMVER
#undef SYMVER1
#ifdef __ASSEMBLER__
#define SYMVER1(name, ver) .symver name, name##@##ver
#else
#define SYMVER1(name, ver) __asm__(".symver " #name ", " #name "@" #ver );
#endif
#define SYMVER(name, ver) SYMVER1(name, ver)

#if defined(__i386__) || defined(__x86_64__)
 
/* Symbols redirected to earlier glibc versions */
SYMVER(__longjmp_chk, GLIBC_2.11)
SYMVER(_sys_errlist, GLIBC_2.4)
SYMVER(_sys_nerr, GLIBC_2.4)
#if defined(__x86_64__)
SYMVER(clock_getcpuclockid, GLIBC_2.2.5)
SYMVER(clock_getres, GLIBC_2.2.5)
SYMVER(clock_gettime, GLIBC_2.2.5)
SYMVER(clock_nanosleep, GLIBC_2.2.5)
SYMVER(clock_settime, GLIBC_2.2.5)
#else
SYMVER(clock_getcpuclockid, GLIBC_2.2)
SYMVER(clock_getres, GLIBC_2.2)
SYMVER(clock_gettime, GLIBC_2.2)
SYMVER(clock_nanosleep, GLIBC_2.2)
SYMVER(clock_settime, GLIBC_2.2)
#endif
SYMVER(execvpe, GLIBC_2.11)
#if defined(__i386__)
SYMVER(fallocate64, GLIBC_2.11)
#endif
#if defined(__x86_64__)
SYMVER(exp2f, GLIBC_2.2.5)
SYMVER(expf, GLIBC_2.2.5)
SYMVER(fmemopen, GLIBC_2.2.5)
SYMVER(glob, GLIBC_2.2.5)
SYMVER(glob64, GLIBC_2.2.5)
SYMVER(lgamma, GLIBC_2.2.5)
SYMVER(lgammaf, GLIBC_2.2.5)
SYMVER(lgammal, GLIBC_2.2.5)
SYMVER(log2f, GLIBC_2.2.5)
SYMVER(logf, GLIBC_2.2.5)
SYMVER(memcpy, GLIBC_2.2.5)
#else
SYMVER(fmemopen, GLIBC_2.2)
SYMVER(lgamma, GLIBC_2.0)
SYMVER(lgammaf, GLIBC_2.0)
SYMVER(lgammal, GLIBC_2.0)
#endif
SYMVER(mkostemps, GLIBC_2.11)
SYMVER(mkostemps64, GLIBC_2.11)
SYMVER(mkstemps, GLIBC_2.11)
SYMVER(mkstemps64, GLIBC_2.11)
#if defined(__x86_64__)
SYMVER(posix_spawn, GLIBC_2.2.5)
SYMVER(posix_spawnp, GLIBC_2.2.5)
SYMVER(powf, GLIBC_2.2.5)
#else
SYMVER(posix_spawn, GLIBC_2.2)
SYMVER(posix_spawnp, GLIBC_2.2)
#endif
SYMVER(pthread_sigqueue, GLIBC_2.11)
SYMVER(quick_exit, GLIBC_2.10)
SYMVER(sys_errlist, GLIBC_2.4)
SYMVER(sys_nerr, GLIBC_2.4)

/* Symbols introduced in newer glibc versions, which must not be used */
SYMVER(_ZGVbN2v_cos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN2v_exp, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN2v_log, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN2v_sin, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN2vv_pow, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN2vvv_sincos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN4v_cosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN4v_expf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN4v_logf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN4v_sinf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN4vv_powf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVbN4vvv_sincosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN4v_cos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN4v_exp, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN4v_log, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN4v_sin, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN4vv_pow, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN4vvv_sincos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN8v_cosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN8v_expf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN8v_logf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN8v_sinf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN8vv_powf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVcN8vvv_sincosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN4v_cos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN4v_exp, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN4v_log, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN4v_sin, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN4vv_pow, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN4vvv_sincos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN8v_cosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN8v_expf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN8v_logf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN8v_sinf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN8vv_powf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVdN8vvv_sincosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN16v_cosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN16v_expf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN16v_logf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN16v_sinf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN16vv_powf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN16vvv_sincosf, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN8v_cos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN8v_exp, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN8v_log, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN8v_sin, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN8vv_pow, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(_ZGVeN8vvv_sincos, GLIBC_DONT_USE_THIS_VERSION_2.22)
SYMVER(__acos_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__acosf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__acosf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__acosh_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__acoshf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__acoshf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__acoshl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__acosl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__asin_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__asinf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__asinf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__asinl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__atan2_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__atan2f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__atan2f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__atan2l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__atanh_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__atanhf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__atanhf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__atanhl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__cosh_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__coshf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__coshf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__coshl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__cxa_thread_atexit_impl, GLIBC_DONT_USE_THIS_VERSION_2.18)
SYMVER(__exp10_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__exp10f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__exp10f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__exp10l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__exp2_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__exp2f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__exp2f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__exp2l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__exp_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__expf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__expf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__expl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__explicit_bzero_chk, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(__fdelt_chk, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__fdelt_warn, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__fentry__, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(__finitef128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__fmod_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__fmodf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__fmodf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__fmodl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__fpclassifyf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__gamma_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__gammaf128_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__gammaf_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__gammal_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__getauxval, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(__hypot_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__hypotf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__hypotf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__hypotl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__iscanonicall, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(__iseqsig, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(__iseqsigf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(__iseqsigf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__iseqsigl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(__isinff128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__isnanf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__issignaling, GLIBC_DONT_USE_THIS_VERSION_2.18)
SYMVER(__issignalingf, GLIBC_DONT_USE_THIS_VERSION_2.18)
SYMVER(__issignalingf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__issignalingl, GLIBC_DONT_USE_THIS_VERSION_2.18)
SYMVER(__j0_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__j0f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__j0f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__j0l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__j1_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__j1f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__j1f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__j1l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__jn_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__jnf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__jnf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__jnl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__lgamma_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__lgammaf128_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__lgammaf_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__lgammal_r_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log10_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log10f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__log10f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log10l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log2_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log2f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__log2f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log2l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__log_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__logf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__logf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__logl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__poll_chk, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(__pow_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__powf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__powf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__powl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__ppoll_chk, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(__remainder_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__remainderf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__remainderf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__remainderl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__scalb_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__scalbf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__scalbl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__signbitf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__signgam, GLIBC_DONT_USE_THIS_VERSION_2.23)
SYMVER(__sinh_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__sinhf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__sinhf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__sinhl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__sqrt_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__sqrtf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__sqrtf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__sqrtl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__strtof128_internal, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__wcstof128_internal, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__y0_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__y0f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__y0f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__y0l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__y1_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__y1f128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__y1f_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__y1l_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__yn_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__ynf128_finite, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(__ynf_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(__ynl_finite, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(acosf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(acosf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acosf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acosf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acosf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acoshf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(acoshf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acoshf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acoshf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(acoshf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(aligned_alloc, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(asinf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(asinf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(asinhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(asinhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atan2f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(atan2f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atan2f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atan2f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atan2f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(atanf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(atanhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(atanhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(c16rtomb, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(c32rtomb, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(cabsf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cabsf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cabsf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cabsf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cabsf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacosf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cacosf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacosf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacosf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacosf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacoshf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cacoshf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacoshf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacoshf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cacoshf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(canonicalize, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(canonicalizef, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(canonicalizef128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(canonicalizef32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(canonicalizef32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(canonicalizef64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(canonicalizef64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(canonicalizel, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(cargf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cargf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cargf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cargf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cargf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(casinf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(casinhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(casinhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(catanf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(catanhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(catanhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cbrtf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cbrtf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cbrtf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cbrtf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cbrtf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccosf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ccosf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccosf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccosf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccosf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccoshf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ccoshf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccoshf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccoshf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ccoshf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ceilf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ceilf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ceilf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ceilf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ceilf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cexpf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cexpf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cexpf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cexpf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cexpf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cimagf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cimagf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cimagf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cimagf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cimagf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clock_adjtime, GLIBC_DONT_USE_THIS_VERSION_2.14)
SYMVER(clog10f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(clog10f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clog10f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clog10f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clog10f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clogf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(clogf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clogf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clogf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(clogf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(conjf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(conjf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(conjf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(conjf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(conjf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(copy_file_range, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(copysignf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(copysignf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(copysignf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(copysignf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(copysignf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cosf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cosf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cosf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cosf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cosf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(coshf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(coshf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(coshf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(coshf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(coshf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cpowf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cpowf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cpowf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cpowf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cpowf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cprojf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(cprojf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cprojf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cprojf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(cprojf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(crealf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(crealf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(crealf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(crealf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(crealf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(csinf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(csinhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csinhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csqrtf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(csqrtf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csqrtf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csqrtf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(csqrtf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ctanf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ctanhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ctanhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erfcf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(erfcf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erfcf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erfcf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erfcf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erff128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(erff32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erff32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erff64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(erff64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp10f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(exp10f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp10f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp10f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp10f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp2f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(exp2f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp2f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp2f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(exp2f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(expf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(explicit_bzero, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(expm1f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(expm1f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expm1f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expm1f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(expm1f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fabsf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fabsf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fabsf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fabsf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fabsf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fanotify_init, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(fanotify_mark, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(fdimf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fdimf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fdimf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fdimf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fdimf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fegetmode, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fesetexcept, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fesetmode, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fetestexceptflag, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(floorf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(floorf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(floorf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(floorf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(floorf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fmaf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fmaxf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxmag, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fmaxmagf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fmaxmagf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fmaxmagf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxmagf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxmagf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxmagf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmaxmagl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fminf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fminf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminmag, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fminmagf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fminmagf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fminmagf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminmagf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminmagf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminmagf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fminmagl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fmodf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fmodf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmodf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmodf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fmodf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(frexpf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(frexpf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(frexpf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(frexpf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(frexpf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfp, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fromfpf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fromfpf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fromfpf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fromfpx, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fromfpxf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fromfpxf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(fromfpxf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpxf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpxf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpxf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(fromfpxl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(fts64_children, GLIBC_DONT_USE_THIS_VERSION_2.23)
SYMVER(fts64_close, GLIBC_DONT_USE_THIS_VERSION_2.23)
SYMVER(fts64_open, GLIBC_DONT_USE_THIS_VERSION_2.23)
SYMVER(fts64_read, GLIBC_DONT_USE_THIS_VERSION_2.23)
SYMVER(fts64_set, GLIBC_DONT_USE_THIS_VERSION_2.23)
SYMVER(getauxval, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(getentropy, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(getpayload, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(getpayloadf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(getpayloadf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(getpayloadf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(getpayloadf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(getpayloadf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(getpayloadf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(getpayloadl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(getrandom, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(hypotf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(hypotf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(hypotf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(hypotf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(hypotf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ilogbf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ilogbf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ilogbf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ilogbf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ilogbf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j0f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(j0f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j0f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j0f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j0f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j1f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(j1f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j1f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j1f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(j1f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(jnf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(jnf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(jnf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(jnf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(jnf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ldexpf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ldexpf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ldexpf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ldexpf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ldexpf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(lgammaf128_r, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(lgammaf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf32_r, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf32x_r, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf64_r, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lgammaf64x_r, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llogb, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(llogbf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(llogbf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(llogbf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llogbf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llogbf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llogbf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llogbl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(llrintf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(llrintf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llrintf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llrintf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llrintf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llroundf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(llroundf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llroundf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llroundf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(llroundf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log10f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(log10f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log10f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log10f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log10f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log1pf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(log1pf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log1pf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log1pf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log1pf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log2f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(log2f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log2f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log2f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(log2f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logbf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(logbf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logbf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logbf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logbf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(logf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(logf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lrintf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(lrintf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lrintf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lrintf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lrintf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lroundf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(lroundf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lroundf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lroundf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(lroundf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(mbrtoc16, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(mbrtoc32, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(memfd_create, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(mlock2, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(modff128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(modff32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(modff32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(modff64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(modff64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(name_to_handle_at, GLIBC_DONT_USE_THIS_VERSION_2.14)
SYMVER(nanf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(nanf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nanf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nanf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nanf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nearbyintf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(nearbyintf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nearbyintf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nearbyintf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nearbyintf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextafterf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(nextafterf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextafterf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextafterf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextafterf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextdown, GLIBC_DONT_USE_THIS_VERSION_2.24)
SYMVER(nextdownf, GLIBC_DONT_USE_THIS_VERSION_2.24)
SYMVER(nextdownf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(nextdownf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextdownf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextdownf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextdownf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextdownl, GLIBC_DONT_USE_THIS_VERSION_2.24)
SYMVER(nextup, GLIBC_DONT_USE_THIS_VERSION_2.24)
SYMVER(nextupf, GLIBC_DONT_USE_THIS_VERSION_2.24)
SYMVER(nextupf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(nextupf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextupf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextupf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextupf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(nextupl, GLIBC_DONT_USE_THIS_VERSION_2.24)
SYMVER(ntp_gettimex, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(open_by_handle_at, GLIBC_DONT_USE_THIS_VERSION_2.14)
SYMVER(pkey_alloc, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(pkey_free, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(pkey_get, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(pkey_mprotect, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(pkey_set, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(powf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(powf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(powf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(powf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(powf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(preadv2, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(preadv64v2, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(prlimit, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(prlimit64, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(process_vm_readv, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(process_vm_writev, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(pthread_getattr_default_np, GLIBC_DONT_USE_THIS_VERSION_2.18)
SYMVER(pthread_getname_np, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_mutex_consistent, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_mutexattr_getrobust, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_mutexattr_setrobust, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_setattr_default_np, GLIBC_DONT_USE_THIS_VERSION_2.18)
SYMVER(pthread_setname_np, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pwritev2, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(pwritev64v2, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(reallocarray, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(recvmmsg, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(remainderf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(remainderf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remainderf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remainderf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remainderf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remquof128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(remquof32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remquof32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remquof64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(remquof64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(rintf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(rintf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(rintf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(rintf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(rintf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundeven, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(roundevenf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(roundevenf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(roundevenf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundevenf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundevenf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundevenf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundevenl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(roundf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(roundf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(roundf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalblnf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(scalblnf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalblnf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalblnf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalblnf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalbnf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(scalbnf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalbnf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalbnf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scalbnf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(scandirat, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(scandirat64, GLIBC_DONT_USE_THIS_VERSION_2.15)
SYMVER(secure_getenv, GLIBC_DONT_USE_THIS_VERSION_2.17)
SYMVER(sendmmsg, GLIBC_DONT_USE_THIS_VERSION_2.14)
SYMVER(setns, GLIBC_DONT_USE_THIS_VERSION_2.14)
SYMVER(setpayload, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(setpayloadf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(setpayloadf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(setpayloadf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(setpayloadsig, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(setpayloadsigf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(setpayloadsigf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(setpayloadsigf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadsigf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadsigf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadsigf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(setpayloadsigl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(sincosf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(sincosf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sincosf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sincosf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sincosf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(sinf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(sinhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sinhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sqrtf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(sqrtf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sqrtf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sqrtf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(sqrtf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strfromd, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(strfromf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(strfromf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(strfromf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strfromf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strfromf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strfromf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strfroml, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(strtof128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(strtof128_l, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(strtof32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof32_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof32x_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof64_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(strtof64x_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(syncfs, GLIBC_DONT_USE_THIS_VERSION_2.14)
SYMVER(tanf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(tanf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanhf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(tanhf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanhf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanhf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tanhf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tgammaf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(tgammaf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tgammaf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tgammaf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(tgammaf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(timespec_get, GLIBC_DONT_USE_THIS_VERSION_2.16)
SYMVER(totalorder, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(totalorderf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(totalorderf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(totalorderf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalorderf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalorderf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalorderf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalorderl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(totalordermag, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(totalordermagf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(totalordermagf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(totalordermagf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalordermagf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalordermagf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalordermagf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(totalordermagl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(truncf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(truncf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(truncf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(truncf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(truncf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfp, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(ufromfpf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(ufromfpf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ufromfpf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(ufromfpx, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(ufromfpxf, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(ufromfpxf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ufromfpxf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpxf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpxf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpxf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ufromfpxl, GLIBC_DONT_USE_THIS_VERSION_2.25)
SYMVER(wcstof128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(wcstof128_l, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(wcstof32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof32_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof32x_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof64_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(wcstof64x_l, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y0f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(y0f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y0f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y0f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y0f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y1f128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(y1f32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y1f32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y1f64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(y1f64x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ynf128, GLIBC_DONT_USE_THIS_VERSION_2.26)
SYMVER(ynf32, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ynf32x, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ynf64, GLIBC_DONT_USE_THIS_VERSION_2.27)
SYMVER(ynf64x, GLIBC_DONT_USE_THIS_VERSION_2.27)

#endif /* x86 */


#if defined(__arm__) || defined(__aarch64__)

/* Symbols redirected to earlier glibc versions */
#if defined(__arm__)
SYMVER(__longjmp_chk, GLIBC_2.11)
#endif
SYMVER(_sys_errlist, GLIBC_2.4)
SYMVER(_sys_nerr, GLIBC_2.4)
SYMVER(execvpe, GLIBC_2.11)
SYMVER(fallocate64, GLIBC_2.11)
SYMVER(mkostemps, GLIBC_2.11)
SYMVER(mkostemps64, GLIBC_2.11)
SYMVER(mkstemps, GLIBC_2.11)
SYMVER(mkstemps64, GLIBC_2.11)
SYMVER(pthread_sigqueue, GLIBC_2.11)
SYMVER(sys_errlist, GLIBC_2.4)
SYMVER(sys_nerr, GLIBC_2.4)

/* Symbols introduced in newer glibc versions, which must not be used */
SYMVER(fanotify_init, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(fanotify_mark, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(ntp_gettimex, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(prlimit, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(prlimit64, GLIBC_DONT_USE_THIS_VERSION_2.13)
SYMVER(pthread_getname_np, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_mutex_consistent, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_mutexattr_getrobust, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_mutexattr_setrobust, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(pthread_setname_np, GLIBC_DONT_USE_THIS_VERSION_2.12)
SYMVER(recvmmsg, GLIBC_DONT_USE_THIS_VERSION_2.12)

#endif /* __arm__ */

#undef SYMVER
#undef SYMVER1

#if defined (__cplusplus)
}
#endif
#endif
