/*
 * Deskflow -- mouse and keyboard sharing utility
 * SPDX-FileCopyrightText: (C) 2025 Deskflow Developers
 * SPDX-FileCopyrightText: (C) 2012 - 2016 Symless Ltd.
 * SPDX-FileCopyrightText: (C) 2002 Chris Schoeneman
 * SPDX-License-Identifier: GPL-2.0-only WITH LicenseRef-OpenSSL-Exception
 */

#pragma once

class NetworkAddress;

//! Generic socket interface
/*!
This interface defines the methods common to all network sockets.
Generated events use \c this as the target.
*/
class ISocket
{
public:
  virtual ~ISocket() = default;
  //! @name manipulators
  //@{

  //! Bind socket to address
  /*!
  Binds the socket to a particular address.
  */
  virtual void bind(const NetworkAddress &) = 0;

  //! Close socket
  /*!
  Closes the socket.  This should flush the output stream.
  */
  virtual void close() = 0;

  //@}
  //! @name accessors
  //@{

  //! Get event target
  /*!
  Returns the event target for events generated by this socket.
  */
  virtual void *getEventTarget() const = 0;

  //@}
};
