/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// SecurityGroupRequest struct for SecurityGroupRequest
type SecurityGroupRequest struct {
	Properties *SecurityGroupProperties      `json:"properties"`
	Entities   *SecurityGroupEntitiesRequest `json:"entities,omitempty"`
}

// NewSecurityGroupRequest instantiates a new SecurityGroupRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSecurityGroupRequest(properties SecurityGroupProperties) *SecurityGroupRequest {
	this := SecurityGroupRequest{}

	this.Properties = &properties

	return &this
}

// NewSecurityGroupRequestWithDefaults instantiates a new SecurityGroupRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSecurityGroupRequestWithDefaults() *SecurityGroupRequest {
	this := SecurityGroupRequest{}
	return &this
}

// GetProperties returns the Properties field value
// If the value is explicit nil, nil is returned
func (o *SecurityGroupRequest) GetProperties() *SecurityGroupProperties {
	if o == nil {
		return nil
	}

	return o.Properties

}

// GetPropertiesOk returns a tuple with the Properties field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SecurityGroupRequest) GetPropertiesOk() (*SecurityGroupProperties, bool) {
	if o == nil {
		return nil, false
	}

	return o.Properties, true
}

// SetProperties sets field value
func (o *SecurityGroupRequest) SetProperties(v SecurityGroupProperties) {

	o.Properties = &v

}

// HasProperties returns a boolean if a field has been set.
func (o *SecurityGroupRequest) HasProperties() bool {
	if o != nil && o.Properties != nil {
		return true
	}

	return false
}

// GetEntities returns the Entities field value
// If the value is explicit nil, nil is returned
func (o *SecurityGroupRequest) GetEntities() *SecurityGroupEntitiesRequest {
	if o == nil {
		return nil
	}

	return o.Entities

}

// GetEntitiesOk returns a tuple with the Entities field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SecurityGroupRequest) GetEntitiesOk() (*SecurityGroupEntitiesRequest, bool) {
	if o == nil {
		return nil, false
	}

	return o.Entities, true
}

// SetEntities sets field value
func (o *SecurityGroupRequest) SetEntities(v SecurityGroupEntitiesRequest) {

	o.Entities = &v

}

// HasEntities returns a boolean if a field has been set.
func (o *SecurityGroupRequest) HasEntities() bool {
	if o != nil && o.Entities != nil {
		return true
	}

	return false
}

func (o SecurityGroupRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Properties != nil {
		toSerialize["properties"] = o.Properties
	}

	if o.Entities != nil {
		toSerialize["entities"] = o.Entities
	}

	return json.Marshal(toSerialize)
}

type NullableSecurityGroupRequest struct {
	value *SecurityGroupRequest
	isSet bool
}

func (v NullableSecurityGroupRequest) Get() *SecurityGroupRequest {
	return v.value
}

func (v *NullableSecurityGroupRequest) Set(val *SecurityGroupRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableSecurityGroupRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableSecurityGroupRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSecurityGroupRequest(val *SecurityGroupRequest) *NullableSecurityGroupRequest {
	return &NullableSecurityGroupRequest{value: val, isSet: true}
}

func (v NullableSecurityGroupRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSecurityGroupRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
