ITK Release 4.4
===============

We are excited to announce two new ImageIO modules available in the main
repository. The MINC ImageIO module provides a bridge to the MINC file
format, a powerful medical imaging format used by the MINC library,
another open source library with many features similar to ITK. The new
MINC module, which has Image IO and Transform IO capabilities, is
considered experimental and must be enabled by turning Module\_ITKIOMINC
ON in CMake’s configuration. This will automatically build the MINC
library, which is now available on Mac, Linux, and Windows. The
HDF5-based MINC2 file format is supported, but support for the
NetCDF-based MINC1 file format is not supported because NetCDF is not
distributed with ITK.

Another new ImageIO module that expands the reach of ITK is the SCIFIO
module. SCIFIO is a refactoring of the Bio-Formats library. This module
provides access to a wide range of file formats encountered in life
sciences/microscopy environments. This experimental feature is available
a Remote module; to enable it, set the Fetch\_SCIFIO CMake variable to
ON. Many improvements and fixes are ongoing for this module; Git master
is recommended for those interested in this module.

A number of improvements were also made to DCMTK ImageIO, but this
module remains experimental on disabled by default. To try DCMTK ImageIO
support, turn the CMake option Module\_ITKIODCMTK ON. For Unix
platforms, the supporting DCMTK library will automatically be built as a
CMake ExternalProject. On Windows, the DCMTK library must be built
independently of the ITK build system. Then, specify the location to the
external build after setting the CMake option ITK\_USE\_SYSTEM\_DCMTK
ON.

A number of performance improvements were made to QuadEdgeMesh
processing and memory copy functions. A new ImageScanlineIterator is
available. This iterator can be used in many of the cases where an
ImageRegionIterator is applied, but it has better performance.

The approach to split image regions for parallel processing is no longer
hard coded to make multiple options available.

An API design change was started to improve the implied functionality of
the GetObject methods. The non-const “GetObjectMacro” has been replaced
with a “GetModifiableObjectMacro” that will result in a GetModifiableXXX
method instead of a GetXXX method. This makes the non-const nature of
the method and the circumvention of pipeline update semantics explicit
for both the code author and those reading the class API. This was
implemented in a backwards compatible way, and it will only be enforced
if ITK\_FUTURE\_LEGACY\_REMOVE is defined.

Support for the Google Double Conversion library was added to improve
the reading and writing of double values as ASCII text with the
intention to improve the precision of the text transform file format’s
serialization.

It is now easier to identify filter inputs by both a string name or an
integer index. The internal methods to store and retrieve inputs by
either string or index was correspondingly refactored, and performance
was also improved.

JPEG ImageIO now writes and reads image spacing in a manner similar to
the TIFF ImageIO.

An extensive amount of code cruft was removed and coding style was made
more consistent; ITK gets more stylish and classy with every release!

The ExternalData method to store large testing data outside of the Git
repository is now in upstream CMake 2.8.11. Our internal version has
been updated to the improved version in CMake.

The minimum CMake required version was bumped to 2.8.8 on Windows and
2.8.5 otherwise. This may be increased even higher in the near future to
ensure all CMake features utilized operate correctly.

Known assertion failures occur when compiled under Visual Studio in the
Debug configuration. This will be fixed in 4.4.1. If this has a
significant negative impact on your work, please consider contributing a
Nightly dashboard build under this configuration. As previously
scheduled, Visual Studio 2005 is no longer be supported.

Support for building against system third party libraries continues to
improve. Further improvements are expected for version 4.5.

All tests are now passing again on the Nightly big-endian dashboard
system.

InsightApplications (ITKApps) has seen fixes in the FLTK superbuild and
the TCL wrapped applications.

Changes in ITK from v4.3.0 to v4.4.0 from the Git log:

Ali Ghayoor (7):

`       ENH: Get the internal transforms of SyN registration filter`\
`       COMP: Fix all valid cppcheck warnings in `“`Module/Filtering`”` directory`\
`       COMP: Fix all valid cppcheck warnings in `“`Module/Core`”` directory`\
`       COMP: Fix all valid cppcheck warnings in `“`Module/Segmentation`”` directory`\
`       COMP: Fix all valid cppcheck warnings in `“`Module/Registration`”` directory`\
`       COMP: Fix all valid cppcheck warnings in ITK (last patch)`\
`       COMP: Fix all valid cppcheck warnings in `“`ITK/Module`”` directory`

Arnaud Gelas (4):

`       PERF: improve performance of couple of methods of itk::QuadEdgeMesh`\
`       PERF: couple of speed up improvements for QuadEdgeMesh processing`\
`       PERF: avoid doing GetPoint and SetPoint for the same point`\
`       ENH: Simplify template parameters in itk::PointsLocator`

Bill Lorensen (20):

`       ENH: Prevent duplicate loading of dynamic libraries`\
`       COMP: Fix compile error in PhilipsRECImageIO`\
`       COMP: Fix compile error in PhilipsRECImageIO`\
`       BUG: Memory leak after failed RegisterFactory`\
`       BUG: Warn on directories`\
`       ENH: Refactor DoubleToString into NumberToString`\
`       DOC: Escape hash in comment`\
`       STYLE: Apply kwstyle to Modules/Core tests`\
`       STYLE: Apply kwstyle to Modules/Filtering tests`\
`       STYLE: Apply kwstyle to Modules/Segmentation tests`\
`       STYLE: Apply kwstyle to Modules/IO tests`\
`       STYLE: Apply kwstyle to Modules/Numerics tests`\
`       STYLE: Apply kwstyle to Modules/Registration tests`\
`       STYLE: Apply kwstyle to some tests`\
`       BUG: Memory leak after failed RegisterFactory`\
`       COMP: Remove copy_n wrapper for standard std::copy`\
`       COMP: Make the test stable by removing random source`\
`       COMP: More baselines`\
`       COMP: Another baseline`\
`       COMP: Missing return error after exception`

Brad King (14):

`       BUG: ExternalData: Do not match directory names when resolving DATA{}`\
`       STYLE: ExternalData: Cleanup stray TODO and typo in comments`\
`       STYLE: ExternalData: Remove unused private interface`\
`       ENH: ExternalData: Improve series matching using an explicit syntax`\
`       ENH: ExternalData: Allow ()-groups in series match regex`\
`       ENH: ExternalData: Allow DATA{} syntax to reference directories`\
`       ENH: Configure new ExternalData series parsing for ITK baselines`\
`       BUG: ExternalData: Collapse ../ components in DATA{} paths`\
`       BUG: Fix `“`git`` ``gerrit-push`”` for content links with spaces`\
`       STYLE: Add detail to the vxl update instructions`\
`       STYLE: Add more detail to the vxl update instructions`\
`       ENH: ExternalData: Partly generalize hash algo/ext handling`\
`       ENH: ExternalData: Attach download rules to content links in IDEs`\
`       ENH: ExternalData: Preserve escaped semicolons during argument expansion`

Bradley Lowekamp (78):

`       STYLE: Use ITK_ prefix for FFTW cmake variables and defines`\
`       BUG: Change default boundary condition to ZeroFlux`\
`       ENH: wrapping itkImageSeriesWriter`\
`       BUG: incorrect CMake variable for system jpeg include`\
`       DOC: Correct description of Bitwise binary filters`\
`       BUG: incorrect CMake variable for system jpeg include`\
`       COMP: GetTimeVaryingVelocityField methods did not compile`\
`       ENH: Creating templateless region splitter classes`\
`       ENH: Adding image region splitter for separable filtering`\
`       PERF: Do not spawn threads that will not be used.`\
`       ENH: ImageIO's now use ImageRegionSplitter base`\
`       COMP: Specify export for Specialized Array output operators`\
`       ENH: making old ImageRegionSplitter compatible with new splitter`\
`       BUG: initials Direction IVAR`\
`       STYLE: never a space before;`\
`       COMP: Address unused parameter warning in GPU code`\
`       BUG: Do not create static initialized ITK objects`\
`       ENH: Converted Multidimensional splitter to new base class`\
`       ENH: moving old ImageRegionSplitter to Deprecated Module`\
`       BUG: Only thread 0 should report progress.`\
`       PERF: Use std::fill for image filling`\
`       BUG: Only thread 0 should report progress in LabelMapFilters`\
`       COMP: Adding missing header`\
`       BUG: Using CMake variable in external builds with autoconf environment`\
`       BUG: initialize InverseCovariance size with degenerate matrix`\
`       ENH: Adding numeric_traits specializations for `“`long`` ``long`”\
`       ENH: instantiate vnl types with `“`long`` ``long`”` on all platforms`\
`       Revert `“`ENH:`` ``Use`` ``named`` ``inputs`` ``in`` ``BinaryReconstruction`` ``filters.`”\
`       BUG: initialize InverseCovariance size with degenerate matrix`\
`       BUG: Using CMake variable in external builds with autoconf environment`\
`       COMP: Address unused parameter warning in GPU code`\
`       BUG: Only thread 0 should report progress in LabelMapFilters`\
`       BUG: Only thread 0 should report progress.`\
`       COMP: Adding missing header`\
`       ENH: Adding support for instantiating long long pixel types`\
`       BUG: VerifyPreconditions checks required named inputs`\
`       PERF: Adding performance oriented ScanlineIterator`\
`       COMP: Remove copy_n wrapper for standard std::copy`\
`       COMP: Missing ProgressReporter header`\
`       COMP: Suppress linker warning from fftw external project`\
`       COMP: Add missing ImageRegionIterator header in test`\
`       BUG: Don't allocate empty names in Get I/O Names methods`\
`       COMP: Make GPUFunctorBase destructor virtual`\
`       PERF: Changing filters to use ImageScanlineInterator`\
`       COMP: GCC_XML external project does not use BUILD_EXAMPLES`\
`       BUG: Scanline iterator in STAPLE filter not advanced to next line`\
`       PERF: Use ImageScanlineIterator in ImageAlgorithm::Copy`\
`       PERF: Use iterators into name map for index inputs`\
`       ENH: index can be associated with required input`\
`       PERF: Add global variable of index names in ProcessObject`\
`       COMP: fix unused result warning in ProcessObject`\
`       ENH: Remove names inputs specialized comparison`\
`       DOC: Updated input methods doxygen`\
`       PERF: Use ImageAlgorithm::Copy in JoinSeries filter`\
`       PERF: Change default index i/o prefix to just `“`_`”\
`       PERF: Use ImageAlgorithm::Copy in CastImageFilter`\
`       COMP: Fix failing implicit conversion from NULL`\
`       BUG: restore gnu aligned attribute`\
`       PERF: ImageAlgorithm::copy to use std::copy for conversion`\
`       PERF: Store indexed outputs in array for constant time access`\
`       COMP: GCC_XML compilation error with type_traits`\
`       BUG: Add unsigned int concept check to LabelVoting filter`\
`       COMP: Disable conversion warning for std::copy in ImageAlgorithm`\
`       BUG: Use correct types for TIFF Tags and buff math`\
`       BUG: Use local var for TIFF va_list parameter`\
`       BUG: Use correct bytes for BigEndian magic number`\
`       COMP: Fix int to char narrowing error and warning`\
`       COMP: Fix int to char narrowing error and warning`\
`       COMP: Fix scanf conversion specification to %u`\
`       COMP: Fix scanf conversion specification for id types`\
`       BUG: Remove extraneous print statement in tiffio`\
`       BUG: Incorrect va_arg type used in TIFF and LSM`\
`       BUG: JPEG2000 bool type in C is now unsigned char`\
`       BUG: add a test to demonstrate ThreadedIteratorPartitioner bug`\
`       BUG: Fix written other magic number in FreeSurferBinaryMeshIO`\
`       COMP: Fix assert in LSM, = in err of ==`\
`       BUG: IteratorPartitioner extra thread don't advance`\
`       BUG: C++ bool is 4 bytes on osx ppc`

Brian Helba (11):

`       STYLE: Ensure documentation \author tags are parsed`\
`       STYLE: Remove unnecessary overloads in favor of implicit conversion`\
`       PERF: Replace deep copy with const const signature`\
`       ENH: Re-enable LoadPrivateTags option in GDCMImageIO`\
`       STYLE: Slightly refactor ImageFileWriter::Write to simplify logic`\
`       ENH: Always enable Get*FromTag methods in GDCMImageIO`\
`       DOC: Fix misspelling in MorphologyImageFilter`\
`       DOC: Fix misspelling in ObjectMorphologyImageFilter`\
`       STYLE: Remove unnecessary function call in GDCMImageIO`\
`       STYLE: Remove calls to deprecated functionality from DICOM Examples / Tests`\
`       ENH: Allow Get*FromTag to accept uppercase hex`

Cory Quammen (1):

`       COMP: Bumped up minimum required CMake version`

Cyrille Faucheux (2):

`       ENH: allow the ClampImageFilter to use user-defined bounds (#3016).`\
`       ENH: Move the ClampImageFilter to the ImageIntensity module (#3016).`

David Cole (4):

`       BUG: Avoid using def file when BUILD_SHARED_LIBS is off`\
`       BUG: Do not undefine _WIN32_WINNT`\
`       BUG: Avoid using def file when BUILD_SHARED_LIBS is off`\
`       BUG: Do not undefine _WIN32_WINNT`

David Fuentes (2):

`       ENH: Allow block matching on diff size images`\
`       ENH: wrapping itkMaskFeaturePointSelectionFilter itkBlockMatchingImageFilter`

Dirk Padfield (6):

`       BUG: CSVFileReader was reading all values as NaN`\
`       DOC: Made AnisotropicDiffusion documentation consistent with code`\
`       ENH: Enable MetaIO to read filenames with spaces using regex`\
`       BUG: CSVFileReader was reading all values as NaN`\
`       ENH: Added m_RequiredFractionOfOverlappingPixels to MaskedFFTNCC`\
`       BUG: SignedMaurerDistanceMap in 4D`

Google double-conversion Maintainers (1):

`       Google double-conversion (reduced)`

Hans Johnson (21):

`       COMP: Remove unnecessary BORLAND code`\
`       COMP: Make type conversions explicit/consistent`\
`       PERF: Optimize loop index computations`\
`       COMP: Remove unnecessary BORLAND code`\
`       COMP: Incomplete variable name change.`\
`       COMP: Incorrect warning presented for cppcheck`\
`       STYLE: The FFTW libs should be co-located with ITK`\
`       COMP: Fix robustness of DCMTK internal builds`\
`       ENH: Get function accessible from const objects`\
`       COMP: Missing patch for ITK_FUTURE_LEGACY_REMOVE`\
`       STYLE: Reduce redundant code identified by cpd`\
`       BUG: Return a modifiable object or provide const`\
`       STYLE: Improve SoftwareGuide documentation`\
`       COMP: Type mis-match for comparison operator`\
`       STYLE: Enforce using ITK macros when available`\
`       COMP: Type mis-match for comparison operator`\
`       BUG: ITK_FUTURE_LEGACY_REMOVE must cmake configured`\
`       BUG: Expose BSplineInterpolateImageFunction test`\
`       COMP: Linkage ITK_ABI_EXPORT to ITKCommon_EXPORT`\
`       BUG: itk_tiff.h should not be in itkTIFFImageIO.h`\
`       DOC: Fix line length issues for the SoftwareGuide`

Ho Cheung (7):

`       BUG: GradientVectorFlow should calculate timestep based on image dimension`\
`       STYLE: GradientVectorFlow - Add const correctness`\
`       STYLE: GradientVectorFlow`\
`       PERF: GradientVectorFlow - Remove redundant initializations`\
`       BUG: itkPolyLineParametricPath infinite loop for degenerate paths`\
`       BUG: Fix ITK Path test failures`\
`       BUG: ITK unable to detect number of threads under Unix in recent glibc.`

ITK Migration V4 (4):

`       DOC: Modify ContourMeanDistanceImageFilter comments.`\
`       DOC: Modify MattesMutualInformationImageToImageMetric comments.`\
`       DOC: Modify MaskImageFilter comments.`\
`       DOC: Modify BSplineTransformInitializer comments.`

Jan Margeta (1):

`       COMP: Added missing header `<functional>` in itkAnchorCloseImageFilter.h`

Julien Finet (2):

`       ENH: Add unit test to itkThresholdImageFilterTest`\
`       ENH: Add MaskingValue to MaskImageFilter`

Julien Malik (2):

`       BUG: Remove itkLoad definition in JPEG2000ImageIOFactory`\
`       ENH: Add missing NumericTraits for complex`

Julien Michel (2):

`       BUG: Fix InverseDisplacementFieldImageFilter bug`\
`       BUG: Fix InverseDisplacementFieldImageFilter bug`

Kent Williams (21):

`       COMP: Turn on -fpic in options for DCMTK External Project`\
`       BUG: using InputPixelType to hold label count can overflow.`\
`       COMP: Update DCMTK version to incorporate new fixes.`\
`       COMP: Use portable method to find source dir & find DCMTK headers`\
`       COMP: Start using ITKConsortium github to retrieve DCMTK.`\
`       BUG: Regressions with respect to building DCMTK`\
`       COMP: Added patch from Dirk Padfield`\
`       ENH: use find_package(DCMTK NO_MODULE)`\
`       ENH: Add double-conversion library for precise Float output`\
`       COMP: replace in-line access methods with itk Macros`\
`       COMP: The install path for DoubleConversion lib was wrong.`\
`       COMP: removed warnings on Windows due to generic vs excp obj throw.`\
`       COMP: check for this == &rhs as much as possible.`\
`       COMP: Replace memcpy with std::copy in ImportImageContainer.`\
`       COMP: Replace memcpy calls with std::copy`\
`       COMP: Further changes to the use of std::copy_n`\
`       COMP: Add preprocessor symbols to double-conversion for OS X PPC`\
`       COMP: Add DoubleConversion merge from upstream documentation`\
`       BUG: Return of NaN by DiffusionTensor3D::GetFractionalAnisotropy`\
`       BUG: Dicom method for Dir Cosines made non-orthogonal directions`\
`       COMP: Install openjpgDllConfig.h`

Kris Zygmunt (1):

`       PERF: Provide better default config for patch-based denoiser`

Luis Ibanez (1):

`       ENH: Maurer for Danielsson in Surface Distance.`

Manuel Grizonnet (4):

`       BUG: Inconsistency detected by ld.so due to static const string`\
`       BUG: Inconsistency detected by ld.so due to static const string`\
`       BUG: Inconsistency detected by ld.so due to static const string`\
`       BUG: Inconsistency detected by ld.so due to static const string`

Marco Feuerstein (1):

`       ENH: JPEG IO now writes and reads spacing, similar to the TIFF IO (ITK-3023)`

Marius Staring (3):

`       ENH: expose parameter in Bilateral filter`\
`       PERF: Replace fill and copy with std alternatives`\
`       BUG: B-spline interpolator should use direction`

Mark Hiner (1):

`       ENH: Add SCIFIOImageIO.`

Matthew McCormick (47):

`       COMP: Fix wrapping configuration warnings about itkMeshBase, etc.`\
`       COMP: Fix HDF5 unused function for long long on Unix.`\
`       ENH: Bump CMake version numbers to 4.4.0.`\
`       BUG: Remove unused metric test content link.`\
`       COMP: Add DLL to PATH for Python tests on Visual Studio.`\
`       BUG: Do not nullify the DCMTK ExternalProject UPDATE_COMMAND.`\
`       BUG: Fix DCMTK lib_prefix identification.`\
`       COMP: Fix HDF5 unused function for long long on Unix.`\
`       BUG: Remove unused metric test content link.`\
`       COMP: Add DLL to PATH for Python tests on Visual Studio.`\
`       ENH: Bump CMakeLists.txt ITK version to 4.3.1.`\
`       STYLE: Fix errors detected by KWStyleCodeTest.`\
`       COMP: VectorIndexSelectionCastImageFilter extra itk namespace.`\
`       STYLE: Fix alignment in itkMask{Image,Negated}ImageFilter.h`\
`       ENH: Doxygen configuration update to 1.8.3.1.`\
`       BUG: Fix FFTW install paths in ITKConfig.cmake (ITK-2995).`\
`       DOC: Doxygen detection of DirectionTolerance as private.`\
`       ENH: Get Direction and CoordinateTolerance are const methods.`\
`       BUG: Add missing header to the third party TIFF install.`\
`       COMP: More fixes to mesh wrapping warnings.`\
`       BUG: Temporarily disable Python utility tests.`\
`       COMP: Avoid explicit instantiation and specialization for Array.`\
`       ENH: Add utility script to create JRE tarballs.`\
`       ENH: Use named inputs in BinaryReconstruction filters.`\
`       STYLE: Remove redundant itk namespace.`\
`       DOC: CreateTestDriver srcs should have the .cxx extension.`\
`       COMP: Must reinterpret the pointers to match`\
`       COMP: Fix project linking against ITK that does not use VtkGlue.`\
`       COMP: Fix project linking against ITK that does not use VtkGlue.`\
`       BUG: Fix FFTW install paths in ITKConfig.cmake (ITK-2995).`\
`       ENH: Bump version in CMakeLists.txt to 4.3.2.`\
`       DOC: Doxygen expansion of itkGetModifiableObjectMacro.`\
`       ENH: Remove unused wrapping code. ITK-3032.`\
`       ENH: Use named inputs in BinaryReconstruction filters.`\
`       COMP: Distance maps filters cannot wrap 1D.`\
`       DOC: Remove reference to MeanDistanceImageFilter.`\
`       STYLE: Fix KWStyle errors.`\
`       STYLE: Remove entries from the old MINC2ImageIO.`\
`       BUG: Remove MINCIO from the default registered modules.`\
`       BUG: Add EXCLUDE_FROM_ALL to ThirdParty/MINC.`\
`       BUG: Include SCIFIO in the auto-registered factories if the module`

is enabled.

`       BUG: Visual Studio itkClampImageFilterTest failures.`\
`       STYLE: itkClampImageFilter.hxx in the wrong module.`\
`       COMP: Add _CRT_NO_SECURE_WARNINGS when building GCCXML.`\
`       COMP: Prevent ITK_USE_64BITS_IDS with Wrapping on Windows.`\
`       STYLE: Too many blank lines in itkCastImageFilterTest.cxx.`\
`       COMP: Bump MINC third party to fix warnings.`

Nick Tustison (4):

`       ENH:  Adding masking capabilities with confidence mask option.`\
`       BUG:  Masks need to be warped.`\
`       ENH:  Permitting access to shrinking per dimension.`\
`       BUG: Valgrind error.`

Nicolas Rey (1):

`       STYLE: Minor style fixes`

Paul Novotny (3):

`       COMP: Fix TIFF on big endian systems`\
`       COMP: Build fails with ITK_USE_SYSTEM_TIFF`\
`       COMP: Fix TIFF on big endian systems`

Prathamesh Kulkarni (1):

`       COMP: QuickViewTest new baseline.`

Sean McBride (4):

`       STYLE: fixed minor spelling: XCode -> Xcode`\
`       COMP: fixed clang warning about NULL to bool conversion`\
`       BUG: Handle missing Analyze 7.5 flipped directions`\
`       COMP: Handle missing Analyze 7.5 flipped directions`

Tim Allman (3):

`       DOC: Modify BSplineTransform comments.`\
`       DOC: Modify JointHistogramMutualInformationImageToImageMetricv4 comments.`\
`       DOC: Modify JointHistogramMutualInformationImageToImageMetricv4 comments.`

Tom Vercauteren (2):

`       COMP: GPUPDEDeformableRegistrationFilter.cl fails to `“`compile`”`.`\
`       COMP: GPUPDEDeformableRegistrationFilter.cl fails to `“`compile`”`.`

Vladimir S. FONOV (2):

`       ENH: Adding libminc and updating MINC IO support.`\
`       BUG: Making 2D Minc IO work properly`

Xiaoxiao Liu (2):

`       ENH: Sync python scripts with python3.`\
`       ENH: Sync python scripts with python3.`

Yan Xu (1):

`       COMP: static cast unsigned int to int`

Changes in ITKapps from v4.3.0-apps to v4.4.0-apps:

Bill Lorensen (3):

`       COMP: VTK6 API change`\
`       ENH: Add TCL Wrapped examples`\
`       BUG: Missing includes for ITK4.4`

Hans Johnson (1):

`       COMP: Mac 10.8 fixes were incorporated in FLTK`

Jamie Snape (1):

`       BUG: Propagate build, linker, and OSX settings to external projects`

Matt McCormick (6):

`       COMP: Re-add the FLTK patch for some Macs.`\
`       BUG: ITK External build only depends on VTK if being built.`\
`       COMP: Update FLTK SVN configuration.`\
`       ENH: Bump VTK ExternalProject to 5.10.1.`\
`       COMP: Use FLTK zip file stored on Midas3.`\
`       ENH: Bump ITK superbuild version to 4.4.0.`

Roland Kwitt (1):

`       COMP: Shadowing warning in GLSliceView.h`

Stephen R. Aylward (1):

`       COMP: Fix FLTK build error on Mac/Clang.`

Xiaoxiao Liu (1):

`       ENH: Print out accurate image IO error message.`
