Minutes from 27th OpenVDB TSC meeting, September 12th, 2019, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M., *Peter* C.

Additional Attendees: Bruce Chernia (Intel), Dan Elliott (Weta)

Agenda:

1) Quorum
2) Secretary
3) Latest on our release plans, specifically v6.2
4) Changes to unit-tests (Ken)
4b) Staggered Interpolation
5) SPDX Update
6) CLA Update
7) OP_Operator::getVersion format (PR502)
8) OpenVKL
9) Renderman and H18
10) Anisotropic Surfacing
11) Next Meeting

1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) Latest on our release plans, specifically v6.2

Jeff would like a 6.2.0 release within the next ten days so it can be integrated
into Houdini 18.0 before the upcoming release. Peter has agreed to do this
release, but would like us to move to a model where others on the TSC can also
do releases. Primary barrier is improving the way Doxygen gets released as
currently this is a manual, offline process and would be better if automated.
Dan mentioned that there are a number of other admin tasks that are still
outstanding of which this is one.

Outstanding items to complete before we release:

* PR502 - Dan to finish, see discussion in (7).
* PR504 - Nick to do more testing, affects Windows builds, may not make the cut
for 6.2.
* PR506 - Nick to merge.
* CMake Deprecation Warnings - Nick to add a few deprecation warnings to CMake.

4) Changes to unit-tests (Ken)

Ken would like to see us move to Google Test over CppUnit. More modern C++ unit
testing framework actively developed by Google. Various useful features such as
parallel testing, running a test until failure, less finicky over type
mismatches, etc. Peter concerned about adding a new dependency, Nick suggested
Boost Test as an alternative. Some discussion about our policy regarding Boost,
general feeling that we have been trying to migrate towards using standard
library as functionality becomes available but no plan to try and accelerate
this. It is deemed more important to reduce the use of Boost in the core library
than the unit tests. It was also suggested that we should look at other
open-source projects and which unit test framework they use.

All agreed that we would benefit from the increased feature set provided in
Google Test, but less certainty about whether the migration would be worth the
effort. Ken to share an example as a test case of how complicated the migration
might be.

Dan to share a link to the SonarCloud code coverage so that all can get an
understanding of areas of the codebase that might be lacking in coverage.

4b) Staggered Interpolation

Ken mentioned that in writing a simple fluid solver, he ran into issues with
efficiency of interpolation of staggered grids, Nick concurred. It is currently
redundantly interpolating in axes that are not used and there is no stencil
caching as recently discussed in regards to sharpening. Ken to look at
contributing an improvement here.

5) SPDX Update

John Mertic not on the call, Dan to reach out to find out if there has been any
progress here.

Update: John Mertic and Steve Winslow had a conference call with Andrew Pearce.
Dreamworks have some concerns on the impact of removing the language from the
license moving to the SPDX license. John and Steve are exploring options to
resolve the non-standard license language while at the same time address
Dreamworks' concerns.

6) CLA Update

Ken, Jeff and Dan have not completed the digital CLAs. This is holding up our
ability to accept external contributions. Dan is still awaiting Lucasfilm/Disney
legal to proceed. Ken and Jeff to follow up on their end. Ken to look at signing
the individual CLA.

7) OP_Operator::getVersion format (PR502)

Peter has suggested both Houdini and VDB versions to be included in the version
string for possible future use and no objections to this. Question over whether
there is a benefit to align with existing version mechanism as
OP_Operator::getVersion is a public function. Jeff said that lots of hip file
nodes such as HDAs use custom strings which cannot be parsed so no real value in
attempting to do so. Jeff proposed "vdb6.1.0 houdini18.0.222" as the format. All
in agreement. Dan to make that change in time for inclusion in a 6.2.0 release.

8) OpenVKL

Bruce to discuss with Greg about the possibility of the TSC receiving an OpenVKL
update from Intel around October. Intel's plan is to incorporate VDB in Q4,
OpenVKL not intended to replace OpenVDB.

9) Renderman and H18

Dan mentioned a discussion being had offline with the Renderman group. Hope that
the developers will be able to join us in a future call to discuss and may even
be able to contribute to the project in the future.

10) Anisotropic Surfacing

Nick looking at open-sourcing this tool. Jeff not certain of the exact
implementation but confirmed that the Particle Fluid Surface SOP is the primary
tool for surfacing particles provided by Houdini.

11) Next Meeting

Next planned meeting is:

September 26th 2019. 3pm-4pm EDT (GMT-4). Option to hold one on September 19th,
depending on the status of the 6.2.0 release.
