use strict;
#use Test::More tests => 34;
use Test::More qw(no_plan);

use English;
use RoPkg::Exceptions;

use warnings;
use strict;

BEGIN {
  use_ok('RoPkg::DB');
  use_ok('RoPkg::Simba');
  use_ok('RoPkg::Simba::Command');
}

my ($dbp, $command);

$dbp = new RoPkg::DB();

eval {
  $dbp->Add('dbi:mysql:database=mirrors_db;host=localhost',
      'root',
      '',
      'commands');
};
ok(
  !ref($@),
  'connect ok'
);

eval {
  $command = new RoPkg::Simba::Command();
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new() raise exception'
);

eval {
  $command = new RoPkg::Simba::Command(dbo => '');
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new(dbo => "") raise exception'
);

eval {
  $command = new RoPkg::Simba::Command(dbo => '', dbo_method => '');
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new(dbo => "", dbo_method => "") raise exception'
);

eval {
  $command = new RoPkg::Simba::Command(dbo => $dbp);
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new(dbo => $dbp) raise exception',
);

eval {
  $command = new RoPkg::Simba::Command(dbo => $dbp, dbo_method => 'db_commands');
};
ok(
  !ref($@),
  'new(dbo => $dbp, dbo_method => "db_commands") should work'
);

