// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


// colors.h
//
// Define the colors you want to use here.

#ifndef _COLORS_H
#define _COLORS_H

typedef unsigned long color_t;

// Colors, in 0xRRGGBB format, in which to plot stars and map decals

const color_t RED_MASK = 0xFF0000,
	GREEN_MASK = 0x00FF00,
	BLUE_MASK = 0x0000FF;

#define RED(color)   (((color) & RED_MASK) >> 16)
#define GREEN(color) (((color) & GREEN_MASK) >> 8)
#define BLUE(color)  ((color) & BLUE_MASK)
#define DIM(color)   (((color) & 0xFEFEFE) >> 1)

const color_t WOLF_RAYET_COLOR = 0x2000A0,
	D_COLOR = 0x808080,
	NON_STELLAR_COLOR = 0xFF00FF,
	DEFAULT_COLOR = 0x00FF00;

const color_t CLASS_COLORS[] = {
	0x0000FF, // O
	0x00C0FF, // B
	0x80E0E0, // A
	0xF0F0F0, // F
	0xF0F000, // G
	0xF0A000, // K
	0xFF2000  // M
};

const color_t POSITIVE = 0x808080,
	NEGATIVE =    0x0000FF,
	BACKGROUND =  0x000000,
	TEXT_COLOR =  0x00FF00,
	LABEL_COLOR = 0xC0C0C0,
	BOLD_COLOR =  0xFFFFFF,
	DIM_COLOR =   0x606060,
	ERROR_COLOR = 0xFF4040;

#endif // #ifndef _COLORS_H

