use core:lang;

/**
 * Basic documentation provided that provides parameter names.
 */
class ParamDoc extends NamedDoc {
	// Parameter names.
	Str[] names;

	// Function.
	Function f;

	// Create.
	init(Function f, Str[] names) {
		init {
			f = f;
			names = names;
		}
	}

	Doc get() {
		DocParam[] params;
		for (i, t in f.params)
			params << DocParam(names[i], t);
		Doc(f.name, params, f.visibility, "");
	}
}
