/* rotate.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define COUNT_MIN 2
#define COUNT_MAX 30
#define COUNT_STEP 1

#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define DIRECTION_MIN 0
#define DIRECTION_MAX 1
#define DIRECTION_STEP 1

#define SIZE_MIN (ftofix(0.1))
#define SIZE_MAX (ftofix(3))
#define SIZE_STEP (ftofix(0.01))

#define SORT_MIN 1
#define SORT_MAX 6
#define SORT_STEP 1

#define STEP_MIN (itofix(-255))
#define STEP_MAX (itofix(255))
#define STEP_STEP (itofix(1))

#define X_MIN 0
#define X_MAX scr_w
#define X_STEP 10

#define Y_MIN 0
#define Y_MAX scr_h
#define Y_STEP 10
/*---------------------------------------------------------------------------*/
/* variables */
char *video_buffer;
int picpos;
/* PIC_H2 = 100, PIC_W2 = 120, SPIC_H2 = 35, SPIC_W2 = 42 */
int xmap[PIC_H2][PIC_W2], xmap_small[SPIC_H2][SPIC_W2];
int ymap[PIC_H2], ymap_small[SPIC_H2];
BITMAP *earth_map, *earth_map1;

volatile int counter = 0;

int count, delayy, direction, direction1, direction2, x, y;
fixed angle, size, step, sign;

static tkeyparse
  see_f7_0 = {K_0, keysee_f7_0}, /* rotate.c specific */
  see_f7_1 = {K_1, keysee_f7_1},
  see_f7_2 = {K_2, keysee_f7_2},
  see_f7_3 = {K_3, keysee_f7_3},
  see_f7_4 = {K_4, keysee_f7_4},
  see_f7_5 = {K_5, keysee_f7_5},
  see_f7_6 = {K_6, keysee_f7_6},
  see_f7_7 = {K_7, keysee_f7_7},
  see_f7_8 = {K_8, keysee_f7_8},
  see_f7_9 = {K_9, keysee_f7_9},
  see_f7_A = {K_A, keysee_f7_A},
  see_f7_C = {K_C, keysee_f7_C},
  see_f7_D = {K_D, keysee_f7_D},
  see_f7_J = {K_J, keysee_f7_J},
  see_f7_K = {K_K, keysee_f7_K},
  see_f7_O = {K_O, keysee_f7_O},
  see_f7_S = {K_S, keysee_f7_S},
  see_f7_X = {K_X, keysee_f7_X},
  see_f7_Y = {K_Y, keysee_f7_Y},
  see_f7_a = {K_a, keysee_f7_a},
  see_f7_c = {K_c, keysee_f7_c},
  see_f7_d = {K_d, keysee_f7_d},
  see_f7_j = {K_j, keysee_f7_j},
  see_f7_k = {K_K, keysee_f7_k},
  see_f7_o = {K_o, keysee_f7_o},
  see_f7_s = {K_s, keysee_f7_s},
  see_f7_x = {K_x, keysee_f7_x},
  see_f7_y = {K_y, keysee_f7_y}
;

tkeyparse* tkeyparsetbl_rotate[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f7_0, /* rotate.c specific */
  &see_f7_1,
  &see_f7_2,
  &see_f7_3,
  &see_f7_4,
  &see_f7_5,
  &see_f7_6,
  &see_f7_7,
  &see_f7_8,
  &see_f7_9,
  &see_f7_A,
  &see_f7_C,
  &see_f7_D,
  &see_f7_J,
  &see_f7_K,
  &see_f7_O,
  &see_f7_S,
  &see_f7_X,
  &see_f7_Y,
  &see_f7_a,
  &see_f7_c,
  &see_f7_d,
  &see_f7_j,
  &see_f7_k,
  &see_f7_o,
  &see_f7_s,
  &see_f7_x,
  &see_f7_y,
  NULL
};

teffect eff_rotate =
{
  rotate_init,
  rotate_effect,
  rotate_loop_end,
  rotate_done,
  tkeyparsetbl_rotate,
  1
};
/*---------------------------------------------------------------------------*/
int rotate_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_A:
    case K_C:
    case K_D:
    case K_J:
    case K_K:
    case K_O:
    case K_S:
    case K_X:
    case K_Y:
    case K_a:
    case K_c:
    case K_d:
    case K_j:
    case K_k:
    case K_o:
    case K_s:
    case K_x:
    case K_y:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void tim_inccounter()
{
  counter++;
}

END_OF_FUNCTION(tim_inccounter);
/*---------------------------------------------------------------------------*/
void rotate_earth(int asort)
{
  __djgpp_nearptr_enable(); /* allow video access */
  while (counter < count);
  counter = 0;
  switch (asort)
    {
    case 1:
      draw_big_earth();
      break;
    case 2:
      draw_revolving_earths();
      break;
    }
  picpos -= direction1;
  if (picpos < 0)
    {
      picpos += MAP_W;
    }
  if (picpos > MAP_W)
    {
      picpos -= MAP_W;
    }
  __djgpp_nearptr_disable();
}
/*---------------------------------------------------------------------------*/
void calculate_curvature(int *xmap, int *ymap, int w, int h)
{
  int ax, ay, h2, w2, xx, yy;
  double ang, angy, dist, disty, disty2, hradius2, q, xloc, yloc;

  w2 = w / 2;
  h2 = h / 2;
  for (ay = 0; ay < h2; ay++)
    {
      disty = ((double)(ay - h2 + 0.5)) / h2;
      disty2 = disty * disty;
      hradius2 = 1.0 - disty2;
      for (ax = 0; ax < w2; ax++)
	{
	  dist = ((double)(ax - w2 + 0.5)) / w2;
	  if ((q = (hradius2 - dist * dist)) >= 0.0 )
	    {
	      if (fabs(dist) > 0.00001)
		{
		  ang = PI - atan2(sqrt(q), dist);
		}
	      else
		{
		  ang = PI2;
		}
	      xloc = ang / (2.0 * PI) ;
	      xx = ((int)(xloc * MAP_W)) % MAP_W;
	      angy = PI2 + atan2(disty, sqrt(1.0 - disty2));
	      yloc = angy / PI;
	      yy = ((int)(yloc * scr_w)) % scr_w;
	      *(xmap + (ay * w2) + ax) = xx;
	      if (ax == (w2 - 1))
		{
		  ymap[ay] = yy;
		}
	    }
	  else
	    {
	      *(xmap + (ay * w2) + ax) = -1;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void draw_big_earth()
{
  char *bl, *br, *mbl, *mbr, *mtl, *mtr, *tl, *tr;
  int ax, ay, ofs, *p_xmapy;

  tl = video_buffer + (scr_w - PIC_W) / 2;
  tr = tl + (PIC_W - 1);
  bl = tl + scr_w * (scr_h - 1);
  br = bl + (PIC_W - 1);
  for (ay = 0; ay < PIC_H2; ay++)
    {
      mtl = earth_map->line[ymap[ay]] + picpos;
      mtr = mtl + (MAP_W2 - 1);
      mbl = earth_map->line[(scr_w - 1) - ymap[ay]] + picpos;
      mbr = mbl + (MAP_W2 - 1);
      p_xmapy = &xmap[ay][0];
      for (ax = 0; ax < PIC_W2; ax++)
	{
	  if ((ofs = *(p_xmapy + ax)) != -1)
	    {
	      *tl++ = *(mtl + ofs);
	      *tr-- = *(mtr - ofs);
	      *bl++ = *(mbl + ofs);
	      *br-- = *(mbr - ofs);
	    }
	  else
	    {
	      tl++;
	      tr--;
	      bl++;
	      br--;
	    }
	}
      tl += scr_w - PIC_W2;
      tr += scr_w + PIC_W2;
      bl -= scr_w + PIC_W2;
      br -= scr_w - PIC_W2;
    }
}
/*---------------------------------------------------------------------------*/
void draw_revolving_earths()
{
  static fixed angle = 0;

  draw_small_earth(XCENTER + fixtoi(fcos(angle + 0xAAAAAA) * 60),
		   YCENTER + fixtoi(fsin(angle + 0xAAAAAA) * 50), picpos);
  draw_small_earth(XCENTER + fixtoi(fcos(angle + 0x555555) * 60),
		   YCENTER + fixtoi(fsin(angle + 0x555555) * 50), (picpos + MAP_W / 3) % MAP_W);
  draw_small_earth(XCENTER + fixtoi(fcos(angle) * 60),
		   YCENTER + fixtoi(fsin(angle) * 50), (picpos + (2 * MAP_W) / 3) % MAP_W);
  angle += direction2 * (0x1000000 / MAP_W);
  if (angle > 0x1000000)
    {
      angle -= 0x1000000;
    }
  if (angle < 0x1000000)
    {
      angle += 0x1000000;
    }
}
/*---------------------------------------------------------------------------*/
void draw_small_earth(int xpos, int ypos, int apicpos)
{
  char *bl, *br, *mbl, *mbr, *mtl, *mtr, *tl, *tr;
  int ax, ay, ofs, *p_xmapy;

  rect(screen, xpos - 1, ypos - 1, xpos + SPIC_W, ypos + SPIC_H, 0);
  tl = video_buffer + xpos + ypos * scr_w;
  tr = tl + (SPIC_W - 1);
  bl = tl + scr_w * (SPIC_H - 1);
  br = bl + (SPIC_W - 1);
  for (ay = 0; ay < SPIC_H2; ay++)
    {
      mtl = earth_map->line[ymap_small[ay]] + apicpos;
      mtr = mtl + (MAP_W2 - 1);
      mbl = earth_map->line[(scr_w - 1) - ymap_small[ay]] + apicpos;
      mbr = mbl + (MAP_W2 - 1);
      p_xmapy = &xmap_small[ay][0];
      for (ax = 0; ax < SPIC_W2; ax++)
	{
	  if ((ofs = *(p_xmapy + ax)) != -1)
	    {
	      *tl++ = *(mtl + ofs);
	      *tr-- = *(mtr - ofs);
	      *bl++ = *(mbl + ofs);
	      *br-- = *(mbr - ofs);
	    }
	  else
	    {
	      *tl++ = 0;
	      *tr-- = 0;
	      *bl++ = 0;
	      *br-- = 0;
	    }
	}
      tl += scr_w - SPIC_W2;
      tr += scr_w + SPIC_W2;
      bl -= scr_w + SPIC_W2;
      br -= scr_w - SPIC_W2;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f7_0()
{
  keysee_f7_gen("f7_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_1()
{
  keysee_f7_gen("f7_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_2()
{
  keysee_f7_gen("f7_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_3()
{
  keysee_f7_gen("f7_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_4()
{
  keysee_f7_gen("f7_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_5()
{
  keysee_f7_gen("f7_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_6()
{
  keysee_f7_gen("f7_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_7()
{
  keysee_f7_gen("f7_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_8()
{
  keysee_f7_gen("f7_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_9()
{
  keysee_f7_gen("f7_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f7_A()
{
  paraint(&eff_rotate.asort, SORT_MIN, SORT_MAX, SORT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_C()
{
  paraint(&count, COUNT_MIN, COUNT_MAX, COUNT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_J()
{
  paraint(&direction, DIRECTION_MIN, DIRECTION_MAX, DIRECTION_STEP, 1, 1);
  direction1++;
  if (direction1 > MAP_W)
    {
      direction1 -= MAP_W;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f7_K()
{
  direction2 = -direction2;
}
/*---------------------------------------------------------------------------*/
void keysee_f7_O()
{
  parafixed(&step, STEP_MIN, STEP_MAX, STEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_S()
{
  parafixed(&size, SIZE_MIN, SIZE_MAX, SIZE_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_X()
{
  paraint(&x, X_MIN, X_MAX, X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_Y()
{
  paraint(&y, Y_MIN, Y_MAX, Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_a()
{
  paraint(&eff_rotate.asort, SORT_MIN, SORT_MAX, SORT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_c()
{
  paraint(&count, COUNT_MIN, COUNT_MAX, COUNT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_gen(uchr s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  eff_rotate.asort = atoi(tps[1]);
  count = atoi(tps[2]);
  delayy = atoi(tps[3]);
  direction = atoi(tps[4]);
  direction1 = atoi(tps[4]);
  direction2 = atoi(tps[5]);
  step = itofix(atoi(tps[6]));
  size = ftofix(atof(tps[7]));
  x = atoi(tps[8]);
  y = atoi(tps[9]);
  do_effect(&eff_rotate);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_j()
{
  paraint(&direction, DIRECTION_MIN, DIRECTION_MAX, DIRECTION_STEP, 0, 1);
  direction1--;
  if (direction1 < 0)
    {
      direction1 += MAP_W;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f7_o()
{
  parafixed(&step, STEP_MIN, STEP_MAX, STEP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_s()
{
  parafixed(&size, SIZE_MIN, SIZE_MAX, SIZE_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_k()
{
  direction2 = -direction2;
}
/*---------------------------------------------------------------------------*/
void keysee_f7_x()
{
  paraint(&x, X_MIN, X_MAX, X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f7_y()
{
  paraint(&y, Y_MIN, Y_MAX, Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void rotate_done()
{
  destroy_bitmapm(earth_map);
  destroy_bitmapm(earth_map1);
}
/*---------------------------------------------------------------------------*/
void rotate_effect(int asort)
{
  if (direction == 1)
    {
      sign = itofix(-1);
    }
  else
    {
      sign = itofix(1);
    }
  switch (asort)
    {
    case 1:
      rotate_scaled_sprite(screen, pbmp, x, y, fmul(sign, angle), size);
      break;
    case 2:
      rotate_scaled_sprite(screen, pbmp, x, y, fmul(sign, angle), size);
      rotate_scaled_sprite(screen, pbmp,
			   x + scr_w - (int)(pbmp->w * fixtof(size)),
			   y, fmul(sign, angle), size);
      break;
    case 3:
      rotate_scaled_sprite(screen, pbmp, x, y, fmul(sign, angle), size);
      rotate_scaled_sprite(screen, pbmp,
			   x + scr_w - (int)(pbmp->w * fixtof(size)),
			   y, fmul(sign, angle), size);
      rotate_scaled_sprite(screen, pbmp,
			   x + scr_w - (int)(pbmp->w * fixtof(size)),
			   y + scr_h - (int)(pbmp->h * fixtof(size)),
			   fmul(sign, angle), size);
      break;
    case 4:
      rotate_scaled_sprite(screen, pbmp, x, y, fmul(sign, angle), size);
      rotate_scaled_sprite(screen, pbmp,
			   x + scr_w - (int)(pbmp->w * fixtof(size)),
			   y, fmul(sign, angle), size);
      rotate_scaled_sprite(screen, pbmp,
			   x + scr_w - (int)(pbmp->w * fixtof(size)),
			   y + scr_h - (int)(pbmp->h * fixtof(size)),
			   fmul(sign, angle), size);
      rotate_scaled_sprite(screen, pbmp, x,
			   y + scr_h - (int)(pbmp->h * fixtof(size)),
			   fmul(sign, angle), size);
      break;
    case 5:
      rotate_earth(1);
      break;
    case 6:
      rotate_earth(2);
      break;
    }
  angle = angle + step;
  if (angle > itofix(256))
    {
      angle = itofix(0);
    }
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void rotate_init()
{
  angle = itofix(1);
  i_love_bill = TRUE;
  picpos = MAP_W2;
  direction1 = 1;
  video_buffer = (char *)(__djgpp_conventional_base + 0xA0000);

  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(tim_inccounter);
  install_timer();
  /* call tim_inccounter each 10 msec */
  install_int(tim_inccounter, 10);

  earth_map1 = create_bitmapm(640, scr_w);
  stretch_blit(pbmp, earth_map1, 0, 0, scr_w, scr_h, 0, 0, 640, scr_w);
  earth_map = create_bitmapm(MAP_W + MAP_W2, scr_w);
  blit(earth_map1, earth_map, 0, 0, 0, 0, MAP_W, scr_w);
  blit(earth_map1, earth_map, 0, 0, MAP_W, 0, MAP_W2, scr_w);
  calculate_curvature((int *)xmap, (int *)ymap, PIC_W, scr_h);
  calculate_curvature((int *)xmap_small, (int *)ymap_small, SPIC_W, SPIC_H);

  lastkey = K_d;
}
