/* zz.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */

/* original code by Michael Bevin */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define SORT_MIN 1
#define SORT_MAX 10
#define SORT_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
uchr *p;
short *b;
int frame_count = 1, i, last_line, the_type, x, x_max, y, y_max;
float fps, x_pos = 0, y_pos = 0;
BITMAP *pbmp_plas, *pbmp_text, *pbmp_worm1, *pbmp_worm2, *temp1, *temp2;
plas aplas;
text atext;
worm aworm1, aworm2;
volatile int counter2 = 1;

int delayy;

static tkeyparse
  see_f12_0 = {K_0, keysee_f12_0}, /* zz.c specific */
  see_f12_1 = {K_1, keysee_f12_1},
  see_f12_2 = {K_2, keysee_f12_2},
  see_f12_3 = {K_3, keysee_f12_3},
  see_f12_4 = {K_4, keysee_f12_4},
  see_f12_5 = {K_5, keysee_f12_5},
  see_f12_6 = {K_6, keysee_f12_6},
  see_f12_7 = {K_7, keysee_f12_7},
  see_f12_8 = {K_8, keysee_f12_8},
  see_f12_9 = {K_9, keysee_f12_9},
  see_f12_A = {K_A, keysee_f12_A},
  see_f12_D = {K_D, keysee_f12_D},
  see_f12_a = {K_a, keysee_f12_a},
  see_f12_d = {K_d, keysee_f12_d}
;

tkeyparse* tkeyparsetbl_zz[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f12_0, /* zz.c specific */
  &see_f12_1,
  &see_f12_2,
  &see_f12_3,
  &see_f12_4,
  &see_f12_5,
  &see_f12_6,
  &see_f12_7,
  &see_f12_8,
  &see_f12_9,
  &see_f12_A,
  &see_f12_D,
  &see_f12_a,
  &see_f12_d,
  NULL
};

teffect eff_zz =
{
  zz_init,
  zz_effect,
  zz_loop_end,
  zz_done,
  tkeyparsetbl_zz,
  1
};
/*---------------------------------------------------------------------------*/
int zz_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_A:
    case K_D:
    case K_a:
    case K_d:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void tim_incrcounter(void)
{
  counter2++;
}

END_OF_FUNCTION(tim_incrcounter);
/*---------------------------------------------------------------------------*/
/* this function calls still_plasma to create the plasma, and then puts */
/* two copies of it onto temp2, as required by the texture-mapping and */
/* wormhole routines */
BITMAP *create_plasma(void)
{
  BITMAP *temp, *temp2;

  temp = still_plasma(256, 256, STILL_SEAMLESS);
  temp2 = create_bitmap_ex(8, 256, 512);
  blit(temp, temp2, 0, 0, 0, 0, 256, 256);
  blit(temp, temp2, 0, 0, 0, 256, 256, 256);
  destroy_bitmapm(temp);
  return temp2;
}
/*---------------------------------------------------------------------------*/
/* w and h are best as powers of 2 + 1, ie 129, 257 etc */
/* with the bitmap being the same dimensions, but ignoring the last row */
/* and column, type can be either STILL_NORMAL or STILL_SEAMLESS */
/* if you set the type to STILL_SEAMLESS it'll make the */
/* edges match up so that you can tile it / texture map it etc. */
BITMAP *still_plasma(int w, int h, int type)
{
  uchr *p;
  short h1, high, low, *q, range, w1;
  long x, y;
  float ratio;
  BITMAP *buff;

  the_type = type;
  w1 = w;
  h1 = h;
  w++; /* increase width & height by one and then ignore last row & col */
  h++;
  x_max = w;
  y_max = h;
  last_line = (y_max - 1) * x_max;

  b = malloc(w * h * 2);
  buff = create_bitmap_ex(8, w1, h1);

  for (x = 0; x < w * h; x++)
    {
      b[x] = -10000; /* magic number */
   }

  b[0] = 128 + random() % 32; /* initialize first four corners */
  b[w - 1] = 128 + random() % 32;
  b[w - 1 + (h - 1) * w] = 128 + random() % 32;
  b[(h - 1) * w] = 128 + random() % 32;
  cs(0, 0, w - 1, h - 1); /* calls recursive function */

  /* normalize the plasma to range 0 - 255 */
  low = 10000;
  high = -10000;

  for (y = 0; y < h1; y++)
    {
      q = &b[y * w];
      for (x = 0; x < w1; x++)
	{
	  if (q[x] < low)
	    {
	      low = q[x];
	    }
	  if (q[x] > high)
	    {
	      high = q[x];
	    }
	}
    }

  range = high - low;

  ratio = (float) ((float)255.0 / (float)range);
  for (y = 0; y < h1; y++)
    {
      p = &buff->line[y][0];
      q = &b[y * w];
      for (x = 0; x < w1; x++)
	{
	  p[x] = (unsigned char) ((float)(q[x] - low) * (float)ratio);
	}
    }
  free(b);
  return(buff);
}
/*---------------------------------------------------------------------------*/
/* recursive function */
/* it saves having a precalculated texture map taking up heaps of space */
void cs(int il, int jl, int ih, int jh)
{
  int im, jm;

  im = (il + ih) / 2;
  jm = (jl + jh) / 2;

  if (jm > jl)
    {
      if(b[il * x_max + jm] == -10000)
	{
	  b[il * x_max + jm] = (b[il * x_max + jl] + b[il * x_max + jh]) / 2 +
	    (random() % 65536 - 32768) / (32768 / (jh - jl));
	  if (il == 0)
	    {
	      if (the_type == STILL_SEAMLESS)
		{
		  b[last_line + jm] = b[il * x_max + jm];
		}
	    }
	}
      if (il < ih && b[ih * x_max + jm] == -10000)
	{
	  b[ih * x_max + jm] = (b[ih * x_max + jl] + b[ih * x_max + jh]) / 2 +
	    (random() % 65536 - 32768) / (32768 / (jh - jl));
	}
    }
  if (im > il)
    {
      if (b[im * x_max + jl] == -10000)
	{
	  b[im * x_max + jl] = (b[il * x_max + jl] + b[ih * x_max + jl]) / 2 +
	    (random() % 65536 - 32768) / (32768 / (ih - il));
	  if (jl == 0)
            if (the_type == STILL_SEAMLESS)
	      b[im * x_max + (x_max - 1)] = b[im * x_max + jl];
	}
      if (jl < jh && b[im * x_max + jh] == -10000)
	{
	  b[im * x_max + jh] = (b[il * x_max + jh] + b[ih * x_max + jh]) / 2 +
	    (random() % 65536 - 32768) / (32768 / (ih - il));
	}
    }
  if ((jm > jl) && (im > il))
    {
      if (b[im * x_max + jm] == -10000)
	{
	  b[im * x_max + jm] = (b[il * x_max + jl] + b[ih * x_max + jl] +
				b[il * x_max + jh] + b[ih * x_max + jh]) / 4 +
	    (random() % 65536 - 32768) / (32768 / (ih - il + jh - jl));
	}
    }
  if ((jm > jl && jm < jh) || (im > il && im < ih))
    {
      cs(il, jl, im, jm);
      cs(il, jm, im, jh);
      cs(im, jl, ih, jm);
      cs(im, jm, ih, jh);
    }
}
/*---------------------------------------------------------------------------*/
/* width : multiple of 16 (e.g. 320) */
/* range : default = 4, varies the output color */
void init_plas(plas *the_plas, int width, int height, int range)
{
  uchr *p, *p2, *q, *q2;
  int i = 0, j, l;
  long k;
  float temp;

  the_plas->width = width;
  the_plas->height = height;

  the_plas->circle1 = (float)(random() % 65536) / 16384.0;
  the_plas->circle2 = (float)(random() % 65536) / 16384.0 * -1;
  the_plas->circle3 = (float)(random() % 65536) / 16384.0;
  the_plas->circle4 = (float)(random() % 65536) / 16384.0 * -1;
  the_plas->circle5 = (float)(random() % 65536) / 16384.0;
  the_plas->circle6 = (float)(random() % 65536) / 16384.0 * -1;
  the_plas->circle7 = (float)(random() % 65536) / 16384.0;
  the_plas->circle8 = (float)(random() % 65536) / 16384.0 * -1;
  the_plas->type = range / 4;

  the_plas->table1 = malloc(the_plas->width * the_plas->height * 4);
  the_plas->table2 = malloc(the_plas->width * the_plas->height * 4);
  p = the_plas->table1;
  q = the_plas->table2;
  l = the_plas->width * 2;

  while (i < the_plas->height)
    {
      j = 0;
      k = (the_plas->height - i) * (the_plas->height - i);

      while (j < the_plas->width)
	{
	  temp = sqrt(16.0 + k + (the_plas->width - j) *
		      (the_plas->width - j)) - 4;
	  *p++ = (temp * 5.4) / range;
	  *q++ = (sin(temp / 9.5) + 1) * 97 / range;
	  j++;
	}
      p2 = p - 1;
      q2 = q - 1;
      while (j < l)
	{
	  *p++ = *p2--;
	  *q++ = *q2--;
	  j++;
	}
      i++;
    }
  while (i < the_plas->height * 2)
   {
     memcpy(&the_plas->table1[i * l], &the_plas->table1[(the_plas->height * 2 - i - 1) * l], l);
     memcpy(&the_plas->table2[i * l], &the_plas->table2[(the_plas->height * 2 - i - 1) * l], l);
     i++;
   }
}
/*---------------------------------------------------------------------------*/
/* faster than the original code by F. Becker aka SLIQ */
/* width : multiple of 16 (e.g. 320) */
void init_texture(text *the_text, int width, int height)
{
  int x;
  double const fd2r = 3.1415926535 / 512;
  long *p1, *p2;

  the_text->width = width;
  the_text->height = height;

  the_text->table1 = malloc(128 * 8);
  the_text->table2 = malloc(the_text->width * 4);

  the_text->xo = 0; /* x offset */
  the_text->yo = 0; /* y offset */
  the_text->deg = 0; /* rotation amount */

  p1 = (long *) the_text->table1;
  p2 = (long *) the_text->table1 + (128 * 4);

  for (x = 0; x < (random() % 512); x++)
    {
      the_text->deg += 2;
      the_text->xo += (1253L << 5);
      the_text->yo += (1534L << 5);
    }

  for (x = 0; x < 128; x++)
    {
      p1[x] = (sin((x << 3) * fd2r) * 65536.0);
      p2[x] = (cos((x << 3) * fd2r) * 65536.0);
    }
}
/*---------------------------------------------------------------------------*/
/* if you wish to use both a normal type and a spiral type in your program, */
/* call init_two_worms with two worm structures and no type */
void init_two_worms(worm *the_worm1, worm *the_worm2, int w, int h, float cone_z, int m)
{
  uchr spirdeg, tx, ty;
  short h1, sx, sy, tsx, tsy, w1;
  ushr *p, *q, ty256, tz256;
  int syw;
  float cone_x, cone_y, cxt1, cyt1, phi, step, t1, theta, x, y;
  const float t360 = 360 * 0.01745329 / 100.0;

  the_worm1->width  = w;
  the_worm1->height = h;
  the_worm1->table1 = malloc(w * h * 2);
  the_worm2->width  = w;
  the_worm2->height = h;
  the_worm2->table1 = malloc(w * h * 2);

  cone_x = (215.0 * w) / 320;
  cone_y = (150.0 * h) / 200;
  spirdeg = 1;

  p = (ushr *) the_worm1->table1;
  q = (ushr *) the_worm2->table1;
  w1 = w / 2;
  h1 = h / 2;

  for (y = 1200.0; y > 0; y -= step)
    {
      phi = y / 100.0;
      step = 0.065 * (200.0 / m) + (0.4 * phi * (200.0 / m));

      ty = phi * 256.0;
      ty256 = ty * 256;
      tz256 = ty256 - ty * spirdeg;

      t1 = 150 / (cone_z * phi + 150);
      cxt1 = t1 * cone_x;
      cyt1 = t1 * cone_y;

      for (x = 100.0; x > 75.0; x -= step)
	{
	  theta  = x * t360;

	  tsy = cyt1 * sin(theta);
	  sy = h1 + tsy;

	  if (sy < h && sy >= 0)
	    {
	      tsx = cxt1 * cos(theta);
	      sx = w1 + tsx;
	      if (sx < w && sx >= 0)
		{
		  syw = sy * w;

		  /* 1st quadrant */
		  tx = x * 256.0 / 100.0;
		  p[syw + sx] = ty256 + tx;
		  q[syw + sx] = tz256 + tx;

		  /* 2nd quadrant */
		  tx = (150.0 - x) * 256.0 / 100.0;
		  sx = w1 - tsx;
		  p[syw + sx] = ty256 + tx;
		  q[syw + sx] = tz256 + tx;

		  /* 3rd quadrant */
		  tx = (x - 50.0) * 256.0 / 100.0;
		  syw = (h1 - tsy) * w;
		  p[syw + sx] = ty256 + tx;
		  q[syw + sx] = tz256 + tx;

		  /* 4th quadrant */
		  tx = (100.0 - x) * 256.0 / 100.0;
		  sx = w1 + tsx;
		  p[syw + sx] = ty256 + tx;
		  q[syw + sx] = tz256 + tx;
		}
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
/* w : multiple of 16 (e.g. 320) */
/* cone_z : 1000.0 */
/* m : 500, if it is too high the initialization will be needlessly slow, */
/*          if too low it will miss pixels and this will be obvious */
/*          when running the program */
/* type : WORM_NORMAL or WORM_SPIRAL */
void init_worm(worm *the_worm, int w, int h, float cone_z, int m, int type)
{
  uchr spirdeg, tx, ty;
  short h1, sx, sy, tsx, tsy, w1;
  ushr *p, ty256;
  int syw;
  float cone_x, cone_y, cxt1, cyt1, phi, step, t1, theta, x, y;
  const float t360 = 360 * 0.01745329 / 100.0;

  the_worm->width  = w;
  the_worm->height = h;
  the_worm->table1 = malloc(w * h * 2);

  cone_x = (215.0 * w) / 320;
  cone_y = (150.0 * h) / 200;
  spirdeg = 1;

  p = (ushr *) the_worm->table1;
  w1 = w/2;
  h1 = h/2;

  for (y = 1200.0; y > 0; y -= step)
    {
      phi = y / 100.0;
      step = 0.065 * (200.0 / m) + (0.4 * phi * (200.0 / m));

      ty = phi * 256.0;
      ty256 = ty * 256;
      if (type == WORM_SPIRAL)
	{
	  ty256 = ty256 - ty * spirdeg;
	}

      t1 = 150 / (cone_z * phi + 150);
      cxt1 = t1 * cone_x;
      cyt1 = t1 * cone_y;

      for (x = 100.0; x > 75.0; x -= step)
	{
	  theta = x * t360;

	  tsy = cyt1 * sin(theta);
	  sy = h1 + tsy;

	  if (sy < h && sy >= 0)
	    {
	      tsx = cxt1 * cos(theta);
	      sx = w1 + tsx;
	      if (sx < w && sx >= 0)
		{
		  syw = sy * w;

		  /* 1st quadrant */
		  tx = x * 256.0 / 100.0;
		  p[syw + sx] = ty256 + tx;

		  /* 2nd quadrant */
		  tx = (150.0 - x) * 256.0 / 100.0;
		  sx = w1 - tsx;
		  p[syw + sx] = ty256 + tx;

		  /* 3rd quadrant */
		  tx = (x - 50.0) * 256.0 / 100.0;
		  syw = (h1 - tsy) * w;
		  p[syw + sx] = ty256 + tx;

		  /* 4th quadrant */
		  tx = (100.0 - x) * 256.0 / 100.0;
		  sx = w1 + tsx;
		  p[syw + sx] = ty256 + tx;
		}
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f12_0()
{
  keysee_f12_gen("f12_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_1()
{
  keysee_f12_gen("f12_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_2()
{
  keysee_f12_gen("f12_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_3()
{
  keysee_f12_gen("f12_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_4()
{
  keysee_f12_gen("f12_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_5()
{
  keysee_f12_gen("f12_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_6()
{
  keysee_f12_gen("f12_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_7()
{
  keysee_f12_gen("f12_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_8()
{
  keysee_f12_gen("f12_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_9()
{
  keysee_f12_gen("f12_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f12_A()
{
  paraint(&eff_zz.asort, SORT_MIN, SORT_MAX, SORT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f12_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f12_a()
{
  paraint(&eff_zz.asort, SORT_MIN, SORT_MAX, SORT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f12_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f12_gen(uchr s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  eff_zz.asort = atoi(tps[1]);
  delayy = atoi(tps[2]);
  do_effect(&eff_zz);
}
/*---------------------------------------------------------------------------*/
/* slimy texture mapping */
/* speed increase by reducing the inner loop to the simplicity of */
/* pointer a++ gets value of (address pointer b points to plus value of */
/* pointer c++) */
void mainpart(long dx, long dy, ushr adx2, ushr ady2,long xo, long yo,
	      text *the_text, BITMAP *buffer, BITMAP *backpic)
{
  uchr *p, *q, wo16, x1;
  ushr *tmp, y = 0;
  long *p1, *p2;
  ulng xstart, ystart;

  p1 = (long *) the_text->table1;
  p2 = (long *) the_text->table1 + (128 * 4);
  wo16 = the_text->width / 16;

  /* precalculate slime values for vertical line (used in inner loop) */
  tmp = (ushr *) the_text->table2;
  *tmp++ = ady2 + (p1[y & 127] >> 8);
  for (y = 1; y < the_text->width; y++)
    {
      *tmp = (ady2 + (p1[y & 127] >> 8) + *(tmp++ - 1));
    }
  *tmp++ = 0;
  for (y = 1; y < the_text->width; y++)
    {
      *tmp = *(tmp++ - 1) + adx2;
    }
  tmp = (ushr *) the_text->table2;
  for (y = 0; y < the_text->width; y++)
    {
      *tmp = (*tmp & 65280) + (*(tmp++ + the_text->width) >> 8);
    }
  xstart = xo;
  ystart = yo;
  p = &buffer->line[0][0];
  /* now lets do it ! */
  for (y = 0; y < the_text->height; y++)
    {
      tmp = (ushr *) the_text->table2;
      q = &backpic->line[(ystart >> 16) % 256][(xstart >> 16) % 256];
      for (x1 = 0; x1 < wo16; x1++)
	{
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	  *p++ = *(q + *tmp++);
	}
      /* calc new start position for vertical line plus slime adjustment ... */
      xstart += (dx + p2[y & 127]);
      ystart += dy;
    }
}
/*---------------------------------------------------------------------------*/
/* buffer, backpic dimensions : width * height */
/* backon : 1 = use backpic */
/* fps : the current frames rate */
void plasma(plas *the_plas, BITMAP *buffer, BITMAP *backpic, int backon, double fps)
{
  uchr j;
  int i = 0, ho2, wo16, wo2, x1, x2, x3, x4, xx1, xx2, xx3, xx4;
  int y1, y2, y3, y4;
  ulng *p, *p1, *p2, *p3, *q, *q1;

  wo16 = the_plas->width / 16;
  wo2  = the_plas->width / 2;
  ho2  = the_plas->height / 2;

  the_plas->circle1 += .0425 * 1.6 / fps;
  the_plas->circle2 -=   .05 * 1.6  / fps;
  the_plas->circle3 +=   .15 * 1.6 / fps;
  the_plas->circle4 -=   .10 * 1.6  / fps;
  the_plas->circle5 +=   .20 * 1.6 / fps;
  the_plas->circle6 -=  .075 * 1.6  / fps;
  the_plas->circle7 +=  .175 * 1.6 / fps;
  the_plas->circle8 -=  .025 * 1.6  / fps;

  x2 = wo2 + wo2 * sin(the_plas->circle1);
  y2 = ho2 + ho2 * cos(the_plas->circle2);
  x1 = wo2 + wo2 * cos(the_plas->circle3);
  y1 = ho2 + ho2 * sin(the_plas->circle4);
  x3 = wo2 + wo2 * cos(the_plas->circle5);
  y3 = ho2 + ho2 * sin(the_plas->circle6);
  x4 = wo2 + wo2 * cos(the_plas->circle7);
  y4 = ho2 + ho2 * sin(the_plas->circle8);
  xx1 = the_plas->width * 2 * y1 + x1;
  xx2 = the_plas->width * 2 * y2 + x2;
  xx3 = the_plas->width * 2 * y3 + x3;
  xx4 = the_plas->width * 2 * y4 + x4;

  for (i = 0; i < the_plas->height; i++)
    {
      p = (ulng *) &buffer->line[i][0];

      x1 = the_plas->width * 2 * i;
      p1 = (ulng *) &the_plas->table1[x1 + xx1];
      p2 = (ulng *) &the_plas->table2[x1 + xx3];
      p3 = (ulng *) &the_plas->table2[x1 + xx4];
      q  = (ulng *) &the_plas->table2[x1 + xx2];

      if (!backon)
	{
	  for (j = 0; j < wo16; j++)
	    {
	      *p++ = *p1++ + *p2++ + *p3++ + *q++;
	      *p++ = *p1++ + *p2++ + *p3++ + *q++;
	      *p++ = *p1++ + *p2++ + *p3++ + *q++;
	      *p++ = *p1++ + *p2++ + *p3++ + *q++;
	    }
	}
      else
	{
	  q1 = (ulng *) &backpic->line[i][0];
	  for (j = 0; j < wo16; j++)
	    {
	      *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
	      *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
	      *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
	      *p++ = *p1++ + *p2++ + *p3++ + *q++ + *q1++;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
/* buffer, backpic dimensions : width * height = 256 * 512 */
/*                              with the second 256 rows a copy of the first */
void texture(text *the_text, BITMAP *buffer, BITMAP *backpic, double fps)
{
  long dx, dy;
  double const fd2r = 3.1415926535 / 512;

  dy = (sin(the_text->deg * fd2r) * 160000.0);
  dx = (cos(the_text->deg * fd2r) * 160000.0);
  mainpart(dx, dy, (ushr) (-dy >> 8), (ushr) (dx >> 8),
	   (long) the_text->xo, (long) the_text->yo,
	   the_text, buffer, backpic);
  the_text->deg += 2.0 * (10.0 / fps);
  the_text->xo += (1253L << 5) * (13.0 / fps);
  the_text->yo += (1534L << 5) * (13.0 / fps);
}
/*---------------------------------------------------------------------------*/
/* buff dimension : w * h */
/* back dimension : 256 * 512 */
/*                  with the second 256 rows a copy of the first */
/* change the x & y positions to generate movement with the wormhole */
/* to create a background picture, use the stilplas routine to */
/* create a still cloud type plasma (use the seamless option) of size 256 x */
/* 256, and then create a 256 x 512 bitmap and blit the plasma onto it at */
/* positions (0, 0) and (0, 256) */
void wormhole(worm *the_worm, BITMAP *buff, BITMAP *back, int y_pos, int x_pos)
{
   uchr a, b, *q, *r, wi, x;
   ushr *p, *p1, y;

   p = (ushr *) the_worm->table1;
   a = y_pos;
   b = x_pos;
   q = &back->line[a][b];
   wi = the_worm->width / 16;

   for (y = 0; y < the_worm->height; y++)
     {
       r = &buff->line[y][0];
       p1 = &p[y * the_worm->width];
       for (x = 0; x < wi; x++)
	 {
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	 }
     }
}
/*---------------------------------------------------------------------------*/
/* the wormhole_lines function is the same as wormhole except it expects a */
/* 256 x 2 back, with the second row an identical copy of the first */
/* try using this with the row being chosen at random out of the plasma */
/* y_pos unused in this function */
void wormhole_lines(worm *the_worm, BITMAP *buff, BITMAP *back,
		    int y_pos, int x_pos)
{
   uchr b, *p1, *q, *r, wo16, x;
   ushr y;

   y_pos = 0;
   b = x_pos;
   q = &back->line[0][0] + b;
   wo16 = the_worm->width / 16;

   p1 = the_worm->table2;

   for (y = 0; y < the_worm->height; y++)
     {
       r = &buff->line[y][0];
       for (x = 0; x < wo16; x++)
	 {
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	   *r++ = *(q + *p1++);
	 }
     }
}
/*---------------------------------------------------------------------------*/
void zz_done()
{
  destroy_bitmapm(temp1);
  destroy_bitmapm(temp2);
}
/*---------------------------------------------------------------------------*/
void zz_effect(int asort)
{
  fps = frame_count * 10.0 / counter2;
  x_pos += 20 / fps; /* move the wormhole */
  y_pos += 20 / fps;
  switch (asort)
    {
    case 1: /* slimy texture */
      texture(&atext, pbmp_text, temp2, fps);
      blit(pbmp_text, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 2: /* red ugly plasma */
      for (i = 0; i < 256; i++)
	{
	  pal[i].r = i >> 2;
	  pal[i].g = 0;
	  pal[i].b = 0;
	}
      set_palette(pal);
      plasma(&aplas, pbmp_plas, pbmp, 1, fps);
      blit(pbmp_plas, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 3: /* green ugly plasma */
      for (i = 0; i < 256; i++)
	{
	  pal[i].r = 0;
	  pal[i].g = i >> 2;
	  pal[i].b = 0;
	}
      set_palette(pal);
      plasma(&aplas, pbmp_plas, pbmp, 1, fps);
      blit(pbmp_plas, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 4: /* blue ugly plasma */
      for (i = 0; i < 256; i++)
	{
	  pal[i].r = 0;
	  pal[i].g = 0;
	  pal[i].b = i >> 2;
	}
      set_palette(pal);
      plasma(&aplas, pbmp_plas, pbmp, 1, fps);
      blit(pbmp_plas, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 5: /* red nice plasma */
      for (i = 0; i < 256; i++)
	{
	  pal[i].r = i >> 2;
	  pal[i].g = 0;
	  pal[i].b = 0;
	}
      set_palette(pal);
      plasma(&aplas, pbmp_plas, pbmp, 1, fps);
      for (y = 0; y < scr_h; y++)
	{
	  p = &pbmp_plas->line[y][0];
	  for (x = 0; x < scr_w / 4; x++)
	    {
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	    }
	}
      blit(pbmp_plas, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 6: /* green nice plasma */
      for (i = 0; i < 256; i++)
	{
	  pal[i].r = 0;
	  pal[i].g = i >> 2;
	  pal[i].b = 0;
	}
      set_palette(pal);
      plasma(&aplas, pbmp_plas, pbmp, 1, fps);
      for (y = 0; y < scr_h; y++)
	{
	  p = &pbmp_plas->line[y][0];
	  for (x = 0; x < scr_w / 4; x++)
	    {
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	    }
	}
      blit(pbmp_plas, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 7: /* blue nice plasma */
      for (i = 0; i < 256; i++)
	{
	  pal[i].r = 0;
	  pal[i].g = 0;
	  pal[i].b = i >> 2;
	}
      set_palette(pal);
      plasma(&aplas, pbmp_plas, pbmp, 1, fps);
      for (y = 0; y < scr_h; y++)
	{
	  p = &pbmp_plas->line[y][0];
	  for (x = 0; x < scr_w / 4; x++)
	    {
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	      if (*p & 128)
		{
		  *p = ~*p;
		}
	      *p = *p++ << 1;
	    }
	}
      blit(pbmp_plas, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 8:
      wormhole(&aworm1, pbmp_worm1, temp2, (int) y_pos, (int) x_pos);
      blit(pbmp_worm1, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 9:
      wormhole(&aworm2, pbmp_worm2, temp2, (int) y_pos, (int) x_pos);
      blit(pbmp_worm2, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    case 10:
      x_pos += 5;
      y_pos += 5;
      wormhole(&aworm1, pbmp_worm1, temp2, (int) y_pos, (int) x_pos);
      blit(pbmp_worm1, screen, 0, 0, 0, 0, scr_w, scr_h);
      break;
    }
  frame_count++;
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void zz_init()
{
  srandom(time(0));
  install_timer();
  LOCK_VARIABLE(counter2);
  LOCK_FUNCTION(tim_incrcounter);

  temp1 = create_bitmapm(256, 256);
  temp2 = create_bitmapm(256, 512);
  stretch_blit(pbmp, temp1, 0, 0, 320, 200, 0, 0, 256, 256);
  blit(temp1, temp2, 0, 0, 0, 0, 256, 256);
  blit(temp1, temp2, 0, 0, 0, 256, 256, 256);
  init_plas(&aplas, scr_w, scr_h, 4);
  init_two_worms(&aworm1, &aworm2, scr_w, scr_h, 1000.0, 150.0);
  init_texture(&atext, scr_w, scr_h);
  pbmp_worm1 = create_bitmap(scr_w, scr_h);
  pbmp_worm2 = create_bitmap(scr_w, scr_h);
  pbmp_plas = create_bitmap(scr_w, scr_h);
  pbmp_text = create_bitmap(scr_w, scr_h);
  install_int(tim_incrcounter, 100);

  lastkey = K_d;
}
/*---------------------------------------------------------------------------*/
/*
  drawbitmap = createbitmap(scr_w, scr_h);
  backbitmap = createbitmap(scr_w, scr_h);
  copy background-data to "backbitmap"
  while(1)
  {
  blit(backbitmap, drawbitmap, 0, 0, 0, 0, scr_w, scr_h);
  change x,y by whatever value you want,
  and change number and size and
  transparency of your sprites as you want
  let them overlap, just everything...
  draw_sprite(drawbitmap, man, x, y);
  vsync();
  blit(drawbitmap, screen, 0, 0, x, y, 100, 100);
  }
*/
/*
  typedef struct tkeyparse
  {
  int key;
  void (*key_handler)();
  } tkeyparse;
  typedef struct effect
  {
  void (*init)();
  void (*effect(int asort));
  void (*done)();
  struct tkeyparse **ptkeyparsetbl;
  } effect
*/
