#!/bin/sh
# original MakeTeXMF -- make a new MF file, because one wasn't found.
# 
# (If you change or delete the word `original' on the previous line,
# installation won't write this script over yours.)
# 
# te@informatik.uni-hannover.de and kb@mail.tug.org. Public domain.

version='$Id: MakeTeXMF,v 1.9 1997/02/08 15:52:15 karl Exp karl $'
usage="Usage: $0 FONT.
  Makes the Metafont source file for FONT, if possible.
  For example, \`ecr12' or \`cmr11'."

: ${TEXMFMAIN=`kpsewhich -expand-var='$TEXMFMAIN'`}
if test -z "$TEXMFMAIN"; then
  echo "$0: No \$TEXMFMAIN; set the environment variable or in texmf.cnf." >&2
  exit 1
fi
: ${TEXMFCNF_DIR=`kpsewhich -expand-var='$TEXMFCNF_DIR'`}
test -n "$TEXMFCNF_DIR" || TEXMFCNF_DIR=$TEXMFMAIN/web2c
. $TEXMFCNF_DIR/MakeTeXcommon

# See comments in MakeTeXPK.
(
name="`basename $1 .mf`"
rootname=`echo "$name" | sed 's/[0-9]*$//'`
pointsize=`echo "$name" | sed "s/^$rootname//"`

case "$name" in
  dc*) fontdir=$dcfontdir;;
  ec*) fontdir=$ecfontdir;;
  fc*) fontdir=$fcfontdir;;
  tc*) fontdir=$tcfontdir;;
  ts*) fontdir=$tsfontdir;;
    *) fontdir=$sauterfontdir; test -r $fontdir/b-$rootname.mf || exit 1;;
esac
cd $fontdir 2>/dev/null || exit 1

case "$pointsize" in
  "") echo "$0: No pointsize." >&2; exit 1;;
  11) realsize=10.95444;;	# \magstephalf
  14) realsize=14.4;;		# \magstep2
  17) realsize=17.28;;		# \magstep3
  20) realsize=20.74;;		# \magstep4
  25) realsize=24.88;;		# \magstep5
        # The new convention is to have three or four letters for the
        # font name and four digits for the pointsize. The number is
        # pointsize * 100. We effectively divide by 100 by ignoring the
        # last two digits.
????) realsize=`echo "$pointsize" | sed 's/\(..\)/\1./'`;;
   *) realsize="$pointsize";;
esac

mfname="$name.mf"
if test -r "$mfname"; then
  echo "$0: $fontdir/$mfname already exists."
  echo $fontdir/$mfname >$STDOUT
  $TEXMFCNF_DIR/MakeTeXupdate "$fontdir" "$mfname"
  exit 0
fi

# MS-DOS limits extension to 3 characters, so put PID into the basename.
base=
case "$name" in
  dc*) base=dxbase;;
  ec*|tc*) base=exbase;;
    *) cat >"mf$$.tmp" <<END-OF-SAUTER
design_size := $realsize;
input b-$rootname;
END-OF-SAUTER
       ;;
esac

test -n "$base" &&
  echo "if unknown $base: input $base fi;" >"mf$$.tmp"

cat >>"mf$$.tmp" <<END
gensize := $realsize;
generate $rootname;
END

chmod $MT_FILE_PERMS "mf$$.tmp"
rm -f "$mfname"
mv "mf$$.tmp" "$mfname"

echo "$fontdir/$mfname" >$STDOUT
$TEXMFCNF_DIR/MakeTeXupdate "$fontdir" "$mfname"
exit 0
) 1>&2 </dev/null
