/* Pathnames and other system-dependent stuff.  */

#if defined(__MSDOS__) || defined(WIN32) || defined(MSDOS)
# define DOSLIKE
# include <fcntl.h>
# ifdef __DJGPP__
#  include <io.h>
#  include <unistd.h>
# endif
#endif

#ifdef DOSLIKE
# undef  PATH_SEPARATOR
# define PATH_SEPARATOR       ';'
# define IS_SLASH(c)          ((c) == '/' || (c) == '\\')
# define NAME_WITH_DRIVE(fn)  (*(fn) && (fn)[1] == ':')
# define POPEN_READ           "rb"
# ifdef __DJGPP__
#  define SETBIN(fd)          if (!isatty((fd)))setmode((fd), O_BINARY)
#  define ENSCRIPTSITE_CFG    "site-enscript.cfg"
# else
#  define SETBIN(fd)          if (!isatty((fd)))_setmode((fd), _O_BINARY)
#  define ENSCRIPTSITE_CFG    "enscriptsite.cfg"
# endif
# ifdef WIN32
#  define ENSCRIPTSITE_CFG    "enscriptsite.cfg"
# else
#  define ENSCRIPTSITE_CFG    "site-enscript.cfg"
# endif
# define PROGNAME(fn)                                             \
   basename((fn));                                                \
   do {                                                           \
     char *exe = (fn) + strlen ((fn)) - 4;                        \
                                                                  \
     /* Drop the .exe suffix, if any.  */                         \
     if (strcmp (exe, ".exe") == 0 || strcmp (exe, ".EXE") == 0)  \
       *exe = '\0';                                               \
   } while (0)
# define BASENAME(fn)         basename((fn))
#else
# undef  PATH_SEPARATOR
# define PATH_SEPARATOR       ':'
# define IS_SLASH(c)          ((c) == '/')
# define NAME_WITH_DRIVE(fn)  0
# define POPEN_READ           "r"
# define SETBIN(fd)           (void)0
# define PROGNAME(fn)         (strrchr((fn), '/') == NULL) \
                              ? (char *) (strrchr((fn), '/') + 1) : (fn)
# define BASENAME(fn)         (strrchr((fn), '/') == NULL) \
                              ? (char *) (strrchr((fn), '/') + 1) : (fn)
# define ENSCRIPTSITE_CFG     "enscriptsite.cfg"
#endif
