/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <unistd.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can xrealloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_xrealloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 86
#define YY_END_OF_BUFFER 87
static yyconst short int yy_accept[195] =
    {   0,
       84,   84,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   54,   54,   78,   78,   87,   85,   84,   84,
       53,   85,   85,    1,   53,    1,    1,    1,    1,    1,
        1,   23,    1,    1,    1,    1,   22,    1,   56,   84,
       85,   50,   49,   77,   68,   64,   60,   77,   69,   77,
       77,   77,   70,   77,   77,   64,   60,   77,   77,   67,
       63,   54,   54,   78,   78,   84,   84,    0,   52,    0,
        0,   40,   28,    0,   51,   57,    3,   11,   18,   14,
       16,   12,   17,   13,    4,   20,   55,   19,   15,    0,
       33,   23,   25,   25,    5,    8,    6,   10,    9,    7,

       22,   48,   47,   44,   44,   46,   58,   84,    0,   83,
       83,    0,   68,   71,    0,   69,    0,    0,   65,   61,
        0,   70,    0,    0,   74,   66,   62,   65,   61,   54,
       54,   78,   78,   42,   41,   29,   59,    0,   21,   55,
       55,   26,   24,   24,   31,   38,   35,    0,   30,   45,
       83,   83,   83,   82,   72,   73,   75,   76,   43,    2,
       27,   34,   32,   32,    0,   37,   36,   82,   82,   79,
       82,   82,    0,   31,   39,   82,   82,   82,   82,    0,
        0,   82,   80,   82,    0,   80,    0,   82,   81,   82,
        0,   81,    0,    0

    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    4,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    7,    1,    8,    9,   10,
       11,   12,   13,   14,   15,   16,   17,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   19,   14,   20,
       21,   22,    1,   14,   23,   23,   23,   23,   24,   23,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       14,   26,   14,   27,   28,    1,   23,   23,   23,   23,

       24,   23,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   29,    8,   30,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[31] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    2,    1,    1,
        1,    1,    2,    2,    2,    1,    1,    2,    1,    1
    } ;

static yyconst short int yy_base[224] =
    {   0,
        0,   29,    9,   15,   33,   38,   39,   42,   66,   94,
      122,  150,  311,  310,  309,  308,  310,  394,   44,  394,
       39,   43,   35,  394,  300,   44,   52,   35,   51,   59,
       60,  175,  287,   62,  285,   65,    0,  203,  299,   85,
       91,  394,  394,   78,  394,  394,  394,   89,  394,  100,
      108,  231,  394,  259,  287,  394,  394,  102,  294,  394,
      394,  301,  394,  300,  394,  113,  394,   74,  394,    0,
      103,  284,   77,  292,  291,  289,  279,  394,  394,  394,
      394,  394,  394,  394,  394,  278,  290,  394,  394,  112,
      307,    0,  394,  125,  394,  394,  394,  394,  394,  394,

        0,  394,  394,  394,  394,    0,  394,  142,  140,  289,
      147,  125,  394,  394,  119,  394,  154,  158,  280,  394,
      276,  394,  160,  275,  394,  274,  394,  273,  394,  280,
      394,  279,  394,  131,  394,  394,  394,  265,  394,  277,
      394,  251,  394,  162,  115,  394,  323,  260,  259,  394,
      273,  394,  172,  183,  264,  394,  263,  394,  394,  394,
      394,  394,  394,  169,  252,  248,  394,  261,  192,  394,
      232,  237,  238,  236,  394,  394,  233,  241,  174,  240,
      245,  247,  394,  241,  249,  394,  250,  199,  394,  254,
      193,  394,  255,  394,  351,  353,  355,  357,  359,  361,

      363,  365,  187,  367,  369,  371,  373,  375,  377,  181,
      165,  379,  161,  381,  139,   92,   88,  383,   64,  385,
      387,  389,  391
    } ;

static yyconst short int yy_def[224] =
    {   0,
      194,    1,  195,  195,  196,  196,  197,  197,  198,  198,
      198,  198,  199,  199,  200,  200,  194,  194,  194,  194,
      201,  194,  194,  194,  202,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  203,  194,  194,  194,
      204,  194,  194,  205,  194,  194,  194,  206,  194,  206,
      206,  207,  194,  207,  207,  194,  194,   55,   55,  194,
      194,  208,  194,  209,  194,  194,  194,  201,  194,  201,
      194,  210,  211,  202,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  212,  194,  194,  194,
      194,   32,  194,  194,  194,  194,  194,  194,  194,  194,

      203,  194,  194,  194,  194,  213,  194,  194,  204,  214,
      214,  205,  194,  194,  206,  194,  206,  206,  194,  194,
       55,  194,   55,   55,  194,  194,  194,  194,  194,  208,
      194,  209,  194,  215,  194,  194,  194,  194,  194,  212,
      194,  216,  194,  194,  217,  194,  194,  194,  217,  194,
      214,  194,  214,  218,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  219,  194,  218,  218,  194,
      220,  218,  194,  217,  194,  194,  220,  221,  218,  221,
      194,  218,  194,  222,  194,  194,  223,  222,  194,  222,
      223,  194,  223,    0,  194,  194,  194,  194,  194,  194,

      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194
    } ;

static yyconst short int yy_nxt[425] =
    {   0,
       18,   19,   20,   19,   21,   22,   23,   24,   25,   26,
       24,   27,   28,   24,   29,   30,   31,   32,   33,   34,
       35,   36,   37,   37,   37,   18,   38,   37,   39,   18,
       40,   43,   43,   43,   41,   45,   43,   43,   43,   43,
       45,   49,   43,   69,   49,   66,   67,   66,   50,   71,
       51,   50,   73,   51,   81,   76,   82,   73,   73,   77,
       72,   46,   47,   78,   70,  175,   46,   47,   53,   85,
       83,   79,   84,   80,   86,   54,   87,   55,   69,   88,
      113,   89,   96,   97,   99,  100,  108,   67,   66,  163,
      109,  116,  111,  142,   56,   57,   53,   71,  117,   70,

      118,  136,  116,   54,  136,   55,  114,  114,   72,  117,
      116,  119,  121,  128,   66,   67,   66,  117,  120,  118,
      134,  116,   56,   57,   53,  134,  134,  113,  117,  142,
      118,   58,  145,   59,  142,  142,  142,  148,  164,  148,
      134,  111,  149,  108,   67,   66,  194,  109,  153,  152,
       60,   61,   53,  114,  114,  159,  116,  194,  159,   58,
      116,   59,  150,  117,  154,  155,   73,  117,  156,  118,
      121,  157,  162,  153,  152,  182,  183,  162,   60,   61,
       90,  173,  135,  173,  169,  170,  174,  171,  101,  154,
       91,  184,   92,  169,  170,  192,  171,   93,   94,   93,

      172,  189,   93,  102,  103,  104,  103,  102,  102,  102,
      102,  102,  105,  105,  105,  105,  105,  105,  105,  105,
      102,  105,  105,  105,  105,  106,  106,  106,  102,  105,
      106,  105,  102,  122,  178,  178,  179,  179,  169,  170,
      123,  171,  124,  189,  181,  181,  185,  186,  182,  183,
      185,  186,  192,  174,  172,  174,  189,  192,  190,  125,
      125,  122,  187,  176,  184,  166,  187,  193,  123,  166,
      126,  190,  193,  158,  156,  152,  149,  149,  161,  141,
      160,  133,  131,  158,  158,  158,  121,  125,  125,  122,
      156,  152,  141,  139,  138,  137,  123,  127,  124,   74,

       75,   72,  133,  131,  129,  107,   98,   95,   75,  194,
       65,   65,   63,   63,  194,  125,  125,  143,  194,  194,
      194,  194,  144,  194,  145,  194,  194,  194,  194,  146,
      147,  146,  194,  194,  146,  165,  194,  165,  194,  194,
      166,  194,  194,  194,  194,  167,  167,  167,  194,  194,
      167,   42,   42,   44,   44,   48,   48,   52,   52,   62,
       62,   64,   64,   68,   68,   74,   74,  110,  110,  112,
      112,  115,  115,  121,  121,  130,  130,  132,  132,  140,
      140,  151,  151,  168,  168,  177,  177,  180,  180,  188,
      188,  191,  191,   17,  194,  194,  194,  194,  194,  194,

      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194
    } ;

static yyconst short int yy_chk[425] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        2,    3,    3,    3,    2,    5,    3,    4,    4,    4,
        6,    7,    4,   21,    8,   19,   19,   19,    7,   22,
        7,    8,   23,    8,   28,   26,   28,   23,   23,   26,
       22,    5,    5,   27,   21,  219,    6,    6,    9,   30,
       29,   27,   29,   27,   30,    9,   31,    9,   68,   31,
       44,   31,   34,   34,   36,   36,   40,   40,   40,  217,
       40,   48,   41,  216,    9,    9,   10,   41,   48,   68,

       48,   73,   50,   10,   73,   10,   44,   44,   41,   50,
       51,   50,   58,   58,   66,   66,   66,   51,   51,   51,
       71,  115,   10,   10,   11,   71,   71,  112,  115,   90,
      115,   11,  145,   11,   90,   90,   90,   94,  145,   94,
      215,  109,   94,  108,  108,  108,  109,  108,  111,  111,
       11,   11,   12,  112,  112,  134,  117,  109,  134,   12,
      118,   12,  213,  117,  111,  117,  211,  118,  118,  118,
      123,  123,  144,  153,  153,  179,  179,  144,   12,   12,
       32,  164,  210,  164,  154,  154,  164,  154,  203,  153,
       32,  179,   32,  169,  169,  191,  169,   32,   32,   32,

      154,  188,   32,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   38,   38,   38,   38,   38,   38,   38,
       38,   38,   38,   52,  171,  177,  171,  177,  172,  172,
       52,  172,   52,  184,  180,  178,  181,  181,  182,  182,
      185,  185,  187,  174,  172,  173,  190,  193,  184,   52,
       52,   54,  181,  168,  182,  166,  185,  187,   54,  165,
       54,  190,  193,  157,  155,  151,  149,  148,  142,  140,
      138,  132,  130,  128,  126,  124,  121,   54,   54,   55,
      119,  110,   87,   86,   77,   76,   55,   55,   55,   75,

       74,   72,   64,   62,   59,   39,   35,   33,   25,   17,
       16,   15,   14,   13,    0,   55,   55,   91,    0,    0,
        0,    0,   91,    0,   91,    0,    0,    0,    0,   91,
       91,   91,    0,    0,   91,  147,    0,  147,    0,    0,
      147,    0,    0,    0,    0,  147,  147,  147,    0,    0,
      147,  195,  195,  196,  196,  197,  197,  198,  198,  199,
      199,  200,  200,  201,  201,  202,  202,  204,  204,  205,
      205,  206,  206,  207,  207,  208,  208,  209,  209,  212,
      212,  214,  214,  218,  218,  220,  220,  221,  221,  222,
      222,  223,  223,  194,  194,  194,  194,  194,  194,  194,

      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  194,
      194,  194,  194,  194
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "<stdin>"
#define INITIAL 0
/*Lexer for Standard and Extended Pascal with Borland and GNU
  extensions

  Copyright (C) 2000-2006 Free Software Foundation, Inc.

  Author: Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 3, or (at your
  option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA. */
/*Notes:

  Return everything, including whitespace and comments if the
  corresponding token values are >= 0.

  Call SaveTokenString before modifying yyleng or the content of yytext. */
#define YY_NO_UNPUT 1
#define CaretLetter 1

#define Comment1 2

#define Comment2 3

#define Comment1B 4

#define Comment2B 5

#define Discard 6

#define DiscardComment 7

#line 46 "<stdin>"
typedef enum
{
  DoubleQuotedStrings,
  MultilineStrings,
  IntegersWithoutSeparator,
  IntegersBase,
  IntegersHex,
  RealsWithoutSeparator,
  RealsWithDotOnly,
  RealsWithoutExpDigits,
  CharConstantsHash,
  MixedComments,
  NestedComments,
  DelphiComments,
  LF_MAX
} TLexFeatureIndex;

typedef struct
{
  HOST_WIDE_INT IntegerValueBytes[BYTES_PER_INTEGER];
  int IntegerValue, IntegerValueOverflow;
  char *TokenString, *StringValue;
  int TokenStringLength, StringValueLength;
} TLexSem;

typedef struct
{
  int Line, Column;
  char *SrcName;
} TLexPos;

extern int CommentLevelCount;
extern int Directive;
extern TLexSem LexSem;
extern TLexPos LexPos;

int CheckFeature (TLexFeatureIndex Feature, int Message);
void ExtraUserAction (const char *buf, unsigned int length);
void SetFileName (int);
void InitLex (const char *, FILE *, int);
void DoneLex (void);
int lexscan (void);
void lex_error (const char *Msg, int Fatal);
#define YY_FATAL_ERROR(msg) lex_error (msg, 1)

int CommentLevelCount = 0, Directive = 0;
TLexSem LexSem;

static int TokenStringBufSize = 0;
static char *TokenStringBuf = NULL;

TLexPos LexPos = { 0, 0, NULL };
static TLexPos NewPos = { 0, 0, NULL }, CommentStartPos = { 0, 0, NULL };

#ifndef yyalloc
void *
yyalloc (yy_size_t size)
{
  void *p = (void *) xmalloc (size);
  if (!p)
    YY_FATAL_ERROR ("out of memory");
  return p;
}
#endif

#ifndef yyxrealloc
void *
yyxrealloc (void *p, yy_size_t size)
{
  p = (void *) xrealloc (p, size);
  if (!p)
    YY_FATAL_ERROR ("out of memory");
  return p;
}
#endif

#ifndef yyfree
#define yyfree free
#endif

static int (*DoInput)(char * buf, int max_size);
static int DoInputF (char *buf, int max_size);
static int DoInputP (char *buf, int max_size);

void InitLex (const char *SrcName, FILE *i, int IsInteractive)
{
  if (IsInteractive >= 0)
    yy_set_interactive (IsInteractive);
  if (LexPos.SrcName) free (LexPos.SrcName);
  LexPos.SrcName = yyalloc (strlen (SrcName) + 1);
  strcpy (LexPos.SrcName, SrcName);
  LexPos.Line = LexPos.Column = 1;
  NewPos = LexPos;
  if (!co->preprocessed)
    {
      init_gpcpp();
      gpcpp_main (SrcName, i);
      YY_CURRENT_BUFFER->yy_input_file = 0;
      YY_FLUSH_BUFFER;
      DoInput = DoInputP;
    }
  else
    {
      YY_CURRENT_BUFFER->yy_input_file = yyin = i;
      YY_FLUSH_BUFFER;
      DoInput = DoInputF;
    }
  (void) yy_fatal_error;  /* avoid a warning */
}

void DoneLex (void)
{
  LexPos.Line = LexPos.Column = 0;
  NewPos = LexPos;
}



#define YY_INPUT(buf, result, max_size) ((result) = DoInput ((buf), (max_size)))

static inline int DoFixInput (char *buf, int r)
{
  static char last = 0;
  int i;
  char *p, *q;
  for (p = q = buf, i = r; i; i--, p++)
    if ((last == '\r' && *p == '\n') || (last == '\n' && *p == '\r'))
      last = 0;
    else
      *q++ = (last = *p) == '\r' ? '\n' : *p;
  return q - buf;
}

static int DoInputF (char *buf, int max_size)
{
  int r = fread (buf, 1, max_size, yyin);
  if (r == 0 && ferror (yyin))
    YY_FATAL_ERROR ("input in flex scanner failed");
  return DoFixInput (buf, r);
}

static int DoInputP (char *buf, int max_size)
{
  int r = gpcpp_fillbuf(buf, max_size);
  return DoFixInput (buf, r);
}

#define YY_USER_ACTION UserAction ();
static inline void UserAction (void)
{
  char *c = yytext;
  int l = yyleng;
  LexSem.TokenString = yytext;
  LexSem.TokenStringLength = yyleng;
  LexSem.StringValue = NULL;
  LexSem.StringValueLength = 0;
  LexPos = NewPos;
  while (l--)
    if (*c++ == '\n')
      {
        NewPos.Line++;
        NewPos.Column = 1;
      }
    else
      NewPos.Column++;
  ExtraUserAction (yytext, yyleng);
}

static void SaveTokenString (void)
{
  if (!TokenStringBuf || TokenStringBufSize < yyleng + 1)
    {
      if (TokenStringBuf)
        free (TokenStringBuf);
      TokenStringBuf = yyalloc ((TokenStringBufSize = yyleng + 1));
    }
  strncpy (TokenStringBuf, yytext, yyleng + 1);
  LexSem.TokenString = TokenStringBuf;
}

static int Char2Digit (char c)
{
  if (c >= '0' && c <= '9')
    return c - '0';
  else if (c >= 'A' && c <= 'Z')
    return c - 'A' + 0xa;
  else if (c >= 'a' && c <= 'z')
    return c - 'a' + 0xa;
  else
    return -1;
}

static char *ReadIntegerConstant (char *p, int base)
{
  int digit, largest_digit = 0, overflow = 0, i, v;
  if (!LEX_SEMANTIC_VALUES) return p;
  for (i = 0; i < BYTES_PER_INTEGER; i++)
    LexSem.IntegerValueBytes[i] = 0;
  while (1)
    {
      digit = Char2Digit (*p);
      if (digit < 0) break;
      if (digit > largest_digit)
        largest_digit = digit;
      for (i = 0; i < BYTES_PER_INTEGER; i++)
        {
          v = LexSem.IntegerValueBytes[i] * base + digit;
          LexSem.IntegerValueBytes[i] = v & ((1 << BITS_PER_BYTES) - 1);
          digit = v >> BITS_PER_BYTES;
        }
      if (digit > 0)
        overflow = 1;
      p++;
    }
  if (largest_digit >= base)
    {
      if (base <= 10 && largest_digit >= 10)
        lex_error ("nondigits in integer constant whose radix <= 10", 0);
      else
        lex_error ("integer constant contains digits beyond the radix", 0);
    }
  else if (overflow)
    lex_error ("integer constant overflow", 0);
  LexSem.IntegerValue = 0;
  LexSem.IntegerValueOverflow = 0;
  for (i = 0, v = 1; i < BYTES_PER_INTEGER; i++, v <<= BITS_PER_BYTES)
    if (v != 0)
      LexSem.IntegerValue += v * LexSem.IntegerValueBytes[i];
    else if (LexSem.IntegerValueBytes[i] != 0)
      LexSem.IntegerValueOverflow = 1;
  return p;
}

static void ReadIntegerBase (void)
{
  char *p;
  CheckFeature (IntegersBase, 1);
  if (LEX_SEMANTIC_VALUES)
    {
      p = ReadIntegerConstant (yytext, 10);
      if (LexSem.IntegerValueOverflow || LexSem.IntegerValue < 2 || LexSem.IntegerValue > 36)
        {
          lex_error ("integer base out of range (2 .. 36)", 0);
          LexSem.IntegerValue = 10;
        }
      ReadIntegerConstant (p + 1, LexSem.IntegerValue);
    }
}

static inline void SetCharConst (int c)
{
  static char CharConstBuf[2] = { 0, 0 };
  CharConstBuf[0] = c;
  LexSem.StringValue = CharConstBuf;
  LexSem.StringValueLength = 1;
}

static void SetCaretCharConst (void)
{
  char c = yytext[1];
  if (c >= 'a' && c <= 'z')
    c -= 'a' - 'A';
  SetCharConst (c ^ 0x40);  /* sic! */
}

static void BPCharConstant (char *p, int base)
{
  CheckFeature (CharConstantsHash, 1);
  if (!LEX_SEMANTIC_VALUES) return;
  ReadIntegerConstant (p, base);
  if (LexSem.IntegerValueOverflow || LexSem.IntegerValue > 0xff)
    lex_error ("numeric value out of range for character constant", 0);
  SetCharConst (LexSem.IntegerValue);
}

static void SetString (int DoubleQuoted)
{
  char *c = yytext, *d = yytext;
  while (*c && *c != '\n')
    c++;
  if (*c)
    CheckFeature (MultilineStrings, 1);
  if (DoubleQuoted)
    CheckFeature (DoubleQuotedStrings, 1);
  if (!LEX_SEMANTIC_VALUES)
    return;
  SaveTokenString ();
  if (!DoubleQuoted)
    {
      for (c = yytext + 1; *c && c[1]; c++)
        if ((*d++ = *c) == '\'')
          c++;
    }
  else
    {
      for (c = yytext + 1; *c && *c != '"'; c++)
        if (*c != '\\')
          *d++ = *c;
        else
          switch (*++c)
            {
              case 'n':  *d++ = '\n' /* TARGET_NEWLINE */; break;
              case 't':  *d++ = '\t' /* TARGET_TAB */;     break;
              case 'r':  *d++ = '\r' /* TARGET_CR */;      break;
              case 'f':  *d++ = '\f' /* TARGET_FF */;      break;
              case 'b':  *d++ = '\b' /* TARGET_BS */;      break;
              case 'v':  *d++ = '\v' /* TARGET_VT */;      break;
              case 'a':  *d++ = '\a' /* TARGET_BELL */;    break;
              case 'e':
              case 'E':  *d++ = 27;             break;
              case 'x':  {
                           int v = 0, n = 0, overflow = 0;
                           while (1)
                             {
                               int digit = Char2Digit (*++c);
                               if (digit < 0 || digit >= 0x10) break;
                               v = 0x10 * v + digit;
                               overflow |= v > 0xff;
                               n++;
                             }
                           if (overflow)
                             lex_error ("hex character escape out of range", 0);
                           else if (!n)
                             lex_error ("hex character escape with no digits", 0);
                           *d++ = v;
                           c--;
                           break;
                         }
              case '0': case '1': case '2': case '3':
              case '4': case '5': case '6': case '7':
                         {
                           int v = 0, n = 1;
                           do
                             v = 8 * v + (*c++ - '0');
                           while (n++ < 3 && *c >= '0' && *c <= '7');
                           if (v > 0xff)
                             lex_error ("octal character escape out of range", 0);
                           *d++ = v;
                           c--;
                           break;
                         }
              case '\n': break;
              default:   *d++ = *c;
            }
    }
  *d = 0;
  LexSem.StringValue = yytext;
  LexSem.StringValueLength = d - yytext;
}

static void DoLineDir (int items)
{
  char *p1 = yytext;
  while (*p1 < '0' || *p1 > '9') p1++;
  ReadIntegerConstant (p1, 10);
  if (LexSem.IntegerValueOverflow)
    lex_error ("number in line directive out of range", 0);
  NewPos.Line = LexSem.IntegerValue;
  if (items >= 2)
    {
      int v = 0;
      char *p2, *q;
      while (*p1 != '"') p1++;
      p2 = ++p1;
      while (*p2 != '"') p2++;
      /* Never free an input filename, since copies of the pointer are
         kept around (in DECL_SOURCE_FILE etc.). */
      NewPos.SrcName = q = yyalloc (p2 - p1 + 1);
      while (p1 < p2)
        {
          if (*p1 == '\\')
            p1++;
          *q++ = *p1++;
        }
      *q = 0;
      if (items >= 3)
        {
          while (*p2 < '0' || *p2 > '9') p2++;
          p2 = ReadIntegerConstant (p2, 10);
          if (LexSem.IntegerValueOverflow)
            lex_error ("number in line directive out of range", 0);
          v = LexSem.IntegerValue;
        }
      SetFileName (v);
    }
}

static inline void StartComment (int IsDirective, int State, int StateBoth)
{
  CommentStartPos = LexPos;
  CommentLevelCount = 1;
  Directive = IsDirective;
  BEGIN (CheckFeature (MixedComments, 0) ? StateBoth : State);
}

#define CommentContent \
  RETURN_IF_DEFINED ((CommentLevelCount == 1 && Directive) ? LEX_DIRECTIVE_CONTENT : LEX_COMMENT_CONTENT)

#define EndComment \
  if (--CommentLevelCount == 0) \
    BEGIN (INITIAL); \
  RETURN_IF_DEFINED ((CommentLevelCount == 0 && Directive) ? LEX_DIRECTIVE_END : LEX_COMMENT_END);

#define RETURN_IF_DEFINED(x) do { if ((x) >= 0) return (x); } while (0)

#define YY_DECL int lexscan (void)

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		yy_current_buffer->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 470 "<stdin>"



	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 195 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 394 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 472 "<stdin>"
return yytext[0];
	YY_BREAK
case 2:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 473 "<stdin>"
return '(';
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 474 "<stdin>"
return '[';
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 475 "<stdin>"
return ']';
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 476 "<stdin>"
return LEX_ASSIGN;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 477 "<stdin>"
return LEX_NE;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 478 "<stdin>"
return LEX_GE;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 479 "<stdin>"
return LEX_LE;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 480 "<stdin>"
return LEX_SYMDIFF;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 481 "<stdin>"
return LEX_RENAME;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 482 "<stdin>"
return LEX_POWER;
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 483 "<stdin>"
return LEX_CEIL_PLUS;
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 484 "<stdin>"
return LEX_CEIL_MINUS;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 485 "<stdin>"
return LEX_CEIL_MULT;
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 486 "<stdin>"
return LEX_CEIL_DIV;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 487 "<stdin>"
return LEX_FLOOR_PLUS;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 488 "<stdin>"
return LEX_FLOOR_MINUS;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 489 "<stdin>"
return LEX_FLOOR_MULT;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 490 "<stdin>"
return LEX_FLOOR_DIV;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 491 "<stdin>"
return LEX_RANGE;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 492 "<stdin>"
return LEX_ELLIPSIS;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 494 "<stdin>"
return LEX_ID;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 496 "<stdin>"
ReadIntegerConstant (yytext, 10); return LEX_INTCONST;
	YY_BREAK
case 24:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 497 "<stdin>"
ReadIntegerConstant (yytext, 10); return LEX_INTCONST;
	YY_BREAK
case 25:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 498 "<stdin>"
CheckFeature (IntegersWithoutSeparator, 1); ReadIntegerConstant (yytext, 10); return LEX_INTCONST;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 499 "<stdin>"
ReadIntegerBase (); return LEX_INTCONST_BASE;
	YY_BREAK
case 27:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 500 "<stdin>"
CheckFeature (IntegersWithoutSeparator, 1); ReadIntegerBase (); return LEX_INTCONST_BASE;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 501 "<stdin>"
CheckFeature (IntegersHex, 1); ReadIntegerConstant (yytext + 1, 0x10); return LEX_INTCONST_BASE;
	YY_BREAK
case 29:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 502 "<stdin>"
CheckFeature (IntegersHex, 1); CheckFeature (IntegersWithoutSeparator, 1); ReadIntegerConstant (yytext + 1, 0x10); return LEX_INTCONST_BASE;
	YY_BREAK
case 30:
#line 505 "<stdin>"
case 31:
YY_RULE_SETUP
#line 505 "<stdin>"
return LEX_REALCONST;
	YY_BREAK
case 32:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 506 "<stdin>"
CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 507 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); return LEX_REALCONST;
	YY_BREAK
case 34:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 508 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); return LEX_REALCONST;  /* note the `{DS}/"."[.)]' rule (fjf528b.pas) */
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 509 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutExpDigits, 1); return LEX_REALCONST;
	YY_BREAK
case 36:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 510 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutExpDigits, 1); CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 511 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); return LEX_REALCONST;
	YY_BREAK
case 38:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 512 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 39:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 513 "<stdin>"
CheckFeature (RealsWithDotOnly, 1); CheckFeature (RealsWithoutSeparator, 1); return LEX_REALCONST;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 515 "<stdin>"
BPCharConstant (yytext + 1, 10); return LEX_STRCONST;
	YY_BREAK
case 41:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 516 "<stdin>"
CheckFeature (IntegersWithoutSeparator, 1); BPCharConstant (yytext + 1, 10); return LEX_STRCONST;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 517 "<stdin>"
BPCharConstant (yytext + 2, 0x10); return LEX_STRCONST;
	YY_BREAK
case 43:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 518 "<stdin>"
CheckFeature (IntegersWithoutSeparator, 1); BPCharConstant (yytext + 2, 0x10); return LEX_STRCONST;
	YY_BREAK
case 44:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 520 "<stdin>"
return '^';
	YY_BREAK
case 45:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 521 "<stdin>"
return '^';
	YY_BREAK
case 46:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 522 "<stdin>"
BEGIN (CaretLetter); return '^';
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 523 "<stdin>"
SetCaretCharConst (); return LEX_CARET_WHITE;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 524 "<stdin>"
SetCaretCharConst (); return LEX_STRCONST;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 525 "<stdin>"
BEGIN (INITIAL); return LEX_CARET_LETTER;
	YY_BREAK
case 50:
#line 527 "<stdin>"
case YY_STATE_EOF(CaretLetter):
#line 527 "<stdin>"
lex_error ("internal lexer error", 1);
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 529 "<stdin>"
SetString (0); return LEX_STRCONST;
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 530 "<stdin>"
SetString (1); return LEX_STRCONST;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 531 "<stdin>"
lex_error ("unterminated string constant", 0); BEGIN (Discard); RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 532 "<stdin>"
RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 534 "<stdin>"
CheckFeature (DelphiComments, 1); RETURN_IF_DEFINED (LEX_COMMENT);
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 535 "<stdin>"
StartComment (0, Comment1, Comment1B); RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 536 "<stdin>"
StartComment (0, Comment2, Comment2B); RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 537 "<stdin>"
StartComment (1, Comment1, Comment1B); RETURN_IF_DEFINED (LEX_DIRECTIVE_BEGIN);
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 538 "<stdin>"
StartComment (1, Comment2, Comment2B); RETURN_IF_DEFINED (LEX_DIRECTIVE_BEGIN);
	YY_BREAK
case 60:
#line 540 "<stdin>"
case 61:
YY_RULE_SETUP
#line 540 "<stdin>"
EndComment;
	YY_BREAK
case 62:
#line 542 "<stdin>"
case 63:
YY_RULE_SETUP
#line 542 "<stdin>"
CheckFeature (MixedComments, 1); EndComment;
	YY_BREAK
case 64:
#line 544 "<stdin>"
case 65:
YY_RULE_SETUP
#line 544 "<stdin>"
{
                             if (CheckFeature (NestedComments, 0))
                               {
                                 CheckFeature (NestedComments, 1);
                                 CommentLevelCount++;
                                 RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
                               }
                             else
                               CommentContent;
                           }
	YY_BREAK
case 66:
#line 555 "<stdin>"
case 67:
YY_RULE_SETUP
#line 555 "<stdin>"
{
                             if (CheckFeature (NestedComments, 0))
                               {
                                 CheckFeature (NestedComments, 1);
                                 CheckFeature (MixedComments, 1);
                                 CommentLevelCount++;
                                 /* Theoretically, we should adjust the lexer state.
                                    But this would require a stack to pop it back
                                    when the nested comment is closed. Since we have
                                    just given a warning for mixed comments (if
                                    requested), this effort seems unjustified just
                                    to give a possible further one. */
                                 RETURN_IF_DEFINED (LEX_COMMENT_BEGIN);
                               }
                             else
                               CommentContent;
                           }
	YY_BREAK
case 68:
#line 573 "<stdin>"
case 69:
#line 574 "<stdin>"
case 70:
YY_RULE_SETUP
#line 574 "<stdin>"
CommentContent;
	YY_BREAK
case 71:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 575 "<stdin>"
CommentContent;
	YY_BREAK
case 72:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 576 "<stdin>"
CommentContent;
	YY_BREAK
case 73:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 577 "<stdin>"
CommentContent;
	YY_BREAK
case 74:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 578 "<stdin>"
CommentContent;
	YY_BREAK
case 75:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 579 "<stdin>"
CommentContent;
	YY_BREAK
case 76:
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */
yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 580 "<stdin>"
CommentContent;
	YY_BREAK
case 77:
#line 582 "<stdin>"
case YY_STATE_EOF(Comment1):
case YY_STATE_EOF(Comment2):
case YY_STATE_EOF(Comment1B):
case YY_STATE_EOF(Comment2B):
#line 582 "<stdin>"
LexPos = CommentStartPos; lex_error ("unterminated comment", 0); BEGIN (DiscardComment); CommentContent;
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 583 "<stdin>"
CommentContent;
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 585 "<stdin>"
DoLineDir (1); RETURN_IF_DEFINED (LEX_LINE_DIRECTIVE);
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 586 "<stdin>"
DoLineDir (2); RETURN_IF_DEFINED (LEX_LINE_DIRECTIVE);
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 587 "<stdin>"
DoLineDir (3); RETURN_IF_DEFINED (LEX_LINE_DIRECTIVE);
	YY_BREAK
case 82:
#line 589 "<stdin>"
case 83:
YY_RULE_SETUP
#line 589 "<stdin>"
lex_error ("invalid `#' directive", 0); RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 591 "<stdin>"
RETURN_IF_DEFINED (LEX_WHITESPACE);
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 592 "<stdin>"
lex_error ("invalid character", 0); RETURN_IF_DEFINED (LEX_INVALID);
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Discard):
case YY_STATE_EOF(DiscardComment):
#line 593 "<stdin>"
return 0;
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 595 "<stdin>"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_xrealloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 195 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 195 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 194);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;

	yy_current_buffer->yy_at_bol = (c == '\n');

	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}



#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_xrealloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) xmalloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_xrealloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_xrealloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) xrealloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 595 "<stdin>"

