"======================================================================
|
|   DatagramSocketImpl
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


AbstractSocketImpl subclass: #DatagramSocketImpl
	   instanceVariableNames: 'remoteAddress remotePort'
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!DatagramSocketImpl class methodsFor: 'constants'!

msgPeek
    ^2
! !

!DatagramSocketImpl methodsFor: 'accessing'!

peek
    ^self receive: self class msgPeek datagram: Datagram new
!

peek: aDatagram
    ^self receive: self class msgPeek datagram: aDatagram
!

next
    ^self receive: 0 datagram: Datagram new.
!

receive: aDatagram
    ^self receive: 0 datagram: aDatagram
!

nextPut: aDatagram
    self subclassResponsibilty
!

receive: flags datagram: datagram
    self subclassResponsibilty
! !

!DatagramSocketImpl methodsFor: 'multicasting'!

ipMulticastIf
    ^(self
	optionAt: self class ipMulticastIf
	level: self class ipprotoIp
	size: CInt sizeof) intAt: 1
!

ipMulticastIf: interface
    self
	optionAt: self class ipMulticastIf
	level: self class ipprotoIp
	put: interface
!

join: ipAddress
    self primJoinLeave: ipAddress option: self class ipAddMembership
!

leave: ipAddress
    self primJoinLeave: ipAddress option: self class ipDropMembership
!

primJoinLeave: ipAddress option: opt
    | data |
    data := ByteArray new: IPAddress addressSize * 2.
    data
	replaceFrom: 1
	to: IPAddress addressSize
	with: ipAddress asByteArray
	startingAt: 1;

	replaceFrom: IPAddress addressSize + 1
	to: data size
	with: IPAddress anyLocalAddress asByteArray
	startingAt: 1.

    self
	optionAt: opt
	level: self ipprotoIp
	put: data
!

timeToLive
    ^(self
	optionAt: self class ipMulticastTtl
	level: self ipprotoIp
	size: CInt sizeof) intAt: 1
!

timeToLive: ttl
    self
	optionAt: self class ipMulticastTtl
	level: self ipprotoIp
	put: ttl
! !
