#!/bin/csh -f
#
# rank-script.sh Version 0.5
#
# Program to calculate the rank correlation coefficient between the rankings
# generated by two different statistical measures on the same
# bigram-frequency (as output by count.pl).
#
# Copyright (C) 2000-2001,
# Satanjeev Banerjee, University of Minnesota, Duluth
# bane0025@d.umn.edu
# Ted Pedersen, University of Minnesota, Duluth
# tpederse@d.umn.edu
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#-----------------------------------------------------------------------------
#                                 Start of Program!
#-----------------------------------------------------------------------------

if($#argv != 3) then
        echo "Usage: rank-script.sh measure1 measure2 input-file"
        exit 1
endif

# First get the two module names and an inputfile.

set lib1=$1;
set lib2=$2;
set file=$3;

# run count.pl to create output suitable for statistic

count.pl $file.out $file

# run statistic.pl using the two libraries to create two files

statistic.pl $lib1 $lib1.out1 $file.out
statistic.pl $lib2 $lib2.out2 $file.out

# run rank.pl
rank.pl $lib1.out1 $lib2.out2

# remove the temporary files
rm -f $lib1.out1 $lib2.out2 $file.out

