/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class OperaDriverService
extends DriverService {
    public static final String OPERA_DRIVER_EXE_PROPERTY = "webdriver.opera.driver";
    public static final String OPERA_DRIVER_LOG_PROPERTY = "webdriver.opera.logfile";
    public static final String OPERA_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.opera.verboseLogging";
    public static final String OPERA_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.opera.silentOutput";

    public OperaDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static OperaDriverService createDefaultService() {
        return (OperaDriverService)new Builder().build();
    }

    public static class Builder
    extends DriverService.Builder<OperaDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.opera.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.opera.silentOutput");

        @Override
        public int score(Capabilities capabilites) {
            int score = 0;
            if ("operablink".equals(capabilites.getBrowserName())) {
                ++score;
            }
            if ("opera".equals(capabilites.getBrowserName())) {
                ++score;
            }
            if (capabilites.getCapability("operaOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        @Override
        protected File findDefaultExecutable() {
            return OperaDriverService.findExecutable("operadriver", OperaDriverService.OPERA_DRIVER_EXE_PROPERTY, "https://github.com/operasoftware/operachromiumdriver", "https://github.com/operasoftware/operachromiumdriver/releases");
        }

        @Override
        protected ImmutableList<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(OperaDriverService.OPERA_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.verbose) {
                argsBuilder.add("--verbose");
            }
            if (this.silent) {
                argsBuilder.add("--silent");
            }
            return argsBuilder.build();
        }

        @Override
        protected OperaDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new OperaDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

