/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

public final class MagicArray {
    private final int[] data;
    private final int size;
    private long lastUpdatedKey = -1L;
    private int lastUpdatedValue;
    private long sum;
    private long maxSum;

    public MagicArray(int n) {
        this.data = new int[n];
        this.size = n;
    }

    public synchronized void incKey(long l) {
        this.incKey(l, 1);
    }

    public synchronized void incKey(long l, int n) {
        if (l < this.lastUpdatedKey) {
            return;
        }
        if (l != this.lastUpdatedKey) {
            if (this.lastUpdatedKey != -1L) {
                this.setValue(this.lastUpdatedKey, this.lastUpdatedValue);
                for (long i = this.lastUpdatedKey + 1L; i < l; ++i) {
                    this.setValue(i, 0);
                }
            }
            this.lastUpdatedValue = 0;
            this.lastUpdatedKey = l;
        }
        this.lastUpdatedValue += n;
    }

    private void setValue(long l, int n) {
        int n2 = (int)(l % (long)this.size);
        this.sum += (long)(n - this.data[n2]);
        if (this.sum > this.maxSum) {
            this.maxSum = this.sum;
        }
        this.data[n2] = n;
    }

    public synchronized long getSum() {
        return this.sum;
    }

    public synchronized long getMaxSum() {
        return this.maxSum;
    }

    private long getSumSlow() {
        long l = 0L;
        for (int n : this.data) {
            l += (long)n;
        }
        return l;
    }
}

