/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropAliasConstantAction
extends DDLConstantAction {
    private SchemaDescriptor sd;
    private final String schemaName;
    private final String aliasName;
    private final char nameSpace;

    DropAliasConstantAction(SchemaDescriptor schemaDescriptor, String string, char c) {
        this.sd = schemaDescriptor;
        this.schemaName = schemaDescriptor.getSchemaName();
        this.aliasName = string;
        this.nameSpace = c;
    }

    public String toString() {
        return "DROP ALIAS " + this.aliasName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        AliasDescriptor aliasDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        dataDictionary.startWriting(languageConnectionContext);
        if (this.sd == null) {
            this.sd = dataDictionary.getSchemaDescriptor(this.schemaName, languageConnectionContext.getTransactionExecute(), true);
        }
        if ((aliasDescriptor = dataDictionary.getAliasDescriptor(this.sd.getUUID().toString(), this.aliasName, this.nameSpace)) == null) {
            throw StandardException.newException("42X94", AliasDescriptor.getAliasType(this.nameSpace), (Object)this.aliasName);
        }
        int n = 0;
        switch (aliasDescriptor.getAliasType()) {
            case 'F': 
            case 'P': {
                n = 6;
                break;
            }
            case 'S': {
                n = 43;
            }
        }
        dependencyManager.invalidateFor(aliasDescriptor, n, languageConnectionContext);
        if (aliasDescriptor.getAliasType() == 'S') {
            DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
            TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.aliasName, this.sd, 4, 'R');
            dataDictionary.dropTableDescriptor(tableDescriptor, this.sd, transactionController);
        }
        dataDictionary.dropAliasDescriptor(aliasDescriptor, transactionController);
    }
}

