# Generated by default/object.tt
package Paws::Synthetics::CanaryRunConfigOutput;
  use Moose;
  has ActiveTracing => (is => 'ro', isa => 'Bool');
  has MemoryInMB => (is => 'ro', isa => 'Int');
  has TimeoutInSeconds => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryRunConfigOutput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryRunConfigOutput object:

  $service_obj->Method(Att1 => { ActiveTracing => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryRunConfigOutput object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveTracing

=head1 DESCRIPTION

A structure that contains information about a canary run.

=head1 ATTRIBUTES


=head2 ActiveTracing => Bool

Displays whether this canary run used active AWS X-Ray tracing.


=head2 MemoryInMB => Int

The maximum amount of memory available to the canary while it is
running, in MB. This value must be a multiple of 64.


=head2 TimeoutInSeconds => Int

How long the canary is allowed to run before it must stop.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

