package Dependency::Resolver::Node;
$Dependency::Resolver::Node::VERSION = '0.04';
use utf8;
use Moose;


has name => (
               isa      => "Str",
               is       => "rw",
);


has deps => (
               is       => "rw",
               isa      => "ArrayRef",
               default  => sub { [] },
           );

sub addDep {
    my ($self, $node) = @_;

    push( @{$self->deps}, $node );
}

=head1 NAME

Dependency::Resolver::Node - Dependency resolver node


=head1 VERSION

version 0.04

This module is at EXPERIMENTAL stage, so use with caution.


=head1 SYNOPSIS

my $a = Dependency::Resolver::Node->new( name => 'a' );
my $b = Dependency::Resolver::Node->new( name => 'b' );
my $c = Dependency::Resolver::Node->new( name => 'c' );
my $d = Dependency::Resolver::Node->new( name => 'd' );
my $e = Dependency::Resolver::Node->new( name => 'e' );

$a->addDep($b);    # a depends on b
$a->addDep($d);    # a depends on d
$b->addDep($c);    # b depends on c
$b->addDep($e);    # b depends on e
$c->addDep($d);    # c depends on d
$c->addDep($e);    # c depends on e


=head1 SUBROUTINES/METHODS

=head2 new( name => '...')

=head2 addDep($dep)

# node A depnds on nodeB
$nodeA->addDep($nodeB);

=head1 AUTHOR

Daniel Brosseau, C<< <dab at catapulse.org> >>

=cut

1;
