# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Date-Components.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 1843;
#use Test::More qw(no_plan);
BEGIN { use_ok('Date::Components') };
BEGIN { use_ok('Test::Manifest') };
use Date::Components qw(number_of_day_within_year);

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

ok(1, '1 is true');
is(2+2, 4, ' The sum is four');
isnt(2*3, 5, 'The product is five');
isnt(2 ** 3, 6, "The results is not six");



# Check for faulty input
eval {number_of_day_within_year()};
ok(($@),      'Parameters are missing.');

eval {number_of_day_within_year('')};
ok(($@),      'Null Parameter is NOT allowed.');

eval {number_of_day_within_year(['3'])};
ok(($@),      'Array reference is not allowed.');

eval {number_of_day_within_year({})};
ok(($@),      'Hash reference is not allowed.');

eval {number_of_day_within_year('2 ')};
ok(($@),      'Leading and trailing spaces are NOT allowed.');

eval {number_of_day_within_year('2/30/1992')};
ok(($@),      'Day of month is too large.');

eval {number_of_day_within_year('0/15/1992')};
ok(($@),      'Month is invalid.');

eval {number_of_day_within_year('13/15/1778')};
ok(($@),      'Month is invalid.');

eval {number_of_day_within_year('7/0/1992')};
ok(($@),      'Day of month is invalid.');

eval {number_of_day_within_year(12, 5, 2071)};
ok(($@),      'Invalid format for date.  It must be supplied as a single date string.');




is(number_of_day_within_year('1/1/2007'),             1,     'number of day within year 1/1/2007   =  1');
is(number_of_day_within_year('1/2/2007'),             2,     'number of day within year 1/2/2007   =  2');
is(number_of_day_within_year('1/3/2007'),             3,     'number of day within year 1/3/2007   =  3');
is(number_of_day_within_year('1/4/2007'),             4,     'number of day within year 1/4/2007   =  4');
is(number_of_day_within_year('1/5/2007'),             5,     'number of day within year 1/5/2007   =  5');
is(number_of_day_within_year('1/6/2007'),             6,     'number of day within year 1/6/2007   =  6');
is(number_of_day_within_year('1/7/2007'),             7,     'number of day within year 1/7/2007   =  7');
is(number_of_day_within_year('1/8/2007'),             8,     'number of day within year 1/8/2007   =  8');
is(number_of_day_within_year('1/9/2007'),             9,     'number of day within year 1/9/2007   =  9');
is(number_of_day_within_year('1/10/2007'),           10,     'number of day within year 1/10/2007  = 10');
is(number_of_day_within_year('1/11/2007'),           11,     'number of day within year 1/11/2007  = 11');
is(number_of_day_within_year('1/12/2007'),           12,     'number of day within year 1/12/2007  = 12');
is(number_of_day_within_year('1/13/2007'),           13,     'number of day within year 1/13/2007  = 13');
is(number_of_day_within_year('1/14/2007'),           14,     'number of day within year 1/14/2007  = 14');
is(number_of_day_within_year('1/15/2007'),           15,     'number of day within year 1/15/2007  = 15');
is(number_of_day_within_year('1/16/2007'),           16,     'number of day within year 1/16/2007  = 16');
is(number_of_day_within_year('1/17/2007'),           17,     'number of day within year 1/17/2007  = 17');
is(number_of_day_within_year('1/18/2007'),           18,     'number of day within year 1/18/2007  = 18');
is(number_of_day_within_year('1/19/2007'),           19,     'number of day within year 1/19/2007  = 19');
is(number_of_day_within_year('1/20/2007'),           20,     'number of day within year 1/20/2007  = 20');
is(number_of_day_within_year('1/21/2007'),           21,     'number of day within year 1/21/2007  = 21');
is(number_of_day_within_year('1/22/2007'),           22,     'number of day within year 1/22/2007  = 22');
is(number_of_day_within_year('1/23/2007'),           23,     'number of day within year 1/23/2007  = 23');
is(number_of_day_within_year('1/24/2007'),           24,     'number of day within year 1/24/2007  = 24');
is(number_of_day_within_year('1/25/2007'),           25,     'number of day within year 1/25/2007  = 25');
is(number_of_day_within_year('1/26/2007'),           26,     'number of day within year 1/26/2007  = 26');
is(number_of_day_within_year('1/27/2007'),           27,     'number of day within year 1/27/2007  = 27');
is(number_of_day_within_year('1/28/2007'),           28,     'number of day within year 1/28/2007  = 28');
is(number_of_day_within_year('1/29/2007'),           29,     'number of day within year 1/29/2007  = 29');
is(number_of_day_within_year('1/30/2007'),           30,     'number of day within year 1/30/2007  = 30');
is(number_of_day_within_year('1/31/2007'),           31,     'number of day within year 1/31/2007  = 31');
is(number_of_day_within_year('2/1/2007'),            32,     'number of day within year 2/1/2007   =  1');
is(number_of_day_within_year('2/2/2007'),            33,     'number of day within year 2/2/2007   =  2');
is(number_of_day_within_year('2/3/2007'),            34,     'number of day within year 2/3/2007   =  3');
is(number_of_day_within_year('2/4/2007'),            35,     'number of day within year 2/4/2007   =  4');
is(number_of_day_within_year('2/5/2007'),            36,     'number of day within year 2/5/2007   =  5');
is(number_of_day_within_year('2/6/2007'),            37,     'number of day within year 2/6/2007   =  6');
is(number_of_day_within_year('2/7/2007'),            38,     'number of day within year 2/7/2007   =  7');
is(number_of_day_within_year('2/8/2007'),            39,     'number of day within year 2/8/2007   =  8');
is(number_of_day_within_year('2/9/2007'),            40,     'number of day within year 2/9/2007   =  9');
is(number_of_day_within_year('2/10/2007'),           41,     'number of day within year 2/10/2007  = 10');
is(number_of_day_within_year('2/11/2007'),           42,     'number of day within year 2/11/2007  = 11');
is(number_of_day_within_year('2/12/2007'),           43,     'number of day within year 2/12/2007  = 12');
is(number_of_day_within_year('2/13/2007'),           44,     'number of day within year 2/13/2007  = 13');
is(number_of_day_within_year('2/14/2007'),           45,     'number of day within year 2/14/2007  = 14');
is(number_of_day_within_year('2/15/2007'),           46,     'number of day within year 2/15/2007  = 15');
is(number_of_day_within_year('2/16/2007'),           47,     'number of day within year 2/16/2007  = 16');
is(number_of_day_within_year('2/17/2007'),           48,     'number of day within year 2/17/2007  = 17');
is(number_of_day_within_year('2/18/2007'),           49,     'number of day within year 2/18/2007  = 18');
is(number_of_day_within_year('2/19/2007'),           50,     'number of day within year 2/19/2007  = 19');
is(number_of_day_within_year('2/20/2007'),           51,     'number of day within year 2/20/2007  = 20');
is(number_of_day_within_year('2/21/2007'),           52,     'number of day within year 2/21/2007  = 21');
is(number_of_day_within_year('2/22/2007'),           53,     'number of day within year 2/22/2007  = 22');
is(number_of_day_within_year('2/23/2007'),           54,     'number of day within year 2/23/2007  = 23');
is(number_of_day_within_year('2/24/2007'),           55,     'number of day within year 2/24/2007  = 24');
is(number_of_day_within_year('2/25/2007'),           56,     'number of day within year 2/25/2007  = 25');
is(number_of_day_within_year('2/26/2007'),           57,     'number of day within year 2/26/2007  = 26');
is(number_of_day_within_year('2/27/2007'),           58,     'number of day within year 2/27/2007  = 27');
is(number_of_day_within_year('2/28/2007'),           59,     'number of day within year 2/28/2007  = 28');
is(number_of_day_within_year('3/1/2007'),            60,     'number of day within year 3/1/2007   =  1');
is(number_of_day_within_year('3/2/2007'),            61,     'number of day within year 3/2/2007   =  2');
is(number_of_day_within_year('3/3/2007'),            62,     'number of day within year 3/3/2007   =  3');
is(number_of_day_within_year('3/4/2007'),            63,     'number of day within year 3/4/2007   =  4');
is(number_of_day_within_year('3/5/2007'),            64,     'number of day within year 3/5/2007   =  5');
is(number_of_day_within_year('3/6/2007'),            65,     'number of day within year 3/6/2007   =  6');
is(number_of_day_within_year('3/7/2007'),            66,     'number of day within year 3/7/2007   =  7');
is(number_of_day_within_year('3/8/2007'),            67,     'number of day within year 3/8/2007   =  8');
is(number_of_day_within_year('3/9/2007'),            68,     'number of day within year 3/9/2007   =  9');
is(number_of_day_within_year('3/10/2007'),           69,     'number of day within year 3/10/2007  = 10');
is(number_of_day_within_year('3/11/2007'),           70,     'number of day within year 3/11/2007  = 11');
is(number_of_day_within_year('3/12/2007'),           71,     'number of day within year 3/12/2007  = 12');
is(number_of_day_within_year('3/13/2007'),           72,     'number of day within year 3/13/2007  = 13');
is(number_of_day_within_year('3/14/2007'),           73,     'number of day within year 3/14/2007  = 14');
is(number_of_day_within_year('3/15/2007'),           74,     'number of day within year 3/15/2007  = 15');
is(number_of_day_within_year('3/16/2007'),           75,     'number of day within year 3/16/2007  = 16');
is(number_of_day_within_year('3/17/2007'),           76,     'number of day within year 3/17/2007  = 17');
is(number_of_day_within_year('3/18/2007'),           77,     'number of day within year 3/18/2007  = 18');
is(number_of_day_within_year('3/19/2007'),           78,     'number of day within year 3/19/2007  = 19');
is(number_of_day_within_year('3/20/2007'),           79,     'number of day within year 3/20/2007  = 20');
is(number_of_day_within_year('3/21/2007'),           80,     'number of day within year 3/21/2007  = 21');
is(number_of_day_within_year('3/22/2007'),           81,     'number of day within year 3/22/2007  = 22');
is(number_of_day_within_year('3/23/2007'),           82,     'number of day within year 3/23/2007  = 23');
is(number_of_day_within_year('3/24/2007'),           83,     'number of day within year 3/24/2007  = 24');
is(number_of_day_within_year('3/25/2007'),           84,     'number of day within year 3/25/2007  = 25');
is(number_of_day_within_year('3/26/2007'),           85,     'number of day within year 3/26/2007  = 26');
is(number_of_day_within_year('3/27/2007'),           86,     'number of day within year 3/27/2007  = 27');
is(number_of_day_within_year('3/28/2007'),           87,     'number of day within year 3/28/2007  = 28');
is(number_of_day_within_year('3/29/2007'),           88,     'number of day within year 3/29/2007  = 29');
is(number_of_day_within_year('3/30/2007'),           89,     'number of day within year 3/30/2007  = 30');
is(number_of_day_within_year('3/31/2007'),           90,     'number of day within year 3/31/2007  = 31');
is(number_of_day_within_year('4/1/2007'),            91,     'number of day within year 4/1/2007   =  1');
is(number_of_day_within_year('4/2/2007'),            92,     'number of day within year 4/2/2007   =  2');
is(number_of_day_within_year('4/3/2007'),            93,     'number of day within year 4/3/2007   =  3');
is(number_of_day_within_year('4/4/2007'),            94,     'number of day within year 4/4/2007   =  4');
is(number_of_day_within_year('4/5/2007'),            95,     'number of day within year 4/5/2007   =  5');
is(number_of_day_within_year('4/6/2007'),            96,     'number of day within year 4/6/2007   =  6');
is(number_of_day_within_year('4/7/2007'),            97,     'number of day within year 4/7/2007   =  7');
is(number_of_day_within_year('4/8/2007'),            98,     'number of day within year 4/8/2007   =  8');
is(number_of_day_within_year('4/9/2007'),            99,     'number of day within year 4/9/2007   =  9');
is(number_of_day_within_year('4/10/2007'),          100,     'number of day within year 4/10/2007  = 10');
is(number_of_day_within_year('4/11/2007'),          101,     'number of day within year 4/11/2007  = 11');
is(number_of_day_within_year('4/12/2007'),          102,     'number of day within year 4/12/2007  = 12');
is(number_of_day_within_year('4/13/2007'),          103,     'number of day within year 4/13/2007  = 13');
is(number_of_day_within_year('4/14/2007'),          104,     'number of day within year 4/14/2007  = 14');
is(number_of_day_within_year('4/15/2007'),          105,     'number of day within year 4/15/2007  = 15');
is(number_of_day_within_year('4/16/2007'),          106,     'number of day within year 4/16/2007  = 16');
is(number_of_day_within_year('4/17/2007'),          107,     'number of day within year 4/17/2007  = 17');
is(number_of_day_within_year('4/18/2007'),          108,     'number of day within year 4/18/2007  = 18');
is(number_of_day_within_year('4/19/2007'),          109,     'number of day within year 4/19/2007  = 19');
is(number_of_day_within_year('4/20/2007'),          110,     'number of day within year 4/20/2007  = 20');
is(number_of_day_within_year('4/21/2007'),          111,     'number of day within year 4/21/2007  = 21');
is(number_of_day_within_year('4/22/2007'),          112,     'number of day within year 4/22/2007  = 22');
is(number_of_day_within_year('4/23/2007'),          113,     'number of day within year 4/23/2007  = 23');
is(number_of_day_within_year('4/24/2007'),          114,     'number of day within year 4/24/2007  = 24');
is(number_of_day_within_year('4/25/2007'),          115,     'number of day within year 4/25/2007  = 25');
is(number_of_day_within_year('4/26/2007'),          116,     'number of day within year 4/26/2007  = 26');
is(number_of_day_within_year('4/27/2007'),          117,     'number of day within year 4/27/2007  = 27');
is(number_of_day_within_year('4/28/2007'),          118,     'number of day within year 4/28/2007  = 28');
is(number_of_day_within_year('4/29/2007'),          119,     'number of day within year 4/29/2007  = 29');
is(number_of_day_within_year('4/30/2007'),          120,     'number of day within year 4/30/2007  = 30');
is(number_of_day_within_year('5/1/2007'),           121,     'number of day within year 5/1/2007   =  1');
is(number_of_day_within_year('5/2/2007'),           122,     'number of day within year 5/2/2007   =  2');
is(number_of_day_within_year('5/3/2007'),           123,     'number of day within year 5/3/2007   =  3');
is(number_of_day_within_year('5/4/2007'),           124,     'number of day within year 5/4/2007   =  4');
is(number_of_day_within_year('5/5/2007'),           125,     'number of day within year 5/5/2007   =  5');
is(number_of_day_within_year('5/6/2007'),           126,     'number of day within year 5/6/2007   =  6');
is(number_of_day_within_year('5/7/2007'),           127,     'number of day within year 5/7/2007   =  7');
is(number_of_day_within_year('5/8/2007'),           128,     'number of day within year 5/8/2007   =  8');
is(number_of_day_within_year('5/9/2007'),           129,     'number of day within year 5/9/2007   =  9');
is(number_of_day_within_year('5/10/2007'),          130,     'number of day within year 5/10/2007  = 10');
is(number_of_day_within_year('5/11/2007'),          131,     'number of day within year 5/11/2007  = 11');
is(number_of_day_within_year('5/12/2007'),          132,     'number of day within year 5/12/2007  = 12');
is(number_of_day_within_year('5/13/2007'),          133,     'number of day within year 5/13/2007  = 13');
is(number_of_day_within_year('5/14/2007'),          134,     'number of day within year 5/14/2007  = 14');
is(number_of_day_within_year('5/15/2007'),          135,     'number of day within year 5/15/2007  = 15');
is(number_of_day_within_year('5/16/2007'),          136,     'number of day within year 5/16/2007  = 16');
is(number_of_day_within_year('5/17/2007'),          137,     'number of day within year 5/17/2007  = 17');
is(number_of_day_within_year('5/18/2007'),          138,     'number of day within year 5/18/2007  = 18');
is(number_of_day_within_year('5/19/2007'),          139,     'number of day within year 5/19/2007  = 19');
is(number_of_day_within_year('5/20/2007'),          140,     'number of day within year 5/20/2007  = 20');
is(number_of_day_within_year('5/21/2007'),          141,     'number of day within year 5/21/2007  = 21');
is(number_of_day_within_year('5/22/2007'),          142,     'number of day within year 5/22/2007  = 22');
is(number_of_day_within_year('5/23/2007'),          143,     'number of day within year 5/23/2007  = 23');
is(number_of_day_within_year('5/24/2007'),          144,     'number of day within year 5/24/2007  = 24');
is(number_of_day_within_year('5/25/2007'),          145,     'number of day within year 5/25/2007  = 25');
is(number_of_day_within_year('5/26/2007'),          146,     'number of day within year 5/26/2007  = 26');
is(number_of_day_within_year('5/27/2007'),          147,     'number of day within year 5/27/2007  = 27');
is(number_of_day_within_year('5/28/2007'),          148,     'number of day within year 5/28/2007  = 28');
is(number_of_day_within_year('5/29/2007'),          149,     'number of day within year 5/29/2007  = 29');
is(number_of_day_within_year('5/30/2007'),          150,     'number of day within year 5/30/2007  = 30');
is(number_of_day_within_year('5/31/2007'),          151,     'number of day within year 5/31/2007  = 31');
is(number_of_day_within_year('6/1/2007'),           152,     'number of day within year 6/1/2007   =  1');
is(number_of_day_within_year('6/2/2007'),           153,     'number of day within year 6/2/2007   =  2');
is(number_of_day_within_year('6/3/2007'),           154,     'number of day within year 6/3/2007   =  3');
is(number_of_day_within_year('6/4/2007'),           155,     'number of day within year 6/4/2007   =  4');
is(number_of_day_within_year('6/5/2007'),           156,     'number of day within year 6/5/2007   =  5');
is(number_of_day_within_year('6/6/2007'),           157,     'number of day within year 6/6/2007   =  6');
is(number_of_day_within_year('6/7/2007'),           158,     'number of day within year 6/7/2007   =  7');
is(number_of_day_within_year('6/8/2007'),           159,     'number of day within year 6/8/2007   =  8');
is(number_of_day_within_year('6/9/2007'),           160,     'number of day within year 6/9/2007   =  9');
is(number_of_day_within_year('6/10/2007'),          161,     'number of day within year 6/10/2007  = 10');
is(number_of_day_within_year('6/11/2007'),          162,     'number of day within year 6/11/2007  = 11');
is(number_of_day_within_year('6/12/2007'),          163,     'number of day within year 6/12/2007  = 12');
is(number_of_day_within_year('6/13/2007'),          164,     'number of day within year 6/13/2007  = 13');
is(number_of_day_within_year('6/14/2007'),          165,     'number of day within year 6/14/2007  = 14');
is(number_of_day_within_year('6/15/2007'),          166,     'number of day within year 6/15/2007  = 15');
is(number_of_day_within_year('6/16/2007'),          167,     'number of day within year 6/16/2007  = 16');
is(number_of_day_within_year('6/17/2007'),          168,     'number of day within year 6/17/2007  = 17');
is(number_of_day_within_year('6/18/2007'),          169,     'number of day within year 6/18/2007  = 18');
is(number_of_day_within_year('6/19/2007'),          170,     'number of day within year 6/19/2007  = 19');
is(number_of_day_within_year('6/20/2007'),          171,     'number of day within year 6/20/2007  = 20');
is(number_of_day_within_year('6/21/2007'),          172,     'number of day within year 6/21/2007  = 21');
is(number_of_day_within_year('6/22/2007'),          173,     'number of day within year 6/22/2007  = 22');
is(number_of_day_within_year('6/23/2007'),          174,     'number of day within year 6/23/2007  = 23');
is(number_of_day_within_year('6/24/2007'),          175,     'number of day within year 6/24/2007  = 24');
is(number_of_day_within_year('6/25/2007'),          176,     'number of day within year 6/25/2007  = 25');
is(number_of_day_within_year('6/26/2007'),          177,     'number of day within year 6/26/2007  = 26');
is(number_of_day_within_year('6/27/2007'),          178,     'number of day within year 6/27/2007  = 27');
is(number_of_day_within_year('6/28/2007'),          179,     'number of day within year 6/28/2007  = 28');
is(number_of_day_within_year('6/29/2007'),          180,     'number of day within year 6/29/2007  = 29');
is(number_of_day_within_year('6/30/2007'),          181,     'number of day within year 6/30/2007  = 30');
is(number_of_day_within_year('7/1/2007'),           182,     'number of day within year 7/1/2007   =  1');
is(number_of_day_within_year('7/2/2007'),           183,     'number of day within year 7/2/2007   =  2');
is(number_of_day_within_year('7/3/2007'),           184,     'number of day within year 7/3/2007   =  3');
is(number_of_day_within_year('7/4/2007'),           185,     'number of day within year 7/4/2007   =  4');
is(number_of_day_within_year('7/5/2007'),           186,     'number of day within year 7/5/2007   =  5');
is(number_of_day_within_year('7/6/2007'),           187,     'number of day within year 7/6/2007   =  6');
is(number_of_day_within_year('7/7/2007'),           188,     'number of day within year 7/7/2007   =  7');
is(number_of_day_within_year('7/8/2007'),           189,     'number of day within year 7/8/2007   =  8');
is(number_of_day_within_year('7/9/2007'),           190,     'number of day within year 7/9/2007   =  9');
is(number_of_day_within_year('7/10/2007'),          191,     'number of day within year 7/10/2007  = 10');
is(number_of_day_within_year('7/11/2007'),          192,     'number of day within year 7/11/2007  = 11');
is(number_of_day_within_year('7/12/2007'),          193,     'number of day within year 7/12/2007  = 12');
is(number_of_day_within_year('7/13/2007'),          194,     'number of day within year 7/13/2007  = 13');
is(number_of_day_within_year('7/14/2007'),          195,     'number of day within year 7/14/2007  = 14');
is(number_of_day_within_year('7/15/2007'),          196,     'number of day within year 7/15/2007  = 15');
is(number_of_day_within_year('7/16/2007'),          197,     'number of day within year 7/16/2007  = 16');
is(number_of_day_within_year('7/17/2007'),          198,     'number of day within year 7/17/2007  = 17');
is(number_of_day_within_year('7/18/2007'),          199,     'number of day within year 7/18/2007  = 18');
is(number_of_day_within_year('7/19/2007'),          200,     'number of day within year 7/19/2007  = 19');
is(number_of_day_within_year('7/20/2007'),          201,     'number of day within year 7/20/2007  = 20');
is(number_of_day_within_year('7/21/2007'),          202,     'number of day within year 7/21/2007  = 21');
is(number_of_day_within_year('7/22/2007'),          203,     'number of day within year 7/22/2007  = 22');
is(number_of_day_within_year('7/23/2007'),          204,     'number of day within year 7/23/2007  = 23');
is(number_of_day_within_year('7/24/2007'),          205,     'number of day within year 7/24/2007  = 24');
is(number_of_day_within_year('7/25/2007'),          206,     'number of day within year 7/25/2007  = 25');
is(number_of_day_within_year('7/26/2007'),          207,     'number of day within year 7/26/2007  = 26');
is(number_of_day_within_year('7/27/2007'),          208,     'number of day within year 7/27/2007  = 27');
is(number_of_day_within_year('7/28/2007'),          209,     'number of day within year 7/28/2007  = 28');
is(number_of_day_within_year('7/29/2007'),          210,     'number of day within year 7/29/2007  = 29');
is(number_of_day_within_year('7/30/2007'),          211,     'number of day within year 7/30/2007  = 30');
is(number_of_day_within_year('7/31/2007'),          212,     'number of day within year 7/31/2007  = 31');
is(number_of_day_within_year('8/1/2007'),           213,     'number of day within year 8/1/2007   =  1');
is(number_of_day_within_year('8/2/2007'),           214,     'number of day within year 8/2/2007   =  2');
is(number_of_day_within_year('8/3/2007'),           215,     'number of day within year 8/3/2007   =  3');
is(number_of_day_within_year('8/4/2007'),           216,     'number of day within year 8/4/2007   =  4');
is(number_of_day_within_year('8/5/2007'),           217,     'number of day within year 8/5/2007   =  5');
is(number_of_day_within_year('8/6/2007'),           218,     'number of day within year 8/6/2007   =  6');
is(number_of_day_within_year('8/7/2007'),           219,     'number of day within year 8/7/2007   =  7');
is(number_of_day_within_year('8/8/2007'),           220,     'number of day within year 8/8/2007   =  8');
is(number_of_day_within_year('8/9/2007'),           221,     'number of day within year 8/9/2007   =  9');
is(number_of_day_within_year('8/10/2007'),          222,     'number of day within year 8/10/2007  = 10');
is(number_of_day_within_year('8/11/2007'),          223,     'number of day within year 8/11/2007  = 11');
is(number_of_day_within_year('8/12/2007'),          224,     'number of day within year 8/12/2007  = 12');
is(number_of_day_within_year('8/13/2007'),          225,     'number of day within year 8/13/2007  = 13');
is(number_of_day_within_year('8/14/2007'),          226,     'number of day within year 8/14/2007  = 14');
is(number_of_day_within_year('8/15/2007'),          227,     'number of day within year 8/15/2007  = 15');
is(number_of_day_within_year('8/16/2007'),          228,     'number of day within year 8/16/2007  = 16');
is(number_of_day_within_year('8/17/2007'),          229,     'number of day within year 8/17/2007  = 17');
is(number_of_day_within_year('8/18/2007'),          230,     'number of day within year 8/18/2007  = 18');
is(number_of_day_within_year('8/19/2007'),          231,     'number of day within year 8/19/2007  = 19');
is(number_of_day_within_year('8/20/2007'),          232,     'number of day within year 8/20/2007  = 20');
is(number_of_day_within_year('8/21/2007'),          233,     'number of day within year 8/21/2007  = 21');
is(number_of_day_within_year('8/22/2007'),          234,     'number of day within year 8/22/2007  = 22');
is(number_of_day_within_year('8/23/2007'),          235,     'number of day within year 8/23/2007  = 23');
is(number_of_day_within_year('8/24/2007'),          236,     'number of day within year 8/24/2007  = 24');
is(number_of_day_within_year('8/25/2007'),          237,     'number of day within year 8/25/2007  = 25');
is(number_of_day_within_year('8/26/2007'),          238,     'number of day within year 8/26/2007  = 26');
is(number_of_day_within_year('8/27/2007'),          239,     'number of day within year 8/27/2007  = 27');
is(number_of_day_within_year('8/28/2007'),          240,     'number of day within year 8/28/2007  = 28');
is(number_of_day_within_year('8/29/2007'),          241,     'number of day within year 8/29/2007  = 29');
is(number_of_day_within_year('8/30/2007'),          242,     'number of day within year 8/30/2007  = 30');
is(number_of_day_within_year('8/31/2007'),          243,     'number of day within year 8/31/2007  = 31');
is(number_of_day_within_year('9/1/2007'),           244,     'number of day within year 9/1/2007   =  1');
is(number_of_day_within_year('9/2/2007'),           245,     'number of day within year 9/2/2007   =  2');
is(number_of_day_within_year('9/3/2007'),           246,     'number of day within year 9/3/2007   =  3');
is(number_of_day_within_year('9/4/2007'),           247,     'number of day within year 9/4/2007   =  4');
is(number_of_day_within_year('9/5/2007'),           248,     'number of day within year 9/5/2007   =  5');
is(number_of_day_within_year('9/6/2007'),           249,     'number of day within year 9/6/2007   =  6');
is(number_of_day_within_year('9/7/2007'),           250,     'number of day within year 9/7/2007   =  7');
is(number_of_day_within_year('9/8/2007'),           251,     'number of day within year 9/8/2007   =  8');
is(number_of_day_within_year('9/9/2007'),           252,     'number of day within year 9/9/2007   =  9');
is(number_of_day_within_year('9/10/2007'),          253,     'number of day within year 9/10/2007  = 10');
is(number_of_day_within_year('9/11/2007'),          254,     'number of day within year 9/11/2007  = 11');
is(number_of_day_within_year('9/12/2007'),          255,     'number of day within year 9/12/2007  = 12');
is(number_of_day_within_year('9/13/2007'),          256,     'number of day within year 9/13/2007  = 13');
is(number_of_day_within_year('9/14/2007'),          257,     'number of day within year 9/14/2007  = 14');
is(number_of_day_within_year('9/15/2007'),          258,     'number of day within year 9/15/2007  = 15');
is(number_of_day_within_year('9/16/2007'),          259,     'number of day within year 9/16/2007  = 16');
is(number_of_day_within_year('9/17/2007'),          260,     'number of day within year 9/17/2007  = 17');
is(number_of_day_within_year('9/18/2007'),          261,     'number of day within year 9/18/2007  = 18');
is(number_of_day_within_year('9/19/2007'),          262,     'number of day within year 9/19/2007  = 19');
is(number_of_day_within_year('9/20/2007'),          263,     'number of day within year 9/20/2007  = 20');
is(number_of_day_within_year('9/21/2007'),          264,     'number of day within year 9/21/2007  = 21');
is(number_of_day_within_year('9/22/2007'),          265,     'number of day within year 9/22/2007  = 22');
is(number_of_day_within_year('9/23/2007'),          266,     'number of day within year 9/23/2007  = 23');
is(number_of_day_within_year('9/24/2007'),          267,     'number of day within year 9/24/2007  = 24');
is(number_of_day_within_year('9/25/2007'),          268,     'number of day within year 9/25/2007  = 25');
is(number_of_day_within_year('9/26/2007'),          269,     'number of day within year 9/26/2007  = 26');
is(number_of_day_within_year('9/27/2007'),          270,     'number of day within year 9/27/2007  = 27');
is(number_of_day_within_year('9/28/2007'),          271,     'number of day within year 9/28/2007  = 28');
is(number_of_day_within_year('9/29/2007'),          272,     'number of day within year 9/29/2007  = 29');
is(number_of_day_within_year('9/30/2007'),          273,     'number of day within year 9/30/2007  = 30');
is(number_of_day_within_year('10/1/2007'),          274,     'number of day within year 10/1/2007   =  1');
is(number_of_day_within_year('10/2/2007'),          275,     'number of day within year 10/2/2007   =  2');
is(number_of_day_within_year('10/3/2007'),          276,     'number of day within year 10/3/2007   =  3');
is(number_of_day_within_year('10/4/2007'),          277,     'number of day within year 10/4/2007   =  4');
is(number_of_day_within_year('10/5/2007'),          278,     'number of day within year 10/5/2007   =  5');
is(number_of_day_within_year('10/6/2007'),          279,     'number of day within year 10/6/2007   =  6');
is(number_of_day_within_year('10/7/2007'),          280,     'number of day within year 10/7/2007   =  7');
is(number_of_day_within_year('10/8/2007'),          281,     'number of day within year 10/8/2007   =  8');
is(number_of_day_within_year('10/9/2007'),          282,     'number of day within year 10/9/2007   =  9');
is(number_of_day_within_year('10/10/2007'),         283,     'number of day within year 10/10/2007  = 10');
is(number_of_day_within_year('10/11/2007'),         284,     'number of day within year 10/11/2007  = 11');
is(number_of_day_within_year('10/12/2007'),         285,     'number of day within year 10/12/2007  = 12');
is(number_of_day_within_year('10/13/2007'),         286,     'number of day within year 10/13/2007  = 13');
is(number_of_day_within_year('10/14/2007'),         287,     'number of day within year 10/14/2007  = 14');
is(number_of_day_within_year('10/15/2007'),         288,     'number of day within year 10/15/2007  = 15');
is(number_of_day_within_year('10/16/2007'),         289,     'number of day within year 10/16/2007  = 16');
is(number_of_day_within_year('10/17/2007'),         290,     'number of day within year 10/17/2007  = 17');
is(number_of_day_within_year('10/18/2007'),         291,     'number of day within year 10/18/2007  = 18');
is(number_of_day_within_year('10/19/2007'),         292,     'number of day within year 10/19/2007  = 19');
is(number_of_day_within_year('10/20/2007'),         293,     'number of day within year 10/20/2007  = 20');
is(number_of_day_within_year('10/21/2007'),         294,     'number of day within year 10/21/2007  = 21');
is(number_of_day_within_year('10/22/2007'),         295,     'number of day within year 10/22/2007  = 22');
is(number_of_day_within_year('10/23/2007'),         296,     'number of day within year 10/23/2007  = 23');
is(number_of_day_within_year('10/24/2007'),         297,     'number of day within year 10/24/2007  = 24');
is(number_of_day_within_year('10/25/2007'),         298,     'number of day within year 10/25/2007  = 25');
is(number_of_day_within_year('10/26/2007'),         299,     'number of day within year 10/26/2007  = 26');
is(number_of_day_within_year('10/27/2007'),         300,     'number of day within year 10/27/2007  = 27');
is(number_of_day_within_year('10/28/2007'),         301,     'number of day within year 10/28/2007  = 28');
is(number_of_day_within_year('10/29/2007'),         302,     'number of day within year 10/29/2007  = 29');
is(number_of_day_within_year('10/30/2007'),         303,     'number of day within year 10/30/2007  = 30');
is(number_of_day_within_year('10/31/2007'),         304,     'number of day within year 10/31/2007  = 31');
is(number_of_day_within_year('11/1/2007'),          305,     'number of day within year 11/1/2007   =  1');
is(number_of_day_within_year('11/2/2007'),          306,     'number of day within year 11/2/2007   =  2');
is(number_of_day_within_year('11/3/2007'),          307,     'number of day within year 11/3/2007   =  3');
is(number_of_day_within_year('11/4/2007'),          308,     'number of day within year 11/4/2007   =  4');
is(number_of_day_within_year('11/5/2007'),          309,     'number of day within year 11/5/2007   =  5');
is(number_of_day_within_year('11/6/2007'),          310,     'number of day within year 11/6/2007   =  6');
is(number_of_day_within_year('11/7/2007'),          311,     'number of day within year 11/7/2007   =  7');
is(number_of_day_within_year('11/8/2007'),          312,     'number of day within year 11/8/2007   =  8');
is(number_of_day_within_year('11/9/2007'),          313,     'number of day within year 11/9/2007   =  9');
is(number_of_day_within_year('11/10/2007'),         314,     'number of day within year 11/10/2007  = 10');
is(number_of_day_within_year('11/11/2007'),         315,     'number of day within year 11/11/2007  = 11');
is(number_of_day_within_year('11/12/2007'),         316,     'number of day within year 11/12/2007  = 12');
is(number_of_day_within_year('11/13/2007'),         317,     'number of day within year 11/13/2007  = 13');
is(number_of_day_within_year('11/14/2007'),         318,     'number of day within year 11/14/2007  = 14');
is(number_of_day_within_year('11/15/2007'),         319,     'number of day within year 11/15/2007  = 15');
is(number_of_day_within_year('11/16/2007'),         320,     'number of day within year 11/16/2007  = 16');
is(number_of_day_within_year('11/17/2007'),         321,     'number of day within year 11/17/2007  = 17');
is(number_of_day_within_year('11/18/2007'),         322,     'number of day within year 11/18/2007  = 18');
is(number_of_day_within_year('11/19/2007'),         323,     'number of day within year 11/19/2007  = 19');
is(number_of_day_within_year('11/20/2007'),         324,     'number of day within year 11/20/2007  = 20');
is(number_of_day_within_year('11/21/2007'),         325,     'number of day within year 11/21/2007  = 21');
is(number_of_day_within_year('11/22/2007'),         326,     'number of day within year 11/22/2007  = 22');
is(number_of_day_within_year('11/23/2007'),         327,     'number of day within year 11/23/2007  = 23');
is(number_of_day_within_year('11/24/2007'),         328,     'number of day within year 11/24/2007  = 24');
is(number_of_day_within_year('11/25/2007'),         329,     'number of day within year 11/25/2007  = 25');
is(number_of_day_within_year('11/26/2007'),         330,     'number of day within year 11/26/2007  = 26');
is(number_of_day_within_year('11/27/2007'),         331,     'number of day within year 11/27/2007  = 27');
is(number_of_day_within_year('11/28/2007'),         332,     'number of day within year 11/28/2007  = 28');
is(number_of_day_within_year('11/29/2007'),         333,     'number of day within year 11/29/2007  = 29');
is(number_of_day_within_year('11/30/2007'),         334,     'number of day within year 11/30/2007  = 30');
is(number_of_day_within_year('12/1/2007'),          335,     'number of day within year 12/1/2007   =  1');
is(number_of_day_within_year('12/2/2007'),          336,     'number of day within year 12/2/2007   =  2');
is(number_of_day_within_year('12/3/2007'),          337,     'number of day within year 12/3/2007   =  3');
is(number_of_day_within_year('12/4/2007'),          338,     'number of day within year 12/4/2007   =  4');
is(number_of_day_within_year('12/5/2007'),          339,     'number of day within year 12/5/2007   =  5');
is(number_of_day_within_year('12/6/2007'),          340,     'number of day within year 12/6/2007   =  6');
is(number_of_day_within_year('12/7/2007'),          341,     'number of day within year 12/7/2007   =  7');
is(number_of_day_within_year('12/8/2007'),          342,     'number of day within year 12/8/2007   =  8');
is(number_of_day_within_year('12/9/2007'),          343,     'number of day within year 12/9/2007   =  9');
is(number_of_day_within_year('12/10/2007'),         344,     'number of day within year 12/10/2007  = 10');
is(number_of_day_within_year('12/11/2007'),         345,     'number of day within year 12/11/2007  = 11');
is(number_of_day_within_year('12/12/2007'),         346,     'number of day within year 12/12/2007  = 12');
is(number_of_day_within_year('12/13/2007'),         347,     'number of day within year 12/13/2007  = 13');
is(number_of_day_within_year('12/14/2007'),         348,     'number of day within year 12/14/2007  = 14');
is(number_of_day_within_year('12/15/2007'),         349,     'number of day within year 12/15/2007  = 15');
is(number_of_day_within_year('12/16/2007'),         350,     'number of day within year 12/16/2007  = 16');
is(number_of_day_within_year('12/17/2007'),         351,     'number of day within year 12/17/2007  = 17');
is(number_of_day_within_year('12/18/2007'),         352,     'number of day within year 12/18/2007  = 18');
is(number_of_day_within_year('12/19/2007'),         353,     'number of day within year 12/19/2007  = 19');
is(number_of_day_within_year('12/20/2007'),         354,     'number of day within year 12/20/2007  = 20');
is(number_of_day_within_year('12/21/2007'),         355,     'number of day within year 12/21/2007  = 21');
is(number_of_day_within_year('12/22/2007'),         356,     'number of day within year 12/22/2007  = 22');
is(number_of_day_within_year('12/23/2007'),         357,     'number of day within year 12/23/2007  = 23');
is(number_of_day_within_year('12/24/2007'),         358,     'number of day within year 12/24/2007  = 24');
is(number_of_day_within_year('12/25/2007'),         359,     'number of day within year 12/25/2007  = 25');
is(number_of_day_within_year('12/26/2007'),         360,     'number of day within year 12/26/2007  = 26');
is(number_of_day_within_year('12/27/2007'),         361,     'number of day within year 12/27/2007  = 27');
is(number_of_day_within_year('12/28/2007'),         362,     'number of day within year 12/28/2007  = 28');
is(number_of_day_within_year('12/29/2007'),         363,     'number of day within year 12/29/2007  = 29');
is(number_of_day_within_year('12/30/2007'),         364,     'number of day within year 12/30/2007  = 30');
is(number_of_day_within_year('12/31/2007'),         365,     'number of day within year 12/31/2007  = 31');
is(number_of_day_within_year('1/1/-1'),             1,     'number of day within year 1/1/-1   =  1');
is(number_of_day_within_year('1/2/-1'),             2,     'number of day within year 1/2/-1   =  2');
is(number_of_day_within_year('1/3/-1'),             3,     'number of day within year 1/3/-1   =  3');
is(number_of_day_within_year('1/4/-1'),             4,     'number of day within year 1/4/-1   =  4');
is(number_of_day_within_year('1/5/-1'),             5,     'number of day within year 1/5/-1   =  5');
is(number_of_day_within_year('1/6/-1'),             6,     'number of day within year 1/6/-1   =  6');
is(number_of_day_within_year('1/7/-1'),             7,     'number of day within year 1/7/-1   =  7');
is(number_of_day_within_year('1/8/-1'),             8,     'number of day within year 1/8/-1   =  8');
is(number_of_day_within_year('1/9/-1'),             9,     'number of day within year 1/9/-1   =  9');
is(number_of_day_within_year('1/10/-1'),           10,     'number of day within year 1/10/-1  = 10');
is(number_of_day_within_year('1/11/-1'),           11,     'number of day within year 1/11/-1  = 11');
is(number_of_day_within_year('1/12/-1'),           12,     'number of day within year 1/12/-1  = 12');
is(number_of_day_within_year('1/13/-1'),           13,     'number of day within year 1/13/-1  = 13');
is(number_of_day_within_year('1/14/-1'),           14,     'number of day within year 1/14/-1  = 14');
is(number_of_day_within_year('1/15/-1'),           15,     'number of day within year 1/15/-1  = 15');
is(number_of_day_within_year('1/16/-1'),           16,     'number of day within year 1/16/-1  = 16');
is(number_of_day_within_year('1/17/-1'),           17,     'number of day within year 1/17/-1  = 17');
is(number_of_day_within_year('1/18/-1'),           18,     'number of day within year 1/18/-1  = 18');
is(number_of_day_within_year('1/19/-1'),           19,     'number of day within year 1/19/-1  = 19');
is(number_of_day_within_year('1/20/-1'),           20,     'number of day within year 1/20/-1  = 20');
is(number_of_day_within_year('1/21/-1'),           21,     'number of day within year 1/21/-1  = 21');
is(number_of_day_within_year('1/22/-1'),           22,     'number of day within year 1/22/-1  = 22');
is(number_of_day_within_year('1/23/-1'),           23,     'number of day within year 1/23/-1  = 23');
is(number_of_day_within_year('1/24/-1'),           24,     'number of day within year 1/24/-1  = 24');
is(number_of_day_within_year('1/25/-1'),           25,     'number of day within year 1/25/-1  = 25');
is(number_of_day_within_year('1/26/-1'),           26,     'number of day within year 1/26/-1  = 26');
is(number_of_day_within_year('1/27/-1'),           27,     'number of day within year 1/27/-1  = 27');
is(number_of_day_within_year('1/28/-1'),           28,     'number of day within year 1/28/-1  = 28');
is(number_of_day_within_year('1/29/-1'),           29,     'number of day within year 1/29/-1  = 29');
is(number_of_day_within_year('1/30/-1'),           30,     'number of day within year 1/30/-1  = 30');
is(number_of_day_within_year('1/31/-1'),           31,     'number of day within year 1/31/-1  = 31');
is(number_of_day_within_year('2/1/-1'),            32,     'number of day within year 2/1/-1   =  1');
is(number_of_day_within_year('2/2/-1'),            33,     'number of day within year 2/2/-1   =  2');
is(number_of_day_within_year('2/3/-1'),            34,     'number of day within year 2/3/-1   =  3');
is(number_of_day_within_year('2/4/-1'),            35,     'number of day within year 2/4/-1   =  4');
is(number_of_day_within_year('2/5/-1'),            36,     'number of day within year 2/5/-1   =  5');
is(number_of_day_within_year('2/6/-1'),            37,     'number of day within year 2/6/-1   =  6');
is(number_of_day_within_year('2/7/-1'),            38,     'number of day within year 2/7/-1   =  7');
is(number_of_day_within_year('2/8/-1'),            39,     'number of day within year 2/8/-1   =  8');
is(number_of_day_within_year('2/9/-1'),            40,     'number of day within year 2/9/-1   =  9');
is(number_of_day_within_year('2/10/-1'),           41,     'number of day within year 2/10/-1  = 10');
is(number_of_day_within_year('2/11/-1'),           42,     'number of day within year 2/11/-1  = 11');
is(number_of_day_within_year('2/12/-1'),           43,     'number of day within year 2/12/-1  = 12');
is(number_of_day_within_year('2/13/-1'),           44,     'number of day within year 2/13/-1  = 13');
is(number_of_day_within_year('2/14/-1'),           45,     'number of day within year 2/14/-1  = 14');
is(number_of_day_within_year('2/15/-1'),           46,     'number of day within year 2/15/-1  = 15');
is(number_of_day_within_year('2/16/-1'),           47,     'number of day within year 2/16/-1  = 16');
is(number_of_day_within_year('2/17/-1'),           48,     'number of day within year 2/17/-1  = 17');
is(number_of_day_within_year('2/18/-1'),           49,     'number of day within year 2/18/-1  = 18');
is(number_of_day_within_year('2/19/-1'),           50,     'number of day within year 2/19/-1  = 19');
is(number_of_day_within_year('2/20/-1'),           51,     'number of day within year 2/20/-1  = 20');
is(number_of_day_within_year('2/21/-1'),           52,     'number of day within year 2/21/-1  = 21');
is(number_of_day_within_year('2/22/-1'),           53,     'number of day within year 2/22/-1  = 22');
is(number_of_day_within_year('2/23/-1'),           54,     'number of day within year 2/23/-1  = 23');
is(number_of_day_within_year('2/24/-1'),           55,     'number of day within year 2/24/-1  = 24');
is(number_of_day_within_year('2/25/-1'),           56,     'number of day within year 2/25/-1  = 25');
is(number_of_day_within_year('2/26/-1'),           57,     'number of day within year 2/26/-1  = 26');
is(number_of_day_within_year('2/27/-1'),           58,     'number of day within year 2/27/-1  = 27');
is(number_of_day_within_year('2/28/-1'),           59,     'number of day within year 2/28/-1  = 28');
is(number_of_day_within_year('3/1/-1'),            60,     'number of day within year 3/1/-1   =  1');
is(number_of_day_within_year('3/2/-1'),            61,     'number of day within year 3/2/-1   =  2');
is(number_of_day_within_year('3/3/-1'),            62,     'number of day within year 3/3/-1   =  3');
is(number_of_day_within_year('3/4/-1'),            63,     'number of day within year 3/4/-1   =  4');
is(number_of_day_within_year('3/5/-1'),            64,     'number of day within year 3/5/-1   =  5');
is(number_of_day_within_year('3/6/-1'),            65,     'number of day within year 3/6/-1   =  6');
is(number_of_day_within_year('3/7/-1'),            66,     'number of day within year 3/7/-1   =  7');
is(number_of_day_within_year('3/8/-1'),            67,     'number of day within year 3/8/-1   =  8');
is(number_of_day_within_year('3/9/-1'),            68,     'number of day within year 3/9/-1   =  9');
is(number_of_day_within_year('3/10/-1'),           69,     'number of day within year 3/10/-1  = 10');
is(number_of_day_within_year('3/11/-1'),           70,     'number of day within year 3/11/-1  = 11');
is(number_of_day_within_year('3/12/-1'),           71,     'number of day within year 3/12/-1  = 12');
is(number_of_day_within_year('3/13/-1'),           72,     'number of day within year 3/13/-1  = 13');
is(number_of_day_within_year('3/14/-1'),           73,     'number of day within year 3/14/-1  = 14');
is(number_of_day_within_year('3/15/-1'),           74,     'number of day within year 3/15/-1  = 15');
is(number_of_day_within_year('3/16/-1'),           75,     'number of day within year 3/16/-1  = 16');
is(number_of_day_within_year('3/17/-1'),           76,     'number of day within year 3/17/-1  = 17');
is(number_of_day_within_year('3/18/-1'),           77,     'number of day within year 3/18/-1  = 18');
is(number_of_day_within_year('3/19/-1'),           78,     'number of day within year 3/19/-1  = 19');
is(number_of_day_within_year('3/20/-1'),           79,     'number of day within year 3/20/-1  = 20');
is(number_of_day_within_year('3/21/-1'),           80,     'number of day within year 3/21/-1  = 21');
is(number_of_day_within_year('3/22/-1'),           81,     'number of day within year 3/22/-1  = 22');
is(number_of_day_within_year('3/23/-1'),           82,     'number of day within year 3/23/-1  = 23');
is(number_of_day_within_year('3/24/-1'),           83,     'number of day within year 3/24/-1  = 24');
is(number_of_day_within_year('3/25/-1'),           84,     'number of day within year 3/25/-1  = 25');
is(number_of_day_within_year('3/26/-1'),           85,     'number of day within year 3/26/-1  = 26');
is(number_of_day_within_year('3/27/-1'),           86,     'number of day within year 3/27/-1  = 27');
is(number_of_day_within_year('3/28/-1'),           87,     'number of day within year 3/28/-1  = 28');
is(number_of_day_within_year('3/29/-1'),           88,     'number of day within year 3/29/-1  = 29');
is(number_of_day_within_year('3/30/-1'),           89,     'number of day within year 3/30/-1  = 30');
is(number_of_day_within_year('3/31/-1'),           90,     'number of day within year 3/31/-1  = 31');
is(number_of_day_within_year('4/1/-1'),            91,     'number of day within year 4/1/-1   =  1');
is(number_of_day_within_year('4/2/-1'),            92,     'number of day within year 4/2/-1   =  2');
is(number_of_day_within_year('4/3/-1'),            93,     'number of day within year 4/3/-1   =  3');
is(number_of_day_within_year('4/4/-1'),            94,     'number of day within year 4/4/-1   =  4');
is(number_of_day_within_year('4/5/-1'),            95,     'number of day within year 4/5/-1   =  5');
is(number_of_day_within_year('4/6/-1'),            96,     'number of day within year 4/6/-1   =  6');
is(number_of_day_within_year('4/7/-1'),            97,     'number of day within year 4/7/-1   =  7');
is(number_of_day_within_year('4/8/-1'),            98,     'number of day within year 4/8/-1   =  8');
is(number_of_day_within_year('4/9/-1'),            99,     'number of day within year 4/9/-1   =  9');
is(number_of_day_within_year('4/10/-1'),          100,     'number of day within year 4/10/-1  = 10');
is(number_of_day_within_year('4/11/-1'),          101,     'number of day within year 4/11/-1  = 11');
is(number_of_day_within_year('4/12/-1'),          102,     'number of day within year 4/12/-1  = 12');
is(number_of_day_within_year('4/13/-1'),          103,     'number of day within year 4/13/-1  = 13');
is(number_of_day_within_year('4/14/-1'),          104,     'number of day within year 4/14/-1  = 14');
is(number_of_day_within_year('4/15/-1'),          105,     'number of day within year 4/15/-1  = 15');
is(number_of_day_within_year('4/16/-1'),          106,     'number of day within year 4/16/-1  = 16');
is(number_of_day_within_year('4/17/-1'),          107,     'number of day within year 4/17/-1  = 17');
is(number_of_day_within_year('4/18/-1'),          108,     'number of day within year 4/18/-1  = 18');
is(number_of_day_within_year('4/19/-1'),          109,     'number of day within year 4/19/-1  = 19');
is(number_of_day_within_year('4/20/-1'),          110,     'number of day within year 4/20/-1  = 20');
is(number_of_day_within_year('4/21/-1'),          111,     'number of day within year 4/21/-1  = 21');
is(number_of_day_within_year('4/22/-1'),          112,     'number of day within year 4/22/-1  = 22');
is(number_of_day_within_year('4/23/-1'),          113,     'number of day within year 4/23/-1  = 23');
is(number_of_day_within_year('4/24/-1'),          114,     'number of day within year 4/24/-1  = 24');
is(number_of_day_within_year('4/25/-1'),          115,     'number of day within year 4/25/-1  = 25');
is(number_of_day_within_year('4/26/-1'),          116,     'number of day within year 4/26/-1  = 26');
is(number_of_day_within_year('4/27/-1'),          117,     'number of day within year 4/27/-1  = 27');
is(number_of_day_within_year('4/28/-1'),          118,     'number of day within year 4/28/-1  = 28');
is(number_of_day_within_year('4/29/-1'),          119,     'number of day within year 4/29/-1  = 29');
is(number_of_day_within_year('4/30/-1'),          120,     'number of day within year 4/30/-1  = 30');
is(number_of_day_within_year('5/1/-1'),           121,     'number of day within year 5/1/-1   =  1');
is(number_of_day_within_year('5/2/-1'),           122,     'number of day within year 5/2/-1   =  2');
is(number_of_day_within_year('5/3/-1'),           123,     'number of day within year 5/3/-1   =  3');
is(number_of_day_within_year('5/4/-1'),           124,     'number of day within year 5/4/-1   =  4');
is(number_of_day_within_year('5/5/-1'),           125,     'number of day within year 5/5/-1   =  5');
is(number_of_day_within_year('5/6/-1'),           126,     'number of day within year 5/6/-1   =  6');
is(number_of_day_within_year('5/7/-1'),           127,     'number of day within year 5/7/-1   =  7');
is(number_of_day_within_year('5/8/-1'),           128,     'number of day within year 5/8/-1   =  8');
is(number_of_day_within_year('5/9/-1'),           129,     'number of day within year 5/9/-1   =  9');
is(number_of_day_within_year('5/10/-1'),          130,     'number of day within year 5/10/-1  = 10');
is(number_of_day_within_year('5/11/-1'),          131,     'number of day within year 5/11/-1  = 11');
is(number_of_day_within_year('5/12/-1'),          132,     'number of day within year 5/12/-1  = 12');
is(number_of_day_within_year('5/13/-1'),          133,     'number of day within year 5/13/-1  = 13');
is(number_of_day_within_year('5/14/-1'),          134,     'number of day within year 5/14/-1  = 14');
is(number_of_day_within_year('5/15/-1'),          135,     'number of day within year 5/15/-1  = 15');
is(number_of_day_within_year('5/16/-1'),          136,     'number of day within year 5/16/-1  = 16');
is(number_of_day_within_year('5/17/-1'),          137,     'number of day within year 5/17/-1  = 17');
is(number_of_day_within_year('5/18/-1'),          138,     'number of day within year 5/18/-1  = 18');
is(number_of_day_within_year('5/19/-1'),          139,     'number of day within year 5/19/-1  = 19');
is(number_of_day_within_year('5/20/-1'),          140,     'number of day within year 5/20/-1  = 20');
is(number_of_day_within_year('5/21/-1'),          141,     'number of day within year 5/21/-1  = 21');
is(number_of_day_within_year('5/22/-1'),          142,     'number of day within year 5/22/-1  = 22');
is(number_of_day_within_year('5/23/-1'),          143,     'number of day within year 5/23/-1  = 23');
is(number_of_day_within_year('5/24/-1'),          144,     'number of day within year 5/24/-1  = 24');
is(number_of_day_within_year('5/25/-1'),          145,     'number of day within year 5/25/-1  = 25');
is(number_of_day_within_year('5/26/-1'),          146,     'number of day within year 5/26/-1  = 26');
is(number_of_day_within_year('5/27/-1'),          147,     'number of day within year 5/27/-1  = 27');
is(number_of_day_within_year('5/28/-1'),          148,     'number of day within year 5/28/-1  = 28');
is(number_of_day_within_year('5/29/-1'),          149,     'number of day within year 5/29/-1  = 29');
is(number_of_day_within_year('5/30/-1'),          150,     'number of day within year 5/30/-1  = 30');
is(number_of_day_within_year('5/31/-1'),          151,     'number of day within year 5/31/-1  = 31');
is(number_of_day_within_year('6/1/-1'),           152,     'number of day within year 6/1/-1   =  1');
is(number_of_day_within_year('6/2/-1'),           153,     'number of day within year 6/2/-1   =  2');
is(number_of_day_within_year('6/3/-1'),           154,     'number of day within year 6/3/-1   =  3');
is(number_of_day_within_year('6/4/-1'),           155,     'number of day within year 6/4/-1   =  4');
is(number_of_day_within_year('6/5/-1'),           156,     'number of day within year 6/5/-1   =  5');
is(number_of_day_within_year('6/6/-1'),           157,     'number of day within year 6/6/-1   =  6');
is(number_of_day_within_year('6/7/-1'),           158,     'number of day within year 6/7/-1   =  7');
is(number_of_day_within_year('6/8/-1'),           159,     'number of day within year 6/8/-1   =  8');
is(number_of_day_within_year('6/9/-1'),           160,     'number of day within year 6/9/-1   =  9');
is(number_of_day_within_year('6/10/-1'),          161,     'number of day within year 6/10/-1  = 10');
is(number_of_day_within_year('6/11/-1'),          162,     'number of day within year 6/11/-1  = 11');
is(number_of_day_within_year('6/12/-1'),          163,     'number of day within year 6/12/-1  = 12');
is(number_of_day_within_year('6/13/-1'),          164,     'number of day within year 6/13/-1  = 13');
is(number_of_day_within_year('6/14/-1'),          165,     'number of day within year 6/14/-1  = 14');
is(number_of_day_within_year('6/15/-1'),          166,     'number of day within year 6/15/-1  = 15');
is(number_of_day_within_year('6/16/-1'),          167,     'number of day within year 6/16/-1  = 16');
is(number_of_day_within_year('6/17/-1'),          168,     'number of day within year 6/17/-1  = 17');
is(number_of_day_within_year('6/18/-1'),          169,     'number of day within year 6/18/-1  = 18');
is(number_of_day_within_year('6/19/-1'),          170,     'number of day within year 6/19/-1  = 19');
is(number_of_day_within_year('6/20/-1'),          171,     'number of day within year 6/20/-1  = 20');
is(number_of_day_within_year('6/21/-1'),          172,     'number of day within year 6/21/-1  = 21');
is(number_of_day_within_year('6/22/-1'),          173,     'number of day within year 6/22/-1  = 22');
is(number_of_day_within_year('6/23/-1'),          174,     'number of day within year 6/23/-1  = 23');
is(number_of_day_within_year('6/24/-1'),          175,     'number of day within year 6/24/-1  = 24');
is(number_of_day_within_year('6/25/-1'),          176,     'number of day within year 6/25/-1  = 25');
is(number_of_day_within_year('6/26/-1'),          177,     'number of day within year 6/26/-1  = 26');
is(number_of_day_within_year('6/27/-1'),          178,     'number of day within year 6/27/-1  = 27');
is(number_of_day_within_year('6/28/-1'),          179,     'number of day within year 6/28/-1  = 28');
is(number_of_day_within_year('6/29/-1'),          180,     'number of day within year 6/29/-1  = 29');
is(number_of_day_within_year('6/30/-1'),          181,     'number of day within year 6/30/-1  = 30');
is(number_of_day_within_year('7/1/-1'),           182,     'number of day within year 7/1/-1   =  1');
is(number_of_day_within_year('7/2/-1'),           183,     'number of day within year 7/2/-1   =  2');
is(number_of_day_within_year('7/3/-1'),           184,     'number of day within year 7/3/-1   =  3');
is(number_of_day_within_year('7/4/-1'),           185,     'number of day within year 7/4/-1   =  4');
is(number_of_day_within_year('7/5/-1'),           186,     'number of day within year 7/5/-1   =  5');
is(number_of_day_within_year('7/6/-1'),           187,     'number of day within year 7/6/-1   =  6');
is(number_of_day_within_year('7/7/-1'),           188,     'number of day within year 7/7/-1   =  7');
is(number_of_day_within_year('7/8/-1'),           189,     'number of day within year 7/8/-1   =  8');
is(number_of_day_within_year('7/9/-1'),           190,     'number of day within year 7/9/-1   =  9');
is(number_of_day_within_year('7/10/-1'),          191,     'number of day within year 7/10/-1  = 10');
is(number_of_day_within_year('7/11/-1'),          192,     'number of day within year 7/11/-1  = 11');
is(number_of_day_within_year('7/12/-1'),          193,     'number of day within year 7/12/-1  = 12');
is(number_of_day_within_year('7/13/-1'),          194,     'number of day within year 7/13/-1  = 13');
is(number_of_day_within_year('7/14/-1'),          195,     'number of day within year 7/14/-1  = 14');
is(number_of_day_within_year('7/15/-1'),          196,     'number of day within year 7/15/-1  = 15');
is(number_of_day_within_year('7/16/-1'),          197,     'number of day within year 7/16/-1  = 16');
is(number_of_day_within_year('7/17/-1'),          198,     'number of day within year 7/17/-1  = 17');
is(number_of_day_within_year('7/18/-1'),          199,     'number of day within year 7/18/-1  = 18');
is(number_of_day_within_year('7/19/-1'),          200,     'number of day within year 7/19/-1  = 19');
is(number_of_day_within_year('7/20/-1'),          201,     'number of day within year 7/20/-1  = 20');
is(number_of_day_within_year('7/21/-1'),          202,     'number of day within year 7/21/-1  = 21');
is(number_of_day_within_year('7/22/-1'),          203,     'number of day within year 7/22/-1  = 22');
is(number_of_day_within_year('7/23/-1'),          204,     'number of day within year 7/23/-1  = 23');
is(number_of_day_within_year('7/24/-1'),          205,     'number of day within year 7/24/-1  = 24');
is(number_of_day_within_year('7/25/-1'),          206,     'number of day within year 7/25/-1  = 25');
is(number_of_day_within_year('7/26/-1'),          207,     'number of day within year 7/26/-1  = 26');
is(number_of_day_within_year('7/27/-1'),          208,     'number of day within year 7/27/-1  = 27');
is(number_of_day_within_year('7/28/-1'),          209,     'number of day within year 7/28/-1  = 28');
is(number_of_day_within_year('7/29/-1'),          210,     'number of day within year 7/29/-1  = 29');
is(number_of_day_within_year('7/30/-1'),          211,     'number of day within year 7/30/-1  = 30');
is(number_of_day_within_year('7/31/-1'),          212,     'number of day within year 7/31/-1  = 31');
is(number_of_day_within_year('8/1/-1'),           213,     'number of day within year 8/1/-1   =  1');
is(number_of_day_within_year('8/2/-1'),           214,     'number of day within year 8/2/-1   =  2');
is(number_of_day_within_year('8/3/-1'),           215,     'number of day within year 8/3/-1   =  3');
is(number_of_day_within_year('8/4/-1'),           216,     'number of day within year 8/4/-1   =  4');
is(number_of_day_within_year('8/5/-1'),           217,     'number of day within year 8/5/-1   =  5');
is(number_of_day_within_year('8/6/-1'),           218,     'number of day within year 8/6/-1   =  6');
is(number_of_day_within_year('8/7/-1'),           219,     'number of day within year 8/7/-1   =  7');
is(number_of_day_within_year('8/8/-1'),           220,     'number of day within year 8/8/-1   =  8');
is(number_of_day_within_year('8/9/-1'),           221,     'number of day within year 8/9/-1   =  9');
is(number_of_day_within_year('8/10/-1'),          222,     'number of day within year 8/10/-1  = 10');
is(number_of_day_within_year('8/11/-1'),          223,     'number of day within year 8/11/-1  = 11');
is(number_of_day_within_year('8/12/-1'),          224,     'number of day within year 8/12/-1  = 12');
is(number_of_day_within_year('8/13/-1'),          225,     'number of day within year 8/13/-1  = 13');
is(number_of_day_within_year('8/14/-1'),          226,     'number of day within year 8/14/-1  = 14');
is(number_of_day_within_year('8/15/-1'),          227,     'number of day within year 8/15/-1  = 15');
is(number_of_day_within_year('8/16/-1'),          228,     'number of day within year 8/16/-1  = 16');
is(number_of_day_within_year('8/17/-1'),          229,     'number of day within year 8/17/-1  = 17');
is(number_of_day_within_year('8/18/-1'),          230,     'number of day within year 8/18/-1  = 18');
is(number_of_day_within_year('8/19/-1'),          231,     'number of day within year 8/19/-1  = 19');
is(number_of_day_within_year('8/20/-1'),          232,     'number of day within year 8/20/-1  = 20');
is(number_of_day_within_year('8/21/-1'),          233,     'number of day within year 8/21/-1  = 21');
is(number_of_day_within_year('8/22/-1'),          234,     'number of day within year 8/22/-1  = 22');
is(number_of_day_within_year('8/23/-1'),          235,     'number of day within year 8/23/-1  = 23');
is(number_of_day_within_year('8/24/-1'),          236,     'number of day within year 8/24/-1  = 24');
is(number_of_day_within_year('8/25/-1'),          237,     'number of day within year 8/25/-1  = 25');
is(number_of_day_within_year('8/26/-1'),          238,     'number of day within year 8/26/-1  = 26');
is(number_of_day_within_year('8/27/-1'),          239,     'number of day within year 8/27/-1  = 27');
is(number_of_day_within_year('8/28/-1'),          240,     'number of day within year 8/28/-1  = 28');
is(number_of_day_within_year('8/29/-1'),          241,     'number of day within year 8/29/-1  = 29');
is(number_of_day_within_year('8/30/-1'),          242,     'number of day within year 8/30/-1  = 30');
is(number_of_day_within_year('8/31/-1'),          243,     'number of day within year 8/31/-1  = 31');
is(number_of_day_within_year('9/1/-1'),           244,     'number of day within year 9/1/-1   =  1');
is(number_of_day_within_year('9/2/-1'),           245,     'number of day within year 9/2/-1   =  2');
is(number_of_day_within_year('9/3/-1'),           246,     'number of day within year 9/3/-1   =  3');
is(number_of_day_within_year('9/4/-1'),           247,     'number of day within year 9/4/-1   =  4');
is(number_of_day_within_year('9/5/-1'),           248,     'number of day within year 9/5/-1   =  5');
is(number_of_day_within_year('9/6/-1'),           249,     'number of day within year 9/6/-1   =  6');
is(number_of_day_within_year('9/7/-1'),           250,     'number of day within year 9/7/-1   =  7');
is(number_of_day_within_year('9/8/-1'),           251,     'number of day within year 9/8/-1   =  8');
is(number_of_day_within_year('9/9/-1'),           252,     'number of day within year 9/9/-1   =  9');
is(number_of_day_within_year('9/10/-1'),          253,     'number of day within year 9/10/-1  = 10');
is(number_of_day_within_year('9/11/-1'),          254,     'number of day within year 9/11/-1  = 11');
is(number_of_day_within_year('9/12/-1'),          255,     'number of day within year 9/12/-1  = 12');
is(number_of_day_within_year('9/13/-1'),          256,     'number of day within year 9/13/-1  = 13');
is(number_of_day_within_year('9/14/-1'),          257,     'number of day within year 9/14/-1  = 14');
is(number_of_day_within_year('9/15/-1'),          258,     'number of day within year 9/15/-1  = 15');
is(number_of_day_within_year('9/16/-1'),          259,     'number of day within year 9/16/-1  = 16');
is(number_of_day_within_year('9/17/-1'),          260,     'number of day within year 9/17/-1  = 17');
is(number_of_day_within_year('9/18/-1'),          261,     'number of day within year 9/18/-1  = 18');
is(number_of_day_within_year('9/19/-1'),          262,     'number of day within year 9/19/-1  = 19');
is(number_of_day_within_year('9/20/-1'),          263,     'number of day within year 9/20/-1  = 20');
is(number_of_day_within_year('9/21/-1'),          264,     'number of day within year 9/21/-1  = 21');
is(number_of_day_within_year('9/22/-1'),          265,     'number of day within year 9/22/-1  = 22');
is(number_of_day_within_year('9/23/-1'),          266,     'number of day within year 9/23/-1  = 23');
is(number_of_day_within_year('9/24/-1'),          267,     'number of day within year 9/24/-1  = 24');
is(number_of_day_within_year('9/25/-1'),          268,     'number of day within year 9/25/-1  = 25');
is(number_of_day_within_year('9/26/-1'),          269,     'number of day within year 9/26/-1  = 26');
is(number_of_day_within_year('9/27/-1'),          270,     'number of day within year 9/27/-1  = 27');
is(number_of_day_within_year('9/28/-1'),          271,     'number of day within year 9/28/-1  = 28');
is(number_of_day_within_year('9/29/-1'),          272,     'number of day within year 9/29/-1  = 29');
is(number_of_day_within_year('9/30/-1'),          273,     'number of day within year 9/30/-1  = 30');
is(number_of_day_within_year('10/1/-1'),          274,     'number of day within year 10/1/-1   =  1');
is(number_of_day_within_year('10/2/-1'),          275,     'number of day within year 10/2/-1   =  2');
is(number_of_day_within_year('10/3/-1'),          276,     'number of day within year 10/3/-1   =  3');
is(number_of_day_within_year('10/4/-1'),          277,     'number of day within year 10/4/-1   =  4');
is(number_of_day_within_year('10/5/-1'),          278,     'number of day within year 10/5/-1   =  5');
is(number_of_day_within_year('10/6/-1'),          279,     'number of day within year 10/6/-1   =  6');
is(number_of_day_within_year('10/7/-1'),          280,     'number of day within year 10/7/-1   =  7');
is(number_of_day_within_year('10/8/-1'),          281,     'number of day within year 10/8/-1   =  8');
is(number_of_day_within_year('10/9/-1'),          282,     'number of day within year 10/9/-1   =  9');
is(number_of_day_within_year('10/10/-1'),         283,     'number of day within year 10/10/-1  = 10');
is(number_of_day_within_year('10/11/-1'),         284,     'number of day within year 10/11/-1  = 11');
is(number_of_day_within_year('10/12/-1'),         285,     'number of day within year 10/12/-1  = 12');
is(number_of_day_within_year('10/13/-1'),         286,     'number of day within year 10/13/-1  = 13');
is(number_of_day_within_year('10/14/-1'),         287,     'number of day within year 10/14/-1  = 14');
is(number_of_day_within_year('10/15/-1'),         288,     'number of day within year 10/15/-1  = 15');
is(number_of_day_within_year('10/16/-1'),         289,     'number of day within year 10/16/-1  = 16');
is(number_of_day_within_year('10/17/-1'),         290,     'number of day within year 10/17/-1  = 17');
is(number_of_day_within_year('10/18/-1'),         291,     'number of day within year 10/18/-1  = 18');
is(number_of_day_within_year('10/19/-1'),         292,     'number of day within year 10/19/-1  = 19');
is(number_of_day_within_year('10/20/-1'),         293,     'number of day within year 10/20/-1  = 20');
is(number_of_day_within_year('10/21/-1'),         294,     'number of day within year 10/21/-1  = 21');
is(number_of_day_within_year('10/22/-1'),         295,     'number of day within year 10/22/-1  = 22');
is(number_of_day_within_year('10/23/-1'),         296,     'number of day within year 10/23/-1  = 23');
is(number_of_day_within_year('10/24/-1'),         297,     'number of day within year 10/24/-1  = 24');
is(number_of_day_within_year('10/25/-1'),         298,     'number of day within year 10/25/-1  = 25');
is(number_of_day_within_year('10/26/-1'),         299,     'number of day within year 10/26/-1  = 26');
is(number_of_day_within_year('10/27/-1'),         300,     'number of day within year 10/27/-1  = 27');
is(number_of_day_within_year('10/28/-1'),         301,     'number of day within year 10/28/-1  = 28');
is(number_of_day_within_year('10/29/-1'),         302,     'number of day within year 10/29/-1  = 29');
is(number_of_day_within_year('10/30/-1'),         303,     'number of day within year 10/30/-1  = 30');
is(number_of_day_within_year('10/31/-1'),         304,     'number of day within year 10/31/-1  = 31');
is(number_of_day_within_year('11/1/-1'),          305,     'number of day within year 11/1/-1   =  1');
is(number_of_day_within_year('11/2/-1'),          306,     'number of day within year 11/2/-1   =  2');
is(number_of_day_within_year('11/3/-1'),          307,     'number of day within year 11/3/-1   =  3');
is(number_of_day_within_year('11/4/-1'),          308,     'number of day within year 11/4/-1   =  4');
is(number_of_day_within_year('11/5/-1'),          309,     'number of day within year 11/5/-1   =  5');
is(number_of_day_within_year('11/6/-1'),          310,     'number of day within year 11/6/-1   =  6');
is(number_of_day_within_year('11/7/-1'),          311,     'number of day within year 11/7/-1   =  7');
is(number_of_day_within_year('11/8/-1'),          312,     'number of day within year 11/8/-1   =  8');
is(number_of_day_within_year('11/9/-1'),          313,     'number of day within year 11/9/-1   =  9');
is(number_of_day_within_year('11/10/-1'),         314,     'number of day within year 11/10/-1  = 10');
is(number_of_day_within_year('11/11/-1'),         315,     'number of day within year 11/11/-1  = 11');
is(number_of_day_within_year('11/12/-1'),         316,     'number of day within year 11/12/-1  = 12');
is(number_of_day_within_year('11/13/-1'),         317,     'number of day within year 11/13/-1  = 13');
is(number_of_day_within_year('11/14/-1'),         318,     'number of day within year 11/14/-1  = 14');
is(number_of_day_within_year('11/15/-1'),         319,     'number of day within year 11/15/-1  = 15');
is(number_of_day_within_year('11/16/-1'),         320,     'number of day within year 11/16/-1  = 16');
is(number_of_day_within_year('11/17/-1'),         321,     'number of day within year 11/17/-1  = 17');
is(number_of_day_within_year('11/18/-1'),         322,     'number of day within year 11/18/-1  = 18');
is(number_of_day_within_year('11/19/-1'),         323,     'number of day within year 11/19/-1  = 19');
is(number_of_day_within_year('11/20/-1'),         324,     'number of day within year 11/20/-1  = 20');
is(number_of_day_within_year('11/21/-1'),         325,     'number of day within year 11/21/-1  = 21');
is(number_of_day_within_year('11/22/-1'),         326,     'number of day within year 11/22/-1  = 22');
is(number_of_day_within_year('11/23/-1'),         327,     'number of day within year 11/23/-1  = 23');
is(number_of_day_within_year('11/24/-1'),         328,     'number of day within year 11/24/-1  = 24');
is(number_of_day_within_year('11/25/-1'),         329,     'number of day within year 11/25/-1  = 25');
is(number_of_day_within_year('11/26/-1'),         330,     'number of day within year 11/26/-1  = 26');
is(number_of_day_within_year('11/27/-1'),         331,     'number of day within year 11/27/-1  = 27');
is(number_of_day_within_year('11/28/-1'),         332,     'number of day within year 11/28/-1  = 28');
is(number_of_day_within_year('11/29/-1'),         333,     'number of day within year 11/29/-1  = 29');
is(number_of_day_within_year('11/30/-1'),         334,     'number of day within year 11/30/-1  = 30');
is(number_of_day_within_year('12/1/-1'),          335,     'number of day within year 12/1/-1   =  1');
is(number_of_day_within_year('12/2/-1'),          336,     'number of day within year 12/2/-1   =  2');
is(number_of_day_within_year('12/3/-1'),          337,     'number of day within year 12/3/-1   =  3');
is(number_of_day_within_year('12/4/-1'),          338,     'number of day within year 12/4/-1   =  4');
is(number_of_day_within_year('12/5/-1'),          339,     'number of day within year 12/5/-1   =  5');
is(number_of_day_within_year('12/6/-1'),          340,     'number of day within year 12/6/-1   =  6');
is(number_of_day_within_year('12/7/-1'),          341,     'number of day within year 12/7/-1   =  7');
is(number_of_day_within_year('12/8/-1'),          342,     'number of day within year 12/8/-1   =  8');
is(number_of_day_within_year('12/9/-1'),          343,     'number of day within year 12/9/-1   =  9');
is(number_of_day_within_year('12/10/-1'),         344,     'number of day within year 12/10/-1  = 10');
is(number_of_day_within_year('12/11/-1'),         345,     'number of day within year 12/11/-1  = 11');
is(number_of_day_within_year('12/12/-1'),         346,     'number of day within year 12/12/-1  = 12');
is(number_of_day_within_year('12/13/-1'),         347,     'number of day within year 12/13/-1  = 13');
is(number_of_day_within_year('12/14/-1'),         348,     'number of day within year 12/14/-1  = 14');
is(number_of_day_within_year('12/15/-1'),         349,     'number of day within year 12/15/-1  = 15');
is(number_of_day_within_year('12/16/-1'),         350,     'number of day within year 12/16/-1  = 16');
is(number_of_day_within_year('12/17/-1'),         351,     'number of day within year 12/17/-1  = 17');
is(number_of_day_within_year('12/18/-1'),         352,     'number of day within year 12/18/-1  = 18');
is(number_of_day_within_year('12/19/-1'),         353,     'number of day within year 12/19/-1  = 19');
is(number_of_day_within_year('12/20/-1'),         354,     'number of day within year 12/20/-1  = 20');
is(number_of_day_within_year('12/21/-1'),         355,     'number of day within year 12/21/-1  = 21');
is(number_of_day_within_year('12/22/-1'),         356,     'number of day within year 12/22/-1  = 22');
is(number_of_day_within_year('12/23/-1'),         357,     'number of day within year 12/23/-1  = 23');
is(number_of_day_within_year('12/24/-1'),         358,     'number of day within year 12/24/-1  = 24');
is(number_of_day_within_year('12/25/-1'),         359,     'number of day within year 12/25/-1  = 25');
is(number_of_day_within_year('12/26/-1'),         360,     'number of day within year 12/26/-1  = 26');
is(number_of_day_within_year('12/27/-1'),         361,     'number of day within year 12/27/-1  = 27');
is(number_of_day_within_year('12/28/-1'),         362,     'number of day within year 12/28/-1  = 28');
is(number_of_day_within_year('12/29/-1'),         363,     'number of day within year 12/29/-1  = 29');
is(number_of_day_within_year('12/30/-1'),         364,     'number of day within year 12/30/-1  = 30');
is(number_of_day_within_year('12/31/-1'),         365,     'number of day within year 12/31/-1  = 31');
is(number_of_day_within_year('1/1/0'),             1,     'number of day within year 1/1/0   =  1');
is(number_of_day_within_year('1/2/0'),             2,     'number of day within year 1/2/0   =  2');
is(number_of_day_within_year('1/3/0'),             3,     'number of day within year 1/3/0   =  3');
is(number_of_day_within_year('1/4/0'),             4,     'number of day within year 1/4/0   =  4');
is(number_of_day_within_year('1/5/0'),             5,     'number of day within year 1/5/0   =  5');
is(number_of_day_within_year('1/6/0'),             6,     'number of day within year 1/6/0   =  6');
is(number_of_day_within_year('1/7/0'),             7,     'number of day within year 1/7/0   =  7');
is(number_of_day_within_year('1/8/0'),             8,     'number of day within year 1/8/0   =  8');
is(number_of_day_within_year('1/9/0'),             9,     'number of day within year 1/9/0   =  9');
is(number_of_day_within_year('1/10/0'),           10,     'number of day within year 1/10/0  = 10');
is(number_of_day_within_year('1/11/0'),           11,     'number of day within year 1/11/0  = 11');
is(number_of_day_within_year('1/12/0'),           12,     'number of day within year 1/12/0  = 12');
is(number_of_day_within_year('1/13/0'),           13,     'number of day within year 1/13/0  = 13');
is(number_of_day_within_year('1/14/0'),           14,     'number of day within year 1/14/0  = 14');
is(number_of_day_within_year('1/15/0'),           15,     'number of day within year 1/15/0  = 15');
is(number_of_day_within_year('1/16/0'),           16,     'number of day within year 1/16/0  = 16');
is(number_of_day_within_year('1/17/0'),           17,     'number of day within year 1/17/0  = 17');
is(number_of_day_within_year('1/18/0'),           18,     'number of day within year 1/18/0  = 18');
is(number_of_day_within_year('1/19/0'),           19,     'number of day within year 1/19/0  = 19');
is(number_of_day_within_year('1/20/0'),           20,     'number of day within year 1/20/0  = 20');
is(number_of_day_within_year('1/21/0'),           21,     'number of day within year 1/21/0  = 21');
is(number_of_day_within_year('1/22/0'),           22,     'number of day within year 1/22/0  = 22');
is(number_of_day_within_year('1/23/0'),           23,     'number of day within year 1/23/0  = 23');
is(number_of_day_within_year('1/24/0'),           24,     'number of day within year 1/24/0  = 24');
is(number_of_day_within_year('1/25/0'),           25,     'number of day within year 1/25/0  = 25');
is(number_of_day_within_year('1/26/0'),           26,     'number of day within year 1/26/0  = 26');
is(number_of_day_within_year('1/27/0'),           27,     'number of day within year 1/27/0  = 27');
is(number_of_day_within_year('1/28/0'),           28,     'number of day within year 1/28/0  = 28');
is(number_of_day_within_year('1/29/0'),           29,     'number of day within year 1/29/0  = 29');
is(number_of_day_within_year('1/30/0'),           30,     'number of day within year 1/30/0  = 30');
is(number_of_day_within_year('1/31/0'),           31,     'number of day within year 1/31/0  = 31');
is(number_of_day_within_year('2/1/0'),            32,     'number of day within year 2/1/0   =  1');
is(number_of_day_within_year('2/2/0'),            33,     'number of day within year 2/2/0   =  2');
is(number_of_day_within_year('2/3/0'),            34,     'number of day within year 2/3/0   =  3');
is(number_of_day_within_year('2/4/0'),            35,     'number of day within year 2/4/0   =  4');
is(number_of_day_within_year('2/5/0'),            36,     'number of day within year 2/5/0   =  5');
is(number_of_day_within_year('2/6/0'),            37,     'number of day within year 2/6/0   =  6');
is(number_of_day_within_year('2/7/0'),            38,     'number of day within year 2/7/0   =  7');
is(number_of_day_within_year('2/8/0'),            39,     'number of day within year 2/8/0   =  8');
is(number_of_day_within_year('2/9/0'),            40,     'number of day within year 2/9/0   =  9');
is(number_of_day_within_year('2/10/0'),           41,     'number of day within year 2/10/0  = 10');
is(number_of_day_within_year('2/11/0'),           42,     'number of day within year 2/11/0  = 11');
is(number_of_day_within_year('2/12/0'),           43,     'number of day within year 2/12/0  = 12');
is(number_of_day_within_year('2/13/0'),           44,     'number of day within year 2/13/0  = 13');
is(number_of_day_within_year('2/14/0'),           45,     'number of day within year 2/14/0  = 14');
is(number_of_day_within_year('2/15/0'),           46,     'number of day within year 2/15/0  = 15');
is(number_of_day_within_year('2/16/0'),           47,     'number of day within year 2/16/0  = 16');
is(number_of_day_within_year('2/17/0'),           48,     'number of day within year 2/17/0  = 17');
is(number_of_day_within_year('2/18/0'),           49,     'number of day within year 2/18/0  = 18');
is(number_of_day_within_year('2/19/0'),           50,     'number of day within year 2/19/0  = 19');
is(number_of_day_within_year('2/20/0'),           51,     'number of day within year 2/20/0  = 20');
is(number_of_day_within_year('2/21/0'),           52,     'number of day within year 2/21/0  = 21');
is(number_of_day_within_year('2/22/0'),           53,     'number of day within year 2/22/0  = 22');
is(number_of_day_within_year('2/23/0'),           54,     'number of day within year 2/23/0  = 23');
is(number_of_day_within_year('2/24/0'),           55,     'number of day within year 2/24/0  = 24');
is(number_of_day_within_year('2/25/0'),           56,     'number of day within year 2/25/0  = 25');
is(number_of_day_within_year('2/26/0'),           57,     'number of day within year 2/26/0  = 26');
is(number_of_day_within_year('2/27/0'),           58,     'number of day within year 2/27/0  = 27');
is(number_of_day_within_year('2/28/0'),           59,     'number of day within year 2/28/0  = 28');
is(number_of_day_within_year('2/29/0'),           60,     'number of day within year 2/29/0  = 29');
is(number_of_day_within_year('3/1/0'),            61,     'number of day within year 3/1/0   =  1');
is(number_of_day_within_year('3/2/0'),            62,     'number of day within year 3/2/0   =  2');
is(number_of_day_within_year('3/3/0'),            63,     'number of day within year 3/3/0   =  3');
is(number_of_day_within_year('3/4/0'),            64,     'number of day within year 3/4/0   =  4');
is(number_of_day_within_year('3/5/0'),            65,     'number of day within year 3/5/0   =  5');
is(number_of_day_within_year('3/6/0'),            66,     'number of day within year 3/6/0   =  6');
is(number_of_day_within_year('3/7/0'),            67,     'number of day within year 3/7/0   =  7');
is(number_of_day_within_year('3/8/0'),            68,     'number of day within year 3/8/0   =  8');
is(number_of_day_within_year('3/9/0'),            69,     'number of day within year 3/9/0   =  9');
is(number_of_day_within_year('3/10/0'),           70,     'number of day within year 3/10/0  = 10');
is(number_of_day_within_year('3/11/0'),           71,     'number of day within year 3/11/0  = 11');
is(number_of_day_within_year('3/12/0'),           72,     'number of day within year 3/12/0  = 12');
is(number_of_day_within_year('3/13/0'),           73,     'number of day within year 3/13/0  = 13');
is(number_of_day_within_year('3/14/0'),           74,     'number of day within year 3/14/0  = 14');
is(number_of_day_within_year('3/15/0'),           75,     'number of day within year 3/15/0  = 15');
is(number_of_day_within_year('3/16/0'),           76,     'number of day within year 3/16/0  = 16');
is(number_of_day_within_year('3/17/0'),           77,     'number of day within year 3/17/0  = 17');
is(number_of_day_within_year('3/18/0'),           78,     'number of day within year 3/18/0  = 18');
is(number_of_day_within_year('3/19/0'),           79,     'number of day within year 3/19/0  = 19');
is(number_of_day_within_year('3/20/0'),           80,     'number of day within year 3/20/0  = 20');
is(number_of_day_within_year('3/21/0'),           81,     'number of day within year 3/21/0  = 21');
is(number_of_day_within_year('3/22/0'),           82,     'number of day within year 3/22/0  = 22');
is(number_of_day_within_year('3/23/0'),           83,     'number of day within year 3/23/0  = 23');
is(number_of_day_within_year('3/24/0'),           84,     'number of day within year 3/24/0  = 24');
is(number_of_day_within_year('3/25/0'),           85,     'number of day within year 3/25/0  = 25');
is(number_of_day_within_year('3/26/0'),           86,     'number of day within year 3/26/0  = 26');
is(number_of_day_within_year('3/27/0'),           87,     'number of day within year 3/27/0  = 27');
is(number_of_day_within_year('3/28/0'),           88,     'number of day within year 3/28/0  = 28');
is(number_of_day_within_year('3/29/0'),           89,     'number of day within year 3/29/0  = 29');
is(number_of_day_within_year('3/30/0'),           90,     'number of day within year 3/30/0  = 30');
is(number_of_day_within_year('3/31/0'),           91,     'number of day within year 3/31/0  = 31');
is(number_of_day_within_year('4/1/0'),            92,     'number of day within year 4/1/0   =  1');
is(number_of_day_within_year('4/2/0'),            93,     'number of day within year 4/2/0   =  2');
is(number_of_day_within_year('4/3/0'),            94,     'number of day within year 4/3/0   =  3');
is(number_of_day_within_year('4/4/0'),            95,     'number of day within year 4/4/0   =  4');
is(number_of_day_within_year('4/5/0'),            96,     'number of day within year 4/5/0   =  5');
is(number_of_day_within_year('4/6/0'),            97,     'number of day within year 4/6/0   =  6');
is(number_of_day_within_year('4/7/0'),            98,     'number of day within year 4/7/0   =  7');
is(number_of_day_within_year('4/8/0'),            99,     'number of day within year 4/8/0   =  8');
is(number_of_day_within_year('4/9/0'),           100,     'number of day within year 4/9/0   =  9');
is(number_of_day_within_year('4/10/0'),          101,     'number of day within year 4/10/0  = 10');
is(number_of_day_within_year('4/11/0'),          102,     'number of day within year 4/11/0  = 11');
is(number_of_day_within_year('4/12/0'),          103,     'number of day within year 4/12/0  = 12');
is(number_of_day_within_year('4/13/0'),          104,     'number of day within year 4/13/0  = 13');
is(number_of_day_within_year('4/14/0'),          105,     'number of day within year 4/14/0  = 14');
is(number_of_day_within_year('4/15/0'),          106,     'number of day within year 4/15/0  = 15');
is(number_of_day_within_year('4/16/0'),          107,     'number of day within year 4/16/0  = 16');
is(number_of_day_within_year('4/17/0'),          108,     'number of day within year 4/17/0  = 17');
is(number_of_day_within_year('4/18/0'),          109,     'number of day within year 4/18/0  = 18');
is(number_of_day_within_year('4/19/0'),          110,     'number of day within year 4/19/0  = 19');
is(number_of_day_within_year('4/20/0'),          111,     'number of day within year 4/20/0  = 20');
is(number_of_day_within_year('4/21/0'),          112,     'number of day within year 4/21/0  = 21');
is(number_of_day_within_year('4/22/0'),          113,     'number of day within year 4/22/0  = 22');
is(number_of_day_within_year('4/23/0'),          114,     'number of day within year 4/23/0  = 23');
is(number_of_day_within_year('4/24/0'),          115,     'number of day within year 4/24/0  = 24');
is(number_of_day_within_year('4/25/0'),          116,     'number of day within year 4/25/0  = 25');
is(number_of_day_within_year('4/26/0'),          117,     'number of day within year 4/26/0  = 26');
is(number_of_day_within_year('4/27/0'),          118,     'number of day within year 4/27/0  = 27');
is(number_of_day_within_year('4/28/0'),          119,     'number of day within year 4/28/0  = 28');
is(number_of_day_within_year('4/29/0'),          120,     'number of day within year 4/29/0  = 29');
is(number_of_day_within_year('4/30/0'),          121,     'number of day within year 4/30/0  = 30');
is(number_of_day_within_year('5/1/0'),           122,     'number of day within year 5/1/0   =  1');
is(number_of_day_within_year('5/2/0'),           123,     'number of day within year 5/2/0   =  2');
is(number_of_day_within_year('5/3/0'),           124,     'number of day within year 5/3/0   =  3');
is(number_of_day_within_year('5/4/0'),           125,     'number of day within year 5/4/0   =  4');
is(number_of_day_within_year('5/5/0'),           126,     'number of day within year 5/5/0   =  5');
is(number_of_day_within_year('5/6/0'),           127,     'number of day within year 5/6/0   =  6');
is(number_of_day_within_year('5/7/0'),           128,     'number of day within year 5/7/0   =  7');
is(number_of_day_within_year('5/8/0'),           129,     'number of day within year 5/8/0   =  8');
is(number_of_day_within_year('5/9/0'),           130,     'number of day within year 5/9/0   =  9');
is(number_of_day_within_year('5/10/0'),          131,     'number of day within year 5/10/0  = 10');
is(number_of_day_within_year('5/11/0'),          132,     'number of day within year 5/11/0  = 11');
is(number_of_day_within_year('5/12/0'),          133,     'number of day within year 5/12/0  = 12');
is(number_of_day_within_year('5/13/0'),          134,     'number of day within year 5/13/0  = 13');
is(number_of_day_within_year('5/14/0'),          135,     'number of day within year 5/14/0  = 14');
is(number_of_day_within_year('5/15/0'),          136,     'number of day within year 5/15/0  = 15');
is(number_of_day_within_year('5/16/0'),          137,     'number of day within year 5/16/0  = 16');
is(number_of_day_within_year('5/17/0'),          138,     'number of day within year 5/17/0  = 17');
is(number_of_day_within_year('5/18/0'),          139,     'number of day within year 5/18/0  = 18');
is(number_of_day_within_year('5/19/0'),          140,     'number of day within year 5/19/0  = 19');
is(number_of_day_within_year('5/20/0'),          141,     'number of day within year 5/20/0  = 20');
is(number_of_day_within_year('5/21/0'),          142,     'number of day within year 5/21/0  = 21');
is(number_of_day_within_year('5/22/0'),          143,     'number of day within year 5/22/0  = 22');
is(number_of_day_within_year('5/23/0'),          144,     'number of day within year 5/23/0  = 23');
is(number_of_day_within_year('5/24/0'),          145,     'number of day within year 5/24/0  = 24');
is(number_of_day_within_year('5/25/0'),          146,     'number of day within year 5/25/0  = 25');
is(number_of_day_within_year('5/26/0'),          147,     'number of day within year 5/26/0  = 26');
is(number_of_day_within_year('5/27/0'),          148,     'number of day within year 5/27/0  = 27');
is(number_of_day_within_year('5/28/0'),          149,     'number of day within year 5/28/0  = 28');
is(number_of_day_within_year('5/29/0'),          150,     'number of day within year 5/29/0  = 29');
is(number_of_day_within_year('5/30/0'),          151,     'number of day within year 5/30/0  = 30');
is(number_of_day_within_year('5/31/0'),          152,     'number of day within year 5/31/0  = 31');
is(number_of_day_within_year('6/1/0'),           153,     'number of day within year 6/1/0   =  1');
is(number_of_day_within_year('6/2/0'),           154,     'number of day within year 6/2/0   =  2');
is(number_of_day_within_year('6/3/0'),           155,     'number of day within year 6/3/0   =  3');
is(number_of_day_within_year('6/4/0'),           156,     'number of day within year 6/4/0   =  4');
is(number_of_day_within_year('6/5/0'),           157,     'number of day within year 6/5/0   =  5');
is(number_of_day_within_year('6/6/0'),           158,     'number of day within year 6/6/0   =  6');
is(number_of_day_within_year('6/7/0'),           159,     'number of day within year 6/7/0   =  7');
is(number_of_day_within_year('6/8/0'),           160,     'number of day within year 6/8/0   =  8');
is(number_of_day_within_year('6/9/0'),           161,     'number of day within year 6/9/0   =  9');
is(number_of_day_within_year('6/10/0'),          162,     'number of day within year 6/10/0  = 10');
is(number_of_day_within_year('6/11/0'),          163,     'number of day within year 6/11/0  = 11');
is(number_of_day_within_year('6/12/0'),          164,     'number of day within year 6/12/0  = 12');
is(number_of_day_within_year('6/13/0'),          165,     'number of day within year 6/13/0  = 13');
is(number_of_day_within_year('6/14/0'),          166,     'number of day within year 6/14/0  = 14');
is(number_of_day_within_year('6/15/0'),          167,     'number of day within year 6/15/0  = 15');
is(number_of_day_within_year('6/16/0'),          168,     'number of day within year 6/16/0  = 16');
is(number_of_day_within_year('6/17/0'),          169,     'number of day within year 6/17/0  = 17');
is(number_of_day_within_year('6/18/0'),          170,     'number of day within year 6/18/0  = 18');
is(number_of_day_within_year('6/19/0'),          171,     'number of day within year 6/19/0  = 19');
is(number_of_day_within_year('6/20/0'),          172,     'number of day within year 6/20/0  = 20');
is(number_of_day_within_year('6/21/0'),          173,     'number of day within year 6/21/0  = 21');
is(number_of_day_within_year('6/22/0'),          174,     'number of day within year 6/22/0  = 22');
is(number_of_day_within_year('6/23/0'),          175,     'number of day within year 6/23/0  = 23');
is(number_of_day_within_year('6/24/0'),          176,     'number of day within year 6/24/0  = 24');
is(number_of_day_within_year('6/25/0'),          177,     'number of day within year 6/25/0  = 25');
is(number_of_day_within_year('6/26/0'),          178,     'number of day within year 6/26/0  = 26');
is(number_of_day_within_year('6/27/0'),          179,     'number of day within year 6/27/0  = 27');
is(number_of_day_within_year('6/28/0'),          180,     'number of day within year 6/28/0  = 28');
is(number_of_day_within_year('6/29/0'),          181,     'number of day within year 6/29/0  = 29');
is(number_of_day_within_year('6/30/0'),          182,     'number of day within year 6/30/0  = 30');
is(number_of_day_within_year('7/1/0'),           183,     'number of day within year 7/1/0   =  1');
is(number_of_day_within_year('7/2/0'),           184,     'number of day within year 7/2/0   =  2');
is(number_of_day_within_year('7/3/0'),           185,     'number of day within year 7/3/0   =  3');
is(number_of_day_within_year('7/4/0'),           186,     'number of day within year 7/4/0   =  4');
is(number_of_day_within_year('7/5/0'),           187,     'number of day within year 7/5/0   =  5');
is(number_of_day_within_year('7/6/0'),           188,     'number of day within year 7/6/0   =  6');
is(number_of_day_within_year('7/7/0'),           189,     'number of day within year 7/7/0   =  7');
is(number_of_day_within_year('7/8/0'),           190,     'number of day within year 7/8/0   =  8');
is(number_of_day_within_year('7/9/0'),           191,     'number of day within year 7/9/0   =  9');
is(number_of_day_within_year('7/10/0'),          192,     'number of day within year 7/10/0  = 10');
is(number_of_day_within_year('7/11/0'),          193,     'number of day within year 7/11/0  = 11');
is(number_of_day_within_year('7/12/0'),          194,     'number of day within year 7/12/0  = 12');
is(number_of_day_within_year('7/13/0'),          195,     'number of day within year 7/13/0  = 13');
is(number_of_day_within_year('7/14/0'),          196,     'number of day within year 7/14/0  = 14');
is(number_of_day_within_year('7/15/0'),          197,     'number of day within year 7/15/0  = 15');
is(number_of_day_within_year('7/16/0'),          198,     'number of day within year 7/16/0  = 16');
is(number_of_day_within_year('7/17/0'),          199,     'number of day within year 7/17/0  = 17');
is(number_of_day_within_year('7/18/0'),          200,     'number of day within year 7/18/0  = 18');
is(number_of_day_within_year('7/19/0'),          201,     'number of day within year 7/19/0  = 19');
is(number_of_day_within_year('7/20/0'),          202,     'number of day within year 7/20/0  = 20');
is(number_of_day_within_year('7/21/0'),          203,     'number of day within year 7/21/0  = 21');
is(number_of_day_within_year('7/22/0'),          204,     'number of day within year 7/22/0  = 22');
is(number_of_day_within_year('7/23/0'),          205,     'number of day within year 7/23/0  = 23');
is(number_of_day_within_year('7/24/0'),          206,     'number of day within year 7/24/0  = 24');
is(number_of_day_within_year('7/25/0'),          207,     'number of day within year 7/25/0  = 25');
is(number_of_day_within_year('7/26/0'),          208,     'number of day within year 7/26/0  = 26');
is(number_of_day_within_year('7/27/0'),          209,     'number of day within year 7/27/0  = 27');
is(number_of_day_within_year('7/28/0'),          210,     'number of day within year 7/28/0  = 28');
is(number_of_day_within_year('7/29/0'),          211,     'number of day within year 7/29/0  = 29');
is(number_of_day_within_year('7/30/0'),          212,     'number of day within year 7/30/0  = 30');
is(number_of_day_within_year('7/31/0'),          213,     'number of day within year 7/31/0  = 31');
is(number_of_day_within_year('8/1/0'),           214,     'number of day within year 8/1/0   =  1');
is(number_of_day_within_year('8/2/0'),           215,     'number of day within year 8/2/0   =  2');
is(number_of_day_within_year('8/3/0'),           216,     'number of day within year 8/3/0   =  3');
is(number_of_day_within_year('8/4/0'),           217,     'number of day within year 8/4/0   =  4');
is(number_of_day_within_year('8/5/0'),           218,     'number of day within year 8/5/0   =  5');
is(number_of_day_within_year('8/6/0'),           219,     'number of day within year 8/6/0   =  6');
is(number_of_day_within_year('8/7/0'),           220,     'number of day within year 8/7/0   =  7');
is(number_of_day_within_year('8/8/0'),           221,     'number of day within year 8/8/0   =  8');
is(number_of_day_within_year('8/9/0'),           222,     'number of day within year 8/9/0   =  9');
is(number_of_day_within_year('8/10/0'),          223,     'number of day within year 8/10/0  = 10');
is(number_of_day_within_year('8/11/0'),          224,     'number of day within year 8/11/0  = 11');
is(number_of_day_within_year('8/12/0'),          225,     'number of day within year 8/12/0  = 12');
is(number_of_day_within_year('8/13/0'),          226,     'number of day within year 8/13/0  = 13');
is(number_of_day_within_year('8/14/0'),          227,     'number of day within year 8/14/0  = 14');
is(number_of_day_within_year('8/15/0'),          228,     'number of day within year 8/15/0  = 15');
is(number_of_day_within_year('8/16/0'),          229,     'number of day within year 8/16/0  = 16');
is(number_of_day_within_year('8/17/0'),          230,     'number of day within year 8/17/0  = 17');
is(number_of_day_within_year('8/18/0'),          231,     'number of day within year 8/18/0  = 18');
is(number_of_day_within_year('8/19/0'),          232,     'number of day within year 8/19/0  = 19');
is(number_of_day_within_year('8/20/0'),          233,     'number of day within year 8/20/0  = 20');
is(number_of_day_within_year('8/21/0'),          234,     'number of day within year 8/21/0  = 21');
is(number_of_day_within_year('8/22/0'),          235,     'number of day within year 8/22/0  = 22');
is(number_of_day_within_year('8/23/0'),          236,     'number of day within year 8/23/0  = 23');
is(number_of_day_within_year('8/24/0'),          237,     'number of day within year 8/24/0  = 24');
is(number_of_day_within_year('8/25/0'),          238,     'number of day within year 8/25/0  = 25');
is(number_of_day_within_year('8/26/0'),          239,     'number of day within year 8/26/0  = 26');
is(number_of_day_within_year('8/27/0'),          240,     'number of day within year 8/27/0  = 27');
is(number_of_day_within_year('8/28/0'),          241,     'number of day within year 8/28/0  = 28');
is(number_of_day_within_year('8/29/0'),          242,     'number of day within year 8/29/0  = 29');
is(number_of_day_within_year('8/30/0'),          243,     'number of day within year 8/30/0  = 30');
is(number_of_day_within_year('8/31/0'),          244,     'number of day within year 8/31/0  = 31');
is(number_of_day_within_year('9/1/0'),           245,     'number of day within year 9/1/0   =  1');
is(number_of_day_within_year('9/2/0'),           246,     'number of day within year 9/2/0   =  2');
is(number_of_day_within_year('9/3/0'),           247,     'number of day within year 9/3/0   =  3');
is(number_of_day_within_year('9/4/0'),           248,     'number of day within year 9/4/0   =  4');
is(number_of_day_within_year('9/5/0'),           249,     'number of day within year 9/5/0   =  5');
is(number_of_day_within_year('9/6/0'),           250,     'number of day within year 9/6/0   =  6');
is(number_of_day_within_year('9/7/0'),           251,     'number of day within year 9/7/0   =  7');
is(number_of_day_within_year('9/8/0'),           252,     'number of day within year 9/8/0   =  8');
is(number_of_day_within_year('9/9/0'),           253,     'number of day within year 9/9/0   =  9');
is(number_of_day_within_year('9/10/0'),          254,     'number of day within year 9/10/0  = 10');
is(number_of_day_within_year('9/11/0'),          255,     'number of day within year 9/11/0  = 11');
is(number_of_day_within_year('9/12/0'),          256,     'number of day within year 9/12/0  = 12');
is(number_of_day_within_year('9/13/0'),          257,     'number of day within year 9/13/0  = 13');
is(number_of_day_within_year('9/14/0'),          258,     'number of day within year 9/14/0  = 14');
is(number_of_day_within_year('9/15/0'),          259,     'number of day within year 9/15/0  = 15');
is(number_of_day_within_year('9/16/0'),          260,     'number of day within year 9/16/0  = 16');
is(number_of_day_within_year('9/17/0'),          261,     'number of day within year 9/17/0  = 17');
is(number_of_day_within_year('9/18/0'),          262,     'number of day within year 9/18/0  = 18');
is(number_of_day_within_year('9/19/0'),          263,     'number of day within year 9/19/0  = 19');
is(number_of_day_within_year('9/20/0'),          264,     'number of day within year 9/20/0  = 20');
is(number_of_day_within_year('9/21/0'),          265,     'number of day within year 9/21/0  = 21');
is(number_of_day_within_year('9/22/0'),          266,     'number of day within year 9/22/0  = 22');
is(number_of_day_within_year('9/23/0'),          267,     'number of day within year 9/23/0  = 23');
is(number_of_day_within_year('9/24/0'),          268,     'number of day within year 9/24/0  = 24');
is(number_of_day_within_year('9/25/0'),          269,     'number of day within year 9/25/0  = 25');
is(number_of_day_within_year('9/26/0'),          270,     'number of day within year 9/26/0  = 26');
is(number_of_day_within_year('9/27/0'),          271,     'number of day within year 9/27/0  = 27');
is(number_of_day_within_year('9/28/0'),          272,     'number of day within year 9/28/0  = 28');
is(number_of_day_within_year('9/29/0'),          273,     'number of day within year 9/29/0  = 29');
is(number_of_day_within_year('9/30/0'),          274,     'number of day within year 9/30/0  = 30');
is(number_of_day_within_year('10/1/0'),          275,     'number of day within year 10/1/0   =  1');
is(number_of_day_within_year('10/2/0'),          276,     'number of day within year 10/2/0   =  2');
is(number_of_day_within_year('10/3/0'),          277,     'number of day within year 10/3/0   =  3');
is(number_of_day_within_year('10/4/0'),          278,     'number of day within year 10/4/0   =  4');
is(number_of_day_within_year('10/5/0'),          279,     'number of day within year 10/5/0   =  5');
is(number_of_day_within_year('10/6/0'),          280,     'number of day within year 10/6/0   =  6');
is(number_of_day_within_year('10/7/0'),          281,     'number of day within year 10/7/0   =  7');
is(number_of_day_within_year('10/8/0'),          282,     'number of day within year 10/8/0   =  8');
is(number_of_day_within_year('10/9/0'),          283,     'number of day within year 10/9/0   =  9');
is(number_of_day_within_year('10/10/0'),         284,     'number of day within year 10/10/0  = 10');
is(number_of_day_within_year('10/11/0'),         285,     'number of day within year 10/11/0  = 11');
is(number_of_day_within_year('10/12/0'),         286,     'number of day within year 10/12/0  = 12');
is(number_of_day_within_year('10/13/0'),         287,     'number of day within year 10/13/0  = 13');
is(number_of_day_within_year('10/14/0'),         288,     'number of day within year 10/14/0  = 14');
is(number_of_day_within_year('10/15/0'),         289,     'number of day within year 10/15/0  = 15');
is(number_of_day_within_year('10/16/0'),         290,     'number of day within year 10/16/0  = 16');
is(number_of_day_within_year('10/17/0'),         291,     'number of day within year 10/17/0  = 17');
is(number_of_day_within_year('10/18/0'),         292,     'number of day within year 10/18/0  = 18');
is(number_of_day_within_year('10/19/0'),         293,     'number of day within year 10/19/0  = 19');
is(number_of_day_within_year('10/20/0'),         294,     'number of day within year 10/20/0  = 20');
is(number_of_day_within_year('10/21/0'),         295,     'number of day within year 10/21/0  = 21');
is(number_of_day_within_year('10/22/0'),         296,     'number of day within year 10/22/0  = 22');
is(number_of_day_within_year('10/23/0'),         297,     'number of day within year 10/23/0  = 23');
is(number_of_day_within_year('10/24/0'),         298,     'number of day within year 10/24/0  = 24');
is(number_of_day_within_year('10/25/0'),         299,     'number of day within year 10/25/0  = 25');
is(number_of_day_within_year('10/26/0'),         300,     'number of day within year 10/26/0  = 26');
is(number_of_day_within_year('10/27/0'),         301,     'number of day within year 10/27/0  = 27');
is(number_of_day_within_year('10/28/0'),         302,     'number of day within year 10/28/0  = 28');
is(number_of_day_within_year('10/29/0'),         303,     'number of day within year 10/29/0  = 29');
is(number_of_day_within_year('10/30/0'),         304,     'number of day within year 10/30/0  = 30');
is(number_of_day_within_year('10/31/0'),         305,     'number of day within year 10/31/0  = 31');
is(number_of_day_within_year('11/1/0'),          306,     'number of day within year 11/1/0   =  1');
is(number_of_day_within_year('11/2/0'),          307,     'number of day within year 11/2/0   =  2');
is(number_of_day_within_year('11/3/0'),          308,     'number of day within year 11/3/0   =  3');
is(number_of_day_within_year('11/4/0'),          309,     'number of day within year 11/4/0   =  4');
is(number_of_day_within_year('11/5/0'),          310,     'number of day within year 11/5/0   =  5');
is(number_of_day_within_year('11/6/0'),          311,     'number of day within year 11/6/0   =  6');
is(number_of_day_within_year('11/7/0'),          312,     'number of day within year 11/7/0   =  7');
is(number_of_day_within_year('11/8/0'),          313,     'number of day within year 11/8/0   =  8');
is(number_of_day_within_year('11/9/0'),          314,     'number of day within year 11/9/0   =  9');
is(number_of_day_within_year('11/10/0'),         315,     'number of day within year 11/10/0  = 10');
is(number_of_day_within_year('11/11/0'),         316,     'number of day within year 11/11/0  = 11');
is(number_of_day_within_year('11/12/0'),         317,     'number of day within year 11/12/0  = 12');
is(number_of_day_within_year('11/13/0'),         318,     'number of day within year 11/13/0  = 13');
is(number_of_day_within_year('11/14/0'),         319,     'number of day within year 11/14/0  = 14');
is(number_of_day_within_year('11/15/0'),         320,     'number of day within year 11/15/0  = 15');
is(number_of_day_within_year('11/16/0'),         321,     'number of day within year 11/16/0  = 16');
is(number_of_day_within_year('11/17/0'),         322,     'number of day within year 11/17/0  = 17');
is(number_of_day_within_year('11/18/0'),         323,     'number of day within year 11/18/0  = 18');
is(number_of_day_within_year('11/19/0'),         324,     'number of day within year 11/19/0  = 19');
is(number_of_day_within_year('11/20/0'),         325,     'number of day within year 11/20/0  = 20');
is(number_of_day_within_year('11/21/0'),         326,     'number of day within year 11/21/0  = 21');
is(number_of_day_within_year('11/22/0'),         327,     'number of day within year 11/22/0  = 22');
is(number_of_day_within_year('11/23/0'),         328,     'number of day within year 11/23/0  = 23');
is(number_of_day_within_year('11/24/0'),         329,     'number of day within year 11/24/0  = 24');
is(number_of_day_within_year('11/25/0'),         330,     'number of day within year 11/25/0  = 25');
is(number_of_day_within_year('11/26/0'),         331,     'number of day within year 11/26/0  = 26');
is(number_of_day_within_year('11/27/0'),         332,     'number of day within year 11/27/0  = 27');
is(number_of_day_within_year('11/28/0'),         333,     'number of day within year 11/28/0  = 28');
is(number_of_day_within_year('11/29/0'),         334,     'number of day within year 11/29/0  = 29');
is(number_of_day_within_year('11/30/0'),         335,     'number of day within year 11/30/0  = 30');
is(number_of_day_within_year('12/1/0'),          336,     'number of day within year 12/1/0   =  1');
is(number_of_day_within_year('12/2/0'),          337,     'number of day within year 12/2/0   =  2');
is(number_of_day_within_year('12/3/0'),          338,     'number of day within year 12/3/0   =  3');
is(number_of_day_within_year('12/4/0'),          339,     'number of day within year 12/4/0   =  4');
is(number_of_day_within_year('12/5/0'),          340,     'number of day within year 12/5/0   =  5');
is(number_of_day_within_year('12/6/0'),          341,     'number of day within year 12/6/0   =  6');
is(number_of_day_within_year('12/7/0'),          342,     'number of day within year 12/7/0   =  7');
is(number_of_day_within_year('12/8/0'),          343,     'number of day within year 12/8/0   =  8');
is(number_of_day_within_year('12/9/0'),          344,     'number of day within year 12/9/0   =  9');
is(number_of_day_within_year('12/10/0'),         345,     'number of day within year 12/10/0  = 10');
is(number_of_day_within_year('12/11/0'),         346,     'number of day within year 12/11/0  = 11');
is(number_of_day_within_year('12/12/0'),         347,     'number of day within year 12/12/0  = 12');
is(number_of_day_within_year('12/13/0'),         348,     'number of day within year 12/13/0  = 13');
is(number_of_day_within_year('12/14/0'),         349,     'number of day within year 12/14/0  = 14');
is(number_of_day_within_year('12/15/0'),         350,     'number of day within year 12/15/0  = 15');
is(number_of_day_within_year('12/16/0'),         351,     'number of day within year 12/16/0  = 16');
is(number_of_day_within_year('12/17/0'),         352,     'number of day within year 12/17/0  = 17');
is(number_of_day_within_year('12/18/0'),         353,     'number of day within year 12/18/0  = 18');
is(number_of_day_within_year('12/19/0'),         354,     'number of day within year 12/19/0  = 19');
is(number_of_day_within_year('12/20/0'),         355,     'number of day within year 12/20/0  = 20');
is(number_of_day_within_year('12/21/0'),         356,     'number of day within year 12/21/0  = 21');
is(number_of_day_within_year('12/22/0'),         357,     'number of day within year 12/22/0  = 22');
is(number_of_day_within_year('12/23/0'),         358,     'number of day within year 12/23/0  = 23');
is(number_of_day_within_year('12/24/0'),         359,     'number of day within year 12/24/0  = 24');
is(number_of_day_within_year('12/25/0'),         360,     'number of day within year 12/25/0  = 25');
is(number_of_day_within_year('12/26/0'),         361,     'number of day within year 12/26/0  = 26');
is(number_of_day_within_year('12/27/0'),         362,     'number of day within year 12/27/0  = 27');
is(number_of_day_within_year('12/28/0'),         363,     'number of day within year 12/28/0  = 28');
is(number_of_day_within_year('12/29/0'),         364,     'number of day within year 12/29/0  = 29');
is(number_of_day_within_year('12/30/0'),         365,     'number of day within year 12/30/0  = 30');
is(number_of_day_within_year('12/31/0'),         366,     'number of day within year 12/31/0  = 31');
is(number_of_day_within_year('1/1/1'),             1,     'number of day within year 1/1/1   =  1');
is(number_of_day_within_year('1/2/1'),             2,     'number of day within year 1/2/1   =  2');
is(number_of_day_within_year('1/3/1'),             3,     'number of day within year 1/3/1   =  3');
is(number_of_day_within_year('1/4/1'),             4,     'number of day within year 1/4/1   =  4');
is(number_of_day_within_year('1/5/1'),             5,     'number of day within year 1/5/1   =  5');
is(number_of_day_within_year('1/6/1'),             6,     'number of day within year 1/6/1   =  6');
is(number_of_day_within_year('1/7/1'),             7,     'number of day within year 1/7/1   =  7');
is(number_of_day_within_year('1/8/1'),             8,     'number of day within year 1/8/1   =  8');
is(number_of_day_within_year('1/9/1'),             9,     'number of day within year 1/9/1   =  9');
is(number_of_day_within_year('1/10/1'),           10,     'number of day within year 1/10/1  = 10');
is(number_of_day_within_year('1/11/1'),           11,     'number of day within year 1/11/1  = 11');
is(number_of_day_within_year('1/12/1'),           12,     'number of day within year 1/12/1  = 12');
is(number_of_day_within_year('1/13/1'),           13,     'number of day within year 1/13/1  = 13');
is(number_of_day_within_year('1/14/1'),           14,     'number of day within year 1/14/1  = 14');
is(number_of_day_within_year('1/15/1'),           15,     'number of day within year 1/15/1  = 15');
is(number_of_day_within_year('1/16/1'),           16,     'number of day within year 1/16/1  = 16');
is(number_of_day_within_year('1/17/1'),           17,     'number of day within year 1/17/1  = 17');
is(number_of_day_within_year('1/18/1'),           18,     'number of day within year 1/18/1  = 18');
is(number_of_day_within_year('1/19/1'),           19,     'number of day within year 1/19/1  = 19');
is(number_of_day_within_year('1/20/1'),           20,     'number of day within year 1/20/1  = 20');
is(number_of_day_within_year('1/21/1'),           21,     'number of day within year 1/21/1  = 21');
is(number_of_day_within_year('1/22/1'),           22,     'number of day within year 1/22/1  = 22');
is(number_of_day_within_year('1/23/1'),           23,     'number of day within year 1/23/1  = 23');
is(number_of_day_within_year('1/24/1'),           24,     'number of day within year 1/24/1  = 24');
is(number_of_day_within_year('1/25/1'),           25,     'number of day within year 1/25/1  = 25');
is(number_of_day_within_year('1/26/1'),           26,     'number of day within year 1/26/1  = 26');
is(number_of_day_within_year('1/27/1'),           27,     'number of day within year 1/27/1  = 27');
is(number_of_day_within_year('1/28/1'),           28,     'number of day within year 1/28/1  = 28');
is(number_of_day_within_year('1/29/1'),           29,     'number of day within year 1/29/1  = 29');
is(number_of_day_within_year('1/30/1'),           30,     'number of day within year 1/30/1  = 30');
is(number_of_day_within_year('1/31/1'),           31,     'number of day within year 1/31/1  = 31');
is(number_of_day_within_year('2/1/1'),            32,     'number of day within year 2/1/1   =  1');
is(number_of_day_within_year('2/2/1'),            33,     'number of day within year 2/2/1   =  2');
is(number_of_day_within_year('2/3/1'),            34,     'number of day within year 2/3/1   =  3');
is(number_of_day_within_year('2/4/1'),            35,     'number of day within year 2/4/1   =  4');
is(number_of_day_within_year('2/5/1'),            36,     'number of day within year 2/5/1   =  5');
is(number_of_day_within_year('2/6/1'),            37,     'number of day within year 2/6/1   =  6');
is(number_of_day_within_year('2/7/1'),            38,     'number of day within year 2/7/1   =  7');
is(number_of_day_within_year('2/8/1'),            39,     'number of day within year 2/8/1   =  8');
is(number_of_day_within_year('2/9/1'),            40,     'number of day within year 2/9/1   =  9');
is(number_of_day_within_year('2/10/1'),           41,     'number of day within year 2/10/1  = 10');
is(number_of_day_within_year('2/11/1'),           42,     'number of day within year 2/11/1  = 11');
is(number_of_day_within_year('2/12/1'),           43,     'number of day within year 2/12/1  = 12');
is(number_of_day_within_year('2/13/1'),           44,     'number of day within year 2/13/1  = 13');
is(number_of_day_within_year('2/14/1'),           45,     'number of day within year 2/14/1  = 14');
is(number_of_day_within_year('2/15/1'),           46,     'number of day within year 2/15/1  = 15');
is(number_of_day_within_year('2/16/1'),           47,     'number of day within year 2/16/1  = 16');
is(number_of_day_within_year('2/17/1'),           48,     'number of day within year 2/17/1  = 17');
is(number_of_day_within_year('2/18/1'),           49,     'number of day within year 2/18/1  = 18');
is(number_of_day_within_year('2/19/1'),           50,     'number of day within year 2/19/1  = 19');
is(number_of_day_within_year('2/20/1'),           51,     'number of day within year 2/20/1  = 20');
is(number_of_day_within_year('2/21/1'),           52,     'number of day within year 2/21/1  = 21');
is(number_of_day_within_year('2/22/1'),           53,     'number of day within year 2/22/1  = 22');
is(number_of_day_within_year('2/23/1'),           54,     'number of day within year 2/23/1  = 23');
is(number_of_day_within_year('2/24/1'),           55,     'number of day within year 2/24/1  = 24');
is(number_of_day_within_year('2/25/1'),           56,     'number of day within year 2/25/1  = 25');
is(number_of_day_within_year('2/26/1'),           57,     'number of day within year 2/26/1  = 26');
is(number_of_day_within_year('2/27/1'),           58,     'number of day within year 2/27/1  = 27');
is(number_of_day_within_year('2/28/1'),           59,     'number of day within year 2/28/1  = 28');
is(number_of_day_within_year('3/1/1'),            60,     'number of day within year 3/1/1   =  1');
is(number_of_day_within_year('3/2/1'),            61,     'number of day within year 3/2/1   =  2');
is(number_of_day_within_year('3/3/1'),            62,     'number of day within year 3/3/1   =  3');
is(number_of_day_within_year('3/4/1'),            63,     'number of day within year 3/4/1   =  4');
is(number_of_day_within_year('3/5/1'),            64,     'number of day within year 3/5/1   =  5');
is(number_of_day_within_year('3/6/1'),            65,     'number of day within year 3/6/1   =  6');
is(number_of_day_within_year('3/7/1'),            66,     'number of day within year 3/7/1   =  7');
is(number_of_day_within_year('3/8/1'),            67,     'number of day within year 3/8/1   =  8');
is(number_of_day_within_year('3/9/1'),            68,     'number of day within year 3/9/1   =  9');
is(number_of_day_within_year('3/10/1'),           69,     'number of day within year 3/10/1  = 10');
is(number_of_day_within_year('3/11/1'),           70,     'number of day within year 3/11/1  = 11');
is(number_of_day_within_year('3/12/1'),           71,     'number of day within year 3/12/1  = 12');
is(number_of_day_within_year('3/13/1'),           72,     'number of day within year 3/13/1  = 13');
is(number_of_day_within_year('3/14/1'),           73,     'number of day within year 3/14/1  = 14');
is(number_of_day_within_year('3/15/1'),           74,     'number of day within year 3/15/1  = 15');
is(number_of_day_within_year('3/16/1'),           75,     'number of day within year 3/16/1  = 16');
is(number_of_day_within_year('3/17/1'),           76,     'number of day within year 3/17/1  = 17');
is(number_of_day_within_year('3/18/1'),           77,     'number of day within year 3/18/1  = 18');
is(number_of_day_within_year('3/19/1'),           78,     'number of day within year 3/19/1  = 19');
is(number_of_day_within_year('3/20/1'),           79,     'number of day within year 3/20/1  = 20');
is(number_of_day_within_year('3/21/1'),           80,     'number of day within year 3/21/1  = 21');
is(number_of_day_within_year('3/22/1'),           81,     'number of day within year 3/22/1  = 22');
is(number_of_day_within_year('3/23/1'),           82,     'number of day within year 3/23/1  = 23');
is(number_of_day_within_year('3/24/1'),           83,     'number of day within year 3/24/1  = 24');
is(number_of_day_within_year('3/25/1'),           84,     'number of day within year 3/25/1  = 25');
is(number_of_day_within_year('3/26/1'),           85,     'number of day within year 3/26/1  = 26');
is(number_of_day_within_year('3/27/1'),           86,     'number of day within year 3/27/1  = 27');
is(number_of_day_within_year('3/28/1'),           87,     'number of day within year 3/28/1  = 28');
is(number_of_day_within_year('3/29/1'),           88,     'number of day within year 3/29/1  = 29');
is(number_of_day_within_year('3/30/1'),           89,     'number of day within year 3/30/1  = 30');
is(number_of_day_within_year('3/31/1'),           90,     'number of day within year 3/31/1  = 31');
is(number_of_day_within_year('4/1/1'),            91,     'number of day within year 4/1/1   =  1');
is(number_of_day_within_year('4/2/1'),            92,     'number of day within year 4/2/1   =  2');
is(number_of_day_within_year('4/3/1'),            93,     'number of day within year 4/3/1   =  3');
is(number_of_day_within_year('4/4/1'),            94,     'number of day within year 4/4/1   =  4');
is(number_of_day_within_year('4/5/1'),            95,     'number of day within year 4/5/1   =  5');
is(number_of_day_within_year('4/6/1'),            96,     'number of day within year 4/6/1   =  6');
is(number_of_day_within_year('4/7/1'),            97,     'number of day within year 4/7/1   =  7');
is(number_of_day_within_year('4/8/1'),            98,     'number of day within year 4/8/1   =  8');
is(number_of_day_within_year('4/9/1'),            99,     'number of day within year 4/9/1   =  9');
is(number_of_day_within_year('4/10/1'),          100,     'number of day within year 4/10/1  = 10');
is(number_of_day_within_year('4/11/1'),          101,     'number of day within year 4/11/1  = 11');
is(number_of_day_within_year('4/12/1'),          102,     'number of day within year 4/12/1  = 12');
is(number_of_day_within_year('4/13/1'),          103,     'number of day within year 4/13/1  = 13');
is(number_of_day_within_year('4/14/1'),          104,     'number of day within year 4/14/1  = 14');
is(number_of_day_within_year('4/15/1'),          105,     'number of day within year 4/15/1  = 15');
is(number_of_day_within_year('4/16/1'),          106,     'number of day within year 4/16/1  = 16');
is(number_of_day_within_year('4/17/1'),          107,     'number of day within year 4/17/1  = 17');
is(number_of_day_within_year('4/18/1'),          108,     'number of day within year 4/18/1  = 18');
is(number_of_day_within_year('4/19/1'),          109,     'number of day within year 4/19/1  = 19');
is(number_of_day_within_year('4/20/1'),          110,     'number of day within year 4/20/1  = 20');
is(number_of_day_within_year('4/21/1'),          111,     'number of day within year 4/21/1  = 21');
is(number_of_day_within_year('4/22/1'),          112,     'number of day within year 4/22/1  = 22');
is(number_of_day_within_year('4/23/1'),          113,     'number of day within year 4/23/1  = 23');
is(number_of_day_within_year('4/24/1'),          114,     'number of day within year 4/24/1  = 24');
is(number_of_day_within_year('4/25/1'),          115,     'number of day within year 4/25/1  = 25');
is(number_of_day_within_year('4/26/1'),          116,     'number of day within year 4/26/1  = 26');
is(number_of_day_within_year('4/27/1'),          117,     'number of day within year 4/27/1  = 27');
is(number_of_day_within_year('4/28/1'),          118,     'number of day within year 4/28/1  = 28');
is(number_of_day_within_year('4/29/1'),          119,     'number of day within year 4/29/1  = 29');
is(number_of_day_within_year('4/30/1'),          120,     'number of day within year 4/30/1  = 30');
is(number_of_day_within_year('5/1/1'),           121,     'number of day within year 5/1/1   =  1');
is(number_of_day_within_year('5/2/1'),           122,     'number of day within year 5/2/1   =  2');
is(number_of_day_within_year('5/3/1'),           123,     'number of day within year 5/3/1   =  3');
is(number_of_day_within_year('5/4/1'),           124,     'number of day within year 5/4/1   =  4');
is(number_of_day_within_year('5/5/1'),           125,     'number of day within year 5/5/1   =  5');
is(number_of_day_within_year('5/6/1'),           126,     'number of day within year 5/6/1   =  6');
is(number_of_day_within_year('5/7/1'),           127,     'number of day within year 5/7/1   =  7');
is(number_of_day_within_year('5/8/1'),           128,     'number of day within year 5/8/1   =  8');
is(number_of_day_within_year('5/9/1'),           129,     'number of day within year 5/9/1   =  9');
is(number_of_day_within_year('5/10/1'),          130,     'number of day within year 5/10/1  = 10');
is(number_of_day_within_year('5/11/1'),          131,     'number of day within year 5/11/1  = 11');
is(number_of_day_within_year('5/12/1'),          132,     'number of day within year 5/12/1  = 12');
is(number_of_day_within_year('5/13/1'),          133,     'number of day within year 5/13/1  = 13');
is(number_of_day_within_year('5/14/1'),          134,     'number of day within year 5/14/1  = 14');
is(number_of_day_within_year('5/15/1'),          135,     'number of day within year 5/15/1  = 15');
is(number_of_day_within_year('5/16/1'),          136,     'number of day within year 5/16/1  = 16');
is(number_of_day_within_year('5/17/1'),          137,     'number of day within year 5/17/1  = 17');
is(number_of_day_within_year('5/18/1'),          138,     'number of day within year 5/18/1  = 18');
is(number_of_day_within_year('5/19/1'),          139,     'number of day within year 5/19/1  = 19');
is(number_of_day_within_year('5/20/1'),          140,     'number of day within year 5/20/1  = 20');
is(number_of_day_within_year('5/21/1'),          141,     'number of day within year 5/21/1  = 21');
is(number_of_day_within_year('5/22/1'),          142,     'number of day within year 5/22/1  = 22');
is(number_of_day_within_year('5/23/1'),          143,     'number of day within year 5/23/1  = 23');
is(number_of_day_within_year('5/24/1'),          144,     'number of day within year 5/24/1  = 24');
is(number_of_day_within_year('5/25/1'),          145,     'number of day within year 5/25/1  = 25');
is(number_of_day_within_year('5/26/1'),          146,     'number of day within year 5/26/1  = 26');
is(number_of_day_within_year('5/27/1'),          147,     'number of day within year 5/27/1  = 27');
is(number_of_day_within_year('5/28/1'),          148,     'number of day within year 5/28/1  = 28');
is(number_of_day_within_year('5/29/1'),          149,     'number of day within year 5/29/1  = 29');
is(number_of_day_within_year('5/30/1'),          150,     'number of day within year 5/30/1  = 30');
is(number_of_day_within_year('5/31/1'),          151,     'number of day within year 5/31/1  = 31');
is(number_of_day_within_year('6/1/1'),           152,     'number of day within year 6/1/1   =  1');
is(number_of_day_within_year('6/2/1'),           153,     'number of day within year 6/2/1   =  2');
is(number_of_day_within_year('6/3/1'),           154,     'number of day within year 6/3/1   =  3');
is(number_of_day_within_year('6/4/1'),           155,     'number of day within year 6/4/1   =  4');
is(number_of_day_within_year('6/5/1'),           156,     'number of day within year 6/5/1   =  5');
is(number_of_day_within_year('6/6/1'),           157,     'number of day within year 6/6/1   =  6');
is(number_of_day_within_year('6/7/1'),           158,     'number of day within year 6/7/1   =  7');
is(number_of_day_within_year('6/8/1'),           159,     'number of day within year 6/8/1   =  8');
is(number_of_day_within_year('6/9/1'),           160,     'number of day within year 6/9/1   =  9');
is(number_of_day_within_year('6/10/1'),          161,     'number of day within year 6/10/1  = 10');
is(number_of_day_within_year('6/11/1'),          162,     'number of day within year 6/11/1  = 11');
is(number_of_day_within_year('6/12/1'),          163,     'number of day within year 6/12/1  = 12');
is(number_of_day_within_year('6/13/1'),          164,     'number of day within year 6/13/1  = 13');
is(number_of_day_within_year('6/14/1'),          165,     'number of day within year 6/14/1  = 14');
is(number_of_day_within_year('6/15/1'),          166,     'number of day within year 6/15/1  = 15');
is(number_of_day_within_year('6/16/1'),          167,     'number of day within year 6/16/1  = 16');
is(number_of_day_within_year('6/17/1'),          168,     'number of day within year 6/17/1  = 17');
is(number_of_day_within_year('6/18/1'),          169,     'number of day within year 6/18/1  = 18');
is(number_of_day_within_year('6/19/1'),          170,     'number of day within year 6/19/1  = 19');
is(number_of_day_within_year('6/20/1'),          171,     'number of day within year 6/20/1  = 20');
is(number_of_day_within_year('6/21/1'),          172,     'number of day within year 6/21/1  = 21');
is(number_of_day_within_year('6/22/1'),          173,     'number of day within year 6/22/1  = 22');
is(number_of_day_within_year('6/23/1'),          174,     'number of day within year 6/23/1  = 23');
is(number_of_day_within_year('6/24/1'),          175,     'number of day within year 6/24/1  = 24');
is(number_of_day_within_year('6/25/1'),          176,     'number of day within year 6/25/1  = 25');
is(number_of_day_within_year('6/26/1'),          177,     'number of day within year 6/26/1  = 26');
is(number_of_day_within_year('6/27/1'),          178,     'number of day within year 6/27/1  = 27');
is(number_of_day_within_year('6/28/1'),          179,     'number of day within year 6/28/1  = 28');
is(number_of_day_within_year('6/29/1'),          180,     'number of day within year 6/29/1  = 29');
is(number_of_day_within_year('6/30/1'),          181,     'number of day within year 6/30/1  = 30');
is(number_of_day_within_year('7/1/1'),           182,     'number of day within year 7/1/1   =  1');
is(number_of_day_within_year('7/2/1'),           183,     'number of day within year 7/2/1   =  2');
is(number_of_day_within_year('7/3/1'),           184,     'number of day within year 7/3/1   =  3');
is(number_of_day_within_year('7/4/1'),           185,     'number of day within year 7/4/1   =  4');
is(number_of_day_within_year('7/5/1'),           186,     'number of day within year 7/5/1   =  5');
is(number_of_day_within_year('7/6/1'),           187,     'number of day within year 7/6/1   =  6');
is(number_of_day_within_year('7/7/1'),           188,     'number of day within year 7/7/1   =  7');
is(number_of_day_within_year('7/8/1'),           189,     'number of day within year 7/8/1   =  8');
is(number_of_day_within_year('7/9/1'),           190,     'number of day within year 7/9/1   =  9');
is(number_of_day_within_year('7/10/1'),          191,     'number of day within year 7/10/1  = 10');
is(number_of_day_within_year('7/11/1'),          192,     'number of day within year 7/11/1  = 11');
is(number_of_day_within_year('7/12/1'),          193,     'number of day within year 7/12/1  = 12');
is(number_of_day_within_year('7/13/1'),          194,     'number of day within year 7/13/1  = 13');
is(number_of_day_within_year('7/14/1'),          195,     'number of day within year 7/14/1  = 14');
is(number_of_day_within_year('7/15/1'),          196,     'number of day within year 7/15/1  = 15');
is(number_of_day_within_year('7/16/1'),          197,     'number of day within year 7/16/1  = 16');
is(number_of_day_within_year('7/17/1'),          198,     'number of day within year 7/17/1  = 17');
is(number_of_day_within_year('7/18/1'),          199,     'number of day within year 7/18/1  = 18');
is(number_of_day_within_year('7/19/1'),          200,     'number of day within year 7/19/1  = 19');
is(number_of_day_within_year('7/20/1'),          201,     'number of day within year 7/20/1  = 20');
is(number_of_day_within_year('7/21/1'),          202,     'number of day within year 7/21/1  = 21');
is(number_of_day_within_year('7/22/1'),          203,     'number of day within year 7/22/1  = 22');
is(number_of_day_within_year('7/23/1'),          204,     'number of day within year 7/23/1  = 23');
is(number_of_day_within_year('7/24/1'),          205,     'number of day within year 7/24/1  = 24');
is(number_of_day_within_year('7/25/1'),          206,     'number of day within year 7/25/1  = 25');
is(number_of_day_within_year('7/26/1'),          207,     'number of day within year 7/26/1  = 26');
is(number_of_day_within_year('7/27/1'),          208,     'number of day within year 7/27/1  = 27');
is(number_of_day_within_year('7/28/1'),          209,     'number of day within year 7/28/1  = 28');
is(number_of_day_within_year('7/29/1'),          210,     'number of day within year 7/29/1  = 29');
is(number_of_day_within_year('7/30/1'),          211,     'number of day within year 7/30/1  = 30');
is(number_of_day_within_year('7/31/1'),          212,     'number of day within year 7/31/1  = 31');
is(number_of_day_within_year('8/1/1'),           213,     'number of day within year 8/1/1   =  1');
is(number_of_day_within_year('8/2/1'),           214,     'number of day within year 8/2/1   =  2');
is(number_of_day_within_year('8/3/1'),           215,     'number of day within year 8/3/1   =  3');
is(number_of_day_within_year('8/4/1'),           216,     'number of day within year 8/4/1   =  4');
is(number_of_day_within_year('8/5/1'),           217,     'number of day within year 8/5/1   =  5');
is(number_of_day_within_year('8/6/1'),           218,     'number of day within year 8/6/1   =  6');
is(number_of_day_within_year('8/7/1'),           219,     'number of day within year 8/7/1   =  7');
is(number_of_day_within_year('8/8/1'),           220,     'number of day within year 8/8/1   =  8');
is(number_of_day_within_year('8/9/1'),           221,     'number of day within year 8/9/1   =  9');
is(number_of_day_within_year('8/10/1'),          222,     'number of day within year 8/10/1  = 10');
is(number_of_day_within_year('8/11/1'),          223,     'number of day within year 8/11/1  = 11');
is(number_of_day_within_year('8/12/1'),          224,     'number of day within year 8/12/1  = 12');
is(number_of_day_within_year('8/13/1'),          225,     'number of day within year 8/13/1  = 13');
is(number_of_day_within_year('8/14/1'),          226,     'number of day within year 8/14/1  = 14');
is(number_of_day_within_year('8/15/1'),          227,     'number of day within year 8/15/1  = 15');
is(number_of_day_within_year('8/16/1'),          228,     'number of day within year 8/16/1  = 16');
is(number_of_day_within_year('8/17/1'),          229,     'number of day within year 8/17/1  = 17');
is(number_of_day_within_year('8/18/1'),          230,     'number of day within year 8/18/1  = 18');
is(number_of_day_within_year('8/19/1'),          231,     'number of day within year 8/19/1  = 19');
is(number_of_day_within_year('8/20/1'),          232,     'number of day within year 8/20/1  = 20');
is(number_of_day_within_year('8/21/1'),          233,     'number of day within year 8/21/1  = 21');
is(number_of_day_within_year('8/22/1'),          234,     'number of day within year 8/22/1  = 22');
is(number_of_day_within_year('8/23/1'),          235,     'number of day within year 8/23/1  = 23');
is(number_of_day_within_year('8/24/1'),          236,     'number of day within year 8/24/1  = 24');
is(number_of_day_within_year('8/25/1'),          237,     'number of day within year 8/25/1  = 25');
is(number_of_day_within_year('8/26/1'),          238,     'number of day within year 8/26/1  = 26');
is(number_of_day_within_year('8/27/1'),          239,     'number of day within year 8/27/1  = 27');
is(number_of_day_within_year('8/28/1'),          240,     'number of day within year 8/28/1  = 28');
is(number_of_day_within_year('8/29/1'),          241,     'number of day within year 8/29/1  = 29');
is(number_of_day_within_year('8/30/1'),          242,     'number of day within year 8/30/1  = 30');
is(number_of_day_within_year('8/31/1'),          243,     'number of day within year 8/31/1  = 31');
is(number_of_day_within_year('9/1/1'),           244,     'number of day within year 9/1/1   =  1');
is(number_of_day_within_year('9/2/1'),           245,     'number of day within year 9/2/1   =  2');
is(number_of_day_within_year('9/3/1'),           246,     'number of day within year 9/3/1   =  3');
is(number_of_day_within_year('9/4/1'),           247,     'number of day within year 9/4/1   =  4');
is(number_of_day_within_year('9/5/1'),           248,     'number of day within year 9/5/1   =  5');
is(number_of_day_within_year('9/6/1'),           249,     'number of day within year 9/6/1   =  6');
is(number_of_day_within_year('9/7/1'),           250,     'number of day within year 9/7/1   =  7');
is(number_of_day_within_year('9/8/1'),           251,     'number of day within year 9/8/1   =  8');
is(number_of_day_within_year('9/9/1'),           252,     'number of day within year 9/9/1   =  9');
is(number_of_day_within_year('9/10/1'),          253,     'number of day within year 9/10/1  = 10');
is(number_of_day_within_year('9/11/1'),          254,     'number of day within year 9/11/1  = 11');
is(number_of_day_within_year('9/12/1'),          255,     'number of day within year 9/12/1  = 12');
is(number_of_day_within_year('9/13/1'),          256,     'number of day within year 9/13/1  = 13');
is(number_of_day_within_year('9/14/1'),          257,     'number of day within year 9/14/1  = 14');
is(number_of_day_within_year('9/15/1'),          258,     'number of day within year 9/15/1  = 15');
is(number_of_day_within_year('9/16/1'),          259,     'number of day within year 9/16/1  = 16');
is(number_of_day_within_year('9/17/1'),          260,     'number of day within year 9/17/1  = 17');
is(number_of_day_within_year('9/18/1'),          261,     'number of day within year 9/18/1  = 18');
is(number_of_day_within_year('9/19/1'),          262,     'number of day within year 9/19/1  = 19');
is(number_of_day_within_year('9/20/1'),          263,     'number of day within year 9/20/1  = 20');
is(number_of_day_within_year('9/21/1'),          264,     'number of day within year 9/21/1  = 21');
is(number_of_day_within_year('9/22/1'),          265,     'number of day within year 9/22/1  = 22');
is(number_of_day_within_year('9/23/1'),          266,     'number of day within year 9/23/1  = 23');
is(number_of_day_within_year('9/24/1'),          267,     'number of day within year 9/24/1  = 24');
is(number_of_day_within_year('9/25/1'),          268,     'number of day within year 9/25/1  = 25');
is(number_of_day_within_year('9/26/1'),          269,     'number of day within year 9/26/1  = 26');
is(number_of_day_within_year('9/27/1'),          270,     'number of day within year 9/27/1  = 27');
is(number_of_day_within_year('9/28/1'),          271,     'number of day within year 9/28/1  = 28');
is(number_of_day_within_year('9/29/1'),          272,     'number of day within year 9/29/1  = 29');
is(number_of_day_within_year('9/30/1'),          273,     'number of day within year 9/30/1  = 30');
is(number_of_day_within_year('10/1/1'),          274,     'number of day within year 10/1/1   =  1');
is(number_of_day_within_year('10/2/1'),          275,     'number of day within year 10/2/1   =  2');
is(number_of_day_within_year('10/3/1'),          276,     'number of day within year 10/3/1   =  3');
is(number_of_day_within_year('10/4/1'),          277,     'number of day within year 10/4/1   =  4');
is(number_of_day_within_year('10/5/1'),          278,     'number of day within year 10/5/1   =  5');
is(number_of_day_within_year('10/6/1'),          279,     'number of day within year 10/6/1   =  6');
is(number_of_day_within_year('10/7/1'),          280,     'number of day within year 10/7/1   =  7');
is(number_of_day_within_year('10/8/1'),          281,     'number of day within year 10/8/1   =  8');
is(number_of_day_within_year('10/9/1'),          282,     'number of day within year 10/9/1   =  9');
is(number_of_day_within_year('10/10/1'),         283,     'number of day within year 10/10/1  = 10');
is(number_of_day_within_year('10/11/1'),         284,     'number of day within year 10/11/1  = 11');
is(number_of_day_within_year('10/12/1'),         285,     'number of day within year 10/12/1  = 12');
is(number_of_day_within_year('10/13/1'),         286,     'number of day within year 10/13/1  = 13');
is(number_of_day_within_year('10/14/1'),         287,     'number of day within year 10/14/1  = 14');
is(number_of_day_within_year('10/15/1'),         288,     'number of day within year 10/15/1  = 15');
is(number_of_day_within_year('10/16/1'),         289,     'number of day within year 10/16/1  = 16');
is(number_of_day_within_year('10/17/1'),         290,     'number of day within year 10/17/1  = 17');
is(number_of_day_within_year('10/18/1'),         291,     'number of day within year 10/18/1  = 18');
is(number_of_day_within_year('10/19/1'),         292,     'number of day within year 10/19/1  = 19');
is(number_of_day_within_year('10/20/1'),         293,     'number of day within year 10/20/1  = 20');
is(number_of_day_within_year('10/21/1'),         294,     'number of day within year 10/21/1  = 21');
is(number_of_day_within_year('10/22/1'),         295,     'number of day within year 10/22/1  = 22');
is(number_of_day_within_year('10/23/1'),         296,     'number of day within year 10/23/1  = 23');
is(number_of_day_within_year('10/24/1'),         297,     'number of day within year 10/24/1  = 24');
is(number_of_day_within_year('10/25/1'),         298,     'number of day within year 10/25/1  = 25');
is(number_of_day_within_year('10/26/1'),         299,     'number of day within year 10/26/1  = 26');
is(number_of_day_within_year('10/27/1'),         300,     'number of day within year 10/27/1  = 27');
is(number_of_day_within_year('10/28/1'),         301,     'number of day within year 10/28/1  = 28');
is(number_of_day_within_year('10/29/1'),         302,     'number of day within year 10/29/1  = 29');
is(number_of_day_within_year('10/30/1'),         303,     'number of day within year 10/30/1  = 30');
is(number_of_day_within_year('10/31/1'),         304,     'number of day within year 10/31/1  = 31');
is(number_of_day_within_year('11/1/1'),          305,     'number of day within year 11/1/1   =  1');
is(number_of_day_within_year('11/2/1'),          306,     'number of day within year 11/2/1   =  2');
is(number_of_day_within_year('11/3/1'),          307,     'number of day within year 11/3/1   =  3');
is(number_of_day_within_year('11/4/1'),          308,     'number of day within year 11/4/1   =  4');
is(number_of_day_within_year('11/5/1'),          309,     'number of day within year 11/5/1   =  5');
is(number_of_day_within_year('11/6/1'),          310,     'number of day within year 11/6/1   =  6');
is(number_of_day_within_year('11/7/1'),          311,     'number of day within year 11/7/1   =  7');
is(number_of_day_within_year('11/8/1'),          312,     'number of day within year 11/8/1   =  8');
is(number_of_day_within_year('11/9/1'),          313,     'number of day within year 11/9/1   =  9');
is(number_of_day_within_year('11/10/1'),         314,     'number of day within year 11/10/1  = 10');
is(number_of_day_within_year('11/11/1'),         315,     'number of day within year 11/11/1  = 11');
is(number_of_day_within_year('11/12/1'),         316,     'number of day within year 11/12/1  = 12');
is(number_of_day_within_year('11/13/1'),         317,     'number of day within year 11/13/1  = 13');
is(number_of_day_within_year('11/14/1'),         318,     'number of day within year 11/14/1  = 14');
is(number_of_day_within_year('11/15/1'),         319,     'number of day within year 11/15/1  = 15');
is(number_of_day_within_year('11/16/1'),         320,     'number of day within year 11/16/1  = 16');
is(number_of_day_within_year('11/17/1'),         321,     'number of day within year 11/17/1  = 17');
is(number_of_day_within_year('11/18/1'),         322,     'number of day within year 11/18/1  = 18');
is(number_of_day_within_year('11/19/1'),         323,     'number of day within year 11/19/1  = 19');
is(number_of_day_within_year('11/20/1'),         324,     'number of day within year 11/20/1  = 20');
is(number_of_day_within_year('11/21/1'),         325,     'number of day within year 11/21/1  = 21');
is(number_of_day_within_year('11/22/1'),         326,     'number of day within year 11/22/1  = 22');
is(number_of_day_within_year('11/23/1'),         327,     'number of day within year 11/23/1  = 23');
is(number_of_day_within_year('11/24/1'),         328,     'number of day within year 11/24/1  = 24');
is(number_of_day_within_year('11/25/1'),         329,     'number of day within year 11/25/1  = 25');
is(number_of_day_within_year('11/26/1'),         330,     'number of day within year 11/26/1  = 26');
is(number_of_day_within_year('11/27/1'),         331,     'number of day within year 11/27/1  = 27');
is(number_of_day_within_year('11/28/1'),         332,     'number of day within year 11/28/1  = 28');
is(number_of_day_within_year('11/29/1'),         333,     'number of day within year 11/29/1  = 29');
is(number_of_day_within_year('11/30/1'),         334,     'number of day within year 11/30/1  = 30');
is(number_of_day_within_year('12/1/1'),          335,     'number of day within year 12/1/1   =  1');
is(number_of_day_within_year('12/2/1'),          336,     'number of day within year 12/2/1   =  2');
is(number_of_day_within_year('12/3/1'),          337,     'number of day within year 12/3/1   =  3');
is(number_of_day_within_year('12/4/1'),          338,     'number of day within year 12/4/1   =  4');
is(number_of_day_within_year('12/5/1'),          339,     'number of day within year 12/5/1   =  5');
is(number_of_day_within_year('12/6/1'),          340,     'number of day within year 12/6/1   =  6');
is(number_of_day_within_year('12/7/1'),          341,     'number of day within year 12/7/1   =  7');
is(number_of_day_within_year('12/8/1'),          342,     'number of day within year 12/8/1   =  8');
is(number_of_day_within_year('12/9/1'),          343,     'number of day within year 12/9/1   =  9');
is(number_of_day_within_year('12/10/1'),         344,     'number of day within year 12/10/1  = 10');
is(number_of_day_within_year('12/11/1'),         345,     'number of day within year 12/11/1  = 11');
is(number_of_day_within_year('12/12/1'),         346,     'number of day within year 12/12/1  = 12');
is(number_of_day_within_year('12/13/1'),         347,     'number of day within year 12/13/1  = 13');
is(number_of_day_within_year('12/14/1'),         348,     'number of day within year 12/14/1  = 14');
is(number_of_day_within_year('12/15/1'),         349,     'number of day within year 12/15/1  = 15');
is(number_of_day_within_year('12/16/1'),         350,     'number of day within year 12/16/1  = 16');
is(number_of_day_within_year('12/17/1'),         351,     'number of day within year 12/17/1  = 17');
is(number_of_day_within_year('12/18/1'),         352,     'number of day within year 12/18/1  = 18');
is(number_of_day_within_year('12/19/1'),         353,     'number of day within year 12/19/1  = 19');
is(number_of_day_within_year('12/20/1'),         354,     'number of day within year 12/20/1  = 20');
is(number_of_day_within_year('12/21/1'),         355,     'number of day within year 12/21/1  = 21');
is(number_of_day_within_year('12/22/1'),         356,     'number of day within year 12/22/1  = 22');
is(number_of_day_within_year('12/23/1'),         357,     'number of day within year 12/23/1  = 23');
is(number_of_day_within_year('12/24/1'),         358,     'number of day within year 12/24/1  = 24');
is(number_of_day_within_year('12/25/1'),         359,     'number of day within year 12/25/1  = 25');
is(number_of_day_within_year('12/26/1'),         360,     'number of day within year 12/26/1  = 26');
is(number_of_day_within_year('12/27/1'),         361,     'number of day within year 12/27/1  = 27');
is(number_of_day_within_year('12/28/1'),         362,     'number of day within year 12/28/1  = 28');
is(number_of_day_within_year('12/29/1'),         363,     'number of day within year 12/29/1  = 29');
is(number_of_day_within_year('12/30/1'),         364,     'number of day within year 12/30/1  = 30');
is(number_of_day_within_year('12/31/1'),         365,     'number of day within year 12/31/1  = 31');
is(number_of_day_within_year('1/1/2000'),             1,     'number of day within year 1/1/2000   =  1');
is(number_of_day_within_year('1/2/2000'),             2,     'number of day within year 1/2/2000   =  2');
is(number_of_day_within_year('1/3/2000'),             3,     'number of day within year 1/3/2000   =  3');
is(number_of_day_within_year('1/4/2000'),             4,     'number of day within year 1/4/2000   =  4');
is(number_of_day_within_year('1/5/2000'),             5,     'number of day within year 1/5/2000   =  5');
is(number_of_day_within_year('1/6/2000'),             6,     'number of day within year 1/6/2000   =  6');
is(number_of_day_within_year('1/7/2000'),             7,     'number of day within year 1/7/2000   =  7');
is(number_of_day_within_year('1/8/2000'),             8,     'number of day within year 1/8/2000   =  8');
is(number_of_day_within_year('1/9/2000'),             9,     'number of day within year 1/9/2000   =  9');
is(number_of_day_within_year('1/10/2000'),           10,     'number of day within year 1/10/2000  = 10');
is(number_of_day_within_year('1/11/2000'),           11,     'number of day within year 1/11/2000  = 11');
is(number_of_day_within_year('1/12/2000'),           12,     'number of day within year 1/12/2000  = 12');
is(number_of_day_within_year('1/13/2000'),           13,     'number of day within year 1/13/2000  = 13');
is(number_of_day_within_year('1/14/2000'),           14,     'number of day within year 1/14/2000  = 14');
is(number_of_day_within_year('1/15/2000'),           15,     'number of day within year 1/15/2000  = 15');
is(number_of_day_within_year('1/16/2000'),           16,     'number of day within year 1/16/2000  = 16');
is(number_of_day_within_year('1/17/2000'),           17,     'number of day within year 1/17/2000  = 17');
is(number_of_day_within_year('1/18/2000'),           18,     'number of day within year 1/18/2000  = 18');
is(number_of_day_within_year('1/19/2000'),           19,     'number of day within year 1/19/2000  = 19');
is(number_of_day_within_year('1/20/2000'),           20,     'number of day within year 1/20/2000  = 20');
is(number_of_day_within_year('1/21/2000'),           21,     'number of day within year 1/21/2000  = 21');
is(number_of_day_within_year('1/22/2000'),           22,     'number of day within year 1/22/2000  = 22');
is(number_of_day_within_year('1/23/2000'),           23,     'number of day within year 1/23/2000  = 23');
is(number_of_day_within_year('1/24/2000'),           24,     'number of day within year 1/24/2000  = 24');
is(number_of_day_within_year('1/25/2000'),           25,     'number of day within year 1/25/2000  = 25');
is(number_of_day_within_year('1/26/2000'),           26,     'number of day within year 1/26/2000  = 26');
is(number_of_day_within_year('1/27/2000'),           27,     'number of day within year 1/27/2000  = 27');
is(number_of_day_within_year('1/28/2000'),           28,     'number of day within year 1/28/2000  = 28');
is(number_of_day_within_year('1/29/2000'),           29,     'number of day within year 1/29/2000  = 29');
is(number_of_day_within_year('1/30/2000'),           30,     'number of day within year 1/30/2000  = 30');
is(number_of_day_within_year('1/31/2000'),           31,     'number of day within year 1/31/2000  = 31');
is(number_of_day_within_year('2/1/2000'),            32,     'number of day within year 2/1/2000   =  1');
is(number_of_day_within_year('2/2/2000'),            33,     'number of day within year 2/2/2000   =  2');
is(number_of_day_within_year('2/3/2000'),            34,     'number of day within year 2/3/2000   =  3');
is(number_of_day_within_year('2/4/2000'),            35,     'number of day within year 2/4/2000   =  4');
is(number_of_day_within_year('2/5/2000'),            36,     'number of day within year 2/5/2000   =  5');
is(number_of_day_within_year('2/6/2000'),            37,     'number of day within year 2/6/2000   =  6');
is(number_of_day_within_year('2/7/2000'),            38,     'number of day within year 2/7/2000   =  7');
is(number_of_day_within_year('2/8/2000'),            39,     'number of day within year 2/8/2000   =  8');
is(number_of_day_within_year('2/9/2000'),            40,     'number of day within year 2/9/2000   =  9');
is(number_of_day_within_year('2/10/2000'),           41,     'number of day within year 2/10/2000  = 10');
is(number_of_day_within_year('2/11/2000'),           42,     'number of day within year 2/11/2000  = 11');
is(number_of_day_within_year('2/12/2000'),           43,     'number of day within year 2/12/2000  = 12');
is(number_of_day_within_year('2/13/2000'),           44,     'number of day within year 2/13/2000  = 13');
is(number_of_day_within_year('2/14/2000'),           45,     'number of day within year 2/14/2000  = 14');
is(number_of_day_within_year('2/15/2000'),           46,     'number of day within year 2/15/2000  = 15');
is(number_of_day_within_year('2/16/2000'),           47,     'number of day within year 2/16/2000  = 16');
is(number_of_day_within_year('2/17/2000'),           48,     'number of day within year 2/17/2000  = 17');
is(number_of_day_within_year('2/18/2000'),           49,     'number of day within year 2/18/2000  = 18');
is(number_of_day_within_year('2/19/2000'),           50,     'number of day within year 2/19/2000  = 19');
is(number_of_day_within_year('2/20/2000'),           51,     'number of day within year 2/20/2000  = 20');
is(number_of_day_within_year('2/21/2000'),           52,     'number of day within year 2/21/2000  = 21');
is(number_of_day_within_year('2/22/2000'),           53,     'number of day within year 2/22/2000  = 22');
is(number_of_day_within_year('2/23/2000'),           54,     'number of day within year 2/23/2000  = 23');
is(number_of_day_within_year('2/24/2000'),           55,     'number of day within year 2/24/2000  = 24');
is(number_of_day_within_year('2/25/2000'),           56,     'number of day within year 2/25/2000  = 25');
is(number_of_day_within_year('2/26/2000'),           57,     'number of day within year 2/26/2000  = 26');
is(number_of_day_within_year('2/27/2000'),           58,     'number of day within year 2/27/2000  = 27');
is(number_of_day_within_year('2/28/2000'),           59,     'number of day within year 2/28/2000  = 28');
is(number_of_day_within_year('2/29/2000'),           60,     'number of day within year 2/29/2000  = 29');
is(number_of_day_within_year('3/1/2000'),            61,     'number of day within year 3/1/2000   =  1');
is(number_of_day_within_year('3/2/2000'),            62,     'number of day within year 3/2/2000   =  2');
is(number_of_day_within_year('3/3/2000'),            63,     'number of day within year 3/3/2000   =  3');
is(number_of_day_within_year('3/4/2000'),            64,     'number of day within year 3/4/2000   =  4');
is(number_of_day_within_year('3/5/2000'),            65,     'number of day within year 3/5/2000   =  5');
is(number_of_day_within_year('3/6/2000'),            66,     'number of day within year 3/6/2000   =  6');
is(number_of_day_within_year('3/7/2000'),            67,     'number of day within year 3/7/2000   =  7');
is(number_of_day_within_year('3/8/2000'),            68,     'number of day within year 3/8/2000   =  8');
is(number_of_day_within_year('3/9/2000'),            69,     'number of day within year 3/9/2000   =  9');
is(number_of_day_within_year('3/10/2000'),           70,     'number of day within year 3/10/2000  = 10');
is(number_of_day_within_year('3/11/2000'),           71,     'number of day within year 3/11/2000  = 11');
is(number_of_day_within_year('3/12/2000'),           72,     'number of day within year 3/12/2000  = 12');
is(number_of_day_within_year('3/13/2000'),           73,     'number of day within year 3/13/2000  = 13');
is(number_of_day_within_year('3/14/2000'),           74,     'number of day within year 3/14/2000  = 14');
is(number_of_day_within_year('3/15/2000'),           75,     'number of day within year 3/15/2000  = 15');
is(number_of_day_within_year('3/16/2000'),           76,     'number of day within year 3/16/2000  = 16');
is(number_of_day_within_year('3/17/2000'),           77,     'number of day within year 3/17/2000  = 17');
is(number_of_day_within_year('3/18/2000'),           78,     'number of day within year 3/18/2000  = 18');
is(number_of_day_within_year('3/19/2000'),           79,     'number of day within year 3/19/2000  = 19');
is(number_of_day_within_year('3/20/2000'),           80,     'number of day within year 3/20/2000  = 20');
is(number_of_day_within_year('3/21/2000'),           81,     'number of day within year 3/21/2000  = 21');
is(number_of_day_within_year('3/22/2000'),           82,     'number of day within year 3/22/2000  = 22');
is(number_of_day_within_year('3/23/2000'),           83,     'number of day within year 3/23/2000  = 23');
is(number_of_day_within_year('3/24/2000'),           84,     'number of day within year 3/24/2000  = 24');
is(number_of_day_within_year('3/25/2000'),           85,     'number of day within year 3/25/2000  = 25');
is(number_of_day_within_year('3/26/2000'),           86,     'number of day within year 3/26/2000  = 26');
is(number_of_day_within_year('3/27/2000'),           87,     'number of day within year 3/27/2000  = 27');
is(number_of_day_within_year('3/28/2000'),           88,     'number of day within year 3/28/2000  = 28');
is(number_of_day_within_year('3/29/2000'),           89,     'number of day within year 3/29/2000  = 29');
is(number_of_day_within_year('3/30/2000'),           90,     'number of day within year 3/30/2000  = 30');
is(number_of_day_within_year('3/31/2000'),           91,     'number of day within year 3/31/2000  = 31');
is(number_of_day_within_year('4/1/2000'),            92,     'number of day within year 4/1/2000   =  1');
is(number_of_day_within_year('4/2/2000'),            93,     'number of day within year 4/2/2000   =  2');
is(number_of_day_within_year('4/3/2000'),            94,     'number of day within year 4/3/2000   =  3');
is(number_of_day_within_year('4/4/2000'),            95,     'number of day within year 4/4/2000   =  4');
is(number_of_day_within_year('4/5/2000'),            96,     'number of day within year 4/5/2000   =  5');
is(number_of_day_within_year('4/6/2000'),            97,     'number of day within year 4/6/2000   =  6');
is(number_of_day_within_year('4/7/2000'),            98,     'number of day within year 4/7/2000   =  7');
is(number_of_day_within_year('4/8/2000'),            99,     'number of day within year 4/8/2000   =  8');
is(number_of_day_within_year('4/9/2000'),           100,     'number of day within year 4/9/2000   =  9');
is(number_of_day_within_year('4/10/2000'),          101,     'number of day within year 4/10/2000  = 10');
is(number_of_day_within_year('4/11/2000'),          102,     'number of day within year 4/11/2000  = 11');
is(number_of_day_within_year('4/12/2000'),          103,     'number of day within year 4/12/2000  = 12');
is(number_of_day_within_year('4/13/2000'),          104,     'number of day within year 4/13/2000  = 13');
is(number_of_day_within_year('4/14/2000'),          105,     'number of day within year 4/14/2000  = 14');
is(number_of_day_within_year('4/15/2000'),          106,     'number of day within year 4/15/2000  = 15');
is(number_of_day_within_year('4/16/2000'),          107,     'number of day within year 4/16/2000  = 16');
is(number_of_day_within_year('4/17/2000'),          108,     'number of day within year 4/17/2000  = 17');
is(number_of_day_within_year('4/18/2000'),          109,     'number of day within year 4/18/2000  = 18');
is(number_of_day_within_year('4/19/2000'),          110,     'number of day within year 4/19/2000  = 19');
is(number_of_day_within_year('4/20/2000'),          111,     'number of day within year 4/20/2000  = 20');
is(number_of_day_within_year('4/21/2000'),          112,     'number of day within year 4/21/2000  = 21');
is(number_of_day_within_year('4/22/2000'),          113,     'number of day within year 4/22/2000  = 22');
is(number_of_day_within_year('4/23/2000'),          114,     'number of day within year 4/23/2000  = 23');
is(number_of_day_within_year('4/24/2000'),          115,     'number of day within year 4/24/2000  = 24');
is(number_of_day_within_year('4/25/2000'),          116,     'number of day within year 4/25/2000  = 25');
is(number_of_day_within_year('4/26/2000'),          117,     'number of day within year 4/26/2000  = 26');
is(number_of_day_within_year('4/27/2000'),          118,     'number of day within year 4/27/2000  = 27');
is(number_of_day_within_year('4/28/2000'),          119,     'number of day within year 4/28/2000  = 28');
is(number_of_day_within_year('4/29/2000'),          120,     'number of day within year 4/29/2000  = 29');
is(number_of_day_within_year('4/30/2000'),          121,     'number of day within year 4/30/2000  = 30');
is(number_of_day_within_year('5/1/2000'),           122,     'number of day within year 5/1/2000   =  1');
is(number_of_day_within_year('5/2/2000'),           123,     'number of day within year 5/2/2000   =  2');
is(number_of_day_within_year('5/3/2000'),           124,     'number of day within year 5/3/2000   =  3');
is(number_of_day_within_year('5/4/2000'),           125,     'number of day within year 5/4/2000   =  4');
is(number_of_day_within_year('5/5/2000'),           126,     'number of day within year 5/5/2000   =  5');
is(number_of_day_within_year('5/6/2000'),           127,     'number of day within year 5/6/2000   =  6');
is(number_of_day_within_year('5/7/2000'),           128,     'number of day within year 5/7/2000   =  7');
is(number_of_day_within_year('5/8/2000'),           129,     'number of day within year 5/8/2000   =  8');
is(number_of_day_within_year('5/9/2000'),           130,     'number of day within year 5/9/2000   =  9');
is(number_of_day_within_year('5/10/2000'),          131,     'number of day within year 5/10/2000  = 10');
is(number_of_day_within_year('5/11/2000'),          132,     'number of day within year 5/11/2000  = 11');
is(number_of_day_within_year('5/12/2000'),          133,     'number of day within year 5/12/2000  = 12');
is(number_of_day_within_year('5/13/2000'),          134,     'number of day within year 5/13/2000  = 13');
is(number_of_day_within_year('5/14/2000'),          135,     'number of day within year 5/14/2000  = 14');
is(number_of_day_within_year('5/15/2000'),          136,     'number of day within year 5/15/2000  = 15');
is(number_of_day_within_year('5/16/2000'),          137,     'number of day within year 5/16/2000  = 16');
is(number_of_day_within_year('5/17/2000'),          138,     'number of day within year 5/17/2000  = 17');
is(number_of_day_within_year('5/18/2000'),          139,     'number of day within year 5/18/2000  = 18');
is(number_of_day_within_year('5/19/2000'),          140,     'number of day within year 5/19/2000  = 19');
is(number_of_day_within_year('5/20/2000'),          141,     'number of day within year 5/20/2000  = 20');
is(number_of_day_within_year('5/21/2000'),          142,     'number of day within year 5/21/2000  = 21');
is(number_of_day_within_year('5/22/2000'),          143,     'number of day within year 5/22/2000  = 22');
is(number_of_day_within_year('5/23/2000'),          144,     'number of day within year 5/23/2000  = 23');
is(number_of_day_within_year('5/24/2000'),          145,     'number of day within year 5/24/2000  = 24');
is(number_of_day_within_year('5/25/2000'),          146,     'number of day within year 5/25/2000  = 25');
is(number_of_day_within_year('5/26/2000'),          147,     'number of day within year 5/26/2000  = 26');
is(number_of_day_within_year('5/27/2000'),          148,     'number of day within year 5/27/2000  = 27');
is(number_of_day_within_year('5/28/2000'),          149,     'number of day within year 5/28/2000  = 28');
is(number_of_day_within_year('5/29/2000'),          150,     'number of day within year 5/29/2000  = 29');
is(number_of_day_within_year('5/30/2000'),          151,     'number of day within year 5/30/2000  = 30');
is(number_of_day_within_year('5/31/2000'),          152,     'number of day within year 5/31/2000  = 31');
is(number_of_day_within_year('6/1/2000'),           153,     'number of day within year 6/1/2000   =  1');
is(number_of_day_within_year('6/2/2000'),           154,     'number of day within year 6/2/2000   =  2');
is(number_of_day_within_year('6/3/2000'),           155,     'number of day within year 6/3/2000   =  3');
is(number_of_day_within_year('6/4/2000'),           156,     'number of day within year 6/4/2000   =  4');
is(number_of_day_within_year('6/5/2000'),           157,     'number of day within year 6/5/2000   =  5');
is(number_of_day_within_year('6/6/2000'),           158,     'number of day within year 6/6/2000   =  6');
is(number_of_day_within_year('6/7/2000'),           159,     'number of day within year 6/7/2000   =  7');
is(number_of_day_within_year('6/8/2000'),           160,     'number of day within year 6/8/2000   =  8');
is(number_of_day_within_year('6/9/2000'),           161,     'number of day within year 6/9/2000   =  9');
is(number_of_day_within_year('6/10/2000'),          162,     'number of day within year 6/10/2000  = 10');
is(number_of_day_within_year('6/11/2000'),          163,     'number of day within year 6/11/2000  = 11');
is(number_of_day_within_year('6/12/2000'),          164,     'number of day within year 6/12/2000  = 12');
is(number_of_day_within_year('6/13/2000'),          165,     'number of day within year 6/13/2000  = 13');
is(number_of_day_within_year('6/14/2000'),          166,     'number of day within year 6/14/2000  = 14');
is(number_of_day_within_year('6/15/2000'),          167,     'number of day within year 6/15/2000  = 15');
is(number_of_day_within_year('6/16/2000'),          168,     'number of day within year 6/16/2000  = 16');
is(number_of_day_within_year('6/17/2000'),          169,     'number of day within year 6/17/2000  = 17');
is(number_of_day_within_year('6/18/2000'),          170,     'number of day within year 6/18/2000  = 18');
is(number_of_day_within_year('6/19/2000'),          171,     'number of day within year 6/19/2000  = 19');
is(number_of_day_within_year('6/20/2000'),          172,     'number of day within year 6/20/2000  = 20');
is(number_of_day_within_year('6/21/2000'),          173,     'number of day within year 6/21/2000  = 21');
is(number_of_day_within_year('6/22/2000'),          174,     'number of day within year 6/22/2000  = 22');
is(number_of_day_within_year('6/23/2000'),          175,     'number of day within year 6/23/2000  = 23');
is(number_of_day_within_year('6/24/2000'),          176,     'number of day within year 6/24/2000  = 24');
is(number_of_day_within_year('6/25/2000'),          177,     'number of day within year 6/25/2000  = 25');
is(number_of_day_within_year('6/26/2000'),          178,     'number of day within year 6/26/2000  = 26');
is(number_of_day_within_year('6/27/2000'),          179,     'number of day within year 6/27/2000  = 27');
is(number_of_day_within_year('6/28/2000'),          180,     'number of day within year 6/28/2000  = 28');
is(number_of_day_within_year('6/29/2000'),          181,     'number of day within year 6/29/2000  = 29');
is(number_of_day_within_year('6/30/2000'),          182,     'number of day within year 6/30/2000  = 30');
is(number_of_day_within_year('7/1/2000'),           183,     'number of day within year 7/1/2000   =  1');
is(number_of_day_within_year('7/2/2000'),           184,     'number of day within year 7/2/2000   =  2');
is(number_of_day_within_year('7/3/2000'),           185,     'number of day within year 7/3/2000   =  3');
is(number_of_day_within_year('7/4/2000'),           186,     'number of day within year 7/4/2000   =  4');
is(number_of_day_within_year('7/5/2000'),           187,     'number of day within year 7/5/2000   =  5');
is(number_of_day_within_year('7/6/2000'),           188,     'number of day within year 7/6/2000   =  6');
is(number_of_day_within_year('7/7/2000'),           189,     'number of day within year 7/7/2000   =  7');
is(number_of_day_within_year('7/8/2000'),           190,     'number of day within year 7/8/2000   =  8');
is(number_of_day_within_year('7/9/2000'),           191,     'number of day within year 7/9/2000   =  9');
is(number_of_day_within_year('7/10/2000'),          192,     'number of day within year 7/10/2000  = 10');
is(number_of_day_within_year('7/11/2000'),          193,     'number of day within year 7/11/2000  = 11');
is(number_of_day_within_year('7/12/2000'),          194,     'number of day within year 7/12/2000  = 12');
is(number_of_day_within_year('7/13/2000'),          195,     'number of day within year 7/13/2000  = 13');
is(number_of_day_within_year('7/14/2000'),          196,     'number of day within year 7/14/2000  = 14');
is(number_of_day_within_year('7/15/2000'),          197,     'number of day within year 7/15/2000  = 15');
is(number_of_day_within_year('7/16/2000'),          198,     'number of day within year 7/16/2000  = 16');
is(number_of_day_within_year('7/17/2000'),          199,     'number of day within year 7/17/2000  = 17');
is(number_of_day_within_year('7/18/2000'),          200,     'number of day within year 7/18/2000  = 18');
is(number_of_day_within_year('7/19/2000'),          201,     'number of day within year 7/19/2000  = 19');
is(number_of_day_within_year('7/20/2000'),          202,     'number of day within year 7/20/2000  = 20');
is(number_of_day_within_year('7/21/2000'),          203,     'number of day within year 7/21/2000  = 21');
is(number_of_day_within_year('7/22/2000'),          204,     'number of day within year 7/22/2000  = 22');
is(number_of_day_within_year('7/23/2000'),          205,     'number of day within year 7/23/2000  = 23');
is(number_of_day_within_year('7/24/2000'),          206,     'number of day within year 7/24/2000  = 24');
is(number_of_day_within_year('7/25/2000'),          207,     'number of day within year 7/25/2000  = 25');
is(number_of_day_within_year('7/26/2000'),          208,     'number of day within year 7/26/2000  = 26');
is(number_of_day_within_year('7/27/2000'),          209,     'number of day within year 7/27/2000  = 27');
is(number_of_day_within_year('7/28/2000'),          210,     'number of day within year 7/28/2000  = 28');
is(number_of_day_within_year('7/29/2000'),          211,     'number of day within year 7/29/2000  = 29');
is(number_of_day_within_year('7/30/2000'),          212,     'number of day within year 7/30/2000  = 30');
is(number_of_day_within_year('7/31/2000'),          213,     'number of day within year 7/31/2000  = 31');
is(number_of_day_within_year('8/1/2000'),           214,     'number of day within year 8/1/2000   =  1');
is(number_of_day_within_year('8/2/2000'),           215,     'number of day within year 8/2/2000   =  2');
is(number_of_day_within_year('8/3/2000'),           216,     'number of day within year 8/3/2000   =  3');
is(number_of_day_within_year('8/4/2000'),           217,     'number of day within year 8/4/2000   =  4');
is(number_of_day_within_year('8/5/2000'),           218,     'number of day within year 8/5/2000   =  5');
is(number_of_day_within_year('8/6/2000'),           219,     'number of day within year 8/6/2000   =  6');
is(number_of_day_within_year('8/7/2000'),           220,     'number of day within year 8/7/2000   =  7');
is(number_of_day_within_year('8/8/2000'),           221,     'number of day within year 8/8/2000   =  8');
is(number_of_day_within_year('8/9/2000'),           222,     'number of day within year 8/9/2000   =  9');
is(number_of_day_within_year('8/10/2000'),          223,     'number of day within year 8/10/2000  = 10');
is(number_of_day_within_year('8/11/2000'),          224,     'number of day within year 8/11/2000  = 11');
is(number_of_day_within_year('8/12/2000'),          225,     'number of day within year 8/12/2000  = 12');
is(number_of_day_within_year('8/13/2000'),          226,     'number of day within year 8/13/2000  = 13');
is(number_of_day_within_year('8/14/2000'),          227,     'number of day within year 8/14/2000  = 14');
is(number_of_day_within_year('8/15/2000'),          228,     'number of day within year 8/15/2000  = 15');
is(number_of_day_within_year('8/16/2000'),          229,     'number of day within year 8/16/2000  = 16');
is(number_of_day_within_year('8/17/2000'),          230,     'number of day within year 8/17/2000  = 17');
is(number_of_day_within_year('8/18/2000'),          231,     'number of day within year 8/18/2000  = 18');
is(number_of_day_within_year('8/19/2000'),          232,     'number of day within year 8/19/2000  = 19');
is(number_of_day_within_year('8/20/2000'),          233,     'number of day within year 8/20/2000  = 20');
is(number_of_day_within_year('8/21/2000'),          234,     'number of day within year 8/21/2000  = 21');
is(number_of_day_within_year('8/22/2000'),          235,     'number of day within year 8/22/2000  = 22');
is(number_of_day_within_year('8/23/2000'),          236,     'number of day within year 8/23/2000  = 23');
is(number_of_day_within_year('8/24/2000'),          237,     'number of day within year 8/24/2000  = 24');
is(number_of_day_within_year('8/25/2000'),          238,     'number of day within year 8/25/2000  = 25');
is(number_of_day_within_year('8/26/2000'),          239,     'number of day within year 8/26/2000  = 26');
is(number_of_day_within_year('8/27/2000'),          240,     'number of day within year 8/27/2000  = 27');
is(number_of_day_within_year('8/28/2000'),          241,     'number of day within year 8/28/2000  = 28');
is(number_of_day_within_year('8/29/2000'),          242,     'number of day within year 8/29/2000  = 29');
is(number_of_day_within_year('8/30/2000'),          243,     'number of day within year 8/30/2000  = 30');
is(number_of_day_within_year('8/31/2000'),          244,     'number of day within year 8/31/2000  = 31');
is(number_of_day_within_year('9/1/2000'),           245,     'number of day within year 9/1/2000   =  1');
is(number_of_day_within_year('9/2/2000'),           246,     'number of day within year 9/2/2000   =  2');
is(number_of_day_within_year('9/3/2000'),           247,     'number of day within year 9/3/2000   =  3');
is(number_of_day_within_year('9/4/2000'),           248,     'number of day within year 9/4/2000   =  4');
is(number_of_day_within_year('9/5/2000'),           249,     'number of day within year 9/5/2000   =  5');
is(number_of_day_within_year('9/6/2000'),           250,     'number of day within year 9/6/2000   =  6');
is(number_of_day_within_year('9/7/2000'),           251,     'number of day within year 9/7/2000   =  7');
is(number_of_day_within_year('9/8/2000'),           252,     'number of day within year 9/8/2000   =  8');
is(number_of_day_within_year('9/9/2000'),           253,     'number of day within year 9/9/2000   =  9');
is(number_of_day_within_year('9/10/2000'),          254,     'number of day within year 9/10/2000  = 10');
is(number_of_day_within_year('9/11/2000'),          255,     'number of day within year 9/11/2000  = 11');
is(number_of_day_within_year('9/12/2000'),          256,     'number of day within year 9/12/2000  = 12');
is(number_of_day_within_year('9/13/2000'),          257,     'number of day within year 9/13/2000  = 13');
is(number_of_day_within_year('9/14/2000'),          258,     'number of day within year 9/14/2000  = 14');
is(number_of_day_within_year('9/15/2000'),          259,     'number of day within year 9/15/2000  = 15');
is(number_of_day_within_year('9/16/2000'),          260,     'number of day within year 9/16/2000  = 16');
is(number_of_day_within_year('9/17/2000'),          261,     'number of day within year 9/17/2000  = 17');
is(number_of_day_within_year('9/18/2000'),          262,     'number of day within year 9/18/2000  = 18');
is(number_of_day_within_year('9/19/2000'),          263,     'number of day within year 9/19/2000  = 19');
is(number_of_day_within_year('9/20/2000'),          264,     'number of day within year 9/20/2000  = 20');
is(number_of_day_within_year('9/21/2000'),          265,     'number of day within year 9/21/2000  = 21');
is(number_of_day_within_year('9/22/2000'),          266,     'number of day within year 9/22/2000  = 22');
is(number_of_day_within_year('9/23/2000'),          267,     'number of day within year 9/23/2000  = 23');
is(number_of_day_within_year('9/24/2000'),          268,     'number of day within year 9/24/2000  = 24');
is(number_of_day_within_year('9/25/2000'),          269,     'number of day within year 9/25/2000  = 25');
is(number_of_day_within_year('9/26/2000'),          270,     'number of day within year 9/26/2000  = 26');
is(number_of_day_within_year('9/27/2000'),          271,     'number of day within year 9/27/2000  = 27');
is(number_of_day_within_year('9/28/2000'),          272,     'number of day within year 9/28/2000  = 28');
is(number_of_day_within_year('9/29/2000'),          273,     'number of day within year 9/29/2000  = 29');
is(number_of_day_within_year('9/30/2000'),          274,     'number of day within year 9/30/2000  = 30');
is(number_of_day_within_year('10/1/2000'),          275,     'number of day within year 10/1/2000   =  1');
is(number_of_day_within_year('10/2/2000'),          276,     'number of day within year 10/2/2000   =  2');
is(number_of_day_within_year('10/3/2000'),          277,     'number of day within year 10/3/2000   =  3');
is(number_of_day_within_year('10/4/2000'),          278,     'number of day within year 10/4/2000   =  4');
is(number_of_day_within_year('10/5/2000'),          279,     'number of day within year 10/5/2000   =  5');
is(number_of_day_within_year('10/6/2000'),          280,     'number of day within year 10/6/2000   =  6');
is(number_of_day_within_year('10/7/2000'),          281,     'number of day within year 10/7/2000   =  7');
is(number_of_day_within_year('10/8/2000'),          282,     'number of day within year 10/8/2000   =  8');
is(number_of_day_within_year('10/9/2000'),          283,     'number of day within year 10/9/2000   =  9');
is(number_of_day_within_year('10/10/2000'),         284,     'number of day within year 10/10/2000  = 10');
is(number_of_day_within_year('10/11/2000'),         285,     'number of day within year 10/11/2000  = 11');
is(number_of_day_within_year('10/12/2000'),         286,     'number of day within year 10/12/2000  = 12');
is(number_of_day_within_year('10/13/2000'),         287,     'number of day within year 10/13/2000  = 13');
is(number_of_day_within_year('10/14/2000'),         288,     'number of day within year 10/14/2000  = 14');
is(number_of_day_within_year('10/15/2000'),         289,     'number of day within year 10/15/2000  = 15');
is(number_of_day_within_year('10/16/2000'),         290,     'number of day within year 10/16/2000  = 16');
is(number_of_day_within_year('10/17/2000'),         291,     'number of day within year 10/17/2000  = 17');
is(number_of_day_within_year('10/18/2000'),         292,     'number of day within year 10/18/2000  = 18');
is(number_of_day_within_year('10/19/2000'),         293,     'number of day within year 10/19/2000  = 19');
is(number_of_day_within_year('10/20/2000'),         294,     'number of day within year 10/20/2000  = 20');
is(number_of_day_within_year('10/21/2000'),         295,     'number of day within year 10/21/2000  = 21');
is(number_of_day_within_year('10/22/2000'),         296,     'number of day within year 10/22/2000  = 22');
is(number_of_day_within_year('10/23/2000'),         297,     'number of day within year 10/23/2000  = 23');
is(number_of_day_within_year('10/24/2000'),         298,     'number of day within year 10/24/2000  = 24');
is(number_of_day_within_year('10/25/2000'),         299,     'number of day within year 10/25/2000  = 25');
is(number_of_day_within_year('10/26/2000'),         300,     'number of day within year 10/26/2000  = 26');
is(number_of_day_within_year('10/27/2000'),         301,     'number of day within year 10/27/2000  = 27');
is(number_of_day_within_year('10/28/2000'),         302,     'number of day within year 10/28/2000  = 28');
is(number_of_day_within_year('10/29/2000'),         303,     'number of day within year 10/29/2000  = 29');
is(number_of_day_within_year('10/30/2000'),         304,     'number of day within year 10/30/2000  = 30');
is(number_of_day_within_year('10/31/2000'),         305,     'number of day within year 10/31/2000  = 31');
is(number_of_day_within_year('11/1/2000'),          306,     'number of day within year 11/1/2000   =  1');
is(number_of_day_within_year('11/2/2000'),          307,     'number of day within year 11/2/2000   =  2');
is(number_of_day_within_year('11/3/2000'),          308,     'number of day within year 11/3/2000   =  3');
is(number_of_day_within_year('11/4/2000'),          309,     'number of day within year 11/4/2000   =  4');
is(number_of_day_within_year('11/5/2000'),          310,     'number of day within year 11/5/2000   =  5');
is(number_of_day_within_year('11/6/2000'),          311,     'number of day within year 11/6/2000   =  6');
is(number_of_day_within_year('11/7/2000'),          312,     'number of day within year 11/7/2000   =  7');
is(number_of_day_within_year('11/8/2000'),          313,     'number of day within year 11/8/2000   =  8');
is(number_of_day_within_year('11/9/2000'),          314,     'number of day within year 11/9/2000   =  9');
is(number_of_day_within_year('11/10/2000'),         315,     'number of day within year 11/10/2000  = 10');
is(number_of_day_within_year('11/11/2000'),         316,     'number of day within year 11/11/2000  = 11');
is(number_of_day_within_year('11/12/2000'),         317,     'number of day within year 11/12/2000  = 12');
is(number_of_day_within_year('11/13/2000'),         318,     'number of day within year 11/13/2000  = 13');
is(number_of_day_within_year('11/14/2000'),         319,     'number of day within year 11/14/2000  = 14');
is(number_of_day_within_year('11/15/2000'),         320,     'number of day within year 11/15/2000  = 15');
is(number_of_day_within_year('11/16/2000'),         321,     'number of day within year 11/16/2000  = 16');
is(number_of_day_within_year('11/17/2000'),         322,     'number of day within year 11/17/2000  = 17');
is(number_of_day_within_year('11/18/2000'),         323,     'number of day within year 11/18/2000  = 18');
is(number_of_day_within_year('11/19/2000'),         324,     'number of day within year 11/19/2000  = 19');
is(number_of_day_within_year('11/20/2000'),         325,     'number of day within year 11/20/2000  = 20');
is(number_of_day_within_year('11/21/2000'),         326,     'number of day within year 11/21/2000  = 21');
is(number_of_day_within_year('11/22/2000'),         327,     'number of day within year 11/22/2000  = 22');
is(number_of_day_within_year('11/23/2000'),         328,     'number of day within year 11/23/2000  = 23');
is(number_of_day_within_year('11/24/2000'),         329,     'number of day within year 11/24/2000  = 24');
is(number_of_day_within_year('11/25/2000'),         330,     'number of day within year 11/25/2000  = 25');
is(number_of_day_within_year('11/26/2000'),         331,     'number of day within year 11/26/2000  = 26');
is(number_of_day_within_year('11/27/2000'),         332,     'number of day within year 11/27/2000  = 27');
is(number_of_day_within_year('11/28/2000'),         333,     'number of day within year 11/28/2000  = 28');
is(number_of_day_within_year('11/29/2000'),         334,     'number of day within year 11/29/2000  = 29');
is(number_of_day_within_year('11/30/2000'),         335,     'number of day within year 11/30/2000  = 30');
is(number_of_day_within_year('12/1/2000'),          336,     'number of day within year 12/1/2000   =  1');
is(number_of_day_within_year('12/2/2000'),          337,     'number of day within year 12/2/2000   =  2');
is(number_of_day_within_year('12/3/2000'),          338,     'number of day within year 12/3/2000   =  3');
is(number_of_day_within_year('12/4/2000'),          339,     'number of day within year 12/4/2000   =  4');
is(number_of_day_within_year('12/5/2000'),          340,     'number of day within year 12/5/2000   =  5');
is(number_of_day_within_year('12/6/2000'),          341,     'number of day within year 12/6/2000   =  6');
is(number_of_day_within_year('12/7/2000'),          342,     'number of day within year 12/7/2000   =  7');
is(number_of_day_within_year('12/8/2000'),          343,     'number of day within year 12/8/2000   =  8');
is(number_of_day_within_year('12/9/2000'),          344,     'number of day within year 12/9/2000   =  9');
is(number_of_day_within_year('12/10/2000'),         345,     'number of day within year 12/10/2000  = 10');
is(number_of_day_within_year('12/11/2000'),         346,     'number of day within year 12/11/2000  = 11');
is(number_of_day_within_year('12/12/2000'),         347,     'number of day within year 12/12/2000  = 12');
is(number_of_day_within_year('12/13/2000'),         348,     'number of day within year 12/13/2000  = 13');
is(number_of_day_within_year('12/14/2000'),         349,     'number of day within year 12/14/2000  = 14');
is(number_of_day_within_year('12/15/2000'),         350,     'number of day within year 12/15/2000  = 15');
is(number_of_day_within_year('12/16/2000'),         351,     'number of day within year 12/16/2000  = 16');
is(number_of_day_within_year('12/17/2000'),         352,     'number of day within year 12/17/2000  = 17');
is(number_of_day_within_year('12/18/2000'),         353,     'number of day within year 12/18/2000  = 18');
is(number_of_day_within_year('12/19/2000'),         354,     'number of day within year 12/19/2000  = 19');
is(number_of_day_within_year('12/20/2000'),         355,     'number of day within year 12/20/2000  = 20');
is(number_of_day_within_year('12/21/2000'),         356,     'number of day within year 12/21/2000  = 21');
is(number_of_day_within_year('12/22/2000'),         357,     'number of day within year 12/22/2000  = 22');
is(number_of_day_within_year('12/23/2000'),         358,     'number of day within year 12/23/2000  = 23');
is(number_of_day_within_year('12/24/2000'),         359,     'number of day within year 12/24/2000  = 24');
is(number_of_day_within_year('12/25/2000'),         360,     'number of day within year 12/25/2000  = 25');
is(number_of_day_within_year('12/26/2000'),         361,     'number of day within year 12/26/2000  = 26');
is(number_of_day_within_year('12/27/2000'),         362,     'number of day within year 12/27/2000  = 27');
is(number_of_day_within_year('12/28/2000'),         363,     'number of day within year 12/28/2000  = 28');
is(number_of_day_within_year('12/29/2000'),         364,     'number of day within year 12/29/2000  = 29');
is(number_of_day_within_year('12/30/2000'),         365,     'number of day within year 12/30/2000  = 30');
is(number_of_day_within_year('12/31/2000'),         366,     'number of day within year 12/31/2000  = 31');
