#!/usr/bin/perl

package eBay::API::XML::Call::GetStore;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetStore.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetStore

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetStore inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetStore::GetStoreRequestType;
use eBay::API::XML::Call::GetStore::GetStoreResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetStore';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetStore::GetStoreRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetStore::GetStoreResponseType';
}

#
# input properties
#

=head2 setCategoryStructureOnly()

If this is set to True, only the category structure of the store is
returned. If this is not specified or set to False, the complete store
configuration is returned.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut
       
sub setCategoryStructureOnly {
   my $self   = shift;
   my $sCategoryStructureOnly = shift;
   $self->getRequestDataType()->setCategoryStructureOnly($sCategoryStructureOnly);
}

=head2 setLevelLimit()

Specifies the limit for the number of levels of the category hierarchy
to return, where the given root category is level 1 and its children are
level 2. Only categories at or above the level specified are returned.
This tag is optional. If LevelLimit is not set, the complete category
hierarchy is returned. Stores support category hierarchies up to 3
levels only.

  RequiredInput: Conditionally
#    Argument: 'xs:int'

=cut
       
sub setLevelLimit {
   my $self   = shift;
   my $sLevelLimit = shift;
   $self->getRequestDataType()->setLevelLimit($sLevelLimit);
}

=head2 setRootCategoryID()

Specifies the category ID for the topmost category to return (along with
the subcategories under it, the value of the LevelLimit property
determining how deep). This tag is optional. If RootCategoryID is not
specified, then the category tree starting at that root Category is
returned.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut
       
sub setRootCategoryID {
   my $self   = shift;
   my $sRootCategoryID = shift;
   $self->getRequestDataType()->setRootCategoryID($sRootCategoryID);
}

=head2 setUserID()

Specifies the user whose store data is to be returned. If not specified,
then the store returned is that for the requesting user.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut
       
sub setUserID {
   my $self   = shift;
   my $pUserID = shift;
   $self->getRequestDataType()->setUserID($pUserID);
}



#
# output properties
#

=head2 getStore()

The data describing the store configuration.

  Returned: Always
#    Returns: 'ns:StoreType'

=cut
       
sub getStore {
   my $self = shift;
   return $self->getResponseDataType()->getStore();
}





1;   
