#!/usr/local/bin/perl -w
#
use Graphics::VTK;



use Tk;
use Graphics::VTK::Tk;
$MW = Tk::MainWindow->new;

# This example demonstrates the use of vtkAssembly.  In an assembly, the motion
# of one actor affects the position of other actors.


# First we include the VTK Tcl packages which will make available
# all of the vtk commands to Tcl

$VTK_DATA_ROOT = 0;
$VTK_DATA_ROOT = $ENV{VTK_DATA_ROOT};
use Graphics::VTK::Tk::vtkInt;

# Create four parts: a top level assembly (in this case, a vtkCylinder)
# and three primitives (using vtkSphereSource, vtkCubeSource, and
# vtkConeSource).  Set up mappers and actors for each part of the assembly to
# carry information about material properties and associated geometry.

$sphere = Graphics::VTK::SphereSource->new;
$sphereMapper = Graphics::VTK::PolyDataMapper->new;
$sphereMapper->SetInput($sphere->GetOutput);
$sphereActor = Graphics::VTK::Actor->new;
$sphereActor->SetMapper($sphereMapper);
$sphereActor->SetOrigin(2,1,3);
$sphereActor->RotateY(6);
$sphereActor->SetPosition(2.25,0,0);
$sphereActor->GetProperty->SetColor(1,0,1);

$cube = Graphics::VTK::CubeSource->new;
$cubeMapper = Graphics::VTK::PolyDataMapper->new;
$cubeMapper->SetInput($cube->GetOutput);
$cubeActor = Graphics::VTK::Actor->new;
$cubeActor->SetMapper($cubeMapper);
$cubeActor->SetPosition(0.0,'.25',0);
$cubeActor->GetProperty->SetColor(0,0,1);

$cone = Graphics::VTK::ConeSource->new;
$coneMapper = Graphics::VTK::PolyDataMapper->new;
$coneMapper->SetInput($cone->GetOutput);
$coneActor = Graphics::VTK::Actor->new;
$coneActor->SetMapper($coneMapper);
$coneActor->SetPosition(0,0,'.25');
$coneActor->GetProperty->SetColor(0,1,0);

# top part of the assembly
$cylinder = Graphics::VTK::CylinderSource->new;
$cylinderMapper = Graphics::VTK::PolyDataMapper->new;
$cylinderMapper->SetInput($cylinder->GetOutput);
$cylinderMapper->SetResolveCoincidentTopologyToPolygonOffset;
$cylinderActor = Graphics::VTK::Actor->new;
$cylinderActor->SetMapper($cylinderMapper);
$cylinderActor->GetProperty->SetColor(1,0,0);

# Create the assembly and add the 4 parts to it.  Also set the origin, position
# and orientation in space.
$assembly = Graphics::VTK::Assembly->new;
$assembly->AddPart($cylinderActor);
$assembly->AddPart($sphereActor);
$assembly->AddPart($cubeActor);
$assembly->AddPart($coneActor);
$assembly->SetOrigin(5,10,15);
$assembly->AddPosition(5,0,0);
$assembly->RotateX(15);

# Create the Renderer, RenderWindow, and RenderWindowInteractor

$ren1 = Graphics::VTK::Renderer->new;
$renWin = Graphics::VTK::RenderWindow->new;
$renWin->AddRenderer($ren1);
$iren = Graphics::VTK::RenderWindowInteractor->new;
$iren->SetRenderWindow($renWin);

# Add the actors to the renderer, set the background and size

$ren1->AddActor($assembly);
$ren1->AddActor($coneActor);
$ren1->SetBackground(0.1,0.2,0.4);
$renWin->SetSize(200,200);

# Set up the camera to get a particular view of the scene
$camera = Graphics::VTK::Camera->new;
$camera->SetClippingRange(21.9464,30.0179);
$camera->SetFocalPoint(3.49221,2.28844,-0.970866);
$camera->SetPosition(3.49221,2.28844,24.5216);
$camera->SetViewAngle(30);
$camera->SetViewUp(0,1,0);
$ren1->SetActiveCamera($camera);

# Set the user method (bound to key 'u')

$iren->AddObserver('UserEvent',
 sub
  {
   $MW->{'.vtkInteract'}->deiconify;
  }
);
$renWin->Render;

# Withdraw the default tk window
$MW->withdraw;


Graphics::VTK::Tk::vtkInt::vtkInteract($MW);

Tk->MainLoop;
