# Generated by default/object.tt
package Paws::Macie2::AssumedRole;
  use Moose;
  has AccessKeyId => (is => 'ro', isa => 'Str', request_name => 'accessKeyId', traits => ['NameInRequest']);
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has PrincipalId => (is => 'ro', isa => 'Str', request_name => 'principalId', traits => ['NameInRequest']);
  has SessionContext => (is => 'ro', isa => 'Paws::Macie2::SessionContext', request_name => 'sessionContext', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::AssumedRole

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::AssumedRole object:

  $service_obj->Method(Att1 => { AccessKeyId => $value, ..., SessionContext => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::AssumedRole object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessKeyId

=head1 DESCRIPTION

Provides information about an identity that performed an action on an
affected resource by using temporary security credentials. The
credentials were obtained using the AssumeRole operation of the
Security Token Service (STS) API.

=head1 ATTRIBUTES


=head2 AccessKeyId => Str

The Amazon Web Services access key ID that identifies the credentials.


=head2 AccountId => Str

The unique identifier for the Amazon Web Services account that owns the
entity that was used to get the credentials.


=head2 Arn => Str

The Amazon Resource Name (ARN) of the entity that was used to get the
credentials.


=head2 PrincipalId => Str

The unique identifier for the entity that was used to get the
credentials.


=head2 SessionContext => L<Paws::Macie2::SessionContext>

The details of the session that was created for the credentials,
including the entity that issued the session.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

