# Generated by default/object.tt
package Paws::CostExplorer::RightsizingRecommendationConfiguration;
  use Moose;
  has BenefitsConsidered => (is => 'ro', isa => 'Bool', required => 1);
  has RecommendationTarget => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::RightsizingRecommendationConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::RightsizingRecommendationConfiguration object:

  $service_obj->Method(Att1 => { BenefitsConsidered => $value, ..., RecommendationTarget => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::RightsizingRecommendationConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->BenefitsConsidered

=head1 DESCRIPTION

Enables you to customize recommendations across two attributes. You can
choose to view recommendations for instances within the same instance
families or across different instance families. You can also choose to
view your estimated savings associated with recommendations with
consideration of existing Savings Plans or RI benefits, or neither.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BenefitsConsidered => Bool

The option to consider RI or Savings Plans discount benefits in your
savings calculation. The default value is C<TRUE>.


=head2 B<REQUIRED> RecommendationTarget => Str

The option to see recommendations within the same instance family, or
recommendations for instances across other families. The default value
is C<SAME_INSTANCE_FAMILY>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

