# Generated by default/object.tt
package Paws::Lightsail::QueryStringObject;
  use Moose;
  has Option => (is => 'ro', isa => 'Bool', request_name => 'option', traits => ['NameInRequest']);
  has QueryStringsAllowList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'queryStringsAllowList', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::QueryStringObject

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::QueryStringObject object:

  $service_obj->Method(Att1 => { Option => $value, ..., QueryStringsAllowList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::QueryStringObject object:

  $result = $service_obj->Method(...);
  $result->Att1->Option

=head1 DESCRIPTION

Describes the query string parameters that an Amazon Lightsail content
delivery network (CDN) distribution to bases caching on.

For the query strings that you specify, your distribution caches
separate versions of the specified content based on the query string
values in viewer requests.

=head1 ATTRIBUTES


=head2 Option => Bool

Indicates whether the distribution forwards and caches based on query
strings.


=head2 QueryStringsAllowList => ArrayRef[Str|Undef]

The specific query strings that the distribution forwards to the
origin.

Your distribution will cache content based on the specified query
strings.

If the C<option> parameter is true, then your distribution forwards all
query strings, regardless of what you specify using the
C<queryStringsAllowList> parameter.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

