/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucketInfo;
import org.couchbase.mock.memcached.VBucketStore;

public class Storage {
    private final VBucketInfo[] vbInfo;
    private final VBucketStore cacheStore;
    private final Map<KeySpec, Item> persistStore;
    private final MemcachedServer server;
    private boolean persistEnabled = true;
    private boolean replicationEnabled = true;

    public Storage(VBucketInfo[] vbi, MemcachedServer server) {
        this.vbInfo = vbi;
        this.persistStore = new HashMap<KeySpec, Item>();
        DeleteActionCallback deleteCallback = new DeleteActionCallback(this);
        MutateActionCallback mutateCallback = new MutateActionCallback(this);
        this.cacheStore = new VBucketStore();
        this.cacheStore.onItemDelete = deleteCallback;
        this.cacheStore.onItemMutated = mutateCallback;
        this.server = server;
    }

    public void persistDeletedItem(KeySpec ks) {
        this.persistStore.remove(ks);
    }

    public void persistMutatedItem(Item itm) {
        this.persistStore.put(itm.getKeySpec(), new Item(itm));
    }

    public void replicateMutatedItem(Item itm) {
        VBucketInfo vbi = this.vbInfo[itm.getKeySpec().vbId];
        if (vbi.getOwner() != this.server) {
            return;
        }
        for (MemcachedServer replica : vbi.getReplicas()) {
            Item newItem = new Item(itm);
            VBucketStore rStore = replica.getStorage().cacheStore;
            rStore.getMap().put(newItem.getKeySpec(), newItem);
            rStore.onItemMutated.onAction(rStore, newItem);
        }
    }

    public void replicateDeletedItem(KeySpec ks) {
        VBucketInfo vbi = this.vbInfo[ks.vbId];
        if (vbi.getOwner() != this.server) {
            return;
        }
        Item itm = new Item(ks);
        for (MemcachedServer replica : vbi.getReplicas()) {
            VBucketStore rStore = replica.getStorage().cacheStore;
            rStore.getMap().remove(ks);
            rStore.onItemDelete.onAction(rStore, itm);
            rStore.onItemMutated.onAction(rStore, itm);
        }
    }

    public void setPersistenceEnabled(boolean val) {
        this.persistEnabled = val;
    }

    public void setReplicationEnabled(boolean val) {
        this.replicationEnabled = val;
    }

    public Item getCached(KeySpec ks) {
        return this.cacheStore.get(ks);
    }

    public Item getPersisted(KeySpec ks) {
        return this.persistStore.get(ks);
    }

    public void putCached(Item itm) {
        this.cacheStore.getMap().put(itm.getKeySpec(), itm);
    }

    public void putPersisted(Item itm) {
        this.persistStore.put(itm.getKeySpec(), itm);
    }

    public void removeCached(KeySpec ks) {
        this.cacheStore.getMap().remove(ks);
    }

    public void removePersisted(KeySpec ks) {
        this.persistStore.remove(ks);
    }

    public VBucketInfo getVBucketInfo(short vb) {
        if (vb < 0 || vb > this.vbInfo.length) {
            throw new AccessControlException("Invalid vBucket");
        }
        return this.vbInfo[vb];
    }

    private void verifyOwnership(MemcachedServer server, short vBucketId) {
        if (server != null && server.getBucket().getType() == Bucket.BucketType.MEMCACHED) {
            return;
        }
        if (vBucketId < 0 || vBucketId > this.vbInfo.length) {
            throw new AccessControlException("Invalid vBucket");
        }
        VBucketInfo vbi = this.vbInfo[vBucketId];
        if (server != null && vbi.getOwner() != server) {
            throw new AccessControlException("Server is not master for this vb");
        }
    }

    public VBucketStore getCache(MemcachedServer server, short vBucketId) {
        this.verifyOwnership(server, vBucketId);
        return this.cacheStore;
    }

    public VBucketStore getCache(short vBucketId) {
        this.verifyOwnership(null, vBucketId);
        return this.cacheStore;
    }

    public void flush() {
        this.cacheStore.getMap().clear();
        this.persistStore.clear();
    }

    private class MutateActionCallback
    implements VBucketStore.ItemAction {
        private final Storage storage;

        public MutateActionCallback(Storage storage2) {
            this.storage = storage2;
        }

        @Override
        public void onAction(VBucketStore cacheStore, Item itm) {
            if (this.storage.persistEnabled) {
                this.storage.persistMutatedItem(itm);
            }
            if (this.storage.replicationEnabled) {
                this.storage.replicateMutatedItem(itm);
            }
        }
    }

    private class DeleteActionCallback
    implements VBucketStore.ItemAction {
        private final Storage storage;

        public DeleteActionCallback(Storage storage2) {
            this.storage = storage2;
        }

        @Override
        public void onAction(VBucketStore cacheStore, Item itm) {
            if (this.storage.persistEnabled) {
                this.storage.persistDeletedItem(itm.getKeySpec());
            }
            if (this.storage.replicationEnabled) {
                this.storage.replicateDeletedItem(itm.getKeySpec());
            }
        }
    }
}

