/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.xmp.convert;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.XMPSchemaRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.XMPRights;
import org.apache.tika.xmp.convert.AbstractConverter;
import org.apache.tika.xmp.convert.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConverter
extends AbstractConverter {
    @Override
    public XMPMeta process(Metadata metadata) throws XMPException {
        String[] keys;
        this.setMetadata(metadata);
        XMPSchemaRegistry registry = XMPMetaFactory.getSchemaRegistry();
        block6: for (String key : keys = metadata.names()) {
            String uri;
            String[] keyParts = key.split(":");
            if (keyParts.length <= 0 || keyParts.length > 2 || (uri = registry.getNamespaceURI(keyParts[0])) == null) continue;
            if (key.equals(DublinCore.TITLE.getName()) || key.equals(DublinCore.DESCRIPTION.getName()) || key.equals(XMPRights.USAGE_TERMS.getName())) {
                this.createLangAltProperty(key, uri, keyParts[1]);
                continue;
            }
            if (key.equals(DublinCore.CREATOR.getName())) {
                this.createArrayProperty(key, uri, keyParts[1], 1024);
                continue;
            }
            Property.PropertyType type = Property.getPropertyType(key);
            if (type == null) continue;
            switch (type) {
                case SIMPLE: {
                    this.createProperty(key, uri, keyParts[1]);
                    continue block6;
                }
                case BAG: {
                    this.createArrayProperty(key, uri, keyParts[1], 512);
                    continue block6;
                }
                case SEQ: {
                    this.createArrayProperty(key, uri, keyParts[1], 1024);
                    continue block6;
                }
                case ALT: {
                    this.createArrayProperty(key, uri, keyParts[1], 2048);
                }
            }
        }
        return this.getXMPMeta();
    }

    @Override
    public Set<Namespace> getAdditionalNamespaces() {
        return Collections.unmodifiableSet(new HashSet());
    }
}

