/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.comparators;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.util.Comparator;

public class EdgeAttributeComparator
implements Comparator<AdjacencyEdge<? extends GenericSegment>> {
    @Override
    public int compare(AdjacencyEdge<? extends GenericSegment> ae1, AdjacencyEdge<? extends GenericSegment> ae2) {
        if (ae1.isHorizontal() && ae2.isHorizontal()) {
            int lengthRetVal = (int)((ae1.physicalLength() / ae1.getFontSize() - ae2.physicalLength() / ae2.getFontSize()) * 10.0f);
            if (Utils.within(ae1.physicalLength() / ae1.getFontSize(), ae2.physicalLength() / ae2.getFontSize(), 0.1f)) {
                lengthRetVal = 0;
            }
            return lengthRetVal;
        }
        if (ae1.isVertical() && ae2.isHorizontal()) {
            return -1;
        }
        if (ae1.isHorizontal() && ae2.isVertical()) {
            return 1;
        }
        GenericSegment f1 = ae1.getNodeFrom();
        GenericSegment t1 = ae1.getNodeTo();
        GenericSegment f2 = ae2.getNodeFrom();
        GenericSegment t2 = ae2.getNodeTo();
        boolean text1 = false;
        boolean text2 = false;
        if (f1 instanceof TextSegment && t1 instanceof TextSegment) {
            text1 = true;
        }
        if (f2 instanceof TextSegment && t2 instanceof TextSegment) {
            text2 = true;
        }
        if (text1 && text2) {
            TextSegment ft1 = (TextSegment)f1;
            TextSegment tt1 = (TextSegment)t1;
            TextSegment ft2 = (TextSegment)f2;
            TextSegment tt2 = (TextSegment)t2;
            boolean sfs1 = false;
            boolean sfs2 = false;
            if (Utils.sameFontSize(ft1, tt1)) {
                sfs1 = true;
            }
            if (Utils.sameFontSize(ft2, tt2)) {
                sfs2 = true;
            }
            if (sfs1 && sfs2) {
                if (Utils.sameFontSize(ft1, ft2)) {
                    if (ae1.isVertical() && ae2.isVertical()) {
                        float width2;
                        float width1;
                        int lengthRetVal = (int)((ae1.physicalLength() / ae1.getFontSize() - ae2.physicalLength() / ae2.getFontSize()) * 10.0f);
                        if (Utils.within(ae1.physicalLength() / ae1.getFontSize(), ae2.physicalLength() / ae2.getFontSize(), 0.1f)) {
                            lengthRetVal = 0;
                        }
                        int widthRetVal = Utils.within(width1 = ft1.getWidth() > tt1.getWidth() ? ft1.getWidth() / tt1.getWidth() : tt1.getWidth() / ft1.getWidth(), width2 = ft2.getWidth() > tt2.getWidth() ? ft2.getWidth() / tt2.getWidth() : tt2.getWidth() / ft2.getWidth(), 0.1f) ? 0 : (width1 < width2 ? -1 : 1);
                        if (lengthRetVal == 0) {
                            return widthRetVal;
                        }
                        return lengthRetVal;
                    }
                    return 0;
                }
                if (ft1.getFontSize() < ft2.getFontSize()) {
                    return -1;
                }
                return 1;
            }
            if (sfs1) {
                return -1;
            }
            if (sfs2) {
                return 1;
            }
            return 0;
        }
        if (text1) {
            return -1;
        }
        if (text2) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj.equals(this);
    }
}

