/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.util.Random;

public class PolyWarpSolver {
    private static Random myRandom = new Random(0L);
    private static double[] c0 = new double[6];
    private static double[] c1 = new double[6];
    private static double noise = 0.0;

    private static double sign(double d, double d2) {
        d = Math.abs(d);
        if (d2 >= 0.0) {
            return d;
        }
        return -d;
    }

    private static final double square(double d) {
        return d * d;
    }

    private static final double sqrt(double d) {
        return Math.sqrt(d);
    }

    private static final double hypot(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            return d4 * PolyWarpSolver.sqrt(PolyWarpSolver.square(d3 / d4) + 1.0);
        }
        if (d3 != 0.0) {
            return d3 * PolyWarpSolver.sqrt(PolyWarpSolver.square(d4 / d3) + 1.0);
        }
        return d4;
    }

    public static double[][] matmul_t(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2[0].length;
        int n4 = dArray2.length;
        double[][] dArray3 = new double[n][n4];
        int n5 = 0;
        while (n5 < n) {
            double[] dArray4 = dArray3[n5];
            double[] dArray5 = dArray[n5];
            int n6 = 0;
            while (n6 < n4) {
                double d = 0.0;
                int n7 = 0;
                while (n7 < n2) {
                    d += dArray5[n7] * dArray2[n6][n7];
                    ++n7;
                }
                dArray4[n6] = d;
                ++n6;
            }
            ++n5;
        }
        return dArray3;
    }

    private static boolean SVD(double[][] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4) {
        double d;
        double d2;
        int n;
        double d3;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        double[] dArray5 = new double[n6];
        int n7 = 0;
        while (n7 < n5) {
            n2 = 0;
            while (n2 < n6) {
                dArray3[n7][n2] = dArray[n7][n2];
                ++n2;
            }
            ++n7;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        n7 = 0;
        while (n7 < n6) {
            n3 = n7 + 1;
            dArray5[n7] = d5 * d4;
            d4 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n7 < n5) {
                n = n7;
                while (n < n5) {
                    d5 += Math.abs(dArray3[n][n7]);
                    ++n;
                }
                if (d5 != 0.0) {
                    n = n7;
                    while (n < n5) {
                        double[] dArray6 = dArray3[n];
                        int n8 = n7;
                        dArray6[n8] = dArray6[n8] / d5;
                        d3 += PolyWarpSolver.square(dArray3[n][n7]);
                        ++n;
                    }
                    d2 = dArray3[n7][n7];
                    d4 = -PolyWarpSolver.sign(PolyWarpSolver.sqrt(d3), d2);
                    d = d2 * d4 - d3;
                    dArray3[n7][n7] = d2 - d4;
                    n2 = n3;
                    while (n2 < n6) {
                        d3 = 0.0;
                        n = n7;
                        while (n < n5) {
                            d3 += dArray3[n][n7] * dArray3[n][n2];
                            ++n;
                        }
                        d2 = d3 / d;
                        n = n7;
                        while (n < n5) {
                            double[] dArray7 = dArray3[n];
                            int n9 = n2;
                            dArray7[n9] = dArray7[n9] + d2 * dArray3[n][n7];
                            ++n;
                        }
                        ++n2;
                    }
                    n = n7;
                    while (n < n5) {
                        double[] dArray8 = dArray3[n];
                        int n10 = n7;
                        dArray8[n10] = dArray8[n10] * d5;
                        ++n;
                    }
                }
            }
            dArray2[n7] = d5 * d4;
            d4 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n7 < n5 && n7 != n6 - 1) {
                n = n3;
                while (n < n6) {
                    d5 += Math.abs(dArray3[n7][n]);
                    ++n;
                }
                if (d5 != 0.0) {
                    n = n3;
                    while (n < n6) {
                        double[] dArray9 = dArray3[n7];
                        int n11 = n;
                        dArray9[n11] = dArray9[n11] / d5;
                        d3 += PolyWarpSolver.square(dArray3[n7][n]);
                        ++n;
                    }
                    d2 = dArray3[n7][n3];
                    d4 = -PolyWarpSolver.sign(PolyWarpSolver.sqrt(d3), d2);
                    d = d2 * d4 - d3;
                    dArray3[n7][n3] = d2 - d4;
                    n = n3;
                    while (n < n6) {
                        dArray5[n] = dArray3[n7][n] / d;
                        ++n;
                    }
                    n2 = n3;
                    while (n2 < n5) {
                        d3 = 0.0;
                        n = n3;
                        while (n < n6) {
                            d3 += dArray3[n2][n] * dArray3[n7][n];
                            ++n;
                        }
                        n = n3;
                        while (n < n6) {
                            double[] dArray10 = dArray3[n2];
                            int n12 = n;
                            dArray10[n12] = dArray10[n12] + d3 * dArray5[n];
                            ++n;
                        }
                        ++n2;
                    }
                    n = n3;
                    while (n < n6) {
                        double[] dArray11 = dArray3[n7];
                        int n13 = n++;
                        dArray11[n13] = dArray11[n13] * d5;
                    }
                }
            }
            d6 = Math.max(d6, Math.abs(dArray2[n7]) + Math.abs(dArray5[n7]));
            ++n7;
        }
        n7 = n6 - 1;
        while (n7 >= 0) {
            if (n7 != n6 - 1) {
                if (d4 != 0.0) {
                    n2 = n3;
                    while (n2 < n6) {
                        dArray4[n2][n7] = dArray3[n7][n2] / dArray3[n7][n3] / d4;
                        ++n2;
                    }
                    n2 = n3;
                    while (n2 < n6) {
                        d3 = 0.0;
                        n = n3;
                        while (n < n6) {
                            d3 += dArray3[n7][n] * dArray4[n][n2];
                            ++n;
                        }
                        n = n3;
                        while (n < n6) {
                            double[] dArray12 = dArray4[n];
                            int n14 = n2;
                            dArray12[n14] = dArray12[n14] + d3 * dArray4[n][n7];
                            ++n;
                        }
                        ++n2;
                    }
                }
                n2 = n3;
                while (n2 < n6) {
                    dArray4[n2][n7] = 0.0;
                    dArray4[n7][n2] = 0.0;
                    ++n2;
                }
            }
            dArray4[n7][n7] = 1.0;
            d4 = dArray5[n7];
            n3 = n7--;
        }
        int n15 = Math.min(n5, n6);
        n7 = n15 - 1;
        while (n7 >= 0) {
            n3 = n7 + 1;
            d4 = dArray2[n7];
            if (n7 != n6 - 1) {
                n2 = n3;
                while (n2 < n6) {
                    dArray3[n7][n2] = 0.0;
                    ++n2;
                }
            }
            if (d4 != 0.0) {
                if (n7 != n15 - 1) {
                    n2 = n3;
                    while (n2 < n6) {
                        d3 = 0.0;
                        n = n3;
                        while (n < n5) {
                            d3 += dArray3[n][n7] * dArray3[n][n2];
                            ++n;
                        }
                        d2 = d3 / dArray3[n7][n7] / d4;
                        n = n7;
                        while (n < n5) {
                            double[] dArray13 = dArray3[n];
                            int n16 = n2;
                            dArray13[n16] = dArray13[n16] + d2 * dArray3[n][n7];
                            ++n;
                        }
                        ++n2;
                    }
                }
                n2 = n7;
                while (n2 < n5) {
                    double[] dArray14 = dArray3[n2];
                    int n17 = n7;
                    dArray14[n17] = dArray14[n17] / d4;
                    ++n2;
                }
            } else {
                n2 = n7;
                while (n2 < n5) {
                    dArray3[n2][n7] = 0.0;
                    ++n2;
                }
            }
            double[] dArray15 = dArray3[n7];
            int n18 = n7--;
            dArray15[n18] = dArray15[n18] + 1.0;
        }
        double d7 = d6;
        n = n6 - 1;
        while (n >= 0) {
            int n19 = n - 1;
            int n20 = 0;
            while (true) {
                double d8;
                double d9;
                double d10;
                double d11;
                boolean bl = true;
                n3 = n;
                while (n3 >= 0) {
                    n4 = n3 - 1;
                    d11 = d7 + Math.abs(dArray5[n3]);
                    if (d11 == d7) {
                        bl = false;
                        break;
                    }
                    d11 = d7 + Math.abs(dArray2[n4]);
                    if (d11 == d7) {
                        bl = true;
                        break;
                    }
                    --n3;
                }
                if (bl) {
                    d10 = 0.0;
                    d3 = 1.0;
                    n7 = n3;
                    while (n7 < n + 1) {
                        d2 = d3 * dArray5[n7];
                        int n21 = n7;
                        dArray5[n21] = dArray5[n21] * d10;
                        d11 = d7 + Math.abs(d2);
                        if (d11 != d7) {
                            d4 = dArray2[n7];
                            dArray2[n7] = d = PolyWarpSolver.hypot(d2, d4);
                            d10 = d4 / d;
                            d3 = -d2 / d;
                            n2 = 0;
                            while (n2 < n5) {
                                d9 = dArray3[n2][n4];
                                d8 = dArray3[n2][n7];
                                dArray3[n2][n4] = d9 * d10 + d8 * d3;
                                dArray3[n2][n7] = -d9 * d3 + d8 * d10;
                                ++n2;
                            }
                        }
                        ++n7;
                    }
                }
                d8 = dArray2[n];
                if (n3 == n) {
                    if (!(d8 < 0.0)) break;
                    dArray2[n] = -d8;
                    n2 = 0;
                    while (n2 < n6) {
                        dArray4[n2][n] = -dArray4[n2][n];
                        ++n2;
                    }
                    break;
                }
                if (n20 == 30) {
                    return false;
                }
                ++n20;
                d6 = dArray2[n3];
                d9 = dArray2[n19];
                d4 = dArray5[n19];
                d = dArray5[n];
                d2 = 0.5 * ((d4 + d8) / d * ((d4 - d8) / d9) + d9 / d - d / d9);
                d4 = PolyWarpSolver.hypot(d2, 1.0);
                d2 = d6 - d8 / d6 * d8 + d / d6 * (d9 / (d2 + PolyWarpSolver.sign(d4, d2)) - d);
                d10 = 1.0;
                d3 = 1.0;
                int n22 = n3;
                while (n22 <= n19) {
                    n7 = n22 + 1;
                    d4 = dArray5[n7];
                    d9 = dArray2[n7];
                    d = d3 * d4;
                    d4 = d10 * d4;
                    dArray5[n22] = d8 = PolyWarpSolver.hypot(d2, d);
                    d10 = d2 / d8;
                    d3 = d / d8;
                    d2 = d6 * d10 + d4 * d3;
                    d4 = -d6 * d3 + d4 * d10;
                    d = d9 * d3;
                    d9 *= d10;
                    n2 = 0;
                    while (n2 < n6) {
                        d6 = dArray4[n2][n22];
                        d8 = dArray4[n2][n7];
                        dArray4[n2][n22] = d6 * d10 + d8 * d3;
                        dArray4[n2][n7] = -d6 * d3 + d8 * d10;
                        ++n2;
                    }
                    dArray2[n22] = d8 = PolyWarpSolver.hypot(d2, d);
                    if (d8 != 0.0) {
                        d10 = d2 / d8;
                        d3 = d / d8;
                    }
                    d2 = d10 * d4 + d3 * d9;
                    d6 = -d3 * d4 + d10 * d9;
                    n2 = 0;
                    while (n2 < n5) {
                        d9 = dArray3[n2][n22];
                        d8 = dArray3[n2][n7];
                        dArray3[n2][n22] = d9 * d10 + d8 * d3;
                        dArray3[n2][n7] = -d9 * d3 + d8 * d10;
                        ++n2;
                    }
                    ++n22;
                }
                dArray5[n3] = 0.0;
                dArray5[n] = d2;
                dArray2[n] = d6;
            }
            --n;
        }
        return true;
    }

    public static float[] getCoeffs(float[] fArray, int n, float[] fArray2, int n2, int n3, float f, float f2, float f3, float f4, int n4) {
        double d;
        Object object;
        int n5 = n3 / 2;
        int n6 = (n4 + 1) * (n4 + 2) / 2;
        float[] fArray3 = new float[2 * n6];
        if (n4 == 1 && n3 == 3) {
            double d2 = fArray[0] * f;
            double d3 = fArray[1] * f2;
            double d4 = fArray[2] * f;
            double d5 = fArray[3] * f2;
            double d6 = fArray[4] * f2;
            double d7 = fArray[5] * f2;
            double d8 = fArray2[0] / f3;
            double d9 = fArray2[1] / f4;
            double d10 = fArray2[2] / f3;
            double d11 = fArray2[3] / f4;
            double d12 = fArray2[4] / f3;
            double d13 = fArray2[5] / f4;
            double d14 = d9 - d11;
            double d15 = d11 - d13;
            double d16 = d13 - d9;
            double d17 = d10 - d8;
            double d18 = d12 - d10;
            double d19 = d8 - d12;
            double d20 = d10 * d13 - d12 * d11;
            double d21 = d12 * d9 - d8 * d13;
            double d22 = d8 * d11 - d10 * d9;
            double d23 = 1.0 / (d8 * d15 + d9 * d18 + d20);
            fArray3[0] = (float)((d15 * d2 + d16 * d4 + d14 * d6) * d23);
            fArray3[1] = (float)((d18 * d2 + d19 * d4 + d17 * d6) * d23);
            fArray3[2] = (float)((d20 * d2 + d21 * d4 + d22 * d6) * d23);
            fArray3[3] = (float)((d15 * d3 + d16 * d5 + d14 * d7) * d23);
            fArray3[4] = (float)((d18 * d3 + d19 * d5 + d17 * d7) * d23);
            fArray3[5] = (float)((d20 * d3 + d21 * d5 + d22 * d7) * d23);
            return fArray3;
        }
        double[][] dArray = new double[n5][n6];
        double[] dArray2 = new double[n4 + 1];
        double[] dArray3 = new double[n4 + 1];
        int n7 = 0;
        while (n7 < n5) {
            object = dArray[n7];
            double d24 = fArray2[2 * n7 + n2] / f3;
            d = fArray2[2 * n7 + 1 + n2] / f4;
            double d25 = 1.0;
            double d26 = 1.0;
            int n8 = 0;
            while (n8 <= n4) {
                dArray2[n8] = d25;
                dArray3[n8] = d26;
                d25 *= d24;
                d26 *= d;
                ++n8;
            }
            int n9 = 0;
            int n10 = 0;
            while (n10 <= n4) {
                int n11 = 0;
                while (n11 <= n10) {
                    object[n9++] = (double[])(dArray2[n10 - n11] * dArray3[n11]);
                    ++n11;
                }
                ++n10;
            }
            ++n7;
        }
        object = new double[n6][n6];
        double[] dArray4 = new double[n6];
        double[][] dArray5 = new double[n5][n6];
        PolyWarpSolver.SVD(dArray, dArray4, dArray5, object);
        int n12 = 0;
        while (n12 < n6) {
            d = dArray4[n12];
            if (d != 0.0) {
                d = 1.0 / d;
            }
            n7 = 0;
            while (n7 < n6) {
                double[] dArray6 = object[n7];
                int n13 = n12;
                dArray6[n13] = dArray6[n13] * d;
                ++n7;
            }
            ++n12;
        }
        double[][] dArray7 = PolyWarpSolver.matmul_t(object, dArray5);
        n7 = 0;
        while (n7 < n6) {
            double d27 = 0.0;
            double d28 = 0.0;
            n12 = 0;
            while (n12 < n5) {
                double d29 = dArray7[n7][n12];
                d27 += d29 * (double)fArray[2 * n12 + n] * (double)f;
                d28 += d29 * (double)fArray[2 * n12 + 1 + n] * (double)f2;
                ++n12;
            }
            fArray3[n7] = (float)d27;
            fArray3[n7 + n6] = (float)d28;
            ++n7;
        }
        return fArray3;
    }

    private static float xpoly(float f, float f2) {
        return (float)(c0[0] + c0[1] * (double)f + c0[2] * (double)f2 + c0[3] * (double)f * (double)f + c0[4] * (double)f * (double)f2 + c0[5] * (double)f2 * (double)f2 + myRandom.nextDouble() * noise);
    }

    private static float ypoly(float f, float f2) {
        return (float)(c1[0] + c1[1] * (double)f + c1[2] * (double)f2 + c1[3] * (double)f * (double)f + c1[4] * (double)f * (double)f2 + c1[5] * (double)f2 * (double)f2 + myRandom.nextDouble() * noise);
    }

    private static void doTest(int n, boolean bl) {
        int n2 = 0;
        while (n2 < 6) {
            PolyWarpSolver.c0[n2] = myRandom.nextDouble() * 100.0;
            PolyWarpSolver.c1[n2] = myRandom.nextDouble() * 100.0;
            ++n2;
        }
        float[] fArray = new float[2 * n];
        int n3 = 0;
        while (n3 < 2 * n) {
            fArray[n3] = myRandom.nextFloat() * 100.0f;
            ++n3;
        }
        float[] fArray2 = new float[2 * n];
        int n4 = 0;
        while (n4 < n) {
            fArray2[2 * n4] = PolyWarpSolver.xpoly(fArray[2 * n4], fArray[2 * n4 + 1]);
            fArray2[2 * n4 + 1] = PolyWarpSolver.ypoly(fArray[2 * n4], fArray[2 * n4 + 1]);
            ++n4;
        }
        float[] fArray3 = PolyWarpSolver.getCoeffs(fArray2, 0, fArray, 0, fArray2.length, 0.5f, 0.5f, 2.0f, 2.0f, 2);
        if (bl) {
            System.out.println("Using " + n + " equations:");
            int n5 = 0;
            while (n5 < 6) {
                System.out.println("c0[" + n5 + "] = " + c0[n5] + ", recovered as " + fArray3[n5] + " (ratio = " + c0[n5] / (double)fArray3[n5] + ")");
                System.out.println("c1[" + n5 + "] = " + c1[n5] + ", recovered as " + fArray3[n5 + 6] + " (ratio = " + c1[n5] / (double)fArray3[n5 + 6] + ")");
                ++n5;
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < 3) {
            PolyWarpSolver.doTest(6 + 50 * n, true);
            System.out.println();
            ++n;
        }
        int n2 = 10000;
        int n3 = 6;
        long l = System.currentTimeMillis();
        int n4 = 0;
        while (n4 < n2) {
            PolyWarpSolver.doTest(n3, false);
            ++n4;
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Did " + n2 + " " + n3 + "-point solutions in " + (float)(l2 - l) / 1000.0f + " seconds.");
        System.out.println("Rate = " + (float)n2 * 1000.0f / (float)(l2 - l) + " trials/second");
    }
}

