package Net::Amazon::EMR::JobFlowInstancesConfig;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'AdditionalMasterSecurityGroups' => ( is => 'ro', 
                                          isa => 'Net::Amazon::EMR::Type::ArrayRefofConstrainedStr',
                                          coerce => 1,
                                      );

has 'AdditionalSlaveSecurityGroups' => ( is => 'ro', 
                                         isa => 'Net::Amazon::EMR::Type::ArrayRefofConstrainedStr',
                                         coerce => 1,
                                     );

has 'Ec2AvailabilityZone' => ( is => 'ro', 
                               isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                               coerce => 1,
                           );

has 'Ec2KeyName' => ( is => 'ro', 
                      isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                      coerce => 1,
                  );

has 'Ec2SubnetId' => ( is => 'ro', 
                       isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                       coerce => 1,
                   );


has 'EmrManagedSlaveSecurityGroup' => ( is => 'ro', 
                                        isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                                        coerce => 1,
                                    );

has 'HadoopVersion' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                         coerce => 1,
                     );

has 'InstanceCount' => ( is => 'ro', 
                         isa => 'Int' );

has 'InstanceGroups' => ( is => 'ro', 
                          isa => 'Net::Amazon::EMR::Type::ArrayRefofInstanceGroupConfig',
                          coerce => 1 );

has 'KeepJobFlowAliveWhenNoSteps' => ( is => 'ro', 
                                       isa => 'Net::Amazon::EMR::Type::Bool',
                                       coerce => 1 );

has 'MasterInstanceType' => ( is => 'ro', 
                              isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                              coerce => 1,
                          );

has 'Placement' => ( is => 'ro', 
                     isa => 'Net::Amazon::EMR::Type::PlacementType',
                     coerce => 1  );

has 'ServiceAccessSecurityGroup' => ( is => 'ro', 
                                      isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                                      coerce => 1,
                                  );

has 'SlaveInstanceType' => ( is => 'ro', 
                             isa => 'Net::Amazon::EMR::Type::NonEmptyConstrainedStr',
                             coerce => 1,
                         );


has 'TerminationProtected' => ( is => 'ro', 
                                isa => 'Net::Amazon::EMR::Type::Bool',
                                coerce => 1 );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::JobFlowInstancesConfig

=head1 DESCRIPTION

Implements the JobFlowInstancesConfig data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_JobFlowInstancesConfig.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
