/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriterVariable;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.MemoryDataSourceImpl;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.WrappingTrack;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Path;
import com.mp4parser.iso14496.part15.AvcConfigurationBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avc1ToAvc3TrackImpl
extends WrappingTrack {
    SampleDescriptionBox stsd;
    AvcConfigurationBox avcC;
    List<Sample> samples;

    public Avc1ToAvc3TrackImpl(Track parent) throws IOException {
        super(parent);
        if (!"avc1".equals(parent.getSampleDescriptionBox().getSampleEntry().getType())) {
            throw new RuntimeException("Only avc1 tracks can be converted to avc3 tracks");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        parent.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
        IsoFile isoFile = new IsoFile(new MemoryDataSourceImpl(baos.toByteArray()));
        this.stsd = (SampleDescriptionBox)Path.getPath(isoFile, "stsd");
        ((VisualSampleEntry)this.stsd.getSampleEntry()).setType("avc3");
        this.avcC = (AvcConfigurationBox)Path.getPath(this.stsd, "avc./avcC");
        this.samples = new ReplaceSyncSamplesList(parent.getSamples());
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplaceSyncSamplesList
    extends AbstractList<Sample> {
        List<Sample> parentSamples;

        public ReplaceSyncSamplesList(List<Sample> parentSamples) {
            this.parentSamples = parentSamples;
        }

        @Override
        public Sample get(int index) {
            if (Arrays.binarySearch(Avc1ToAvc3TrackImpl.this.getSyncSamples(), (long)(index + 1)) >= 0) {
                final int len = Avc1ToAvc3TrackImpl.this.avcC.getLengthSizeMinusOne() + 1;
                final ByteBuffer buf = ByteBuffer.allocate(len);
                final Sample orignalSample = this.parentSamples.get(index);
                return new Sample(){

                    public void writeTo(WritableByteChannel channel) throws IOException {
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            IsoTypeWriterVariable.write(bytes.length, (ByteBuffer)buf.rewind(), len);
                            channel.write((ByteBuffer)buf.rewind());
                            channel.write(ByteBuffer.wrap(bytes));
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            IsoTypeWriterVariable.write(bytes.length, (ByteBuffer)buf.rewind(), len);
                            channel.write((ByteBuffer)buf.rewind());
                            channel.write(ByteBuffer.wrap(bytes));
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            IsoTypeWriterVariable.write(bytes.length, (ByteBuffer)buf.rewind(), len);
                            channel.write((ByteBuffer)buf.rewind());
                            channel.write(ByteBuffer.wrap(bytes));
                        }
                        orignalSample.writeTo(channel);
                    }

                    public long getSize() {
                        int spsPpsSize = 0;
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            spsPpsSize += len + bytes.length;
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            spsPpsSize += len + bytes.length;
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            spsPpsSize += len + bytes.length;
                        }
                        return orignalSample.getSize() + (long)spsPpsSize;
                    }

                    public ByteBuffer asByteBuffer() {
                        int spsPpsSize = 0;
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            spsPpsSize += len + bytes.length;
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            spsPpsSize += len + bytes.length;
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            spsPpsSize += len + bytes.length;
                        }
                        ByteBuffer data = ByteBuffer.allocate(CastUtils.l2i(orignalSample.getSize()) + spsPpsSize);
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSets()) {
                            IsoTypeWriterVariable.write(bytes.length, data, len);
                            data.put(bytes);
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getSequenceParameterSetExts()) {
                            IsoTypeWriterVariable.write(bytes.length, data, len);
                            data.put(bytes);
                        }
                        for (byte[] bytes : ((ReplaceSyncSamplesList)ReplaceSyncSamplesList.this).Avc1ToAvc3TrackImpl.this.avcC.getPictureParameterSets()) {
                            IsoTypeWriterVariable.write(bytes.length, data, len);
                            data.put(bytes);
                        }
                        data.put(orignalSample.asByteBuffer());
                        return (ByteBuffer)data.rewind();
                    }
                };
            }
            return this.parentSamples.get(index);
        }

        @Override
        public int size() {
            return this.parentSamples.size();
        }
    }
}

