/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;

final class Java2D
extends Geometries<Shape> {
    Java2D() {
        super(GeometryLibrary.JAVA2D, Shape.class, Point2D.class, Shape.class, Shape.class);
    }

    @Override
    final String tryGetLabel(Object object) {
        if (object instanceof Shape) {
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = clazz.getEnclosingClass();
            return Classes.getShortName(clazz2 != null ? clazz2 : clazz);
        }
        return null;
    }

    @Override
    final GeneralEnvelope tryGetEnvelope(Object object) {
        Rectangle2D rectangle2D;
        if (object instanceof Shape && !(rectangle2D = ((Shape)object).getBounds2D()).isEmpty()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(2);
            generalEnvelope.setRange(0, rectangle2D.getMinX(), rectangle2D.getMaxX());
            generalEnvelope.setRange(1, rectangle2D.getMinY(), rectangle2D.getMaxY());
            return generalEnvelope;
        }
        return null;
    }

    @Override
    final double[] tryGetCoordinate(Object object) {
        if (object instanceof Point2D) {
            Point2D point2D = (Point2D)object;
            return new double[]{point2D.getX(), point2D.getY()};
        }
        return null;
    }

    @Override
    public Object createPoint(double d, double d2) {
        return new Point2D.Double(d, d2);
    }

    @Override
    public Shape createPolyline(int n, Vector ... vectorArray) {
        double d;
        double d2;
        double d3;
        double d4;
        if (n != 2) {
            throw Java2D.unsupported(n);
        }
        int n2 = 0;
        boolean bl = true;
        Object object = vectorArray;
        int n3 = ((Vector[])object).length;
        block0: for (int i = 0; i < n3; ++i) {
            Vector vector = object[i];
            if (vector == null) continue;
            n2 = JDK8.addExact(n2, vector.size());
            if (!bl) continue;
            int n4 = vector.size();
            while (--n4 >= 0) {
                d4 = vector.doubleValue(n4);
                if (Double.doubleToRawLongBits(d4) == Double.doubleToRawLongBits((float)d4)) continue;
                bl = false;
                continue block0;
            }
        }
        if (!((n2 /= 2) != 2 || vectorArray.length != 1 || Double.isNaN(d3 = ((Vector)(object = vectorArray[0])).doubleValue(0)) || Double.isNaN(d2 = ((Vector)object).doubleValue(1)) || Double.isNaN(d4 = ((Vector)object).doubleValue(2)) || Double.isNaN(d = ((Vector)object).doubleValue(3)))) {
            Line2D line2D = bl ? new Line2D.Float() : new Line2D.Double();
            line2D.setLine(d3, d2, d4, d);
            return line2D;
        }
        object = bl ? new Path2D.Float(1, n2) : new Path2D.Double(1, n2);
        n3 = 0;
        for (Vector vector : vectorArray) {
            int n5 = vector.size();
            int n6 = 0;
            while (n6 < n5) {
                double d5 = vector.doubleValue(n6++);
                double d6 = vector.doubleValue(n6++);
                if (Double.isNaN(d5) || Double.isNaN(d6)) {
                    n3 = 0;
                    continue;
                }
                if (n3 != 0) {
                    ((Path2D)object).lineTo(d5, d6);
                    continue;
                }
                ((Path2D)object).moveTo(d5, d6);
                n3 = 1;
            }
        }
        return ShapeUtilities.toPrimitive((Shape)object);
    }

    @Override
    final Shape tryMergePolylines(Object object, Iterator<?> iterator) {
        if (!(object instanceof Shape) && !(object instanceof Point2D)) {
            return null;
        }
        Path2D.Double double_ = new Path2D.Double();
        boolean bl = false;
        while (true) {
            if (object != null) {
                if (object instanceof Point2D) {
                    double d = ((Point2D)object).getX();
                    double d2 = ((Point2D)object).getY();
                    if (Double.isNaN(d) || Double.isNaN(d2)) {
                        bl = false;
                    } else if (bl) {
                        ((Path2D)double_).lineTo(d, d2);
                    } else {
                        ((Path2D)double_).moveTo(d, d2);
                        bl = true;
                    }
                } else {
                    double_.append((Shape)object, false);
                    bl = false;
                }
            }
            if (!iterator.hasNext()) break;
            object = iterator.next();
        }
        return ShapeUtilities.toPrimitive(double_);
    }

    @Override
    public Object parseWKT(String string) {
        throw Java2D.unsupported(2);
    }
}

