use strict;
use warnings;
use utf8;
use Test::More;
use t::Util;

my $parser = make_parser
    q{03366,"02955","0295513","ｲﾜﾃｹﾝ","ﾜｶﾞｸﾞﾝﾆｼﾜｶﾞﾏﾁ","ｶｯﾁ51ﾁﾜﾘ","岩手県","和賀郡西和賀町","甲子５１地割",0,0,0,1,0,0},
    q{03366,"02955","0295523","ｲﾜﾃｹﾝ","ﾜｶﾞｸﾞﾝﾆｼﾜｶﾞﾏﾁ","ｶﾂﾗｺﾞｻﾞﾜ75ﾁﾜﾘ､ｶﾂﾗｺﾞｻﾞﾜ76ﾁﾜﾘ","岩手県","和賀郡西和賀町","桂子沢７５地割、桂子沢７６地割",0,0,0,1,0,0},
    q{03366,"02955","0295521","ｲﾜﾃｹﾝ","ﾜｶﾞｸﾞﾝﾆｼﾜｶﾞﾏﾁ","ｺﾂﾅｷﾞｻﾞﾜ54ﾁﾜﾘ-ｺﾂﾅｷﾞｻﾞﾜ56ﾁﾜﾘ","岩手県","和賀郡西和賀町","小繋沢５４地割〜小繋沢５６地割",0,0,0,1,0,0},
    q{03366,"02955","0240341","ｲﾜﾃｹﾝ","ﾜｶﾞｸﾞﾝﾆｼﾜｶﾞﾏﾁ","ｽｷﾞﾅﾊﾀ44ﾁﾜﾘ(ﾕﾀﾞﾀﾞﾑｶﾝﾘｼﾞﾑｼｮ､ｳｼﾛｸﾞﾁﾔﾏ､ｱﾃﾗｸ)","岩手県","和賀郡西和賀町","杉名畑４４地割（湯田ダム管理事務所、後口山、当楽）",1,0,0,0,0,0},
    q{03507,"02879","0287911","ｲﾜﾃｹﾝ","ｸﾉﾍｸﾞﾝﾋﾛﾉﾁｮｳ","ﾀﾈｲﾁﾀﾞｲ39ﾁﾜﾘ-ﾀﾞｲ45ﾁﾜﾘ(ｶﾄﾞﾉﾊﾏ､ﾃﾞﾝｷﾁ)","岩手県","九戸郡洋野町","種市第３９地割〜第４５地割（角浜、伝吉）",0,1,0,0,0,0};

do {
    my $row = $parser->fetch_obj;
    is($row->town, '甲子');
    is($row->town_kana, 'カッチ');
    ok($row->has_subtown);
    is($row->subtown->[0], '第51地割');
    is($row->subtown_kana->[0], 'ダイ51チワリ');
};

do {
    my $row = $parser->fetch_obj;
    is($row->town, '桂子沢');
    is($row->town_kana, 'カツラゴザワ');
    ok($row->has_subtown);
    is($row->subtown->[0], '第75地割');
    is($row->subtown_kana->[0], 'ダイ75チワリ');
    is($row->subtown->[1], '第76地割');
    is($row->subtown_kana->[1], 'ダイ76チワリ');
};

do {
    my $row = $parser->fetch_obj;
    is($row->town, '小繋沢');
    is($row->town_kana, 'コツナギザワ');
    ok($row->has_subtown);
    is($row->subtown->[0], '第54地割〜第56地割');
    is($row->subtown_kana->[0], 'ダイ54チワリ-ダイ56チワリ');
};

do {
    my $row = $parser->fetch_obj;
    is($row->town, '杉名畑');
    is($row->town_kana, 'スギナハタ');
    ok($row->has_subtown);
    is($row->subtown->[0], '第44地割 湯田ダム管理事務所');
    is($row->subtown_kana->[0], 'ダイ44チワリ ユダダムカンリジムショ');
    is($row->subtown->[1], '第44地割 後口山');
    is($row->subtown_kana->[1], 'ダイ44チワリ ウシログチヤマ');
    is($row->subtown->[2], '第44地割 当楽');
    is($row->subtown_kana->[2], 'ダイ44チワリ アテラク');
};

#03507,"02879","0287911","ｲﾜﾃｹﾝ","ｸﾉﾍｸﾞﾝﾋﾛﾉﾁｮｳ","ﾀﾈｲﾁﾀﾞｲ39ﾁﾜﾘ-ﾀﾞｲ45ﾁﾜﾘ(ｶﾄﾞﾉﾊﾏ､ﾃﾞﾝｷﾁ)","岩手県","九戸郡洋野町","種市第３９地割〜第４５地割（角浜、伝吉）",0,1,0,0,0,0
do {
    my $row = $parser->fetch_obj;
    is($row->town, '種市');
    is($row->town_kana, 'タネイチ');
    ok($row->has_subtown);
    is($row->subtown->[0], '第39地割〜第45地割 角浜');
    is($row->subtown_kana->[0], 'ダイ39チワリ-ダイ45チワリ カドノハマ');
    is($row->subtown->[1], '第39地割〜第45地割 伝吉');
    is($row->subtown_kana->[1], 'ダイ39チワリ-ダイ45チワリ デンキチ');
};

done_testing;
