# -*-Perl-*- Test Harness script for Bioperl
# $Id$


use strict;

BEGIN {
   use Bio::Root::Test;
   
   test_begin(-tests => 14);
   
   use_ok 'Bio::Matrix::PSM::ProtMatrix';
}


my %param = (
   '-id' => 'A. thaliana protein atp1',
   '-e_val' => 0.0001,
   '-ic' => [ '0.28', '0.40', '0.64', '0.68', '0.68', '0.70', '0.72', '0.72' ],
   '-lS' => [ '-2', '3', '-3', '2', '-3', '1', '1', '3' ],
   '-lF' => [ '-1', '-4', '0', '-5', '0', '-5', '-4', '-4' ],
   '-lT' => [ '-1', '1', '0', '1', '-2', '-1', '0', '1' ],
   '-lN' => [ '-3', '-1', '-2', '3', '-5', '5', '-2', '0' ],
   '-lK' => [ '-2', '0', '-3', '2', '-3', '2', '-3', '-1' ],
   '-lY' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-4', '-4' ],
   '-lE' => [ '-3', '4', '-3', '2', '-4', '-2', '-3', '2' ],
   '-lV' => [ '0', '-2', '1', '-4', '1', '-4', '-1', '-3' ],
   '-lQ' => [ '-1', '0', '-2', '3', '-4', '1', '-3', '0' ],
   '-lM' => [ '8', '-3', '8', '-3', '1', '-3', '-3', '-3' ],
   '-lC' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-3', '-3' ],
   '-lL' => [ '1', '-3', '1', '-4', '3', '-4', '-2', '-4' ],
   '-lA' => [ '-2', '1', '-2', '0', '-2', '-2', '2', '2' ],
   '-lW' => [ '-2', '-4', '-3', '-5', '-4', '-5', '-5', '-5' ],
   '-lP' => [ '-3', '-2', '-4', '-3', '-1', '-3', '6', '-3' ],
   '-lH' => [ '-2', '-2', '-3', '-2', '-5', '-2', '-2', '-3' ],
   '-lD' => [ '-4', '-1', '-3', '1', '-3', '-1', '-3', '4' ],
   '-lR' => [ '-2', '-1', '-3', '0', '-4', '4', '-4', '-3' ],
   '-lI' => [ '0', '-3', '0', '-4', '6', '-4', '-2', '-2' ],
   '-lG' => [ '-4', '-2', '-4', '-2', '-5', '-3', '-1', '-2' ],
   '-pS' => [ '0', '33', '0', '16', '1', '12', '11', '25' ],
   '-pF' => [ '0', '0', '2', '0', '3', '0', '0', '0' ],
   '-pT' => [ '0', '8', '7', '10', '1', '2', '7', '8' ],
   '-pN' => [ '0', '0', '2', '13', '0', '36', '1', '4' ],
   '-pK' => [ '0', '5', '0', '13', '1', '15', '0', '2' ],
   '-pY' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],
   '-pE' => [ '0', '41', '1', '12', '0', '0', '0', '15' ],
   '-pV' => [ '0', '3', '9', '0', '2', '0', '3', '1' ],
   '-pQ' => [ '0', '0', '0', '15', '0', '4', '0', '3' ],
   '-pM' => [ '100', '0', '66', '0', '2', '0', '0', '0' ],
   '-pC' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],
   '-pL' => [ '0', '0', '8', '0', '25', '0', '4', '0' ],
   '-pA' => [ '0', '10', '1', '9', '2', '0', '22', '16' ],
   '-pW' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],
   '-pP' => [ '0', '0', '0', '0', '3', '1', '45', '0' ],
   '-pH' => [ '0', '0', '0', '0', '0', '0', '1', '0' ],
   '-pD' => [ '0', '0', '1', '7', '2', '2', '0', '22' ],
   '-pR' => [ '0', '0', '0', '3', '0', '27', '0', '0' ],
   '-pI' => [ '0', '0', '3', '0', '59', '1', '2', '3' ],
   '-pG' => [ '0', '0', '0', '1', '0', '0', '4', '1' ],
);

my $matrix = Bio::Matrix::PSM::ProtMatrix->new(%param);
ok $matrix;

#Simple methods here
is $matrix->IUPAC,'MEMSINPS';

is $matrix->consensus,'MEMSINPS';

is $matrix->width,8;

is $matrix->curpos,0;

is $matrix->get_string('A'), '0100a90200220160';

my %x1 = (
         'base' => 'M', 'prob' => 100, 'rel' => 0,
         'lC' => '-2',
         'pM' => '100',
         'lY' => '-2',
         'lK' => '-2',
         'lR' => '-2',
         'lM' => '8',
         'pP' => '0',
         'lV' => '0',
         'pK' => '0',
         'lH' => '-2',
         'pI' => '0',
         'pT' => '0',
         'lE' => '-3',
         'lN' => '-3',
         'lQ' => '-1',
         'lW' => '-2',
         'pH' => '0',
         'pC' => '0',
         'lI' => '0',
         'pA' => '0',
         'lA' => '-2',
         'pV' => '0',
         'pF' => '0',
         'lS' => '-2',
         'pY' => '0',
         'lL' => '1',
         'lG' => '-4',
         'pE' => '0',
         'pL' => '0',
         'lF' => '-1',
         'pS' => '0',
         'pD' => '0',
         'pN' => '0',
         'lP' => '-3',
         'lT' => '-1',
         'pQ' => '0',
         'pR' => '0',
         'lD' => '-4',
         'pW' => '0',
         'pG' => '0'
);

my %x2 = $matrix->next_pos;
is_deeply \%x1, \%x2;

is $matrix->curpos,1;

ok $matrix->e_val(0.0001);
is $matrix->e_val,0.0001;

#Now some PSM specific methods like regexp and matrix info

my @a = ('0', '10', '1', '9', '2', '0', '22', '16');
is_deeply [$matrix->get_array('A')], \@a;

my $regexp = '[Mm][EeSs][Mm]\.[IiLl][RrNn][AaPp][DdSs]';
is $matrix->regexp, $regexp;
is $matrix->sequence_match_weight('MSMPLRPD'), 33;
