# Generated by default/object.tt
package Paws::LexModelsV2::SlotTypeValue;
  use Moose;
  has SampleValue => (is => 'ro', isa => 'Paws::LexModelsV2::SampleValue', request_name => 'sampleValue', traits => ['NameInRequest']);
  has Synonyms => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::SampleValue]', request_name => 'synonyms', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::SlotTypeValue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::SlotTypeValue object:

  $service_obj->Method(Att1 => { SampleValue => $value, ..., Synonyms => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::SlotTypeValue object:

  $result = $service_obj->Method(...);
  $result->Att1->SampleValue

=head1 DESCRIPTION

Each slot type can have a set of values. Each C<SlotTypeValue>
represents a value that the slot type can take.

=head1 ATTRIBUTES


=head2 SampleValue => L<Paws::LexModelsV2::SampleValue>

The value of the slot type entry.


=head2 Synonyms => ArrayRef[L<Paws::LexModelsV2::SampleValue>]

Additional values releated to the slot type entry.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

