# Generated by default/object.tt
package Paws::KinesisAnalyticsV2::CustomArtifactConfiguration;
  use Moose;
  has ArtifactType => (is => 'ro', isa => 'Str', required => 1);
  has MavenReference => (is => 'ro', isa => 'Paws::KinesisAnalyticsV2::MavenReference');
  has S3ContentLocation => (is => 'ro', isa => 'Paws::KinesisAnalyticsV2::S3ContentLocation');

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalyticsV2::CustomArtifactConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisAnalyticsV2::CustomArtifactConfiguration object:

  $service_obj->Method(Att1 => { ArtifactType => $value, ..., S3ContentLocation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisAnalyticsV2::CustomArtifactConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ArtifactType

=head1 DESCRIPTION

Specifies dependency JARs, as well as JAR files that contain
user-defined functions (UDF).

=head1 ATTRIBUTES


=head2 B<REQUIRED> ArtifactType => Str

C<UDF> stands for user-defined functions. This type of artifact must be
in an S3 bucket. A C<DEPENDENCY_JAR> can be in either Maven or an S3
bucket.


=head2 MavenReference => L<Paws::KinesisAnalyticsV2::MavenReference>

The parameters required to fully specify a Maven reference.


=head2 S3ContentLocation => L<Paws::KinesisAnalyticsV2::S3ContentLocation>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisAnalyticsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

